// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__5DBB4665_03EE_4DA2_890F_8C00CAB84348__INCLUDED_)
#define AFX_CHILDVIEW_H__5DBB4665_03EE_4DA2_890F_8C00CAB84348__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CardType.h"
#include "SolveThread.h"
#include "WaitDlg.h"
#include "BoardStatusData.h"

enum BoardStatus { 
	NORMAL = 1,
	MOVEUP,
	MULTIMOVE
};

/////////////////////////////////////////////////////////////////////////////
// CChildView window

//	abbb bbcc cccd dddd
//	
//	a : 1 bit - 0 ~  1 (0 ~  1) : bBegin
//	b : 1 bit - 0 ~  1 (0 ~  1) : bEnd
//	b : 5 bit - 0 ~ 31 (0 ~ 15) : nSource
//  c : 5 bit - 0 ~ 31 (0 ~ 15) : nTarget
//  d : 4 bit - 0 ~ 15 (1 ~ 21) : nReserved
struct StateData
{
	union {
		BYTE bt[2];
		struct {
			unsigned short nReserved	: 4;
			unsigned short nTarget		: 5;
			unsigned short nSource		: 5;
			unsigned short bEnd			: 1;
			unsigned short bStart		: 1;
		};
	};
};

struct QueueData
{
	int nTarget;
	int nSource;
};

enum MoveState { msNone = 0, msUndo, msRedo, msUndoAll, msRedoAll, msUndoDone, msRedoDone, msQueue };

struct Option
{
	BOOL	bMoveAni;
	int		nMoveStep;
	int		nMoveDelay;
	BOOL	bSelectStartDate;
	BOOL	bSelectEndDate;
	int		nStartDate;		//  yyyymmdd ǥ
	int		nEndDate;		//  yyyymmdd ǥ
	int		nNextGame;		// 1: , 2: 
	BOOL	bNextNormal;
	BOOL	bNextTry;
	BOOL	bNextSolved;
	BOOL	bNextMark;
	BOOL	bViewDaySolved;	// Ϸ Ǭ 
	BOOL	bViewRatio;		// ü Ǭ 
	BOOL	bViewDayExpect;	// Ϸ Ǯ  
	BOOL	bViewEndDate;	// 
};

class CChildView : public CWnd
{
// Construction
public:
	CChildView();

// Attributes
public:
	int m_nTryCount;		//  õ Ƚ
	bool m_bGameSolve;		// ذ  
	int m_nGameNum;			//   ȣ
	bool m_bIdle;			//  Է ޾   ִ 
	bool m_bModify;			//   
	int		m_nLastGameNum;	//  ÷ߴ ӹȣ
	CCard m_Card;
	int m_nMoveStartCol;
	int m_nMoveEndCol;
	int m_nMoveCount;
	Option	m_Option;
	int  m_nStatus;
	MoveState  m_MoveState;
	CWaitDlg*	m_pWaitDlg;
	void*		m_pvSolveInstance;
	int			m_nSolveResult;
	char		m_szUserState[1024];
	bool		m_bDoneExitProcess;

	CBoardStatusData	m_BoardStatusData;


	CList<StateData, StateData&>	m_StateList;
	CList<QueueData, QueueData&>	m_QueueList;
	POSITION						m_posList;

	CSolveThread*	m_pSolveThread;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	int AddQueue(int nStart, int nEnd);
	void DoRedo();
	void DoUndo();
	void DoRedoAll();
	void DoUndoAll();
	void DoSave(int nNum = -1);
	bool DoLoad();
	bool DoNextGame();
	bool DoPrevGame();
	bool DoRestart();
	void SetMoveTimer(bool bStart, bool bEnd);
	void AddList(bool bStart, bool bEnd, int nStartCol, int nEndCol);
	int CalcMaxMove(int nFreeCell, int nEmptyCol);
	bool SaveOptions();
	bool LoadOptions();
	int m_nSelectCard;
	int m_nSelectCol;
	virtual ~CChildView();
	void NewBoard(int nGameNum = -1);
	void CheckDataFile(int nNum, bool& bDone, int& nMaxTry);
	void DoSolve();
	void DoNewGame();
	int GetRandomGameNum();

private:
	bool CheckAndLoad(int nGameNum);
	int LoadTodayValue(int nToday = -1);
	bool SaveTodayValue(int nValue, int nToday = -1);

	// Generated message map functions
protected:
	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg void OnSolve();
	afx_msg void OnUpdateSolve(CCmdUI* pCmdUI);
	afx_msg void OnGameLoad();
	afx_msg void OnGameNew();
	afx_msg void OnGameOption();
	afx_msg void OnGameRedoAll();
	afx_msg void OnGameRestart();
	afx_msg void OnGameSave();
	afx_msg void OnGameSelect();
	afx_msg void OnGameUndoAll();
	afx_msg void OnNewgame();
	afx_msg void OnNextgame();
	afx_msg void OnPrevgame();
	afx_msg void OnRedo();
	afx_msg void OnUndo();
	afx_msg void OnUpdateGameLoad(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameNew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameOption(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameRedoAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameRestart(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameSelect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGameUndoAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNewgame(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNextgame(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePrevgame(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRedo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateUndo(CCmdUI* pCmdUI);
	afx_msg void OnAppExit();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__5DBB4665_03EE_4DA2_890F_8C00CAB84348__INCLUDED_)
