// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "PocketFreeCell.h"
#include "ChildView.h"
#include "Registry.h"
#include "SelectGameDlg.h"
#include "OptionDlg.h"

#include "fcs_cl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	m_nMoveCount = 0;
	m_nSelectCol = 0;
	m_nSelectCard = -1;
	m_nStatus = NORMAL;
	m_posList = NULL;
	//m_nGameNum = 1;
	m_MoveState = msNone;
	LoadOptions();

	m_bIdle = true;
	m_nTryCount = 1;
	m_bModify = false;
	m_pSolveThread = NULL;
	m_pWaitDlg = NULL;
	m_bDoneExitProcess = false;
}

CChildView::~CChildView()
{
	if (!m_bDoneExitProcess)
	{
		m_bDoneExitProcess = true;
		if (m_bModify)
			DoSave();

		SaveOptions();
	}
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_COMMAND(IDC_SOLVE, OnSolve)
	ON_UPDATE_COMMAND_UI(IDC_SOLVE, OnUpdateSolve)
	ON_COMMAND(ID_GAME_LOAD, OnGameLoad)
	ON_COMMAND(ID_GAME_NEW, OnGameNew)
	ON_COMMAND(ID_GAME_OPTION, OnGameOption)
	ON_COMMAND(ID_GAME_REDO_ALL, OnGameRedoAll)
	ON_COMMAND(ID_GAME_RESTART, OnGameRestart)
	ON_COMMAND(ID_GAME_SAVE, OnGameSave)
	ON_COMMAND(ID_GAME_SELECT, OnGameSelect)
	ON_COMMAND(ID_GAME_UNDO_ALL, OnGameUndoAll)
	ON_COMMAND(IDC_NEWGAME, OnNewgame)
	ON_COMMAND(IDC_NEXTGAME, OnNextgame)
	ON_COMMAND(IDC_PREVGAME, OnPrevgame)
	ON_COMMAND(IDC_REDO, OnRedo)
	ON_COMMAND(IDC_UNDO, OnUndo)
	ON_UPDATE_COMMAND_UI(ID_GAME_LOAD, OnUpdateGameLoad)
	ON_UPDATE_COMMAND_UI(ID_GAME_NEW, OnUpdateGameNew)
	ON_UPDATE_COMMAND_UI(ID_GAME_OPTION, OnUpdateGameOption)
	ON_UPDATE_COMMAND_UI(ID_GAME_REDO_ALL, OnUpdateGameRedoAll)
	ON_UPDATE_COMMAND_UI(ID_GAME_RESTART, OnUpdateGameRestart)
	ON_UPDATE_COMMAND_UI(ID_GAME_SAVE, OnUpdateGameSave)
	ON_UPDATE_COMMAND_UI(ID_GAME_SELECT, OnUpdateGameSelect)
	ON_UPDATE_COMMAND_UI(ID_GAME_UNDO_ALL, OnUpdateGameUndoAll)
	ON_UPDATE_COMMAND_UI(IDC_NEWGAME, OnUpdateNewgame)
	ON_UPDATE_COMMAND_UI(IDC_NEXTGAME, OnUpdateNextgame)
	ON_UPDATE_COMMAND_UI(IDC_PREVGAME, OnUpdatePrevgame)
	ON_UPDATE_COMMAND_UI(IDC_REDO, OnUpdateRedo)
	ON_UPDATE_COMMAND_UI(IDC_UNDO, OnUpdateUndo)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;
	cs.style &= ~WS_BORDER;

#ifdef _WIN32_WCE
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		NULL, HBRUSH(COLOR_WINDOW+1), NULL);
#else
	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);
#endif

	return TRUE;
}

int DaysInMonth[12] = { 31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
int GetDays(int nYear, int nMonth, int nDay)
{
    int     i;
    int     nTotal;
    int     nLastYear = nYear - 1;

    nTotal = (nLastYear * 365) + (nLastYear / 4) - (nLastYear / 100) + (nLastYear / 400);

    DaysInMonth[1] = ( ((nYear % 400) == 0) || (((nYear % 100) != 0) && ((nYear % 4) == 0)) ) ? 29 : 28;
    for (i = 0; i < nMonth - 1; i++) {
        nTotal += DaysInMonth[i];
    }

    return (nTotal + nDay - 1);
}

int MakeDays(int nDays)
{
	int i;
	int nYear, nMonth;
	int nRest;
	
	if (nDays < 0)
		return 0;

	for (i = 1; ; i++)
	{
		nRest = nDays - GetDays(i, 1, 1);
		if (nRest <= 0)
		{
			nYear = i - 1;
			nRest = nDays - GetDays(nYear, 1, 1);
			break;
		}
	}
    DaysInMonth[1] = ( ((nYear % 400) == 0) || (((nYear % 100) != 0) && ((nYear % 4) == 0)) ) ? 29 : 28;
	for (nMonth = 0; nMonth < 12; nMonth++)
	{
		if (nRest >= DaysInMonth[nMonth])
		{
			nRest -= DaysInMonth[nMonth];
		}
		else
		{
			break;
		}
	}
	nMonth++;
	
	return (nYear*10000 + nMonth*100 + nRest + 1);
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	HDC hdc = dc.m_hDC;
	HDC hdcMem = ::CreateCompatibleDC(hdc);
	HBITMAP hbmpMem = ::CreateCompatibleBitmap(hdc, c_ScreenWidth, c_ScreenHeight);
	HGDIOBJ hbmpOldMem = ::SelectObject(hdcMem, hbmpMem);

	//  
	HBRUSH  hbr = ::CreateSolidBrush(0xffffff);
	RECT	r = { 0, 0, c_ScreenWidth, c_ScreenHeight };
	::FillRect(hdcMem, &r, hbr);

	HDC hdcBitmap = ::CreateCompatibleDC(hdc);

	HGDIOBJ hbmpBitmapOld = ::SelectObject(hdcBitmap, g_hCards[0]);

	bool bMoveNow = (m_Option.bMoveAni && m_nMoveCount);

	SIZE size = { c_nCardWidth, c_nCardHeight };
    for (int pos = 0; pos < MAXPOS; pos++)
	{
	    for (int col = 0; col < MAXCOL; col++)
		{
			DWORD dwRop = SRCCOPY;
			if (col == 0)
			{
				if (pos > 8) continue;
				bool bEmpty = (m_Card.m_nCards[0][pos] == -1) || (bMoveNow && pos == -m_nMoveStartCol);
				if (pos == -m_nSelectCol) 
					dwRop = SRCINVERT;

				if (bEmpty)
				{
					if (pos <= 4)
					{
						// ִ FreeCell
						::Rectangle(hdcMem, (pos-1) * c_nTopGapWidth, 1, (pos-1) * c_nTopGapWidth + size.cx, 1 + size.cy);
					}
					else
					{
						// ִ HomeCell
						if (bMoveNow && pos == -m_nMoveStartCol && VALUE(m_Card.m_nCards[0][pos]) > 0)
							// HomeCell ִ ϴ, ׿ִ ǥø ؾ Ѵ.
							::SelectObject(hdcBitmap, g_hCards[ VALUE(m_Card.m_nCards[0][pos]) - 1 + SUIT(m_Card.m_nCards[0][pos])*13 ]);
						else
							::SelectObject(hdcBitmap, g_hCards[ 52 ]);
						::BitBlt(hdcMem, c_nTopGap + (pos-5) * c_nTopGapWidth, 1, size.cx, size.cy, hdcBitmap, 0, 0, SRCCOPY);
					}
				}
				else
				{
					::SelectObject(hdcBitmap, g_hCards[ VALUE(m_Card.m_nCards[0][pos]) + SUIT(m_Card.m_nCards[0][pos])*13 ]);
					if (pos <= 4)
						::BitBlt(hdcMem, (pos-1) * c_nTopGapWidth, 1, size.cx, size.cy, hdcBitmap, 0, 0, dwRop);
					else
						::BitBlt(hdcMem, c_nTopGap + (pos-5) * c_nTopGapWidth, 1, size.cx, size.cy, hdcBitmap, 0, 0, dwRop);
				}
			}
			else
			{
				if (m_Card.m_nCards[col][pos] != -1)
				{
					POINT p = { (col-1) * c_nGapWidth + c_nGapLeft, pos * c_nGapHeight + c_nGapTop };
					RECT  r = { p.x, p.y, p.x + size.cx, p.y + size.cy }; 

					if (pos == m_Card.GetLastPosInCol(col))
					{
						// col  ī̴.
						if (bMoveNow && col == m_nMoveStartCol)
						{
							// ̰ ִ  ī ǥø  ʴ´.
							continue;
						}
						if (col == m_nSelectCol)
						{
							// õ ī̴. ( ׸.)
							::FillRect(hdcMem, &r, hbr);
							dwRop = SRCINVERT;
						}
					}
					::SelectObject(hdcBitmap, g_hCards[ VALUE(m_Card.m_nCards[col][pos]) + SUIT(m_Card.m_nCards[col][pos])*13 ]);
					::BitBlt(hdcMem, p.x, p.y, size.cx, size.cy, hdcBitmap, 0, 0, dwRop);
				}
			}
		}
	}

	if (bMoveNow)
	{
		POINT p1, p2;
		if (m_nMoveStartCol > 0)
		{
			int nStartPos = m_Card.GetLastPosInCol(m_nMoveStartCol);
			
			::SelectObject(hdcBitmap, g_hCards[ VALUE(m_Card.m_nCards[m_nMoveStartCol][nStartPos]) + SUIT(m_Card.m_nCards[m_nMoveStartCol][nStartPos])*13 ]);
			p1.x = (m_nMoveStartCol-1) * c_nGapWidth + c_nGapLeft;
			p1.y = nStartPos * c_nGapHeight + c_nGapTop;
		}
		else
		{
			::SelectObject(hdcBitmap, g_hCards[ VALUE(m_Card.m_nCards[0][-m_nMoveStartCol]) + SUIT(m_Card.m_nCards[0][-m_nMoveStartCol])*13 ]);
			p1.x = (-m_nMoveStartCol-1) * c_nGapWidth + c_nGapLeft + ((-m_nMoveStartCol > 4) * 4);
			p1.y = 1;
		}

		if (m_nMoveEndCol > 0)
		{
			int nTargetPos = m_Card.GetLastPosInCol(m_nMoveEndCol) + 1;
			
			p2.x = (m_nMoveEndCol-1) * c_nGapWidth + c_nGapLeft;
			p2.y = nTargetPos * c_nGapHeight + c_nGapTop;
		}
		else
		{
			p2.x = (-m_nMoveEndCol-1) * c_nGapWidth + c_nGapLeft + ((-m_nMoveEndCol > 4) * 4);
			p2.y = 1;
		}
		
		SIZE dif = { (p2.x-p1.x)/(m_Option.nMoveStep) * m_nMoveCount, (p2.y-p1.y)/(m_Option.nMoveStep)*m_nMoveCount };
		POINT p3 = { p2.x - dif.cx, p2.y - dif.cy };
		
		::BitBlt(hdcMem, p3.x, p3.y, size.cx, size.cy , hdcBitmap, 0, 0, SRCCOPY);
	}
	else
	{
/*		
		int nCount = 0;
		POSITION posTemp = m_StateList.GetHeadPosition();
		
		for (int i = 0; i < m_StateList.GetCount(); i++)
		{
			if (m_posList == posTemp)
			{
				nCount = i + 1;
				break;
			}
			m_StateList.GetNext(posTemp);
		}
*/		
#ifdef _WIN32_WCE
		static LOGFONT logFont = {
			12,                        // nHeight
			0,                         // nWidth
			0,                         // nEscapement
			0,                         // nOrientation
			FW_NORMAL,                 // nWeight
			FALSE,                     // bItalic
			FALSE,                     // bUnderline
			0,                         // cStrikeOut
			ANSI_CHARSET,              // nCharSet
			OUT_DEFAULT_PRECIS,        // nOutPrecision
			CLIP_DEFAULT_PRECIS,       // nClipPrecision
			DEFAULT_QUALITY,           // nQuality
			DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
			_T("Arial")};                 // lpszFacename
		HFONT hFont = ::CreateFontIndirect(&logFont);
		HGDIOBJ hFontOld = SelectObject(hdcMem, hFont);
#endif
		static int s_nGameNum = -999;
		static CString s_strText = _T("");
		if (s_nGameNum != m_nGameNum)
		{
			int nNormal, nTry, nMark, nSolved;
			m_BoardStatusData.GetCount(nNormal, nTry, nMark, nSolved);
			int nStartDays = GetDays(m_Option.nStartDate / 10000, (m_Option.nStartDate / 100) % 100, m_Option.nStartDate % 100);
			CTime time = CTime::GetCurrentTime();
			int nTodays = GetDays(time.GetYear(), time.GetMonth(), time.GetDay());
			int nDays = nTodays - nStartDays;	// ϼ
			
			int nExpectDay = MakeDays(int(nStartDays + (32000-nSolved)/((double)nSolved / nDays)));

			//  
			int nTodayValue = LoadTodayValue(nTodays);
			
			CString strTemp = _T("");
			//strTemp.Format(_T("%3d:%3d/%3d "), m_nTryCount, nCount, m_StateList.GetCount());
			strTemp.Format(_T("Ϸ:%.2fذ:%d(%.2f%%):%04d-%02d-%02d:%d"),
				(double)nSolved / nDays,
				nSolved,
				nSolved * 100. / 32000.,
				nExpectDay / 10000, (nExpectDay / 100)%100, nExpectDay % 100,
				nTodayValue);
			s_strText = strTemp;
			s_nGameNum = m_nGameNum;
		}
		RECT rect_text = { 1, c_ScreenHeight-25, c_ScreenWidth, c_ScreenHeight-1 };
		::DrawText(hdcMem, (LPCTSTR)s_strText, s_strText.GetLength(), &rect_text, DT_BOTTOM);

#ifdef _WIN32_WCE
		::SelectObject(hdcMem, hFontOld);
		::DeleteObject(hFont);
#endif
	}
	::BitBlt(hdc, 0, 0, c_ScreenWidth, c_ScreenHeight, hdcMem, 0, 0, SRCCOPY);

	::DeleteObject(hbr);

	::SelectObject(hdcBitmap,hbmpBitmapOld);
	::DeleteDC(hdcBitmap);

	::SelectObject(hdcMem,hbmpOldMem);
	::DeleteObject(hbmpMem);
	::DeleteDC(hdcMem);
	// Do not call CWnd::OnPaint() for painting messages
}


BOOL CChildView::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	switch (pMsg->message)
	{
	case WM_LBUTTONDOWN:
		{
			if (!m_bIdle)
				goto endof_PreTranslateMessage;

			CPoint point(LOWORD(pMsg->lParam), HIWORD(pMsg->lParam));
			int nCol = m_Card.GetColByPoint(point);
			int nMode = 0;
			if (nCol > 0)
			{
				if (m_nSelectCol == 0)
				{
					// õ ī尡   , 
					if (m_Card.m_nCards[nCol][0] != -1)
					{
						//   ƴ 쿡,
						nMode = 1;
					}
				}
				else if (nCol == m_nSelectCol)
				{
					// õ  ٽ ϸ, 
					nMode = 2;
				}
				else
				{
					// ̵
					if (m_nSelectCol < 0)
					{
						// FreeCell -> Col
						int nCard = m_Card.GetLastCardInCol(nCol);
						if ((VALUE(m_nSelectCard) + 1 == VALUE(nCard) && COLOR(m_nSelectCard) != COLOR(nCard)) ||
							nCard == -1 )
							nMode = 3;
					}
					else 
					{
						switch (AddQueue(m_nSelectCol, nCol))
						{
						case 0:
							{
							}
							break;
						case 1:
							{
								nMode = 3;
							}
							break;
						default:
							{
								nMode = 4;
							}
						}
					}
				}
			}
			else
			{
				if (m_nSelectCol == 0)
				{
					if (-nCol <= 4 && m_Card.m_nCards[0][-nCol] != -1)
					{
						//   CELL ,
						nMode = 1;
					}
				}
				else if (nCol == m_nSelectCol)
				{
					nMode = 2;
				}
				else
				{
					int nEndCard = m_Card.m_nCards[0][-nCol];
					if ((-nCol <= 4 && nEndCard == -1) ||	// Target CELL̸, ־ ϰ
						(-nCol > 4 && ((nEndCard == -1 && VALUE(m_nSelectCard) == 0) ||// Target ״°̰, , Ace ÷ ϰ,
							((nEndCard != -1 && VALUE(nEndCard) != 12 && VALUE(nEndCard)+1 == VALUE(m_nSelectCard) && SUIT(nEndCard) == SUIT(m_nSelectCard))))
						))
					{
						// ̵
						nMode = 3;
					}
				}
			}

			switch (nMode)
			{
			case 1:
				{
					m_nSelectCol = nCol;
					m_nSelectCard = (nCol > 0) ? m_Card.GetLastCardInCol(nCol) : m_Card.m_nCards[0][-nCol];
				}
				break;
			case 2:
				{
					m_nSelectCol = 0;
					m_nSelectCard = -1;
				}
				break;
			case 3:
				{
					m_nMoveStartCol = m_nSelectCol;
					m_nMoveEndCol = nCol;
					m_MoveState = msNone;
					SetMoveTimer(true, true);
				}
				break;
			case 4:
				{
					// Queue
					QueueData qval;
					qval = m_QueueList.GetHead();
					m_nMoveStartCol = qval.nSource;
					m_nMoveEndCol = qval.nTarget;
					m_MoveState = msQueue;
					m_QueueList.RemoveHead();
					SetMoveTimer(true, false);
				}
				break;
			}
			Invalidate(FALSE);
		}
		break;

	case WM_LBUTTONDBLCLK:
		{
			if (!m_bIdle)
				goto endof_PreTranslateMessage;

			CPoint point(LOWORD(pMsg->lParam), HIWORD(pMsg->lParam));
			int nCol = m_Card.GetColByPoint(point);
			if (nCol > 0 && (m_nSelectCol == 0 || m_nSelectCol == nCol) )
			{
				if ((m_nMoveEndCol = m_Card.FindFreeCell()))
				{
					m_nMoveStartCol = nCol;
					SetMoveTimer(true, true);
				}
			}
		}
		break;
	case WM_TIMER:
		{
			int nID = pMsg->wParam;
			switch (nID)
			{
			case ID_TIMER_MOVE:
				{
					KillTimer(ID_TIMER_MOVE);
					Invalidate(FALSE);
					if ( --m_nMoveCount )
					{
						//  ̵
						SetTimer(ID_TIMER_MOVE, m_Option.nMoveDelay, NULL);
					}
					else
					{
						// ̵ Ϸ
						m_Card.Move(m_nMoveStartCol, m_nMoveEndCol);
						m_nSelectCol = 0;

						switch (m_MoveState)
						{
						case msUndo:
						case msUndoAll:
							{
								DoUndo();
							}
							break;
						case msUndoDone:
						case msRedoDone:
							{
								m_MoveState = msNone;
								m_bIdle = true;
							}
							break;
						case msRedo:
						case msRedoAll:
							{
								DoRedo();
							}
							break;
						case msQueue:
							{
								QueueData qval;
								qval = m_QueueList.GetHead();
								m_nMoveStartCol = qval.nSource;
								m_nMoveEndCol = qval.nTarget;
								m_QueueList.RemoveHead();
								bool bEnd = false;
								if (m_QueueList.GetCount() == 0)
								{
									m_MoveState = msNone;
									bEnd = true;
								}
								//SetMoveTimer(bSkip);
								SetMoveTimer(false, bEnd);
							}
							break;
						default:
							{
								// ̵ , ڵ ƾ Ѿ.
								SetTimer(ID_TIMER_AUTOUP, 1, NULL);
							}
						}
					}
				}
				break;
			case ID_TIMER_AUTOUP:
				{
					KillTimer(ID_TIMER_AUTOUP);

					int nEmptyCount = 0;
				    for (int col = -3; col < MAXCOL; col++)
					{
						int nCard = (col <= 0) ? m_Card.m_nCards[0][-col+1] : m_Card.GetLastCardInCol(col);
						if (nCard == -1)
						{
							++nEmptyCount;
							continue;
						}
						int nCardValue = VALUE(nCard);
						int nUpMinCard = (COLOR(nCard)) ? min(m_Card.m_nMoveUp[SPADE], m_Card.m_nMoveUp[CLUB]) : min(m_Card.m_nMoveUp[DIAMOND], m_Card.m_nMoveUp[HEART]);

						// A, 2 ϶ ,  ̻(3̻)  ̰ 1 ĿѴ.
						int nAddNum = (nCardValue <= 1) ? 2 : 1;

						if ((nCardValue == m_Card.m_nMoveUp[SUIT(nCard)] + 1) && (nCardValue <= nUpMinCard + nAddNum))
						{
							// find!!!
							m_nStatus = MOVEUP;
							m_nMoveStartCol = (col <= 0) ? col-1 : col;
							for (int i = 5; i <= 8; i++)
							{
								if ((((nCardValue == 0) && (m_Card.m_nCards[0][i] == -1)) || ((nCardValue != 0) && (SUIT(nCard) == SUIT(m_Card.m_nCards[0][i])))))
								{
									m_nMoveEndCol = -i;
									break;
								}
							}

							// ã, δ.
							SetMoveTimer(false, false);
							goto endof_PreTranslateMessage;
						}
					}
					if (nEmptyCount == 12)
					{
						// DONE !!!!
						m_bGameSolve = true;
						m_bModify = false;
						DoSave(0);
						if (AfxMessageBox(_T("մϴ. ϼ̽ϴ.  Ѿ ?"), MB_YESNO) == IDYES)
						{
							DoNextGame();
						}
					}
					//   Ŀ ޴ Ѵ.
					m_bIdle = true;
				}
				break;
			}
		}
		break;
	}

endof_PreTranslateMessage:
	return CWnd ::PreTranslateMessage(pMsg);
}

bool CChildView::LoadOptions()
{
	// Default Value
	m_Option.bMoveAni = false;
	m_Option.nMoveStep = 2;
	m_Option.nMoveDelay = 1;

	CRegistry reg;
	if (!reg.Open(HKEY_CURRENT_USER, REGKEY_OPTIONS, true))
		return false;

	// Get the settings
	DWORD dwData;
	if ( reg.Read(_T("UseMoveAnimation"),  dwData) )	m_Option.bMoveAni = dwData;				else	m_Option.bMoveAni = false;
	if ( reg.Read(_T("MoveStep"),  dwData) )			m_Option.nMoveStep = int(dwData);		else	m_Option.nMoveStep = 2;
	if ( reg.Read(_T("ModeDelay"), dwData) )			m_Option.nMoveDelay = int(dwData);		else	m_Option.nMoveDelay = 1;
	if ( reg.Read(_T("LastPlay"), dwData) )				m_nLastGameNum = m_nGameNum = dwData;	else	{m_nGameNum = GetRandomGameNum(); m_nLastGameNum = 0; }
	if ( reg.Read(_T("SelectStartDate"), dwData) )		m_Option.bSelectStartDate = dwData;		else	m_Option.bSelectStartDate = false;
	if ( reg.Read(_T("SelectEndDate"), dwData) )		m_Option.bSelectEndDate = dwData;		else	m_Option.bSelectEndDate = false;
	if ( reg.Read(_T("StartDate"), dwData) )			m_Option.nStartDate = dwData;			else	m_Option.nStartDate = 20000101;
	if ( reg.Read(_T("EndDate"), dwData) )				m_Option.nEndDate = dwData;				else	m_Option.nEndDate = 20000101;
	if ( reg.Read(_T("NextGameStyle"), dwData) )		m_Option.nNextGame = dwData;			else	m_Option.nNextGame = 1;
	if ( reg.Read(_T("NextNormal"), dwData) )			m_Option.bNextNormal = dwData;			else	m_Option.bNextNormal = false;
	if ( reg.Read(_T("NextTry"), dwData) )				m_Option.bNextTry = dwData;				else	m_Option.bNextTry = false;
	if ( reg.Read(_T("NextSolved"), dwData) )			m_Option.bNextSolved = dwData;			else	m_Option.bNextSolved = false;
	if ( reg.Read(_T("NextMark"), dwData) )				m_Option.bNextMark = dwData;			else	m_Option.bNextMark = false;
	if ( reg.Read(_T("ViewDaySolved"), dwData) )		m_Option.bViewDaySolved = dwData;		else	m_Option.bViewDaySolved = false;
	if ( reg.Read(_T("ViewRatio"), dwData) )			m_Option.bViewRatio = dwData;			else	m_Option.bViewRatio = false;
	if ( reg.Read(_T("ViewDayExpect"), dwData) )		m_Option.bViewDayExpect = dwData;		else	m_Option.bViewDayExpect = false;
	if ( reg.Read(_T("ViewEndDate"), dwData) )			m_Option.bViewEndDate = dwData;			else	m_Option.bViewEndDate = false;
	
	// Close registry
	reg.Close();

	// Return successfully
	return true;
}

bool CChildView::SaveOptions()
{
	// Try to open the registry
	CRegistry reg;
	if (!reg.Open(HKEY_CURRENT_USER, REGKEY_OPTIONS, true))
		return false;

	// Save the settings
	reg.Write(_T("UseMoveAnimation"), m_Option.bMoveAni );
	reg.Write(_T("MoveStep"),		m_Option.nMoveStep );
	reg.Write(_T("ModeDelay"),		m_Option.nMoveDelay );
	reg.Write(_T("LastPlay"),		m_nGameNum);
	reg.Write(_T("SelectStartDate"), m_Option.bSelectStartDate );
	reg.Write(_T("SelectEndDate"),	m_Option.bSelectEndDate );
	reg.Write(_T("StartDate"),		m_Option.nStartDate );
	reg.Write(_T("EndDate"),		m_Option.nEndDate );
	reg.Write(_T("NextGameStyle"),	m_Option.nNextGame );
	reg.Write(_T("NextNormal"),		m_Option.bNextNormal );
	reg.Write(_T("NextTry"),		m_Option.bNextTry );
	reg.Write(_T("NextSolved"),		m_Option.bNextSolved );
	reg.Write(_T("NextMark"),		m_Option.bNextMark );
	reg.Write(_T("ViewDaySolved"),	m_Option.bViewDaySolved );
	reg.Write(_T("ViewRatio"),		m_Option.bViewRatio );
	reg.Write(_T("ViewDayExpect"),	m_Option.bViewDayExpect );
	reg.Write(_T("ViewEndDate"),	m_Option.bViewEndDate );

	// Close registry
	reg.Close();

	// Return successfully
	return true;
}

int CChildView::CalcMaxMove(int nFreeCell, int nEmptyCol)
{
	return ((1 << nEmptyCol) * (nFreeCell + 1));
}

void CChildView::AddList(bool bStart, bool bEnd, int nStartCol, int nEndCol)
{
	StateData val;

	val.bStart = bStart ? 0x01 : 0x00;
	val.bEnd = bEnd ? 0x01 : 0x00;
	val.nSource = nStartCol + 8;
	val.nTarget = nEndCol + 8;

	/*
	// 纸 ڿ ִ Ʈ  Ѵ.
	int nCount = 0;
	POSITION posTemp = m_posList;
	while (posTemp != m_StateList.GetTailPosition())
	{
		nCount++;
		m_StateList.GetNext(posTemp);
	}

	// 纸 ڿ ִ Ʈ  3 ̸̻, ο  õϴ  Ѵ.
	if (nCount >= 3)
	{
		DoSave();
	}
	*/

	while (m_posList != m_StateList.GetTailPosition()) 
	{
		// m_posList ڿ ִ   .
		m_StateList.RemoveTail();
	}
	m_posList = m_StateList.AddTail(val);
}

void CChildView::SetMoveTimer(bool bStart, bool bEnd)
{
	m_bIdle = false;
	m_bModify = true;
	
	// ϳ ̸ õ .
	BoardStatusType bst = m_BoardStatusData.GetStatus(m_nGameNum);
	if (bst == bstNormal)
		m_BoardStatusData.SetStatus(m_nGameNum, bstTry, true);

	AddList(bStart, bEnd, m_nMoveStartCol, m_nMoveEndCol);

	if (m_Option.bMoveAni)
	{
		m_nMoveCount = m_Option.nMoveStep;
		SetTimer(ID_TIMER_MOVE, m_Option.nMoveDelay, NULL);
	}
	else
	{
		m_nMoveCount = 1;
		SetTimer(ID_TIMER_MOVE, 1, NULL);
	}
/*
	m_nMoveCount = (m_bOption_MoveAni) ? m_nOption_MoveStep : 1;
	while (m_nMoveCount--)
	{
		//Invalidate( FALSE );
		OnPaint();
		//SendMessage(WM_PAINT, 0, 0);
		if (m_bOption_MoveAni)
			::Sleep(m_nOption_MoveDelay);
	}
*/
}


void CChildView::DoUndo()
{
	if (m_posList)
	{
		m_bIdle = false;

		StateData val;

		val = m_StateList.GetPrev(m_posList);
		m_nMoveStartCol = val.nTarget - 8;
		m_nMoveEndCol = val.nSource - 8;
		
		if (m_MoveState != msUndoAll)
			m_MoveState = (val.bStart) ? msUndoDone : msUndo;
		
		if (m_Option.bMoveAni)
		{
			m_nMoveCount = m_Option.nMoveStep;
			SetTimer(ID_TIMER_MOVE, m_Option.nMoveDelay, NULL);
		}
		else
		{
			m_nMoveCount = 1;
			SetTimer(ID_TIMER_MOVE, 1, NULL);
		}
	}
	else
	{
		m_MoveState = msNone;
		m_bIdle = true;
	}
}

void CChildView::DoRedo()
{
	if (m_posList != m_StateList.GetTailPosition())
	{
		m_bIdle = false;

		StateData val;

		if (m_posList == NULL)
		{
			val = m_StateList.GetHead();
			m_posList = m_StateList.GetHeadPosition();
		}
		else
		{
			val = m_StateList.GetNext(m_posList);
			val = m_StateList.GetAt(m_posList);
		}
		m_nMoveStartCol = val.nSource - 8;
		m_nMoveEndCol = val.nTarget - 8;
		if (m_posList == m_StateList.GetTailPosition())
		{
			m_MoveState = msNone;
		}
		else
		{
			POSITION pos = m_posList;
			val = m_StateList.GetNext(pos);
			val = m_StateList.GetAt(pos);

			if (m_MoveState != msRedoAll)
				m_MoveState = (val.bEnd) ? msRedoDone : msRedo;
		}

		if (m_Option.bMoveAni)
		{
			m_nMoveCount = m_Option.nMoveStep;
			SetTimer(ID_TIMER_MOVE, m_Option.nMoveDelay, NULL);
		}
		else
		{
			m_nMoveCount = 1;
			SetTimer(ID_TIMER_MOVE, 1, NULL);
		}
	}
	else
	{
		m_MoveState = msNone;
		m_bIdle = true;
	}
}

void CChildView::DoUndoAll()
{
	m_MoveState = msUndoAll;
	DoUndo();
}

void CChildView::DoRedoAll()
{
	m_MoveState = msRedoAll;
	DoRedo();
}

#define QADD(val,source,target)		val.nSource = source;	\
									val.nTarget = target;	\
									m_QueueList.AddTail(val)

// AddQueue() : nStart -> nEnd   Ȥ  ī带 ű.
//  : nStart, nEnd  > 0 (, col -> col̴.)
// return : Queue   (1̸ ϳ ű ̹Ƿ,  Queue Ե ʴ´.)
int CChildView::AddQueue(int nStart, int nEnd)
{
	int nStartCard = m_Card.GetLastCardInCol(nStart);
	int nEndCard = m_Card.GetLastCardInCol(nEnd);

	m_QueueList.RemoveAll();

	if ((COLOR(nStartCard) != COLOR(nEndCard) && VALUE(nStartCard) == VALUE(nEndCard) - 1))
	{
		return 1;
	}

	int nContinuousFirstPosInCol = m_Card.GetContinuousFirstPosInCol(nStart, nEndCard);
	if (nContinuousFirstPosInCol == -1)
	{
		::AfxMessageBox(IDS_DONT_MOVE);
		return 0;
	}

	int nContinuousCount = m_Card.GetLastPosInCol(nStart) - nContinuousFirstPosInCol + 1;

	if (nEndCard == -1)
	{
		//  ̵
		if (nContinuousCount == 1)
		{
			// ϳ ̵
			return 1;
		}

		int nMaxMovable = m_Card.CountEmptyFreeCell() + 1;
		int nMove = min(nContinuousCount, nMaxMovable) - 1;
		
		// Queue  ....
		int nOrder[4];
		int nOrderPos = 0;
		for (int i = 1; i <= 4; i++)
		{
			if (m_Card.m_nCards[0][i] == -1)
			{
				nOrder[nOrderPos++] = -i;
			}
		}

		// FreeCell ̵
		QueueData val;
		for (i = 0; i < nMove; i++)
		{
			QADD(val, nStart, nOrder[i]);
		}
		QADD(val, nStart, nEnd);
		// FreeCell->Col
		for (i = nMove-1; i >= 0; i--)
		{
			QADD(val, nOrder[i], nEnd);
		}
	}
	else
	{
		// ī尡 ִ  ̵
		int nEmptyFreeCell = m_Card.CountEmptyFreeCell();
		int nEmptyCol = m_Card.CountEmptyCol();
		int nMaxMovable = CalcMaxMove(nEmptyFreeCell, nEmptyCol);
		
		if (nMaxMovable < nContinuousCount)
		{
			//::AfxMessageBox(_T("Don't move that..."));
			CString strMsg = _T("");
			strMsg.Format(IDS_NOT_ENOUGH_SPACE, nContinuousCount, nMaxMovable);
			::AfxMessageBox(strMsg);
			m_nSelectCol = 0;
			return 0;
		}
		
		if (nEmptyCol > 1 && CalcMaxMove(nEmptyFreeCell, 1) < nContinuousCount)
		{
			CString strMsg = _T("");
			strMsg.Format(IDS_NOT_ENOUGH_SPACE, nContinuousCount, CalcMaxMove(nEmptyFreeCell, 1));
			::AfxMessageBox(strMsg);
			//::AfxMessageBox(_T("????"));
			m_nSelectCol = 0;
#ifdef _DEBUG
			CFile	file(_T("\\My Documents\\FreeCell_error.dat"), CFile::modeCreate | CFile::modeWrite);
			file.Write(&m_nGameNum, sizeof(m_nGameNum));
			POSITION pos;
			pos = m_StateList.GetHeadPosition();
			int nCount = m_StateList.GetCount();
			file.Write(&nCount, sizeof(nCount));
			for (int i = 0; i < nCount; i++)
			{
				StateData val;
				val = m_StateList.GetNext(pos);
				file.Write(&val, sizeof(val));
			}
			file.Close();
#endif
			return 0;
		}

		// Queue  ....
		int nOrder[4];
		int nOrderPos = 0;
		for (int i = 1; i <= 4; i++)
		{
			if (m_Card.m_nCards[0][i] == -1)
			{
				nOrder[nOrderPos++] = -i;
			}
		}

		if (nEmptyFreeCell + 1 >= nContinuousCount)
		{
			// FreeCell Ͽ ̵ 

			// FreeCell ̵
			int nMove = nContinuousCount - 1;
			QueueData val;
			for (i = 0; i < nMove; i++)
			{
				QADD(val, nStart, nOrder[i]);
			}
			QADD(val, nStart, nEnd);
			// FreeCell->Col
			for (i = nMove-1; i >= 0; i--)
			{
				QADD(val, nOrder[i], nEnd);
			}
		}
		else
		{
			// ִ Colϳ FreeCell Ͽ ̵
			// 1. ִ col ̵
			int nEmptyCol = 0;
			for (int i = 1; i <= 8; i++)
				if (m_Card.m_nCards[i][0] == -1)
				{
					nEmptyCol = i;
					break;
				}

			int nMove1 = nContinuousCount - nEmptyFreeCell - 2;

			QueueData val;
			for (i = 0; i < nMove1; i++)
			{
				QADD(val, nStart, nOrder[i]);
			}
			QADD(val, nStart, nEmptyCol);
			for (i = nMove1-1; i >= 0; i--)
			{
				QADD(val, nOrder[i], nEmptyCol);
			}
			// 2.   ̵
			for (i = 0; i < nEmptyFreeCell; i++)
			{
				QADD(val, nStart, nOrder[i]);
			}
			QADD(val, nStart, nEnd);
			for (i = nEmptyFreeCell-1; i >= 0; i--)
			{
				QADD(val, nOrder[i], nEnd);
			}
			// 3.  Col ̵ߴ  ̵
			for (i = 0; i < nMove1; i++)
			{
				QADD(val, nEmptyCol, nOrder[i]);
			}
			QADD(val, nEmptyCol, nEnd);
			for (i = nMove1-1; i >= 0; i--)
			{
				QADD(val, nOrder[i], nEnd);
			}

		}
	}

	return m_QueueList.GetCount();
}

void CChildView::CheckDataFile(int nNum, bool& bDone, int& nMaxTry)
{
	WIN32_FIND_DATA		find_file_data;
	HANDLE	hFindFile = INVALID_HANDLE_VALUE;

	CString strDataFile;
	bDone = false;
	nMaxTry = 0;
	strDataFile.Format(FILEFIND_FMT, nNum);
	hFindFile = FindFirstFile( strDataFile, &find_file_data );
	if( (hFindFile != INVALID_HANDLE_VALUE) )
	{
		do
		{
			CString strMax( find_file_data.cFileName );
			int nTemp = _ttoi(strMax.Mid(6, strMax.GetLength() - 10));
			if (nTemp == 0)
			{
				bDone = true;
			}
			else if (nTemp > nMaxTry)
			{
				nMaxTry = nTemp;
			}
		} 
		while( FindNextFile(hFindFile, &find_file_data) );
		FindClose( hFindFile );
	}
}

void CChildView::DoSave(int nNum/*= -1*/)
{
	CreateDirectory(PATH_BASE, NULL);

	if (nNum == 0)
	{
		// ,
		m_BoardStatusData.SetStatus(m_nGameNum, bstSolved, true);
		
		// õߴ Ÿ ϵ  .
		CString fname = _T("");
		fname.Format(FILEFIND_FMT, m_nGameNum);

		WIN32_FIND_DATA		find_file_data;
		HANDLE hFindFile = INVALID_HANDLE_VALUE;

		hFindFile = FindFirstFile(fname, &find_file_data);
		if ( (hFindFile != INVALID_HANDLE_VALUE) )
		{
			do 
			{
				CString strDelete;
				strDelete.Format(_T("%s\\%s"), PATH_BASE, find_file_data.cFileName);
				DeleteFile(strDelete);
			}
			while ( FindNextFile(hFindFile, &find_file_data) );
			FindClose( hFindFile );
		}
		
		// ó¥ ذᰳ Ѵ.
		SaveTodayValue(LoadTodayValue()+1);
	}
	else
	{
		BoardStatusType bst = m_BoardStatusData.GetStatus(m_nGameNum);
		if (bst == bstNormal)
			m_BoardStatusData.SetStatus(m_nGameNum, bstTry, true);

		// nNum ã´.
		if (nNum == -1)
		{
			bool bDone;
			CheckDataFile(m_nGameNum, bDone, nNum);
			nNum++;
		}
		
		// file save
		CString fname = _T("");
		fname.Format(DATA_FILENAME_FMT, m_nGameNum, nNum);
		CFile	file(fname, CFile::modeCreate | CFile::modeWrite);
		file.Write(&m_nGameNum, sizeof(m_nGameNum));
		POSITION pos;
		pos = m_StateList.GetHeadPosition();
		int nCount = m_StateList.GetCount();
		file.Write(&nCount, sizeof(nCount));
		for (int i = 0; i < nCount; i++)
		{
			StateData val;
			val = m_StateList.GetNext(pos);
			file.Write(&val, sizeof(val));
		}
		file.Close();
		m_bModify = false;
		m_nTryCount = nNum + 1;
	}
}

bool CChildView::DoLoad()
{
#ifdef _WIN32_WCE
	CFileDialog dlg(TRUE, NULL, NULL, OFN_PROPERTY, _T("PocketFreeCell File (*.pfc)|*.pfc||") );
#else
	CFileDialog dlg(TRUE, NULL, NULL, NULL, _T("PocketFreeCell File (*.pfc)|*.pfc||") );
#endif
	if (dlg.DoModal() == IDOK)
	{
		if (m_StateList.GetCount() > 0)
		{
			if (MessageBox(_T("Abort this game?"), _T("Confirmation"), MB_ICONWARNING | MB_YESNO) == IDNO)
				return false;
		}

		CFile file(dlg.m_ofn.lpstrFile, CFile::modeRead);
		file.Read(&m_nGameNum, sizeof(m_nGameNum));

		NewBoard( m_nGameNum );

		int nCount;
		file.Read(&nCount, sizeof(nCount));
		for (int i = 0; i < nCount; i++)
		{
			StateData val;
			file.Read(&val, sizeof(val));
			m_StateList.AddTail(val);
		}
		file.Close();
		return true;
	}
	else
		return false;
}

bool CChildView::CheckAndLoad(int nGameNum)
{
	bool bDone;
	int nMaxTry;
	CheckDataFile(nGameNum, bDone, nMaxTry);

	if (bDone)
	{
		CString strTemp = _T("");
		strTemp.Format(_T("You already solved #%d. Resolve?"), nGameNum);
		if (MessageBox(strTemp, _T("Confirmation"), MB_ICONWARNING | MB_YESNO) == IDNO)
		{
			return false;
		}
	}
	else if (nMaxTry > 0)
	{
		CString strTemp = _T("");
		strTemp.Format(_T("You already try #%d. Load the last try?"), nGameNum);
		if (MessageBox(strTemp, _T("Confirmation"), MB_ICONWARNING | MB_YESNO) == IDYES)
		{
			CString fname = _T("");
			fname.Format(DATA_FILENAME_FMT, nGameNum, nMaxTry);
			CFile file(fname, CFile::modeRead);
			file.Read(&nGameNum, sizeof(nGameNum));

			NewBoard( nGameNum );

			int nCount;
			file.Read(&nCount, sizeof(nCount));
			for (int i = 0; i < nCount; i++)
			{
				StateData val;
				file.Read(&val, sizeof(val));
				m_StateList.AddTail(val);
			}
			file.Close();

			Invalidate(FALSE);
			DoRedoAll();
			
			return true;
		}
		else
		{
			return false;
		}
	}

	//m_nGameNum = nGameNum;

	NewBoard( nGameNum );
	Invalidate(FALSE);
	DoRedoAll();

	return true;
}

bool CChildView::DoNextGame()
{
	int nGameNum = m_nGameNum;
	while (!m_BoardStatusData.CheckStatus(++nGameNum, m_Option.bNextNormal, m_Option.bNextTry, m_Option.bNextMark, m_Option.bNextSolved))
	{
		if (nGameNum == 32000)
			nGameNum = 0;
	}

	CheckAndLoad(nGameNum);

	return true;
}

bool CChildView::DoPrevGame()
{
	int nGameNum = m_nGameNum;
	while (!m_BoardStatusData.CheckStatus(--nGameNum, m_Option.bNextNormal, m_Option.bNextTry, m_Option.bNextMark, m_Option.bNextSolved))
	{
		if (nGameNum == 1)
			nGameNum = 32001;
	}

	CheckAndLoad(nGameNum);

	return true;
}

bool CChildView::DoRestart()
{
	// Ǯ  ̸,    Ѵ.

	CString strTemp = _T("");
	strTemp.Format(_T("Restart #%d?"), m_nGameNum);
	if (MessageBox(strTemp, _T("Confirmation"), MB_ICONWARNING | MB_YESNO) == IDYES)
	{
		NewBoard( m_nGameNum);
	}

	return true;
}

void CChildView::NewBoard(int nGameNum/*=-1*/)
{
	if (m_bModify)
		DoSave();

	if (nGameNum != -1)
	{
		m_nGameNum = nGameNum;
	}

	m_Card.NewBoard( m_nGameNum );
	m_StateList.RemoveAll();
	m_posList = NULL;
	m_nSelectCol = 0;
	m_nSelectCard = -1;
	m_bGameSolve = false;
	m_bModify = false;

	::AfxGetMainWnd()->PostMessage(WM_UPDATETITLE, (WPARAM)m_nGameNum);
	Invalidate(FALSE);
}

void CChildView::DoSolve()
{
	m_pvSolveInstance = freecell_solver_user_alloc();
	CCard local_card = m_Card;
	static char SuitChar[4] = {'C', 'D', 'H', 'S'};
	static char* strNum[13] = { "A", "2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K" };

	m_szUserState[0] = 0x00;

	m_bIdle = false;

	if (local_card.CountEmptyFreeCell() < 4)
	{
		strcat(m_szUserState, "FC:");
		for (int i = 0; i < 4; i++)
		{
			int nCard = local_card.m_nCards[0][i+1];
			
			if (nCard == -1)
			{
				strcat(m_szUserState, " -");
			}
			else
			{
				sprintf(m_szUserState + strlen(m_szUserState), " %s%c", strNum[VALUE(nCard)], SuitChar[SUIT(nCard)]);
			}
		}
		strcat(m_szUserState, "\n");
	}

	int nHomeCell = 0;
	for (int i = 0; i < 4; i++)
	{
		if (local_card.m_nCards[0][i+5] == -1)
			nHomeCell++;
	}
	if (nHomeCell < 4)
	{
		strcat(m_szUserState, "Founds:");
		for (int i = 0; i < 4; i++)
		{
			int nNum = local_card.m_nMoveUp[i];

			if (nNum == -1)
			{
				sprintf(m_szUserState + strlen(m_szUserState), " %c-*", SuitChar[i]);
			}
			else
			{
				sprintf(m_szUserState + strlen(m_szUserState), " %c-%s", SuitChar[i], strNum[nNum]);
			}
		}
		strcat(m_szUserState, "\n");
	}

	for (i = 1; i <= 8; i++)
	{
		for (int j = 0; j < MAXPOS; j++)
		{
			int nCard = local_card.m_nCards[i][j];

			if (nCard == -1)
				break;

			sprintf(m_szUserState + strlen(m_szUserState), "%s%c ", strNum[VALUE(nCard)], SuitChar[SUIT(nCard)]);
		}
		strcat(m_szUserState, "\n");
	}
/*
	// MS Freecell 1 ڷ
	strcpy(user_state,
//
		"Founds: D-* H-A C-* S-*\n"
		"FC: JD\n"
		"KD 2S 4C 3S 6D 6S\n" // row 1
		"2D KC KS 5C 10D 8S 9C\n" // row 2
		"9H 9S 9D 10S 4S 8D 2H\n" // row 3...
		"JC 5S QD QH 10H QS 6H\n"
		"5D AD JS 4H 8H 6C\n"
		"7H QC AS AC 2C 3D\n"
		"7C KH    4D JH 8C\n"
		"5H 3H 3C 7S 7D 10C\n"
//
/*		
		"JD KD 2S 4C 3S 6D 6S\n" // row 1
		"2D KC KS 5C 10D 8S 9C\n" // row 2
		"9H 9S 9D 10S 4S 8D 2H\n" // row 3...
		"JC 5S QD QH 10H QS 6H\n"
		"5D AD JS 4H 8H 6C\n"
		"7H QC AS AC 2C 3D\n"
		"7C KH AH 4D JH 8C\n"
		"5H 3H 3C 7S 7D 10C\n"

		);
*/

	m_pSolveThread = new CSolveThread;
	m_pSolveThread->CreateThread();

	m_pWaitDlg = new CWaitDlg;
	if (m_pWaitDlg->DoModal() != IDOK)
	{
		goto exit;
	}

//	int ret = freecell_solver_user_solve_board(instance, user_state);

	if (m_nSolveResult == FCS_STATE_INVALID_STATE)
	{
		// user_state ̻ϴ.
		TRACE(_T("Invalid User State...\n"));
		::AfxMessageBox(IDS_DONT_UNDERSTAND_SOLVE);
	}
	else
	{
		if (m_nSolveResult == FCS_STATE_WAS_SOLVED)
		{
			// solved
			fcs_move_t move;
			char * as_string;
			int move_num = 0;

			POSITION pos = m_posList;
			while (m_posList != m_StateList.GetTailPosition()) 
			{
				// m_posList ڿ ִ   .
				m_StateList.RemoveTail();
			}

			CCard local_card = m_Card;

			while ( freecell_solver_user_get_next_move( m_pvSolveInstance, &move ) == 0 )
			{
				

				as_string = freecell_solver_user_move_to_string(move, 0);
#ifdef _WIN32_WCE
				TCHAR szString[256];
				memset(szString, 0x00, sizeof(szString));
				MultiByteToWideChar(CP_ACP, 0, as_string, strlen(as_string), szString, 256);
				TRACE(_T("%3d: %3d %3d %3d %3d - %s\n"), move_num, move.c[0], move.c[1], move.c[2], move.c[3], szString);
#else
				TRACE(_T("%3d: %3d %3d %3d %3d - %s\n"), move_num, move.c[0], move.c[1], move.c[2], move.c[3], as_string);
#endif

#define _MOVE(s,e)	{ AddList(true, true, (s), (e)); local_card.Move( (s), (e) ); ++move_num;}

#define _MOVE_NO_STACK(s,e,n)	\
				{										\
					for (int i = 0; i < (n); i++)		\
					{									\
						_MOVE( (s), nFreeOrder[i] )		\
					}									\
					_MOVE( (s), (e) )					\
					for (i = (n)-1; i >= 0; i--)		\
					{									\
						_MOVE( nFreeOrder[i], (e) )		\
					}									\
				}

#define _MOVE_ONE_STACK(s,m,e,n1,n2)	\
				{											\
					if ((n1) >= 0)							\
						_MOVE_NO_STACK( (s), (m), (n1) )	\
					if ((n2) >= 0)							\
						_MOVE_NO_STACK( (s), (e), (n2) )	\
					if ((n1) >= 0)							\
						_MOVE_NO_STACK( (m), (e), (n1) )	\
				}


				switch (move.c[0])
				{
				case FCS_MOVE_TYPE_STACK_TO_STACK:
					{
						int nStart = move.c[1]+1;
						int nEnd   = move.c[2]+1;

						// Empty FreeCell ľ
						int nFreeOrder[4];
						int nFreePos = 0;
						for (int i = 1; i <= 4; i++)
						{
							if (local_card.m_nCards[0][i] == -1)
							{
								nFreeOrder[nFreePos++] = -i;
							}
						}

						// Empty Stack ľ
						int nStackOrder[8];
						int nStackPos = 0;
						for (i = 1; i <= 8; i++)
						{
							if ((local_card.m_nCards[i][0] == -1) && (i != move.c[2] + 1))
							{
								nStackOrder[nStackPos++] = i;
							}
						}

						if (move.c[3] == 1)
						{
							// ű ī尡 ϳ.
							_MOVE( nStart, nEnd );
						}
						else if (nFreePos >= move.c[3] -1)
						{
							// FreeCell ű  ִ.
							int nMove = move.c[3] - 1;
							_MOVE_NO_STACK( nStart, nEnd, nMove );
						}
						else if (nStackPos >= 1 && move.c[3] <= CalcMaxMove(nFreePos, 1))
						{
							// FreeCell  Stack 1θ ű  ִ.
							int nMove1 = move.c[3] - CalcMaxMove(nFreePos, 0) - 1;

							_MOVE_ONE_STACK( nStart, nStackOrder[0], nEnd, nMove1, nFreePos );
						}
						else if (nStackPos >= 2 && move.c[3] <= CalcMaxMove(nFreePos, 2))
						{
							// FreeCell  Stack 2 ű  ִ.
							int nMove1 = move.c[3] - CalcMaxMove(nFreePos, 1) - CalcMaxMove(nFreePos, 0) - 1;
							int nMove2 = move.c[3] - CalcMaxMove(nFreePos, 1) - 1;
							if (nMove2 > nFreePos)
								nMove2 = nFreePos;

							_MOVE_ONE_STACK( nStart, nStackOrder[0], nStackOrder[1], nMove1, nMove2 );
							_MOVE_ONE_STACK( nStart, nStackOrder[0], nEnd, nFreePos, nFreePos);
							_MOVE_ONE_STACK( nStackOrder[1], nStackOrder[0], nEnd, nMove2, nMove1 );
						}
						else
						{
							TRACE(_T("... not supported...\n"));
							::AfxMessageBox(IDS_NOT_SUPPORT);
							free(as_string);
							m_posList = pos;
							goto exit;
						}
					}
					break;
				case FCS_MOVE_TYPE_STACK_TO_FREECELL:
					{
						_MOVE(move.c[1] + 1, -move.c[2] - 1);
					}
					break;
				case FCS_MOVE_TYPE_FREECELL_TO_STACK:
					{
						_MOVE(-move.c[1] - 1, move.c[2] + 1);
					}
					break;
				case FCS_MOVE_TYPE_FREECELL_TO_FREECELL:
					{
						_MOVE(-move.c[1] - 1, -move.c[2] - 1);
					}
					break;
				case FCS_MOVE_TYPE_STACK_TO_FOUNDATION:
					{
						int nCard = local_card.GetLastCardInCol( move.c[1]+1 );
						int nCardValue = VALUE(nCard);
						int nEndCol = 0;
						for (int i = 5; i <= 8; i++)
						{
							if ((((nCardValue == 0) && (local_card.m_nCards[0][i] == -1)) || ((nCardValue != 0) && (SUIT(nCard) == SUIT(local_card.m_nCards[0][i])))))
							{
								nEndCol = -i;
								break;
							}
						}
						if (nEndCol == 0)
						{
							TRACE(_T("Error....Not found empty home cell....\n"));
							CString strMsg=_T("");
							strMsg.Format(IDS_INTERNAL_SOLVER_ERROR, 101);
							::AfxMessageBox(strMsg);
							free(as_string);
							m_posList = pos;
							goto exit;
						}
						_MOVE(move.c[1] + 1, nEndCol);
					}
					break;
				case FCS_MOVE_TYPE_FREECELL_TO_FOUNDATION:
					{
						int nCard = local_card.m_nCards[0][ move.c[1]+1 ];
						int nCardValue = VALUE(nCard);
						int nEndCol = 0;
						for (int i = 5; i <= 8; i++)
						{
							if ((((nCardValue == 0) && (local_card.m_nCards[0][i] == -1)) || ((nCardValue != 0) && (SUIT(nCard) == SUIT(local_card.m_nCards[0][i])))))
							{
								nEndCol = -i;
								break;
							}
						}
						if (nEndCol == 0)
						{
							TRACE(_T("Error....Not found empty home cell....\n"));
							CString strMsg=_T("");
							strMsg.Format(IDS_INTERNAL_SOLVER_ERROR, 102);
							::AfxMessageBox(strMsg);
							free(as_string);
							m_posList = pos;
							goto exit;
						}

						_MOVE(-move.c[1] - 1, nEndCol);
					}
					break;
				}
				free(as_string);
			}
			m_posList = pos;
		}
		else
		{
			// not solved...
			TRACE(_T("I could not solve this game.\n"));
			::AfxMessageBox(IDS_DONT_UNDERSTAND_SOLVE);
		}
	}
exit:
	BeginWaitCursor();

	freecell_solver_user_free(m_pvSolveInstance);
	Invalidate( FALSE );

	delete m_pWaitDlg;
	m_pWaitDlg = NULL;

	if (::WaitForSingleObject(m_pSolveThread->m_hThread, 100) == WAIT_TIMEOUT)
	{
		::TerminateThread(m_pSolveThread->m_hThread, 0);
	}
	delete m_pSolveThread;
	m_pSolveThread = NULL;

	m_bIdle = true;
	EndWaitCursor();
}

int CChildView::GetRandomGameNum()
{
	bool bPrevIdle = m_bIdle;
	m_bIdle = false;

	CTime t = CTime::GetCurrentTime();
	srand( (unsigned int)t.GetTime() );
/*
	
	bool bDone;
	int nMaxTry;

	int nCount = rand() % (rand() %30 + 1);
	for (int i = 0; i < nCount; i++)
		rand();

	int nGameNum;
	do
	{
		nGameNum = rand() % 32000 + 1;
		CheckDataFile( nGameNum, bDone, nMaxTry );
	} while (!bDone && nMaxTry != 0);
*/
	int nCount = 0;
	int nGameNum;

	for (;;)
	{
		if (++nCount > 320000)
		{
			nGameNum = -1;
			break;
		}

		nGameNum = rand() % 32000 + 1;
		BoardStatusType status = m_BoardStatusData.GetStatus(nGameNum);
		if (m_Option.bNextNormal && status == bstNormal) break;
		if (m_Option.bNextTry && status == bstTry) break;
		if (m_Option.bNextMark && status == bstMark) break;
		if (m_Option.bNextSolved && status == bstSolved) break;
	} 

	m_bIdle = bPrevIdle;

	return nGameNum;
}

void CChildView::DoNewGame()
{
	NewBoard( GetRandomGameNum() );
}

void CChildView::OnSolve() 
{
	if ( !m_bIdle ) return;

	DoSolve();
}

void CChildView::OnUpdateSolve(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnGameLoad() 
{
	if ( !m_bIdle ) return;

	DoLoad();
}

void CChildView::OnGameNew() 
{
	if ( !m_bIdle ) return;

	DoNewGame();
}

void CChildView::OnGameOption() 
{
	if ( !m_bIdle ) return;

	COptionDlg dlg;
	//dlg.m_bFullScreen = FALSE;
	memcpy(&dlg.m_Option, &m_Option, sizeof(m_Option));

	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		memcpy(&m_Option, &dlg.m_Option, sizeof(m_Option));
		SaveOptions();
	}
	else
	{
	}
}

void CChildView::OnGameRedoAll() 
{
	if ( !m_bIdle ) return;

	DoRedoAll();
}

void CChildView::OnGameRestart() 
{
	if ( !m_bIdle ) return;

	DoRestart();
}

void CChildView::OnGameSave() 
{
	if ( !m_bIdle ) return;

	DoSave();
}

void CChildView::OnGameSelect() 
{
	if ( !m_bIdle ) return;

	CSelectGameDlg dlg;
	//dlg.m_nSelectGame = m_nGameNum;
	dlg.m_nSelectGame = GetRandomGameNum();
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		bool bDone;
		int nTryCount;
		CheckDataFile( dlg.m_nSelectGame, bDone, nTryCount);
		NewBoard( dlg.m_nSelectGame );
		m_nTryCount = nTryCount + 1;
	}
	else if (nResponse == IDCANCEL)
	{
	}
}

void CChildView::OnGameUndoAll() 
{
	if ( !m_bIdle ) return;

	DoUndoAll();
}

void CChildView::OnNewgame() 
{
	if ( !m_bIdle ) return;

	DoNewGame();
}

void CChildView::OnNextgame() 
{
	if ( !m_bIdle ) return;

	DoNextGame();
}

void CChildView::OnPrevgame() 
{
	if ( !m_bIdle ) return;

	DoPrevGame();
}

void CChildView::OnRedo() 
{
	if ( !m_bIdle ) return;

	DoRedo();
}

void CChildView::OnUndo() 
{
	if ( !m_bIdle ) return;

	DoUndo();
}

void CChildView::OnUpdateGameLoad(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameNew(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameOption(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameRedoAll(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameRestart(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameSave(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameSelect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateGameUndoAll(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateNewgame(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateNextgame(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdatePrevgame(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_bIdle );
}

void CChildView::OnUpdateRedo(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_posList != m_StateList.GetTailPosition() && m_bIdle);
}

void CChildView::OnUpdateUndo(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bIdle && m_posList != NULL);
}

BOOL CChildView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL bResult = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

/*
	bool bDone;
	int nMaxTry;
	do
	{
		CheckDataFile(m_nGameNum, bDone, nMaxTry);
		if (bDone)
		{
			if (++m_nGameNum > 32000)
				m_nGameNum = 1;
		}
	} while (bDone);

	CheckAndLoad(m_nGameNum);
*/
	m_BoardStatusData.Load(PATH_BASE, m_nLastGameNum);

	/*
	CString strTemp;
	int N = m_BoardStatusData.GetStatusCount(bstNormal);
	int T = m_BoardStatusData.GetStatusCount(bstTry);
	int M = m_BoardStatusData.GetStatusCount(bstMark);
	int S = m_BoardStatusData.GetStatusCount(bstSolved);
	strTemp.Format(_T("N: %d, T: %d, M: %d, S: %d, Total: %d"), 
		N, T, M, S, N+T+M+S);
	AfxMessageBox(strTemp);
	*/

	CheckAndLoad(m_nGameNum);

	return bResult;
}

void CChildView::PostNcDestroy() 
{
	if (!m_bDoneExitProcess)
	{
		m_bDoneExitProcess = true;
		if (m_bModify)
			DoSave();

		SaveOptions();
	}
	
	CWnd ::PostNcDestroy();
}

void CChildView::OnAppExit() 
{
	if (!m_bDoneExitProcess)
	{
		m_bDoneExitProcess = true;
		if (m_bModify)
			DoSave();

		SaveOptions();
	}
	theApp.m_pMainWnd->SendMessage(WM_CLOSE);
}

int CChildView::LoadTodayValue(int nToday /*= -1*/)
{
	int nResult = 0;

	if (nToday == -1)
	{
		CTime time = CTime::GetCurrentTime();
		nToday = GetDays(time.GetYear(), time.GetMonth(), time.GetDay());
	}

	CRegistry reg;
	int nTodayValue = 0;
	if (reg.Open(HKEY_CURRENT_USER, REGKEY_OPTIONS, true))
	{
		DWORD dwTodayKey, dwTodayValue;
		if ( reg.Read(_T("TodayKey"),  dwTodayKey) )	
		{
			if ( (int)dwTodayKey == nToday && reg.Read(_T("TodayValue"), dwTodayValue) )
				nResult = dwTodayValue;
		}
		reg.Close();
	}

	return nResult;
}

bool CChildView::SaveTodayValue(int nValue, int nToday /*= -1*/)
{
	if (nToday == -1)
	{
		CTime time = CTime::GetCurrentTime();
		nToday = GetDays(time.GetYear(), time.GetMonth(), time.GetDay());
	}

	CRegistry reg;
	if (!reg.Open(HKEY_CURRENT_USER, REGKEY_OPTIONS, true))
		return false;

	reg.Write(_T("TodayKey"), nToday);
	reg.Write(_T("TodayValue"), nValue);
	reg.Close();

	return true;
}

