// Card.h: interface for the CCard class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CARD_H__51D23881_25F1_4684_AF6B_D2955CDD6275__INCLUDED_)
#define AFX_CARD_H__51D23881_25F1_4684_AF6B_D2955CDD6275__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define     BLACK           0               // COLOR(card)
#define     RED             1

#define     ACE             0               // VALUE(card)
#define     DEUCE           1

#define     CLUB            0               // SUIT(card)
#define     DIAMOND         1
#define     HEART           2
#define     SPADE           3

#define     SUIT(card)      ((card) % 4)
#define     VALUE(card)     ((card) / 4)
#define     COLOR(card)     (SUIT(card) == DIAMOND || SUIT(card) == HEART)

#define     MAXPOS         21
#define     MAXCOL          9    // includes top row as column 0
#define		MAXDECK			52

#ifdef _WIN32_WCE
	const	c_nCardWidth	= 29;
	const	c_nCardHeight	= 41;
	const	c_nGapLeft		= 0;
	const	c_nGapTop		= c_nCardHeight + 1;
	const	c_nGapWidth		= c_nCardWidth + 1;
	const	c_nGapHeight	= 12;

	const	c_nTopGapWidth	= c_nCardWidth;
	const	c_nFreeCellWidth = c_nCardWidth * 4;
	const	c_nTopGap = c_nFreeCellWidth + 8;

	const	c_ScreenWidth	= 240;
	const	c_ScreenHeight	= 270;
#else
	const	c_nCardWidth	= 71;
	const	c_nCardHeight	= 96;
	const	c_nGapLeft		= 0;
	const	c_nGapTop		= c_nCardHeight + 4;
	const	c_nGapWidth		= c_nCardWidth + 1;
	const	c_nGapHeight	= 20;

	const	c_nTopGapWidth	= c_nCardWidth;
	const	c_nFreeCellWidth = c_nCardWidth * 4;
	const	c_nTopGap = c_nFreeCellWidth + 8;

	const	c_ScreenWidth	= 640;
	const	c_ScreenHeight	= 480;
#endif

class CCard  
{
public:
	int CountEmptyCol();
	int CountEmptyFreeCell();
	int GetContinuousFirstCardInCol(int nCol, int nLastCard);
	int GetContinuousFirstPosInCol(int nCol, int nLastCard);
	int FindFreeCell();
	void InitBoard();
	void PrintBoard();
	int GetLastCardInCol(int nCol);
	int GetLastPosInCol(int nCol);
	int GetColByPoint(CPoint point);
	void Move(int nStartCol, int nEndCol);

	int m_nCards[MAXCOL][MAXPOS];
	int m_nDeck[MAXDECK];
	int m_nMoveUp[4];
	
	void NewBoard(int nNum);
	CCard();
	virtual ~CCard();
	static int CalcMaxMove(int nFreeCell, int nEmptyCol)
	{
		return ((1 << nEmptyCol) * (nFreeCell + 1));
	};

	void operator=(const CCard& card)
	{
		memcpy(m_nCards, card.m_nCards, sizeof(m_nCards));
		memcpy(m_nDeck, card.m_nDeck, sizeof(m_nDeck));
		memcpy(m_nMoveUp, card.m_nMoveUp, sizeof(m_nMoveUp));
	};
 
private:
};

#endif // !defined(AFX_CARD_H__51D23881_25F1_4684_AF6B_D2955CDD6275__INCLUDED_)
