// Card.cpp: implementation of the CCard class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PocketFreeCell.h"
#include "CardType.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCard::CCard()
{
	InitBoard();
}

CCard::~CCard()
{
}

void CCard::NewBoard(int nNum)
{
	InitBoard();
    int  wLeft = 52;          // cards left to be chosen in shuffle

    srand(nNum);            // gamenumber is seed for rand()
    for (int i = 0; i < 52; i++)
    {
        int j = rand() % wLeft;
        m_nCards[(i%8)+1][i/8] = m_nDeck[j];
        m_nDeck[j] = m_nDeck[--wLeft];
    }
}

void CCard::PrintBoard()
{
    for (int pos = 0; pos < MAXPOS; pos++)
	{
	    for (int col = 0; col < MAXCOL; col++)
		{
			if (m_nCards[col][pos] == -1)
				TRACE(_T(" -   "));
			else
				TRACE(_T("%d-%.2d "), SUIT( m_nCards[col][pos] ), VALUE( m_nCards[col][pos] )+1 );
		}
		TRACE(_T("\n"));
	}
}

void CCard::InitBoard()
{
    int  i;                // generic counters
    int  col, pos;

    for (col = 0; col < MAXCOL; col++)          // clear the deck
        for (pos = 0; pos < MAXPOS; pos++)
            m_nCards[col][pos] = -1;

    for (i = 0; i < 52; i++)      // put unique card in each deck loc.
        m_nDeck[i] = i;

	for (i = 0; i < 4; i++)
		m_nMoveUp[i] = -1;
}

// ش Point ϴ col
int CCard::GetColByPoint(CPoint point)
{
	int nCol;

	if (point.y >= c_nGapTop)
	{
		nCol = ((point.x - c_nGapLeft) / c_nGapWidth) + 1;
	}
	else
	{
		if (point.x < c_nFreeCellWidth)
			nCol = -(((point.x - c_nGapLeft) / c_nTopGapWidth) + 1);
		else if (point.x >= c_nTopGap)
			nCol =  -(((point.x - c_nTopGap) / c_nTopGapWidth) + 5);
		else
			nCol = 0;
	}
	if (nCol > 8 || nCol < -8)
		nCol = 0;

	return nCol;
}

// ش col ִ  ī
int CCard::GetLastCardInCol(int nCol)
{
	int nPos = GetLastPosInCol(nCol);
	return (nPos == -1) ? -1 : m_nCards[nCol][nPos];
}

// ش col  ī尡 ִ pos
int CCard::GetLastPosInCol(int nCol)
{
	for (int pos = 0; pos < MAXPOS; pos++)
	{
		if (m_nCards[nCol][pos] == -1) {
			return pos - 1;
		}
	}
	return -1;
}

int CCard::FindFreeCell()
{
	for (int i = 1; i <= 4; i++)
		if (m_nCards[0][i] == -1)
			return -i;
	return 0;
}

int CCard::GetContinuousFirstPosInCol(int nCol, int nLastCard)
{
	int nPos = GetLastPosInCol(nCol);
	if (nPos == -1)
	{
		// ī尡 ϳ .
		return -1;
	}

	int nBaseCard = m_nCards[nCol][nPos];
	int nCard;

	for (; nPos > 0; nPos--)
	{
		nCard = m_nCards[nCol][nPos-1];
		if ((COLOR(nBaseCard) == COLOR(nCard)) || VALUE(nBaseCard) + 1 != VALUE(nCard))
		{
			break;
		}
		if ((COLOR(nCard) == COLOR(nLastCard)) && (VALUE(nCard) == VALUE(nLastCard)))
		{
			break;
		}
		nBaseCard = nCard;
	}
	if (nLastCard == -1)
		return nPos;

	nCard = m_nCards[nCol][nPos];
	if ((COLOR(nLastCard) == COLOR(nCard)) || VALUE(nLastCard) != VALUE(nCard) + 1)
		return -1;
	else
		return nPos;
}

int CCard::GetContinuousFirstCardInCol(int nCol, int nLastCard)
{
	int nPos = GetContinuousFirstPosInCol(nCol, nLastCard);
	return (nPos == -1) ? -1 : m_nCards[nCol][nPos];
}

// ִ freecell 
int CCard::CountEmptyFreeCell()
{
	int nCount = 0;

	for (int i = 1; i <= 4; i++)
		if (m_nCards[0][i] == -1)
			nCount++;

	return nCount;
}

//   
int CCard::CountEmptyCol()
{
	int nCount = 0;

	for (int i = 1; i <= 8; i++)
		if (m_nCards[i][0] == -1)
			nCount++;
		
	return nCount;
}

void CCard::Move(int nStartCol, int nEndCol)
{
	// ̵ Ϸ
	int *pStart = (nStartCol < 0) ? &(m_nCards[0][-nStartCol]) : &(m_nCards[nStartCol][GetLastPosInCol(nStartCol)  ]);
	int *pEnd   = (nEndCol   < 0) ? &(m_nCards[0][-nEndCol  ]) : &(m_nCards[nEndCol  ][GetLastPosInCol(nEndCol  )+1]);

	*pEnd = *pStart;

	if (nEndCol <= -5) // -5, -6, -7, -8
	{
		// HomeCell ̵̸, HomeCell ֻ  ش.
		m_nMoveUp[SUIT(*pEnd)] = VALUE(*pEnd);
	}
	
	if (nStartCol <= -5)
	{
		int tempCard = VALUE(*pStart) - 1;
		m_nMoveUp[SUIT(*pStart)] = tempCard;
		*pStart = (tempCard > -1) ? *pStart - 4 : -1;
	}
	else
	{
		*pStart = -1;
	}
}
