/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<WinTimer.c>	2005-03-13,10:51

*/

#include "WinTimer.h"



static HS_UINT		gTimerListId = 0;
static NoLockList	gTimerList;
static HSSemaphore	gSemaTimerList;



typedef struct
{
	HS_UINT			timerListId;
	HS_QID			queueId;
	HS_TIMER_ID		timerId;
	HS_UINT			subId;
} TimerSet;


HSTimerEvent *_sip_new_HSTimerEvent(HS_TIMER_ID pTimerId, HS_UINT pSubId)
{
	HSTimerEvent *result = NULL;

	if( (result=(HSTimerEvent*)HSMalloc(sizeof(HSTimerEvent))) == NULL ) return NULL;

	result->timerId = pTimerId;
	result->subId = pSubId;

	return result;
}
HS_RESULT _sip_deletem_HSTimerEvent(HSTimerEvent *pObj)
{
	if( pObj == NULL ) return HS_ERR_NULL_PARAM;
	
	HSFree(pObj);
	return HS_OK;
}


static HS_RESULT _sip_new_TimerSet( TimerSet *pObj, HS_QID pQueueId, HS_TIMER_ID pTimerId, HS_UINT pSubId )
{
	if( pObj == NULL ) return HS_ERR_NULL_PARAM;

	pObj->queueId = pQueueId;
	pObj->timerId = pTimerId;
	pObj->subId = pSubId;
	pObj->timerListId = gTimerListId++;
	return HS_OK;
}
static HS_RESULT _sip_delete_TimerSet( TimerSet *pObj )
{
	return HS_OK;
}


static HS_RESULT _sip_NoLockList_AttachTimerSet( NoLockList *pObj, void *pData )
{
	HS_RESULT ret;

	HSLockSemaphore(gSemaTimerList);
	ret = NoLockList_AttachData(pObj, pData);
	HSUnlockSemaphore(gSemaTimerList);

	return ret;
}
static HS_RESULT _sip_NoLockList_DeleteTimerChain( NoLockList *pObj, void *pData )
{
	HS_RESULT ret;

	HSLockSemaphore(gSemaTimerList);
	ret = NoLockList_DeleteChain(pObj, pData);
	HSUnlockSemaphore(gSemaTimerList);

	return ret;
}
static ChainUnit *_sip_NoLockList_FindTimerSetByTimerListId( NoLockList *pObj, HS_UINT pTimerListId )
{
	HS_UINT i;
	ChainUnit *ret = NULL;
	TimerSet *tSet = NULL;

	if( pObj == NULL ) return NULL;
	if( pObj->size == 0 ) return NULL;

	HSLockSemaphore(gSemaTimerList);
	ret = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( ret == NULL )
		{
			ret = NULL;
			break;
		}
		if( ret->data == NULL )
		{
			ret = NULL;
			break;
		}

		tSet = (TimerSet*)(ret->data);
		if( tSet->timerListId == pTimerListId ) break;

		ret = ret->next;
	}
	HSUnlockSemaphore(gSemaTimerList);

	return ret;
}
static ChainUnit *_sip_NoLockList_FindTimerSetByTimerId( NoLockList *pObj, HS_TIMER_ID pTimerId, HS_UINT pSubId )
{
	HS_UINT i;
	ChainUnit *ret = NULL;
	TimerSet *tSet = NULL;

	if( pObj == NULL ) return NULL;
	if( pObj->size == 0 ) return NULL;

	HSLockSemaphore(gSemaTimerList);
	ret = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( ret == NULL )
		{
			ret = NULL;
			break;
		}
		if( ret->data == NULL )
		{
			ret = NULL;
			break;
		}

		tSet = (TimerSet*)(ret->data);
		if( tSet->timerId == pTimerId && tSet->subId == pSubId ) break;

		ret = ret->next;
	}
	HSUnlockSemaphore(gSemaTimerList);

	return ret;
}
HS_RESULT _sip_NoLockList_DeleteTimerSetByTimerId( NoLockList *pObj, HS_TIMER_ID pTimerId, HS_UINT pSubId )
{
	ChainUnit *tChain;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	
	if( (tChain=_sip_NoLockList_FindTimerSetByTimerId(pObj,pTimerId,pSubId)) != NULL )
		return _sip_NoLockList_DeleteTimerChain(pObj,tChain);

	return HS_ERR_SIP_NO_EXIST;
}



HS_RESULT _sip_InitTimerList()
{
	HSOpenSemaphore(gSemaTimerList);
	return new_NoLockList( &gTimerList, _sip_delete_TimerSet );
}
HS_RESULT _sip_CloseTimerList()
{
	delete_NoLockList( &gTimerList );
	HSCloseSemaphore(gSemaTimerList);
	return HS_OK;
}






unsigned __stdcall _sip_TimerThread( void* pParam )
{
	ChainUnit *tChain = NULL;
	HSTimerEvent *tEvent = NULL;
	TimerObject *tTimerObject = (TimerObject *)pParam;

	if( tTimerObject == NULL )
	{
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex( 0 );
#endif
		return 0;
	}

	if( tTimerObject->type == e_TimerType_Forever )
	{
		while(1)
		{
			Sleep( tTimerObject->milliSecond );
			if( (tChain=_sip_NoLockList_FindTimerSetByTimerListId( &gTimerList, tTimerObject->timerListId)) != NULL )
			{
				if( (tEvent=new_HSTimerEvent(tTimerObject->timerId, tTimerObject->subId)) != NULL )
					_HSThreadSendMessage(tTimerObject->queueId, HS_QM_TIMER, 0, (LPARAM)tEvent);
			}
			else break;
		}
	}
	else
	{
		Sleep( tTimerObject->milliSecond );
		if( (tChain=_sip_NoLockList_FindTimerSetByTimerListId( &gTimerList, tTimerObject->timerListId )) != NULL )
		{
			if( (tEvent=new_HSTimerEvent(tTimerObject->timerId, tTimerObject->subId)) != NULL )
				_HSThreadSendMessage(tTimerObject->queueId, HS_QM_TIMER, 0, (LPARAM)tEvent);

			_sip_NoLockList_DeleteTimerChain(&gTimerList, tChain);
		}
	}

	HSFree( tTimerObject );
#ifdef _WIN32_WCE
	ExitThread(0);
#else
	_endthreadex( 0 );
#endif
	return 0;
}



HS_RESULT _sip_HSSetTimer(HS_UINT pMilliSecond, HS_QID pQueueId, HS_TIMER_ID pTimerId, HS_UINT pSubId, TimerType pType)
{
	HS_QID	tQueueId;
	TimerSet *tTimerSet = NULL;
	TimerObject *tTimerObject = NULL;

	if( pMilliSecond == 0 || pQueueId == 0 ) return HS_ERR_NULL_PARAM;

	HSKillTimer( pTimerId, pSubId );

	if( (tTimerSet=(TimerSet*)HSMalloc( sizeof(TimerSet) )) != NULL )
		_sip_new_TimerSet(tTimerSet, pQueueId, pTimerId, pSubId);
	else
		return HS_ERR_MALLOC;

	if( (tTimerObject=(TimerObject *)HSMalloc( sizeof(TimerObject) )) != NULL )
	{
		tTimerObject->milliSecond = pMilliSecond;
		tTimerObject->queueId = pQueueId;
		tTimerObject->timerId = pTimerId;
		tTimerObject->subId = pSubId;
		tTimerObject->type = pType;
		tTimerObject->timerListId = tTimerSet->timerListId;
	}
	else
	{
		_sip_delete_TimerSet( tTimerSet );
		HSFree(tTimerSet);
		return HS_ERR_MALLOC;
	}

	_sip_NoLockList_AttachTimerSet(&gTimerList, tTimerSet);
#ifdef _WIN32_WCE
	CreateThread(NULL,0,_sip_TimerThread,(void *)tTimerObject,0,&tQueueId);
#else
	_beginthreadex(NULL,0,_sip_TimerThread,(void *)tTimerObject,0,&tQueueId);
#endif

	return HS_OK;
}


HS_RESULT _sip_HSKillTimer(HS_TIMER_ID pTimerId, HS_UINT pSubId)
{
	return _sip_NoLockList_DeleteTimerSetByTimerId( &gTimerList, pTimerId, pSubId );
}