// PlusPhoneDlg.h : header file
//

#if !defined(AFX_PLUSPHONEDLG_H__B465B386_BDE0_4FA9_80FB_4B1CFA95645E__INCLUDED_)
#define AFX_PLUSPHONEDLG_H__B465B386_BDE0_4FA9_80FB_4B1CFA95645E__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "../os_win32/BookDlg.h"
#include "../os_win32/OptionDlg.h"
#include "../os_win32/GlassBox.h"
#include "../os_win32/InterfaceDlg.h"




#define PHONE_OPEN_SIZE		252
#define PHONE_CLOSE_SIZE	140

#define APP_MAX_PHONE_BOOK	10

#define ID_MENU_ADD			HS_QM_MAX +1
#define ID_MENU_DELETE		HS_QM_MAX +2
#define ID_MENU_CANCEL		HS_QM_MAX +3
#define ID_MENU_NUMBER		HS_QM_MAX +10
#define ID_MENU_NUMBER_1	ID_MENU_NUMBER +1
#define ID_MENU_NUMBER_2	ID_MENU_NUMBER +2
#define ID_MENU_NUMBER_3	ID_MENU_NUMBER +3
#define ID_MENU_NUMBER_4	ID_MENU_NUMBER +4
#define ID_MENU_NUMBER_5	ID_MENU_NUMBER +5
#define ID_MENU_NUMBER_6	ID_MENU_NUMBER +6
#define ID_MENU_NUMBER_7	ID_MENU_NUMBER +7
#define ID_MENU_NUMBER_8	ID_MENU_NUMBER +8
#define ID_MENU_NUMBER_9	ID_MENU_NUMBER +9





/////////////////////////////////////////////////////////////////////////////
// CPlusPhoneDlg dialog

class CPlusPhoneDlg : public CDialog
{
// Construction
public:
	CPlusPhoneDlg(CWnd* pParent = NULL);	// standard constructor

// Programer's data
	enum Protocol
	{
		e_Protocol_H323,
		e_Protocol_Sip,
		e_ProtocolMax
	};
	
	enum State
	{
		e_State_Idle,
		e_State_Tone,
		e_State_Proceed,
		e_State_Powerring,
		e_State_Connect,
		e_StateMax
	};

	enum MenuPoint
	{
		e_MenuPoint_PhoneBook,
		e_MenuPoint_History,
		e_MenuPoint_Delete,
		e_MenuPointMax
	};

	HS_QID		mQid;
	State		mState;
	BOOL		mIsH323Reg;
	BOOL		mIsSipReg;
	BOOL		mFHold;
	BOOL		mRHold;
	Protocol	mProtocol;

	PPOption	mOption;

	char		mDial[128];
	HS_UINT		mDialPos;
	CString		mStateString;
	CString		mCodecString;

	MenuPoint	mMenuPoint;
	NoLockList	mBookList;
	NoLockList	mHistoryList;

// Programer's function
	void SetState(State pState,CString pStateString);
	void ShowState();
	HS_RESULT LoadOption(PPOption *pOption);
	HS_RESULT SaveOption(PPOption *pOption);
	HS_RESULT TestOption();
	HS_RESULT LoadBook();
	HS_RESULT SaveBook();
	HS_RESULT LoadHistory();
	HS_RESULT SaveHistory();

	HS_RESULT OnActiveCall();
	HS_RESULT OnActiveOption();
	HS_RESULT OnActiveHangup();
	HS_RESULT OnActiveClear();
	HS_RESULT OnActiveCancel();
	HS_RESULT OnActiveSend();
	HS_RESULT OnActiveSendHold();
	HS_RESULT OnActiveSendResume();
	HS_RESULT OnActiveRecvHold();
	HS_RESULT OnActiveRecvResume();
	HS_RESULT OnActiveMessage();
	HS_RESULT OnActiveAccept();
	HS_RESULT OnActiveReject();

	void OnKeyboardN(char pKey);

	void OnMenu_Add();
	void OnMenu_Delete();
	void OnMenu_Cancel();
	void OnMenu_Number(HS_UINT pIndex);
	void OnMenu_0();
	void OnMenu_1();
	void OnMenu_2();
	void OnMenu_3();
	void OnMenu_4();
	void OnMenu_5();
	void OnMenu_6();
	void OnMenu_7();
	void OnMenu_8();
	void OnMenu_9();
	/*void OnMenu_APP_MAX_PHONE_BOOK()*/

// GUI data
	CBitmap		mMainImage;
	CBitmap		*mOldImage;

	CBitmapButton	mRccButtonNStar;
	CBitmapButton	mRccButtonNShap;
	CBitmapButton	mRccButtonSip;
	CBitmapButton	mRccButtonN9;
	CBitmapButton	mRccButtonN8;
	CBitmapButton	mRccButtonN7;
	CBitmapButton	mRccButtonN6;
	CBitmapButton	mRccButtonN5;
	CBitmapButton	mRccButtonN4;
	CBitmapButton	mRccButtonN3;
	CBitmapButton	mRccButtonN2;
	CBitmapButton	mRccButtonN1;
	CBitmapButton	mRccButtonN0;
	CBitmapButton	mRccButtonH323;
	CBitmapButton	mRccButtonB2;
	CBitmapButton	mRccButtonB1;
	CBitmapButton	mRccButtonA2;
	CBitmapButton	mRccButtonA1;

	CBitmapButton	mRccButtonExit;
	CBitmapButton	mRccButtonMini;
	CBitmapButton	mRccButtonBook;
	CBitmapButton	mRccButtonHistory;
// Dialog Data
	//{{AFX_DATA(CPlusPhoneDlg)
	enum { IDD = IDD_PLUSPHONE_DIALOG };
	CGlassBox		mRccListMain;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPlusPhoneDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CPlusPhoneDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg void OnAppCid(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppIncoming(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppConnected(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppCodec(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppCallEnd(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppDtmf(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppMsg(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppRegistSuccess(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAppRegistFail(WPARAM wParam,LPARAM lParam);
	afx_msg void OnButtonA1();
	afx_msg void OnButtonA2();
	afx_msg void OnButtonB1();
	afx_msg void OnButtonB2();
	afx_msg void OnButtonH323();
	afx_msg void OnButtonN0();
	afx_msg void OnButtonN1();
	afx_msg void OnButtonN2();
	afx_msg void OnButtonN3();
	afx_msg void OnButtonN4();
	afx_msg void OnButtonN5();
	afx_msg void OnButtonN6();
	afx_msg void OnButtonN7();
	afx_msg void OnButtonN8();
	afx_msg void OnButtonN9();
	afx_msg void OnButtonNshap();
	afx_msg void OnButtonNstar();
	afx_msg void OnDestroy();
	afx_msg void OnButtonBook();
	afx_msg void OnButtonHistory();
	afx_msg void OnButtonExit();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PLUSPHONEDLG_H__B465B386_BDE0_4FA9_80FB_4B1CFA95645E__INCLUDED_)
