// PlusPhoneDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "PlusPhoneDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif







static HS_RESULT NoLockList_DeleteHistoryByString(NoLockList *pList,char *pString)
{
	HS_UINT i;
	char *tString = NULL;
	ChainUnit *rounder = NULL;

	if( pList==NULL || pString==NULL ) return HS_ERR_NULL_PARAM;

	rounder = pList->units;
	for(i=0;i<pList->size;i++)
	{
		if( rounder==NULL ) return HS_ERR;
		if( (tString=(char*)(rounder->data))==NULL ) return HS_ERR;

		if( !strcmp(tString,pString) ) break;

		rounder = (ChainUnit*)(rounder->next);
	}

	if( rounder != NULL )
		return NoLockList_DeleteChain(pList,rounder);

	return HS_OK;
}


static HS_RESULT NoLockList_ShowBookList(NoLockList *pList,CMenu *pMenu)
{
	HS_UINT i;
	CString tString;
	char *tCharString = NULL;
	ChainUnit *rounder = NULL;

	if( pList==NULL || pMenu==NULL ) return HS_ERR_NULL_PARAM;

	rounder = pList->units;
	for(i=0;i<pList->size;i++)
	{
		if( rounder==NULL ) return HS_ERR;
		if( (tCharString=(char*)(rounder->data))==NULL ) return HS_ERR;

		tString = tCharString;
		pMenu->AppendMenu(MF_STRING,ID_MENU_NUMBER+i,tString);
		rounder = (ChainUnit*)(rounder->next);

	}

	return HS_OK;
}


static HS_RESULT NoLockList_ShowHistoryList(NoLockList *pList,CMenu *pMenu)
{
	return NoLockList_ShowBookList(pList,pMenu);
}



/////////////////////////////////////////////////////////////////////////////
// CPlusPhoneDlg dialog

CPlusPhoneDlg::CPlusPhoneDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPlusPhoneDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlusPhoneDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	mQid = HS_INVALID_QID;
	mState = e_State_Idle;
	mProtocol = e_Protocol_Sip;

	mIsH323Reg = FALSE;
	mIsSipReg = FALSE;

	memset(mDial,0,128);
	mDialPos = 0;
	mStateString = "Hook On";
	mCodecString.Empty();

	mMenuPoint = e_MenuPointMax;

	mMainImage.LoadBitmap(IDB_MAIN);
}

void CPlusPhoneDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlusPhoneDlg)
	DDX_Control(pDX, IDC_LIST_MAIN, mRccListMain);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPlusPhoneDlg, CDialog)
	//{{AFX_MSG_MAP(CPlusPhoneDlg)
	ON_WM_PAINT()
	ON_MESSAGE(HS_QM_APP_CID,OnAppCid)
	ON_MESSAGE(HS_QM_APP_INCOMING,OnAppIncoming)
	ON_MESSAGE(HS_QM_APP_CONNECTED,OnAppConnected)
	ON_MESSAGE(HS_QM_APP_CODEC,OnAppCodec)
	ON_MESSAGE(HS_QM_APP_CALL_END,OnAppCallEnd)
	ON_MESSAGE(HS_QM_APP_DTMF,OnAppDtmf)
	ON_MESSAGE(HS_QM_APP_MSG,OnAppMsg)
	ON_MESSAGE(HS_QM_APP_REGIST_SUCC,OnAppRegistSuccess)
	ON_MESSAGE(HS_QM_APP_REGIST_FAIL,OnAppRegistFail)
	ON_BN_CLICKED(IDC_BUTTON_A1, OnButtonA1)
	ON_BN_CLICKED(IDC_BUTTON_A2, OnButtonA2)
	ON_BN_CLICKED(IDC_BUTTON_B1, OnButtonB1)
	ON_BN_CLICKED(IDC_BUTTON_B2, OnButtonB2)
	ON_BN_CLICKED(IDC_BUTTON_H323, OnButtonH323)
	ON_BN_CLICKED(IDC_BUTTON_N0, OnButtonN0)
	ON_BN_CLICKED(IDC_BUTTON_N1, OnButtonN1)
	ON_BN_CLICKED(IDC_BUTTON_N2, OnButtonN2)
	ON_BN_CLICKED(IDC_BUTTON_N3, OnButtonN3)
	ON_BN_CLICKED(IDC_BUTTON_N4, OnButtonN4)
	ON_BN_CLICKED(IDC_BUTTON_N5, OnButtonN5)
	ON_BN_CLICKED(IDC_BUTTON_N6, OnButtonN6)
	ON_BN_CLICKED(IDC_BUTTON_N7, OnButtonN7)
	ON_BN_CLICKED(IDC_BUTTON_N8, OnButtonN8)
	ON_BN_CLICKED(IDC_BUTTON_N9, OnButtonN9)
	ON_BN_CLICKED(IDC_BUTTON_NSHAP, OnButtonNshap)
	ON_BN_CLICKED(IDC_BUTTON_NSTAR, OnButtonNstar)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_BOOK, OnButtonBook)
	ON_BN_CLICKED(IDC_BUTTON_HISTORY, OnButtonHistory)
	ON_BN_CLICKED(ID_MENU_ADD,OnMenu_Add)
	ON_BN_CLICKED(ID_MENU_DELETE,OnMenu_Delete)
	ON_BN_CLICKED(ID_MENU_CANCEL,OnMenu_Cancel)
	ON_BN_CLICKED(ID_MENU_NUMBER  ,OnMenu_0)
	ON_BN_CLICKED(ID_MENU_NUMBER_1,OnMenu_1)
	ON_BN_CLICKED(ID_MENU_NUMBER_2,OnMenu_2)
	ON_BN_CLICKED(ID_MENU_NUMBER_3,OnMenu_3)
	ON_BN_CLICKED(ID_MENU_NUMBER_4,OnMenu_4)
	ON_BN_CLICKED(ID_MENU_NUMBER_5,OnMenu_5)
	ON_BN_CLICKED(ID_MENU_NUMBER_6,OnMenu_6)
	ON_BN_CLICKED(ID_MENU_NUMBER_7,OnMenu_7)
	ON_BN_CLICKED(ID_MENU_NUMBER_8,OnMenu_8)
	ON_BN_CLICKED(ID_MENU_NUMBER_9,OnMenu_9)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnButtonExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlusPhoneDlg message handlers

BOOL CPlusPhoneDlg::OnInitDialog()
{
	CInterfaceDlg mIpDlg;

	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	// TODO: Add extra initialization here
	mRccButtonNStar.AutoLoad(IDC_BUTTON_NSTAR,this);
	mRccButtonNShap.AutoLoad(IDC_BUTTON_NSHAP,this);
	mRccButtonSip.AutoLoad(IDC_BUTTON_SIP,this);
	mRccButtonN9.AutoLoad(IDC_BUTTON_N9,this);
	mRccButtonN8.AutoLoad(IDC_BUTTON_N8,this);
	mRccButtonN7.AutoLoad(IDC_BUTTON_N7,this);
	mRccButtonN6.AutoLoad(IDC_BUTTON_N6,this);
	mRccButtonN5.AutoLoad(IDC_BUTTON_N5,this);
	mRccButtonN4.AutoLoad(IDC_BUTTON_N4,this);
	mRccButtonN3.AutoLoad(IDC_BUTTON_N3,this);
	mRccButtonN2.AutoLoad(IDC_BUTTON_N2,this);
	mRccButtonN1.AutoLoad(IDC_BUTTON_N1,this);
	mRccButtonN0.AutoLoad(IDC_BUTTON_N0,this);
	mRccButtonH323.AutoLoad(IDC_BUTTON_H323,this);
	mRccButtonB2.AutoLoad(IDC_BUTTON_B2,this);
	mRccButtonB1.AutoLoad(IDC_BUTTON_B1,this);
	mRccButtonA2.AutoLoad(IDC_BUTTON_A2,this);
	mRccButtonA1.AutoLoad(IDC_BUTTON_A1,this);

	mRccButtonExit.AutoLoad(IDC_BUTTON_EXIT,this);
	mRccButtonMini.AutoLoad(IDC_BUTTON_MINI,this);
	mRccButtonBook.AutoLoad(IDC_BUTTON_BOOK,this);
	mRccButtonHistory.AutoLoad(IDC_BUTTON_HISTORY,this);

	// todo for stack
	HS_UINT tIntIp;
	HS_UCHAR tLocalIp[4];
	LoadHSResource(100);

#if 1
	if( GetLocalIp(tLocalIp)==FALSE )
	{
		UnloadHSResource(1000);
		MessageBox(_T("Fail to get local IP"));
		SetState(e_StateMax,"Invalid");
		return TRUE;
	}
#else
	mIpDlg.DoModal();

	if( mIpDlg.mIpAddr.IsEmpty()==TRUE )
	{
		UnloadHSResource(1000);
		MessageBox(_T("Fail to get local IP"));
		SetState(e_StateMax,"Invalid");
		return TRUE;
	}

	tIntIp = inet_addr( (const char*)mIpDlg.mIpAddr.GetBuffer(0) );
	memcpy(tLocalIp,&tIntIp,4);
#endif

	/*TestOption();*/
	if( LoadOption(&mOption) != HS_OK )
	{
		UnloadHSResource(1000);
		MessageBox(_T("Fail to load option"));
		SetState(e_StateMax,"Invalid");
		return TRUE;
	}
	LoadBook();
	LoadHistory();

	if( ! is_blank(mOption.mGeneral.mLogServer) )
		HSPrintToNetworkOn(mOption.mGeneral.mLogServer,5530);

	if( (mQid=PPCore_Start(GetSafeHwnd(),tLocalIp,mOption))==HS_INVALID_QID )
	{
		UnloadHSResource(1000);
		MessageBox(_T("Fail to start core task"));
		SetState(e_StateMax,"Invalid");
		return TRUE;
	}

	HSPrint("\n Start PlusPhone on %u.%u.%u.%u",tLocalIp[0],tLocalIp[1],tLocalIp[2],tLocalIp[3]);
	SetState(e_State_Idle,"Hook Sleep");
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPlusPhoneDlg::OnPaint() 
{
	/* draw background image
	*/
	BITMAP		tBitmap;
	CPaintDC	dc(this);
	CDC			tCdc;
	CDC			*tPcdc = &dc;

	mMainImage.GetObject(sizeof(BITMAP),&tBitmap);
	tCdc.CreateCompatibleDC(tPcdc);
	mOldImage = tCdc.SelectObject(&mMainImage);
	tPcdc->BitBlt(0,0,tBitmap.bmWidth,tBitmap.bmHeight,&tCdc,0,0,SRCCOPY);
	tCdc.SelectObject(mOldImage);

	// Do not call CDialog::OnPaint() for painting messages
}

/*
 *
 * programer's function
 *
 */
void CPlusPhoneDlg::SetState(CPlusPhoneDlg::State pState,CString pStateString)
{
	mStateString = pStateString;

	switch(pState)
	{
		case e_State_Idle:
			ChangeButtonText(&mRccButtonA1,"call");
			ChangeButtonText(&mRccButtonA2,"option");
			/* clear screen
			*/
			mRccButtonB1.EnableWindow(FALSE);
			mRccButtonB2.EnableWindow(FALSE);
			mRccButtonN0.EnableWindow(FALSE);
			mRccButtonN1.EnableWindow(FALSE);
			mRccButtonN2.EnableWindow(FALSE);
			mRccButtonN3.EnableWindow(FALSE);
			mRccButtonN4.EnableWindow(FALSE);
			mRccButtonN5.EnableWindow(FALSE);
			mRccButtonN6.EnableWindow(FALSE);
			mRccButtonN7.EnableWindow(FALSE);
			mRccButtonN8.EnableWindow(FALSE);
			mRccButtonN9.EnableWindow(FALSE);
			mRccButtonNShap.EnableWindow(FALSE);
			mRccButtonNStar.EnableWindow(FALSE);
			mState = pState;
			mDialPos = 0;
			mCodecString.Empty();
			ShowState();
			return;
		case e_State_Tone:
			ChangeButtonText(&mRccButtonA1,"hangup");
			ChangeButtonText(&mRccButtonA2,"send");
			/* display screen
			*/
			ChangeButtonText(&mRccButtonB1,"cancel");
			ChangeButtonText(&mRccButtonB2,"clear");
			mRccButtonB1.EnableWindow();
			mRccButtonB2.EnableWindow();
			mRccButtonN0.EnableWindow();
			mRccButtonN1.EnableWindow();
			mRccButtonN2.EnableWindow();
			mRccButtonN3.EnableWindow();
			mRccButtonN4.EnableWindow();
			mRccButtonN5.EnableWindow();
			mRccButtonN6.EnableWindow();
			mRccButtonN7.EnableWindow();
			mRccButtonN8.EnableWindow();
			mRccButtonN9.EnableWindow();
			mRccButtonNShap.EnableWindow();
			mRccButtonNStar.EnableWindow();
			mState = pState;
			ShowState();
			return;
		case e_State_Proceed:
			ChangeButtonText(&mRccButtonA1,"hangup");
			ChangeButtonText(&mRccButtonA2,"send");
			/* clear screen
			*/
			mRccButtonB1.EnableWindow(FALSE);
			mRccButtonB2.EnableWindow(FALSE);
			mRccButtonN0.EnableWindow(FALSE);
			mRccButtonN1.EnableWindow(FALSE);
			mRccButtonN2.EnableWindow(FALSE);
			mRccButtonN3.EnableWindow(FALSE);
			mRccButtonN4.EnableWindow(FALSE);
			mRccButtonN5.EnableWindow(FALSE);
			mRccButtonN6.EnableWindow(FALSE);
			mRccButtonN7.EnableWindow(FALSE);
			mRccButtonN8.EnableWindow(FALSE);
			mRccButtonN9.EnableWindow(FALSE);
			mRccButtonNShap.EnableWindow(FALSE);
			mRccButtonNStar.EnableWindow(FALSE);
			mState = pState;
			ShowState();
			return;
		case e_State_Powerring:
			ChangeButtonText(&mRccButtonA1,"accept");
			ChangeButtonText(&mRccButtonA2,"reject");
			/* clear screen
			*/
			mRccButtonB1.EnableWindow(FALSE);
			mRccButtonB2.EnableWindow(FALSE);
			mRccButtonN0.EnableWindow(FALSE);
			mRccButtonN1.EnableWindow(FALSE);
			mRccButtonN2.EnableWindow(FALSE);
			mRccButtonN3.EnableWindow(FALSE);
			mRccButtonN4.EnableWindow(FALSE);
			mRccButtonN5.EnableWindow(FALSE);
			mRccButtonN6.EnableWindow(FALSE);
			mRccButtonN7.EnableWindow(FALSE);
			mRccButtonN8.EnableWindow(FALSE);
			mRccButtonN9.EnableWindow(FALSE);
			mRccButtonNShap.EnableWindow(FALSE);
			mRccButtonNStar.EnableWindow(FALSE);
			mState = pState;
			ShowState();
			return;
		case e_State_Connect:
			ChangeButtonText(&mRccButtonA1,"hangup");
			ChangeButtonText(&mRccButtonA2,"message");
			/* display screen
			*/
			ChangeButtonText(&mRccButtonB1,"rhold");
			ChangeButtonText(&mRccButtonB2,"fhold");
			mRccButtonB1.EnableWindow();
			mRccButtonB2.EnableWindow();
			mRccButtonN0.EnableWindow();
			mRccButtonN1.EnableWindow();
			mRccButtonN2.EnableWindow();
			mRccButtonN3.EnableWindow();
			mRccButtonN4.EnableWindow();
			mRccButtonN5.EnableWindow();
			mRccButtonN6.EnableWindow();
			mRccButtonN7.EnableWindow();
			mRccButtonN8.EnableWindow();
			mRccButtonN9.EnableWindow();
			mRccButtonNShap.EnableWindow();
			mRccButtonNStar.EnableWindow();
			mState = pState;
			ShowState();
			return;
		case e_StateMax:
			mState = pState;
			ShowState();
			return;
		default:
			ShowState();
			return;
	}

	ShowState();
	return;
}


void CPlusPhoneDlg::ShowState()
{
	HS_UINT i, tSize;
	CString tString;

	mRccListMain.ResetContentEx();

	mRccListMain.AddString(_T(""));

	if( mState==e_State_Idle )
	{
		if( mProtocol==e_Protocol_H323)
		{
			tSize = strlen(mOption.mH323.mPrimeGk);
			for(i=0;i<tSize;i++)
			{
				if( mOption.mH323.mPrimeGk[i]=='@' ) break;
			}
			if( i==tSize )	i = 0;
			else			i++;

			mRccListMain.AddString( (CString)"   " +(CString)(mOption.mH323.mPrimeGk+i) );
		}
		else
			mRccListMain.AddString( (CString)"   " +(CString)(mOption.mSip.mPrimeProxy) );
	}
	else
	{
		mDial[mDialPos] = '\0';
		mRccListMain.AddString( (CString)" ȣ  " +mDial);
	}

	mRccListMain.AddString(_T(""));
	mRccListMain.AddString( (CString)"   " +mStateString);

	if( mProtocol==e_Protocol_H323 )
		tString.Format(_T("   H323(%s), SIP(%s)"), mIsH323Reg? _T("on"):_T("off"), mIsSipReg? _T("on"):_T("off"));
	else
		tString.Format(_T("   SIP(%s), H323(%s)"), mIsSipReg? _T("on"):_T("off"), mIsH323Reg? _T("on"):_T("off"));

	mRccListMain.AddString(tString);
	mRccListMain.AddString(_T(""));
	if( mState==e_State_Idle )
		mRccListMain.AddString(_T("   PlusPhone ver.1.0.0.1"));
	else
		mRccListMain.AddString(mCodecString);
}


HS_RESULT CPlusPhoneDlg::LoadOption(PPOption *pOption)
{
	CString tString;
	char tPath[256];
	FILE *tFile = NULL;
	HS_USHORT tSize = (HS_USHORT)sizeof(PPOption);

	if( pOption==NULL ) return HS_ERR_NULL_PARAM;

	tString = HSGetCurrentPath();
	if( tString.IsEmpty()==TRUE ) return HS_ERR;
	HSCString2Charp(tPath,tString);
	if( strlen(tPath)==0 ) return HS_ERR;
	sprintf(tPath+strlen(tPath),"option.ini");

	if( (tFile=fopen(tPath,"rb"))==NULL )
	{
		PPOption tOption;

		new_PPOption(&tOption);
		if( SaveOption(&tOption) != HS_OK ) return HS_ERR;
		if( (tFile=fopen(tPath,"rb"))==NULL ) return HS_ERR;
	}

	if( fread(pOption,sizeof(char),tSize,tFile) != tSize )
	{
		fclose(tFile);
		return HS_ERR;
	}

	fclose(tFile);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::SaveOption(PPOption *pOption)
{
	CString tString;
	char tPath[256];
	FILE *tFile = NULL;
	HS_USHORT tSize = (HS_USHORT)sizeof(PPOption);

	if( pOption==NULL ) return HS_ERR_NULL_PARAM;

	tString = HSGetCurrentPath();
	if( tString.IsEmpty()==TRUE ) return HS_ERR;
	HSCString2Charp(tPath,tString);
	if( strlen(tPath)==0 ) return HS_ERR;
	sprintf(tPath+strlen(tPath),"option.ini");

	if( (tFile=fopen(tPath,"wb"))==NULL ) return HS_ERR;

	if( fwrite(pOption,sizeof(char),tSize,tFile) != tSize )
	{
		fclose(tFile);
		return HS_ERR;
	}

	fclose(tFile);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::LoadBook()
{
	HS_UINT i;
	CString tPathString;
	char tPath[256];
	FILE *tFile = NULL;
	char tString[256];

	new_NoLockList(&mBookList,NULL);

	tPathString = HSGetCurrentPath();
	if( tPathString.IsEmpty()==TRUE ) return HS_ERR;
	HSCString2Charp(tPath,tPathString);
	if( strlen(tPath)==0 ) return HS_ERR;
	sprintf(tPath+strlen(tPath),"book.ini");

	if( (tFile=fopen(tPath,"rb"))==NULL )
		return HS_ERR;

	for(i=0;i<APP_MAX_PHONE_BOOK;i++)
	{
		if( fread(tString,sizeof(char),256,tFile) != 256 )
		{
			fclose(tFile);
			return HS_ERR;
		}

		if( tString[0]=='\0' ) continue;
		NoLockList_AttachData(&mBookList,HSStringAlloc(tString));
	}

	fclose(tFile);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::SaveBook()
{
	HS_UINT i;
	char tPath[256];
	CString tPathString;
	FILE *tFile = NULL;
	char *tUnit = NULL;
	char tString[256];

	tPathString = HSGetCurrentPath();
	if( tPathString.IsEmpty()==TRUE ) return HS_ERR;
	HSCString2Charp(tPath,tPathString);
	if( strlen(tPath)==0 ) return HS_ERR;
	sprintf(tPath+strlen(tPath),"book.ini");

	if( (tFile=fopen(tPath,"wb"))==NULL )
	{
		delete_NoLockList(&mBookList);
		return HS_ERR;
	}

	for(i=0;i<APP_MAX_PHONE_BOOK;i++)
	{
		memset(tString,0,256);
		if( (tUnit=(char*)NoLockList_DetachData(&mBookList,0)) != NULL )
		{
			strcpy(tString,tUnit);
			HSFree(tUnit);
		}
	
		if( fwrite(tString,sizeof(char),256,tFile) != 256 )
		{
			delete_NoLockList(&mBookList);
			fclose(tFile);
			return HS_ERR;
		}
	}

	delete_NoLockList(&mBookList);
	fclose(tFile);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::LoadHistory()
{
	HS_UINT i;
	char tPath[256];
	CString tPathString;
	FILE *tFile = NULL;
	char tString[256];

	new_NoLockList(&mHistoryList,NULL);

	tPathString = HSGetCurrentPath();
	if( tPathString.IsEmpty()==TRUE ) return HS_ERR;
	HSCString2Charp(tPath,tPathString);
	if( strlen(tPath)==0 ) return HS_ERR;
	sprintf(tPath+strlen(tPath),"history.ini");

	if( (tFile=fopen(tPath,"rb"))==NULL )
		return HS_ERR;

	for(i=0;i<APP_MAX_PHONE_BOOK;i++)
	{
		if( fread(tString,sizeof(char),256,tFile) != 256 )
		{
			fclose(tFile);
			return HS_ERR;
		}

		if( tString[0]=='\0' ) continue;
		NoLockList_AttachData(&mHistoryList,HSStringAlloc(tString));
	}

	fclose(tFile);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::SaveHistory()
{
	HS_UINT i;
	char tPath[256];
	CString tPathString;
	FILE *tFile = NULL;
	char *tUnit = NULL;
	char tString[256];

	tPathString = HSGetCurrentPath();
	if( tPathString.IsEmpty()==TRUE ) return HS_ERR;
	HSCString2Charp(tPath,tPathString);
	if( strlen(tPath)==0 ) return HS_ERR;
	sprintf(tPath+strlen(tPath),"history.ini");

	if( (tFile=fopen(tPath,"wb"))==NULL )
	{
		delete_NoLockList(&mHistoryList);
		return HS_ERR;
	}

	for(i=0;i<APP_MAX_PHONE_BOOK;i++)
	{
		memset(tString,0,256);
		if( (tUnit=(char*)NoLockList_DetachData(&mHistoryList,0)) != NULL )
		{
			strcpy(tString,tUnit);
			HSFree(tUnit);
		}
	
		if( fwrite(tString,sizeof(char),256,tFile) != 256 )
		{
			delete_NoLockList(&mHistoryList);
			fclose(tFile);
			return HS_ERR;
		}
	}

	delete_NoLockList(&mHistoryList);
	fclose(tFile);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::TestOption()
{
	new_PPOption(&mOption);
	mOption.mGeneral.mCodec = PP_CODEC_ALL;
	mOption.mGeneral.mDtmfBand = e_PPOptionDtmfBand_Rfc2833;
	mOption.mGeneral.mPreferProtocol = e_PPOptionPreferProtocol_H323;

	strcpy(mOption.mH323.mCallingPartyNumber,"760124");
	mOption.mH323.mCanMapAlias = TRUE;
	mOption.mH323.mEarlyH245 = FALSE;
	mOption.mH323.mFastStart = FALSE;
	mOption.mH323.mFSPoint = e_PPOptionFSRespPoint_Alert;
	mOption.mH323.mH245Point = e_PPOptionH245AddrPoint_CallProceed;
	strcpy(mOption.mH323.mH323Id,"070323");
	strcpy(mOption.mH323.mPhoneNumber,"070323");
	strcpy(mOption.mH323.mPrimeGk,"1719@222.239.220.66");
	strcpy(mOption.mH323.mSecondGk,"1719@222.239.220.66");
	mOption.mH323.mTtl = 600;
	mOption.mH323.mTunneling = FALSE;
	mOption.mH323.mUseBRQ = FALSE;
	mOption.mH323.mUseGRQ = FALSE;
	mOption.mH323.mUseIRR = FALSE;
	mOption.mH323.mUseLightWeightRRQ = TRUE;

	strcpy(mOption.mSip.mAuthId,"1111");
	mOption.mSip.mLocalTcpPort = 5060;
	mOption.mSip.mLocalUdpPort = 5060;
	strcpy(mOption.mSip.mPassword,"1111");
	strcpy(mOption.mSip.mPhoneNumber,"07070005555");
	mOption.mSip.mPrimePort = 5060;
	strcpy(mOption.mSip.mPrimeProxy,"222.239.220.66");
	mOption.mSip.mSecondPort = 5060;
	strcpy(mOption.mSip.mSecondProxy,"222.239.220.66");
	mOption.mSip.mTtl = 600;
	strcpy(mOption.mSip.mUserName,"07070005555");

	SaveOption(&mOption);
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveCall()
{
	if( mState != e_State_Idle )
	{
		MessageBox(_T("FATAL:0"));
		return HS_ERR;
	}
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	_HSThreadSendMessage(mQid,HS_QM_PP_HOOK_OFF,0,0);
	SetState(e_State_Tone,"Dialing");

	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveOption()
{
	COptionDlg tOptionDlg;
	PPOption *tOption = NULL;

	if( (tOption=tOptionDlg.DoModalEx(mOption)) != NULL )
	{
		if( mQid==HS_INVALID_QID )
			return HS_ERR;

		mOption = *tOption;
		SaveOption(tOption);

		if( is_blank(mOption.mGeneral.mLogServer) )
			HSPrintToNetworkOff();
		else
			HSPrintToNetworkOn(mOption.mGeneral.mLogServer,5530);

		_HSThreadSendMessage(mQid,HS_QM_PP_OPTION,0,(HS_UINT)tOption);
	}

	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveHangup()
{
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	switch(mState)
	{
		case e_State_Tone:
		case e_State_Proceed:
		case e_State_Connect:
			break;
		default:
			MessageBox(_T("FATAL:1"));
			return HS_ERR;
	}

	_HSThreadSendMessage(mQid,HS_QM_PP_HOOK_ON,0,0);
	SetState(e_State_Idle,"Hook Sleep");

	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveClear()
{
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	mDialPos = 0;
	ShowState();

	return _HSThreadSendMessage(mQid,HS_QM_PP_DTMF_CLEAR,0,0);
}


HS_RESULT CPlusPhoneDlg::OnActiveCancel()
{
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	if(mDialPos > 0) mDialPos--;
	ShowState();

	return _HSThreadSendMessage(mQid,HS_QM_PP_DTMF_CANCEL,0,0);
}


HS_RESULT CPlusPhoneDlg::OnActiveSend()
{
	char *tString = NULL;

	if( mState != e_State_Tone )
	{
		MessageBox(_T("FATAL:2"));
		return HS_ERR;
	}
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	if( mProtocol==e_Protocol_Sip )
		_HSThreadSendMessage(mQid,HS_QM_PP_MAKE_CALL,0,0);
	else
		_HSThreadSendMessage(mQid,HS_QM_PP_MAKE_CALL,1,0);
	SetState(e_State_Proceed,"Calling..");

	NoLockList_DeleteHistoryByString(&mHistoryList,mDial);
	if( mHistoryList.size>(APP_MAX_PHONE_BOOK-1) )
	{
		if( (tString=(char*)NoLockList_DetachData(&mHistoryList,0)) != NULL )
			HSFree(tString);
	}
	NoLockList_AttachData(&mHistoryList,HSStringAlloc(mDial));

	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveSendHold()
{
	if( mState != e_State_Connect )
	{
		MessageBox(_T("FATAL:10"));
		return HS_ERR;
	}
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	_HSThreadSendMessage(mQid,HS_QM_PP_HOLD,0,(HS_UINT)(e_PPDirection_Forward));

	mFHold = TRUE;
	ChangeButtonText(&mRccButtonB2,"fresume");
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveSendResume()
{
	if( mState != e_State_Connect )
	{
		MessageBox(_T("FATAL:11"));
		return HS_ERR;
	}
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	_HSThreadSendMessage(mQid,HS_QM_PP_RESUME,0,(HS_UINT)(e_PPDirection_Forward));

	mFHold = FALSE;
	ChangeButtonText(&mRccButtonB2,"fhold");
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveRecvHold()
{
	if( mState != e_State_Connect )
	{
		MessageBox(_T("FATAL:12"));
		return HS_ERR;
	}
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	_HSThreadSendMessage(mQid,HS_QM_PP_HOLD,0,(HS_UINT)(e_PPDirection_Reverse));

	mRHold = TRUE;
	ChangeButtonText(&mRccButtonB1,"rresume");
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveRecvResume()
{
	if( mState != e_State_Connect )
	{
		MessageBox(_T("FATAL:13"));
		return HS_ERR;
	}
	if( mQid==HS_INVALID_QID ) return HS_ERR;

	_HSThreadSendMessage(mQid,HS_QM_PP_RESUME,0,(HS_UINT)(e_PPDirection_Reverse));

	mRHold = FALSE;
	ChangeButtonText(&mRccButtonB1,"rhold");
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveMessage()
{
	MessageBox(_T("Not Support Yet."));
	return HS_OK;
}


HS_RESULT CPlusPhoneDlg::OnActiveAccept()
{
	if( mState != e_State_Powerring )
	{
		MessageBox(_T("FATAL:3"));
		return HS_ERR;
	}

	sndPlaySound(NULL,0);

	if( mQid==HS_INVALID_QID ) return HS_ERR;

	return _HSThreadSendMessage(mQid,HS_QM_PP_HOOK_OFF,0,0);
}


HS_RESULT CPlusPhoneDlg::OnActiveReject()
{
	if( mState != e_State_Powerring )
	{
		MessageBox(_T("FATAL:4"));
		return HS_ERR;
	}

	sndPlaySound(NULL,0);

	if( mQid==HS_INVALID_QID ) return HS_ERR;

	_HSThreadSendMessage(mQid,HS_QM_PP_HOOK_ON,0,0);
	SetState(e_State_Idle,"Hook Sleep");

	return HS_OK;
}





/*
 *
 * message event from ppcore thread
 *
 */
void CPlusPhoneDlg::OnAppCid(WPARAM wParam,LPARAM lParam)
{
	char *tString = NULL;
	char *tCid = (char*)lParam;

	if( tCid==NULL ) return;

	switch(mState)
	{
		case e_State_Idle:
		case e_State_Powerring:
			break;
		case e_State_Tone:
		case e_State_Proceed:
		case e_State_Connect:
		case e_StateMax:
		default:
			HSFree(tCid);
			return;
	}

	mDialPos = strlen(tCid);
	strcpy(mDial,tCid);
	ShowState();

	NoLockList_DeleteHistoryByString(&mHistoryList,mDial);
	if( mHistoryList.size>(APP_MAX_PHONE_BOOK-1) )
	{
		if( (tString=(char*)NoLockList_DetachData(&mHistoryList,0)) != NULL )
			HSFree(tString);
	}
	NoLockList_AttachData(&mHistoryList,HSStringAlloc(mDial));

	HSFree(tCid);
	return;
}


void CPlusPhoneDlg::OnAppIncoming(WPARAM wParam,LPARAM lParam)
{
	if( mState != e_State_Idle )
	{
		MessageBox(_T("FATAL:5"));
		return;
	}
	SetState(e_State_Powerring,"Incoming Call..");

	sndPlaySound(HSGetCurrentPath()+_T("ppring.wav"),SND_ASYNC|SND_LOOP);
}


void CPlusPhoneDlg::OnAppConnected(WPARAM wParam,LPARAM lParam)
{
	if( mState != e_State_Proceed &&
		mState != e_State_Powerring )
	{
		MessageBox(_T("FATAL:6"));
		return;
	}
	SetState(e_State_Connect,"Connected");
}


void CPlusPhoneDlg::OnAppCodec(WPARAM wParam,LPARAM lParam)
{
	mCodecString = (CString)" ڵ  " + AppGetCodecName((RtpPayloadType)lParam);
	ShowState();
}


void CPlusPhoneDlg::OnAppCallEnd(WPARAM wParam,LPARAM lParam)
{
	switch(mState)
	{
		case e_State_Idle:
			return;
		case e_State_Powerring:
			sndPlaySound(NULL,0);
			SetState(e_State_Idle,"Hook Sleep");
			return;
		case e_State_Tone:
		case e_State_Proceed:
		case e_State_Connect:
			break;
		default:
			MessageBox(_T("FATAL:7"));
			return;
	}

	SetState(e_State_Tone,"Reorder Tone");
}


void CPlusPhoneDlg::OnAppDtmf(WPARAM wParam,LPARAM lParam)
{
	QmSipContext *ctx = (QmSipContext*)lParam;

	if( ctx==NULL )
		MessageBox(_T("FATAL:8"));
	else
	{
		/*HSPrint("app: recv: dtmf(%s)",ctx->mContext);
			! NOTE : it can receive non-visible-string
		*/
		deletem_QmSipContext(ctx);
	}
}


void CPlusPhoneDlg::OnAppMsg(WPARAM wParam,LPARAM lParam)
{
	QmSipContext *ctx = (QmSipContext*)lParam;

	if( ctx==NULL )
		MessageBox(_T("FATAL:9"));
	else
	{
		/*HSPrint("app: recv: message(%s)",ctx->mContext);
			! NOTE : it can receive non-visible-string
		*/
		deletem_QmSipContext(ctx);
	}
}


void CPlusPhoneDlg::OnAppRegistSuccess(WPARAM wParam,LPARAM lParam)
{
	if( lParam==0 )
		mIsSipReg = TRUE;
	else
		mIsH323Reg = TRUE;

	ShowState();
}


void CPlusPhoneDlg::OnAppRegistFail(WPARAM wParam,LPARAM lParam)
{
	if( lParam==0 )
		mIsSipReg = FALSE;
	else
		mIsH323Reg = FALSE;

	ShowState();
}





/*
 *
 * button event
 *
 */
void CPlusPhoneDlg::OnButtonH323() 
{
	if( mProtocol==e_Protocol_H323 )
	{
		ChangeButtonText(&mRccButtonH323,"h323");
		mProtocol = e_Protocol_Sip;
	}
	else
	{
		ChangeButtonText(&mRccButtonH323,"sip");
		mProtocol = e_Protocol_H323;
	}
	ShowState();
}


void CPlusPhoneDlg::OnButtonA1() 
{
	switch(mState)
	{
		case e_State_Idle:
			OnActiveCall();
			return;
		case e_State_Tone:
		case e_State_Proceed:
		case e_State_Connect:
			OnActiveHangup();
			return;
		case e_State_Powerring:
			OnActiveAccept();
			return;
		case e_StateMax:
		default:
			return;
	}

	return;
}


void CPlusPhoneDlg::OnButtonA2() 
{
	switch(mState)
	{
		case e_State_Idle:
			OnActiveOption();
			return;
		case e_State_Tone:
			OnActiveSend();
			return;
		case e_State_Powerring:
			OnActiveReject();
			return;
		case e_State_Connect:
			OnActiveMessage();
			return;
		case e_State_Proceed:
		case e_StateMax:
		default:
			return;
	}

	return;
}


void CPlusPhoneDlg::OnButtonB1() 
{
	switch(mState)
	{
		case e_State_Tone:
			OnActiveCancel();
			return;
		case e_State_Connect:
			if( mRHold==FALSE ) OnActiveRecvHold();
			else				OnActiveRecvResume();
			return;
		case e_State_Idle:
		case e_State_Proceed:
		case e_State_Powerring:
		case e_StateMax:
		default:
			return;
	}

	return;
}


void CPlusPhoneDlg::OnButtonB2() 
{
	switch(mState)
	{
		case e_State_Tone:
			OnActiveClear();
			return;
		case e_State_Connect:
			if( mFHold==FALSE ) OnActiveSendHold();
			else				OnActiveSendResume();
			return;
		case e_State_Idle:
		case e_State_Proceed:
		case e_State_Powerring:
		case e_StateMax:
		default:
			return;
	}

	return;
}


void CPlusPhoneDlg::OnButtonN0() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'0');
		mDial[mDialPos++] = '0';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN1()
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'1');
		mDial[mDialPos++] = '1';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN2() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'2');
		mDial[mDialPos++] = '2';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN3() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'3');
		mDial[mDialPos++] = '3';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN4() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'4');
		mDial[mDialPos++] = '4';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN5() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'5');
		mDial[mDialPos++] = '5';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN6() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'6');
		mDial[mDialPos++] = '6';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN7() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'7');
		mDial[mDialPos++] = '7';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN8() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'8');
		mDial[mDialPos++] = '8';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonN9() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'9');
		mDial[mDialPos++] = '9';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonNstar()
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'*');
		mDial[mDialPos++] = '*';
		ShowState();
	}
}


void CPlusPhoneDlg::OnButtonNshap() 
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,TRUE,(HS_UINT)'#');
		mDial[mDialPos++] = '#';
		ShowState();
	}
}


void CPlusPhoneDlg::OnKeyboardN(char pKey)
{
	if( mQid != HS_INVALID_QID )
	{
		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,FALSE,(HS_UINT)pKey);
		mDial[mDialPos++] = pKey;
		ShowState();
	}
}



void CPlusPhoneDlg::OnButtonExit() 
{
	if( mState==e_State_Idle )
		OnOK();
}


void CPlusPhoneDlg::OnButtonBook() 
{
	CMenu tMenu;
	POINT tPoint;

	if( mState != e_State_Idle ) return;

	mMenuPoint = e_MenuPoint_PhoneBook;
	GetCursorPos(&tPoint);
	tMenu.CreatePopupMenu();

	/*mTrayMenu.DeleteMenu(0,MF_BYPOSITION);*/
	tMenu.AppendMenu(MF_STRING,ID_MENU_ADD,_T("Add"));
	tMenu.AppendMenu(MF_STRING,ID_MENU_DELETE,_T("Delete"));
	tMenu.AppendMenu(MF_STRING,ID_MENU_CANCEL,_T("Cancel"));

	NoLockList_ShowBookList(&mBookList,&tMenu);

	SetForegroundWindow();
	tMenu.TrackPopupMenu(TPM_CENTERALIGN,tPoint.x,tPoint.y,this);
	tMenu.DestroyMenu();
}


void CPlusPhoneDlg::OnButtonHistory() 
{
	CMenu tMenu;
	POINT tPoint;

	if( mState != e_State_Idle ) return;

	mMenuPoint = e_MenuPoint_History;
	GetCursorPos(&tPoint);
	tMenu.CreatePopupMenu();

	/*mTrayMenu.DeleteMenu(0,MF_BYPOSITION);*/
	tMenu.AppendMenu(MF_STRING,ID_MENU_CANCEL,_T("Cancel"));

	NoLockList_ShowHistoryList(&mHistoryList,&tMenu);

	SetForegroundWindow();
	tMenu.TrackPopupMenu(TPM_CENTERALIGN,tPoint.x,tPoint.y,this);
	tMenu.DestroyMenu();
}


void CPlusPhoneDlg::OnMenu_Add()
{
	CString tString;
	CBookDlg tBookDlg;
	char tCharString[512];

	if( mBookList.size>(APP_MAX_PHONE_BOOK-1) )
	{
		MessageBox(_T("Address Full"));
		return;
	}
	
	if( tBookDlg.DoModal() != IDOK ) return;
	if( tBookDlg.mRcdEditFriendName.IsEmpty()==TRUE ) return;
	if( tBookDlg.mRcdEditPhoneNumber.IsEmpty()==TRUE ) return;

	tString = tBookDlg.mRcdEditPhoneNumber +(CString)" "+ tBookDlg.mRcdEditFriendName;
	CString2CharString(tCharString,tString);
	NoLockList_AttachData(&mBookList,HSStringAlloc(tCharString));
}


void CPlusPhoneDlg::OnMenu_Delete()
{
	CMenu tMenu;
	POINT tPoint;

	mMenuPoint = e_MenuPoint_Delete;
	GetCursorPos(&tPoint);
	tMenu.CreatePopupMenu();

	/*mTrayMenu.DeleteMenu(0,MF_BYPOSITION);*/
	tMenu.AppendMenu(MF_STRING,ID_MENU_CANCEL,_T("Cancel"));

	NoLockList_ShowBookList(&mBookList,&tMenu);

	SetForegroundWindow();
	tMenu.TrackPopupMenu(TPM_CENTERALIGN,tPoint.x,tPoint.y,this);
	tMenu.DestroyMenu();
}


void CPlusPhoneDlg::OnMenu_Cancel()
{
	/* nothing to do ...
	*/
}


void CPlusPhoneDlg::OnMenu_Number(HS_UINT pIndex)
{
	HS_UINT i, tSize;
	char *tString = NULL;

	if( mQid==HS_INVALID_QID ) return;
	if( mState != e_State_Idle ) return;

	switch(mMenuPoint)
	{
		case e_MenuPoint_PhoneBook:
			if( (tString=(char*)NoLockList_GetData(&mBookList,pIndex))==NULL ) return;
			break;
		case e_MenuPoint_History:
			if( (tString=(char*)NoLockList_GetData(&mHistoryList,pIndex))==NULL ) return;
			break;
		case e_MenuPoint_Delete:
			if( (tString=(char*)NoLockList_DetachData(&mBookList,pIndex))==NULL ) return;
			HSFree(tString);
			return;
		default:
			return;
	}

	OnActiveCall();

	tSize = strlen(tString);
	for(i=0;i<tSize;i++)
	{
		if( tString[i]==' ' || tString[i]=='\0' )
		{
			ShowState();
			return;
		}

		_HSThreadSendMessage(mQid,HS_QM_PP_DTMF,FALSE,(HS_UINT)tString[i]);
		mDial[mDialPos++] = tString[i];
	}

	ShowState();
}


void CPlusPhoneDlg::OnMenu_0(){	OnMenu_Number(0);	}
void CPlusPhoneDlg::OnMenu_1(){	OnMenu_Number(1);	}
void CPlusPhoneDlg::OnMenu_2(){	OnMenu_Number(2);	}
void CPlusPhoneDlg::OnMenu_3(){	OnMenu_Number(3);	}
void CPlusPhoneDlg::OnMenu_4(){	OnMenu_Number(4);	}
void CPlusPhoneDlg::OnMenu_5(){	OnMenu_Number(5);	}
void CPlusPhoneDlg::OnMenu_6(){	OnMenu_Number(6);	}
void CPlusPhoneDlg::OnMenu_7(){	OnMenu_Number(7);	}
void CPlusPhoneDlg::OnMenu_8(){	OnMenu_Number(8);	}
void CPlusPhoneDlg::OnMenu_9(){	OnMenu_Number(9);	}
/*void CPlusPhoneDlg::OnMenu_APP_MAX_PHONE_BOOK(){}*/







BOOL CPlusPhoneDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);

	HSPrint("\ntp> KeyDown: %08x",pMsg->wParam);

	if( (pMsg->wParam>0x2f && pMsg->wParam<0x3a)
		|| pMsg->wParam==0xbe
		|| pMsg->wParam==0x08
		|| pMsg->wParam==0x1b
		|| pMsg->wParam==0x0d
	)
	{
		if( mState==e_State_Tone || mState==e_State_Connect )
		{
			if( mState==e_State_Tone )
			{
				switch(pMsg->wParam)
				{
					case 0x08:/*back-space*/
						OnActiveCancel();
						break;
					case 0x1b:/*ESC*/
						OnActiveClear();
						break;
					case 0x0d:/*Enter*/
						OnActiveSend();
						break;
				}
			}

			switch(pMsg->wParam)
			{
				case 0x30:	OnButtonN0();	break;
				case 0x31:	OnButtonN1();	break;
				case 0x32:	OnButtonN2();	break;
				case 0x33:
					if( GetKeyState(VK_SHIFT) < 0 ) OnButtonNshap();
					else OnButtonN3();
					break;
				case 0x34:	OnButtonN4();	break;
				case 0x35:	OnButtonN5();	break;
				case 0x36:	OnButtonN6();	break;
				case 0x37:	OnButtonN7();	break;
				case 0x38:
					if( GetKeyState(VK_SHIFT) < 0 ) OnButtonNstar();
					else OnButtonN8();
					break;
				case 0x39:	OnButtonN9();	break;
				case 0xbe:
					OnKeyboardN('.');
					break;
			}

			return TRUE;
		}
	}

	/* ignore 'ENTER, ESC and SPACE'
	*/
	if( pMsg->wParam==0x0d || pMsg->wParam==0x1b || pMsg->wParam==0x20 )
		return TRUE;

	return CDialog::PreTranslateMessage(pMsg);
}


void CPlusPhoneDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	HSPrint("\n OnDestroy of MFC");

	SaveBook();
	SaveHistory();

	PPCore_Stop(mQid);
	UnloadHSResource(1000);
	mQid = HS_INVALID_QID;
}



