// OptionSip1Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "OptionSip1Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionSip1Dlg dialog


COptionSip1Dlg::COptionSip1Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionSip1Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionSip1Dlg)
	mRcdEditProxyAddr = _T("");
	mRcdEditProxyPort = _T("");
	mRcdEditTcpPort = _T("");
	mRcdEditTtl = _T("");
	mRcdEditUdpPort = _T("");
	mRcdEditUsername = _T("");
	//}}AFX_DATA_INIT
}


void COptionSip1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionSip1Dlg)
	DDX_Text(pDX, IDC_EDIT_PROXY_ADDR, mRcdEditProxyAddr);
	DDX_Text(pDX, IDC_EDIT_PROXY_PORT, mRcdEditProxyPort);
	DDX_Text(pDX, IDC_EDIT_SIP_TCP_PORT, mRcdEditTcpPort);
	DDX_Text(pDX, IDC_EDIT_SIP_TTL, mRcdEditTtl);
	DDX_Text(pDX, IDC_EDIT_SIP_UDP_PORT, mRcdEditUdpPort);
	DDX_Text(pDX, IDC_EDIT_USERNAME, mRcdEditUsername);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionSip1Dlg, CDialog)
	//{{AFX_MSG_MAP(COptionSip1Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionSip1Dlg message handlers

BOOL COptionSip1Dlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);
		
	/* ENTER, ESC and SPACE to TAP
	*/
	if( pMsg->wParam==13 || pMsg->wParam==27 || pMsg->wParam==32 )
		pMsg->wParam = 9;

	return CDialog::PreTranslateMessage(pMsg);
}

BOOL COptionSip1Dlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	mRcdEditProxyAddr = mOption.mPrimeProxy;
#if defined(_WIN32_WCE)
	mRcdEditProxyPort.Format(_T("%u"),mOption.mPrimePort);
	mRcdEditTcpPort.Format(_T("%u"),mOption.mLocalTcpPort);
	mRcdEditTtl.Format(_T("%u"),mOption.mTtl);
	mRcdEditUdpPort.Format(_T("%u"),mOption.mLocalUdpPort);
#else
	mRcdEditProxyPort.Format("%u",mOption.mPrimePort);
	mRcdEditTcpPort.Format("%u",mOption.mLocalTcpPort);
	mRcdEditTtl.Format("%u",mOption.mTtl);
	mRcdEditUdpPort.Format("%u",mOption.mLocalUdpPort);
#endif
	mRcdEditUsername = mOption.mUserName;
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionSip1Dlg::UpdateDataEx()
{
	UpdateData();

	new_PPOptionSip(&mOption);

#if defined(_WIN32_WCE)
	CString2CharString(mOption.mPrimeProxy,mRcdEditProxyAddr);
	mOption.mPrimePort = CString2Integer(mRcdEditProxyPort);
	mOption.mLocalTcpPort = CString2Integer(mRcdEditTcpPort);
	mOption.mTtl = CString2Integer(mRcdEditTtl);
	mOption.mLocalUdpPort = CString2Integer(mRcdEditUdpPort);
	CString2CharString(mOption.mUserName,mRcdEditUsername);
#else
	strcpy(mOption.mPrimeProxy,mRcdEditProxyAddr.GetBuffer(0));
	mOption.mPrimePort = atoi(mRcdEditProxyPort.GetBuffer(0));
	mOption.mLocalTcpPort = atoi(mRcdEditTcpPort.GetBuffer(0));
	mOption.mTtl = atoi(mRcdEditTtl.GetBuffer(0));
	mOption.mLocalUdpPort = atoi(mRcdEditUdpPort.GetBuffer(0));
	strcpy(mOption.mUserName,mRcdEditUsername.GetBuffer(0));
#endif

	return;
}

