// OptionH3232Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "OptionH3232Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionH3232Dlg dialog


COptionH3232Dlg::COptionH3232Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionH3232Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionH3232Dlg)
	mRcdCheckCanMapAlias = FALSE;
	mRcdEditCallingParty = _T("");
	mRcdEditSGkAddr = _T("");
	mRcdEditSGkPort = _T("");
	//}}AFX_DATA_INIT
}


void COptionH3232Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionH3232Dlg)
	DDX_Control(pDX, IDC_COMBO_H245_POINT, mRccCombo245Point);
	DDX_Control(pDX, IDC_COMBO_FS_POINT, mRccComboFSPoint);
	DDX_Check(pDX, IDC_CHECK_CANMAPALIAS, mRcdCheckCanMapAlias);
	DDX_Text(pDX, IDC_EDIT_CALLING_PARTY, mRcdEditCallingParty);
	DDX_Text(pDX, IDC_EDIT_SGK_ADDR, mRcdEditSGkAddr);
	DDX_Text(pDX, IDC_EDIT_SGK_PORT, mRcdEditSGkPort);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionH3232Dlg, CDialog)
	//{{AFX_MSG_MAP(COptionH3232Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionH3232Dlg message handlers

BOOL COptionH3232Dlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);
		
	/* ENTER, ESC and SPACE to TAP
	*/
	if( pMsg->wParam==13 || pMsg->wParam==27 || pMsg->wParam==32 )
		pMsg->wParam = 9;

	return CDialog::PreTranslateMessage(pMsg);
}

BOOL COptionH3232Dlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	mRcdCheckCanMapAlias = mOption.mCanMapAlias;
	mRcdEditCallingParty = mOption.mCallingPartyNumber;

	mRcdEditSGkAddr = mOption.mSecondGk;
	mRcdEditSGkPort = mRcdEditSGkAddr.Left( mRcdEditSGkAddr.Find('@',0) );
	mRcdEditSGkAddr = mRcdEditSGkAddr.Right(
		mRcdEditSGkAddr.GetLength() -mRcdEditSGkPort.GetLength() -1
	);

	UpdateData(FALSE);

#if defined(_WIN32_WCE)
	mRccCombo245Point.AddString(_T("CallProceed"));
	mRccCombo245Point.AddString(_T("Alert"));
	mRccCombo245Point.AddString(_T("Connect"));
#else
	mRccCombo245Point.AddString("CallProceed");
	mRccCombo245Point.AddString("Alert");
	mRccCombo245Point.AddString("Connect");
#endif
	switch(mOption.mH245Point)
	{
		case e_PPOptionH245AddrPoint_CallProceed:
			mRccCombo245Point.SetCurSel(0);
			break;
		case e_PPOptionH245AddrPoint_Alert:
			mRccCombo245Point.SetCurSel(1);
			break;
		case e_PPOptionH245AddrPoint_Connect:
		default:
			mRccCombo245Point.SetCurSel(2);
			break;
	}

#if defined(_WIN32_WCE)
	mRccComboFSPoint.AddString(_T("CallProceed"));
	mRccComboFSPoint.AddString(_T("Alert"));
	mRccComboFSPoint.AddString(_T("Connect"));
#else
	mRccComboFSPoint.AddString("CallProceed");
	mRccComboFSPoint.AddString("Alert");
	mRccComboFSPoint.AddString("Connect");
#endif
	switch(mOption.mFSPoint)
	{
		case e_PPOptionFSRespPoint_CallProceed:
			mRccComboFSPoint.SetCurSel(0);
			break;
		case e_PPOptionFSRespPoint_Alert:
			mRccComboFSPoint.SetCurSel(1);
			break;
		case e_PPOptionFSRespPoint_Connect:
		default:
			mRccComboFSPoint.SetCurSel(2);
			break;
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionH3232Dlg::UpdateDataEx()
{
	int tCurSel;
	CString tString;

	UpdateData();

	new_PPOptionH323(&mOption);
	mOption.mCanMapAlias = mRcdCheckCanMapAlias;
#if defined(_WIN32_WCE)
	CString2CharString(mOption.mCallingPartyNumber,mRcdEditCallingParty);
	tString = mRcdEditSGkPort + (CString)"@" + mRcdEditSGkAddr;
	CString2CharString(mOption.mSecondGk,tString);
#else
	strcpy(mOption.mCallingPartyNumber,mRcdEditCallingParty.GetBuffer(0));
	sprintf(mOption.mSecondGk,"%s@%s",mRcdEditSGkPort.GetBuffer(0),mRcdEditSGkAddr.GetBuffer(0));
#endif

	switch( (tCurSel=mRccCombo245Point.GetCurSel()) )
	{
		case 0:
			mOption.mH245Point = e_PPOptionH245AddrPoint_CallProceed;
			break;
		case 1:
			mOption.mH245Point = e_PPOptionH245AddrPoint_Alert;
			break;
		case 2:
			mOption.mH245Point = e_PPOptionH245AddrPoint_Connect;
			break;
		default:
			break;
	}

	switch( (tCurSel=mRccComboFSPoint.GetCurSel()) )
	{
		case 0:
			mOption.mFSPoint = e_PPOptionFSRespPoint_CallProceed;
			break;
		case 1:
			mOption.mFSPoint = e_PPOptionFSRespPoint_Alert;
			break;
		case 2:
			mOption.mFSPoint = e_PPOptionFSRespPoint_Connect;
			break;
		default:
			break;
	}

	return;
}

