// OptionGeneralDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "OptionGeneralDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionGeneralDlg dialog


COptionGeneralDlg::COptionGeneralDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionGeneralDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionGeneralDlg)
	mRcdCheck711a = FALSE;
	mRcdCheck711u = FALSE;
	mRcdCheck729 = FALSE;
	mRcdCheckGsm = FALSE;
	mRcdCheckIlbc = FALSE;
	mRcdComboDtmf = _T("");
	mRcdEditLogServer = _T("");
	//}}AFX_DATA_INIT
}


void COptionGeneralDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionGeneralDlg)
	DDX_Control(pDX, IDC_COMBO_DTMF, mRccComboDtmf);
	DDX_Check(pDX, IDC_CHECK_711A, mRcdCheck711a);
	DDX_Check(pDX, IDC_CHECK_711U, mRcdCheck711u);
	DDX_Check(pDX, IDC_CHECK_729, mRcdCheck729);
	DDX_Check(pDX, IDC_CHECK_GSM, mRcdCheckGsm);
	DDX_Check(pDX, IDC_CHECK_ILBC, mRcdCheckIlbc);
	DDX_CBString(pDX, IDC_COMBO_DTMF, mRcdComboDtmf);
	DDX_Text(pDX, IDC_EDIT_LOG_SERVER, mRcdEditLogServer);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionGeneralDlg, CDialog)
	//{{AFX_MSG_MAP(COptionGeneralDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionGeneralDlg message handlers

BOOL COptionGeneralDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);
		
	/* ENTER, ESC and SPACE to TAP
	*/
	if( pMsg->wParam==13 || pMsg->wParam==27 || pMsg->wParam==32 )
		pMsg->wParam = 9;

	return CDialog::PreTranslateMessage(pMsg);
}

BOOL COptionGeneralDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if( PP_INCLUDE_G711A(mOption.mCodec) )
		mRcdCheck711a = TRUE;
	else mRcdCheck711a = FALSE;
	if( PP_INCLUDE_G711U(mOption.mCodec) )
		mRcdCheck711u = TRUE;
	else mRcdCheck711u = FALSE;
	if( PP_INCLUDE_G729(mOption.mCodec) )
		mRcdCheck729 = TRUE;
	else mRcdCheck729 = FALSE;
	if( PP_INCLUDE_MSGSM(mOption.mCodec) )
		mRcdCheckGsm = TRUE;
	else mRcdCheckGsm = FALSE;
	if( PP_INCLUDE_ILBC(mOption.mCodec) )
		mRcdCheckIlbc = TRUE;
	else mRcdCheckIlbc = FALSE;

	mRcdEditLogServer = mOption.mLogServer;

	UpdateData(FALSE);

#if defined(_WIN32_WCE)
	mRccComboDtmf.AddString(_T("Inband"));
	mRccComboDtmf.AddString(_T("Outband"));
	mRccComboDtmf.AddString(_T("Rfc2833"));
#else
	mRccComboDtmf.AddString("Inband");
	mRccComboDtmf.AddString("Outband");
	mRccComboDtmf.AddString("Rfc2833");
#endif

	switch(mOption.mDtmfBand)
	{
		case e_PPOptionDtmfBand_Outband:
			mRccComboDtmf.SetCurSel(1);
			break;
		case e_PPOptionDtmfBand_Rfc2833:
			mRccComboDtmf.SetCurSel(2);
			break;
		case e_PPOptionDtmfBand_Inband:
		default:
			mRccComboDtmf.SetCurSel(0);
			break;
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionGeneralDlg::UpdateDataEx()
{
	int tCurSel;

	UpdateData();

#if defined(_WIN32_WCE)
	CString2CharString(mOption.mLogServer,mRcdEditLogServer);
#else
	strcpy(mOption.mLogServer,mRcdEditLogServer.GetBuffer(0));
#endif

	switch( (tCurSel=mRccComboDtmf.GetCurSel()) )
	{
		case 0:
			mOption.mDtmfBand = e_PPOptionDtmfBand_Inband;
			break;
		case 1:
			mOption.mDtmfBand = e_PPOptionDtmfBand_Outband;
			break;
		case 2:
			mOption.mDtmfBand = e_PPOptionDtmfBand_Rfc2833;
			break;
		default:
			break;
	}

	mOption.mCodec = 0x00000000;
	if( mRcdCheck711a )	mOption.mCodec += PP_CODEC_G711A;
	if( mRcdCheck711u )	mOption.mCodec += PP_CODEC_G711U;
	if( mRcdCheck729 )	mOption.mCodec += PP_CODEC_G729;
	if( mRcdCheckGsm )	mOption.mCodec += PP_CODEC_MSGSM;
	if( mRcdCheckIlbc )	mOption.mCodec += PP_CODEC_ILBC;

	return;
}