/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppQmessage.h>		2006-02-23,22:56

  : thread queue message definitions.
*/

#ifndef __2006_02_23__22_56__PPQMESSAGE_H__
#define __2006_02_23__22_56__PPQMESSAGE_H__





#include "ppDefine.h"





#define HS_QM_PP_MIN			1500
/*
 *
 * event from user interface to PP
 *
 */
/* user option change event
	wparam: null
	lparam: PPOption object's pointer
*/
#define HS_QM_PP_OPTION			HS_QM_PP_MIN +1
/* hook off from user
	wparam: null
	lparam: null
*/
#define HS_QM_PP_HOOK_OFF		HS_QM_PP_OPTION +1
/* hook on from user
	wparam: null
	lparam: null
*/
#define HS_QM_PP_HOOK_ON		HS_QM_PP_HOOK_OFF +1
/* DTMF signal from user
	wparam: dtmf sound (TRUE/FALSE)
	lparam: DTMF signal (char)
*/
#define HS_QM_PP_DTMF			HS_QM_PP_HOOK_ON +1
/* undo one DTMF signal
	wparam: null
	lparam: null
*/
#define HS_QM_PP_DTMF_CANCEL	HS_QM_PP_DTMF +1
/* clear all DTMF signal buffer
	wparam: null
	lparam: null
*/
#define HS_QM_PP_DTMF_CLEAR		HS_QM_PP_DTMF_CANCEL +1
/* try calling by DTMF signal buffer, 'name string' or 'IP address string'.
	wparam: 0-sip,1-h323
	lparam: destination name(IP address) string (char*),
	       (if it's null,try by DTMF signal buffer)
*/
#define HS_QM_PP_MAKE_CALL		HS_QM_PP_DTMF_CLEAR +1
/* hold RTP stream command from user
	wparam: null
	lparam: PPDirection
*/
typedef enum
{
	e_PPDirection_Forward,
	e_PPDirection_Reverse,
	e_PPDirectionMax
} PPDirection;
#define HS_QM_PP_HOLD			HS_QM_PP_MAKE_CALL +1
/* resume RTP stream command from user
	wparam: null
	lparam: PPDirection
*/
#define HS_QM_PP_RESUME			HS_QM_PP_HOLD +1
/* instant message from user
	wparam: null
	lparam: instant message string (char*)
*/
#define HS_QM_PP_INST_MSG		HS_QM_PP_RESUME +1





/*
 *
 * event from callback to PP
 *
 */
/* caller Id information
	wparam: 0-sip, 1-h.323
	lparam: char pointer (memory allocated)
*/
#define HS_QM_PP_CID			HS_QM_PP_INST_MSG +1
/* dialogue incoming by INVITE
	wparam: 0-sip, 1-h.323
	lparam: call handle
*/
#define HS_QM_PP_INCOMING		HS_QM_PP_CID +1
/* ring back signal (received 180/183 with SIP or Alerting with H.323)
	wparam: 0-sip, 1-h.323
	lparam: call handle
*/
#define HS_QM_PP_RING_BACK		HS_QM_PP_INCOMING +1
/* made media session
	wparam: null
	lparam: QmMediaInfo object pointer
	! NOTE: if sockaddr_in.sa_family==AF_MAX, direction is reverse.
*/
typedef struct
{
	struct sockaddr_in	mAddrIn;
	HS_USHORT			mPort;
	RtpPayloadType		mType;
	HS_UINT				mFpp;
} QmMediaInfo;
QmMediaInfo *newm_QmMediaInfo(struct sockaddr_in pAddrIn,HS_USHORT pPort,RtpPayloadType pType,HS_UINT mFpp);
QmMediaInfo *newm_QmMediaInfoEx(char *pIp,HS_USHORT pRemotePort,HS_USHORT pPort,RtpPayloadType pType,HS_UINT mFpp);
HS_RESULT deletem_QmMediaInfo(void *pObject);
#define HS_QM_PP_SESSION		HS_QM_PP_RING_BACK +1
/* session closed signal
	wparam: null
	lparam: PPDirection
*/
typedef enum
{
	e_PPHold_Hold,
	e_PPHold_Resume,
	e_PPHoldMax
} PPHold;
#define HS_QM_PP_UNSESSION		HS_QM_PP_SESSION +1
/* connected signal (200 with SIP or Connect with H.323)
	wparam: 0-sip, 1-h.323
	lparam: call handle
*/
#define HS_QM_PP_CONNECTED		HS_QM_PP_UNSESSION +1
/* outbound-dtmf signal by INFO method
	wparam: null
	lparam: QmSipContext object's pointer
*/
typedef struct
{
	HS_CALL_HANDLE	mHandle;
	char			*mType;
	char			*mContext;
	HS_UINT			mLen;
} QmSipContext;
QmSipContext *newm_QmSipContext(HS_CALL_HANDLE pHandle,char *pType,char *pContext,HS_UINT pLen);
HS_RESULT deletem_QmSipContext(void *pObject);
#define HS_QM_PP_OUT_DTMF		HS_QM_PP_CONNECTED +1
/* instant-message signal by MESSAGE method
	wparam: null
	lparam: QmSipContext object's pointer
*/
#define HS_QM_PP_INSTANT_MSG	HS_QM_PP_OUT_DTMF +1
/* call end siangl (BYE/3xx/4xx with SIP or ReleaseComplete/ARJ with H.323)
	wparam: 0-sip/ 1-ReleaseComplete/ 2-ARJ/
	lparam: QmCallEnd object's pointer
*/
typedef struct
{
	/* sip:sip_response_value, ReleaseComplete:cause_value, ARJ:reject_reason
	*/
	HS_UINT			mReason;
	HS_CALL_HANDLE	mHandle;
} QmCallEnd;
QmCallEnd *newm_QmCallEnd(HS_CALL_HANDLE pHandle,HS_UINT pReason);
HS_RESULT deletem_QmCallEnd(void *pObject);
#define HS_QM_PP_CALL_END		HS_QM_PP_INSTANT_MSG +1
/* registration success
	wparam: 0-sip, 1-h.323
	lparam: ua handle, null
*/
#define HS_QM_PP_REGIST_SUCC	HS_QM_PP_CALL_END +1
/* registration fail
	wparam: 0-sip, 1-h.323
	lparam: ua handle, null
*/
#define HS_QM_PP_REGIST_FAIL	HS_QM_PP_REGIST_SUCC +1





/*
 *
 * event to user interface
 *
 */
/* stack initialization error
	wparam: null
	lparam: null
*/
#define HS_QM_APP_STACK_FAIL	HS_QM_PP_REGIST_FAIL +1
/* registration success
	wparam: null
	lparam: 0-sip, 1-h.323
*/
#define HS_QM_APP_REGIST_SUCC	HS_QM_APP_STACK_FAIL +1
/* registration fail
	wparam: null
	lparam: 0-sip, 1-h.323
*/
#define HS_QM_APP_REGIST_FAIL	HS_QM_APP_REGIST_SUCC +1
/* caller Id information
	wparam: null
	lparam: char pointer (memory allocated)
*/
#define HS_QM_APP_CID			HS_QM_APP_REGIST_FAIL +1
/* inform call incoming to user
	wparam: null
	lparam: null
*/
#define HS_QM_APP_INCOMING		HS_QM_APP_CID +1
/* inform 'call is connected' to user
	wparam: null
	lparam: null
*/
#define HS_QM_APP_CONNECTED		HS_QM_APP_INCOMING +1
/* codec information
	wparam: null
	lparam: RtpPayloadType
*/
#define HS_QM_APP_CODEC			HS_QM_APP_CONNECTED +1
/* inform 'call failed or ended' to user
	wparam: null
	lparam: null
*/
#define HS_QM_APP_CALL_END		HS_QM_APP_CODEC +1
/* inform 'dtmf message' comming from remote
	wparam: null
	lparam: QmSipContext object's pointer
*/
#define HS_QM_APP_DTMF			HS_QM_APP_CALL_END +1
/* inform 'instant message' comming from remote
	wparam: null
	lparam: QmSipContext object's pointer
*/
#define HS_QM_APP_MSG			HS_QM_APP_DTMF +1





/*
 *
 * event to media thread
 *
 */
/* call progress tone start
	wparam: null
	lparam: tone type (enum of DtmfSignal)
*/
#define HS_QM_MM_START_TONE		HS_QM_APP_CALL_END +1
/* call progress tone stop
	wparam: null
	lparam: null
*/
#define HS_QM_MM_STOP_TONE		HS_QM_MM_START_TONE +1
/* forward media start
	wparam: null
	lparam: QmMediaInfo object pointer
*/
#define HS_QM_MM_FWRD_MEDIA		HS_QM_MM_STOP_TONE +1
/* reverse media start
	wparam: null
	lparam: QmMediaInfo object pointer
*/
#define HS_QM_MM_RVRS_MEDIA		HS_QM_MM_FWRD_MEDIA +1
/* media stop
	wparam: null
	lparam: null
*/
#define HS_QM_MM_STOP_MEDIA		HS_QM_MM_RVRS_MEDIA +1
/* media hold/resume
	wparam: forward/reverse (PPDirection)
	lparam: hold/resume (PPHold)
*/
#define HS_QM_MM_HOLD_RESUME	HS_QM_MM_STOP_MEDIA +1
/* send dtmf rtp data to remote phone.
	wparam: null
	lparam: dtmf signal
*/
#define HS_QM_MM_ADD_DTMF		HS_QM_MM_HOLD_RESUME +1
/* send dtmf rfc2833 data to remote phone.
	wparam: null
	lparam: dtmf signal
*/
#define HS_QM_MM_ADD_DTMF_2833	HS_QM_MM_ADD_DTMF +1




#define HS_QM_PP_MAX			HS_QM_MM_ADD_DTMF_2833 +1





#endif/*__2006_02_23__22_56__PPQMESSAGE_H__*/