/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppQmessage.c>		2006-03-06,21:13

*/

#include "ppQmessage.h"





/* QmMediaInfo member functions
*/
QmMediaInfo *newm_QmMediaInfo(struct sockaddr_in pAddrIn,HS_USHORT pPort,RtpPayloadType pType,HS_UINT pFpp)
{
	QmMediaInfo *tResult = NULL;

	if( (tResult=(QmMediaInfo*)HSMalloc(sizeof(QmMediaInfo)))==NULL ) return NULL;

	tResult->mAddrIn = pAddrIn;
	tResult->mPort = pPort;
	tResult->mType = pType;
	tResult->mFpp = pFpp;
	return tResult;
}


QmMediaInfo *newm_QmMediaInfoEx(char *pIp,HS_USHORT pRemotePort,HS_USHORT pPort,RtpPayloadType pType,HS_UINT pFpp)
{
	QmMediaInfo *tResult = NULL;

	if( pIp==NULL ) return NULL;
	if( (tResult=(QmMediaInfo*)HSMalloc(sizeof(QmMediaInfo)))==NULL ) return NULL;

	tResult->mAddrIn.sin_family = AF_INET;
	tResult->mAddrIn.sin_addr.s_addr = inet_addr(pIp);
	tResult->mAddrIn.sin_port = htons(pRemotePort);
	tResult->mPort = pPort;
	tResult->mType = pType;
	tResult->mFpp = pFpp;
	return tResult;
}


HS_RESULT deletem_QmMediaInfo(void *pObject)
{
	QmMediaInfo *pObj = (QmMediaInfo*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	HSFree(pObj);
	return HS_OK;
}





/* QmSipContext member functions
*/
QmSipContext *newm_QmSipContext(HS_CALL_HANDLE pHandle,char *pType,char *pContext,HS_UINT pLen)
{
	QmSipContext *tResult = NULL;

	if( (tResult=(QmSipContext*)HSMalloc(sizeof(QmSipContext)))==NULL ) return NULL;

	tResult->mHandle = pHandle;
	if( pType==NULL ) tResult->mType = NULL;
	else			  tResult->mType = HSStringAlloc(pType);
	if( pContext==NULL ) tResult->mContext = NULL;
	else
	{
		if( (tResult->mContext=(char*)HSMalloc(pLen+1)) != NULL )
		{
			memcpy(tResult->mContext,pContext,pLen);
			tResult->mContext[pLen] = '\0';
			tResult->mLen= pLen;
		}
	}

	return tResult;
}


HS_RESULT deletem_QmSipContext(void *pObject)
{
	QmSipContext *pObj = (QmSipContext*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mType != NULL ) HSFree(pObj->mType);
	if( pObj->mContext != NULL ) HSFree(pObj->mContext);
	pObj->mLen = 0;

	HSFree(pObj);
	return HS_OK;
}





/* QmCallEnd member functions
*/
QmCallEnd *newm_QmCallEnd(HS_CALL_HANDLE pHandle,HS_UINT pReason)
{
	QmCallEnd *tResult = NULL;

	if( (tResult=(QmCallEnd*)HSMalloc(sizeof(QmCallEnd)))==NULL )
		return NULL;

	tResult->mHandle = pHandle;
	tResult->mReason = pReason;
	return tResult;
}


HS_RESULT deletem_QmCallEnd(void *pObject)
{
	QmCallEnd *pObj = (QmCallEnd*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	HSFree(pObj);
	return HS_OK;
}



