/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppOption.c>	2006-02-16,22:22

 */

#include "ppOption.h"





HS_RESULT new_PPOptionGeneral(void *pObject)
{
	PPOptionGeneral *pObj = (PPOptionGeneral*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mCodec = PP_CODEC_ALL;
	pObj->mDtmfBand = e_PPOptionDtmfBand_Inband;
	pObj->mPreferProtocol = e_PPOptionPreferProtocol_H323;
	memset(pObj->mLogServer,0,128);

	return HS_OK;
}


HS_RESULT delete_PPOptionGeneral(void *pObject)
{
	PPOptionGeneral *pObj = (PPOptionGeneral*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	return HS_OK;
}



HS_RESULT new_PPOptionH323(void *pObject)
{
	PPOptionH323 *pObj = (PPOptionH323*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	memset(pObj->mH323Id,0,PP_LETTER_MAX);
	memset(pObj->mPhoneNumber,0,PP_LETTER_MAX);

	memset(pObj->mPrimeGk,0,PP_LETTER_MAX);
	pObj->mTtl = 600;

	memset(pObj->mSecondGk,0,PP_LETTER_MAX);
	
	pObj->mFastStart = TRUE;
	pObj->mTunneling = FALSE;
	pObj->mEarlyH245 = FALSE;
	pObj->mCanMapAlias = TRUE;

	pObj->mUseGRQ = FALSE;
	pObj->mUseBRQ = TRUE;
	pObj->mUseIRR = TRUE;
	pObj->mUseLightWeightRRQ = TRUE;

	memset(pObj->mCallingPartyNumber,0,PP_LETTER_MAX);

	pObj->mH245Point = e_PPOptionH245AddrPoint_Connect;
	pObj->mFSPoint = e_PPOptionFSRespPoint_Connect;

	return HS_OK;
}


HS_RESULT delete_PPOptionH323(void *pObject)
{
	PPOptionH323 *pObj = (PPOptionH323*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	return HS_OK;
}



HS_RESULT new_PPOptionSip(void *pObject)
{
	PPOptionSip *pObj = (PPOptionSip*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	memset(pObj->mUserName,0,PP_LETTER_MAX);
	memset(pObj->mPhoneNumber,0,PP_LETTER_MAX);
	pObj->mLocalUdpPort = 5060;
	pObj->mLocalTcpPort = 5060;

	memset(pObj->mPrimeProxy,0,PP_LETTER_MAX);
	pObj->mPrimePort = 5060;
	memset(pObj->mSecondProxy,0,PP_LETTER_MAX);
	pObj->mSecondPort = 5060;
	pObj->mTtl = 600;

	memset(pObj->mOutboundProxy,0,PP_LETTER_MAX);
	memset(pObj->mDisplayName,0,PP_LETTER_MAX);
	memset(pObj->mAuthId,0,PP_LETTER_MAX);
	memset(pObj->mPassword,0,PP_LETTER_MAX);
	memset(pObj->mTargetGw,0,PP_LETTER_MAX);
	
	return HS_OK;
}


HS_RESULT delete_PPOptionSip(void *pObject)
{
	PPOptionSip *pObj = (PPOptionSip*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	return HS_OK;
}



HS_RESULT new_PPOption(void *pObject)
{
	HS_RESULT tRet = HS_OK;
	PPOption *pObj = (PPOption*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( (tRet=new_PPOptionGeneral(&(pObj->mGeneral))) != HS_OK )
		return tRet;
	if( (tRet=new_PPOptionH323(&(pObj->mH323))) != HS_OK )
		return tRet;
	if( (tRet=new_PPOptionSip(&(pObj->mSip))) != HS_OK )
		return tRet;

	return HS_OK;
}


HS_RESULT delete_PPOption(void *pObject)
{
	HS_RESULT tRet = HS_OK;
	PPOption *pObj = (PPOption*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( (tRet=delete_PPOptionGeneral(&(pObj->mGeneral))) != HS_OK )
		return tRet;
	if( (tRet=delete_PPOptionH323(&(pObj->mH323))) != HS_OK )
		return tRet;
	if( (tRet=delete_PPOptionSip(&(pObj->mSip))) != HS_OK )
		return tRet;

	return HS_OK;
}





