/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppCbH323.c>	2006-03-07,22:18

*/

#include "ppCbH323.h"





/* exception callbacks
*/
void AppOnException(HSException pException, HS_RESULT pRet)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :err:323:cb-: exception(%d),ret(%d)",pException,pRet);
#endif
}


void AppOnAsnDecodingError(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :err:323:cb-: ASN decode error,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif
}





/* normal callbacks
*/
void AppOnCallIncoming(HS_STACK_HANDLE pStack, void* pCall)
{
	HS_QID tQid;
	PPOption tOption;
	ICall *tCall = (ICall*)pCall;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: incoming call");
#endif

	if( tCall==NULL ) return;

#ifdef HS_DEBUG_H323
	HSPrint("\n,call(%u)",tCall->handle);
#endif

	/* send incoming to pp
	*/
	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID )
	{
		HapiCommandRemoveCall(pStack,tCall->handle,e_CallCloseReason_Undefined);
		return;
	}
	_HSThreadSendMessage(tQid,HS_QM_PP_INCOMING,1,(HS_UINT)(tCall->handle));

	/* codec setting
	*/
	if( ppHandle_GetOption(&tOption) != HS_OK )
	{
		HapiCommandRemoveCall(pStack,tCall->handle,e_CallCloseReason_Undefined);
		return;
	}
	if( PP_INCLUDE_G711A(tOption.mGeneral.mCodec) )
		HapiAddG711Alaw64k(tCall,HS_H323_AUDIO_GROUP,10);
	if( PP_INCLUDE_G711U(tOption.mGeneral.mCodec) )
		HapiAddG711Ulaw64k(tCall,HS_H323_AUDIO_GROUP,10);
	if( PP_INCLUDE_G729(tOption.mGeneral.mCodec) )
	{
		HapiAddG729(tCall,HS_H323_AUDIO_GROUP,10);
		HapiAddG729AnnexA(tCall,HS_H323_AUDIO_GROUP,10);
		HapiAddG729AnnexAwAnnexB(tCall,HS_H323_AUDIO_GROUP,10);
	}

	/* other parameters setting
	*/
	switch(tOption.mH323.mH245Point)
	{
		case e_PPOptionH245AddrPoint_CallProceed:
			tCall->h245ListenPoint = e_H245ListenPoint_CallProceed;
			break;
		case e_PPOptionH245AddrPoint_Alert:
			tCall->h245ListenPoint = e_H245ListenPoint_Alert;
			break;
		case e_PPOptionH245AddrPoint_Connect:
			tCall->h245ListenPoint = e_H245ListenPoint_Connect;
			break;
		case e_PPOptionH245AddrPointMax:
		default:
			break;
	}
	switch(tOption.mH323.mFSPoint)
	{
		case e_PPOptionFSRespPoint_CallProceed:
			tCall->fastStartPoint = e_FastStartResponsePoint_CallProceed;
			break;
		case e_PPOptionFSRespPoint_Alert:
			tCall->fastStartPoint = e_FastStartResponsePoint_Alert;
			break;
		case e_PPOptionFSRespPoint_Connect:
			tCall->fastStartPoint = e_FastStartResponsePoint_Connect;
			break;
		case e_PPOptionFSRespPointMax:
		default:
			break;
	}

	return;
}


void AppOnCallRemoved(HS_CALL_HANDLE pHandle, CallCloseReason pReason, Q931CauseType pCause)
{
	HS_QID tQid;
	QmCallEnd *tQm = NULL;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: call removed,call(%u),reason(%d),q931_cause(%u)",pHandle,pReason,pCause);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tQm=newm_QmCallEnd(pHandle,pCause))==NULL ) return;

	if( pReason==e_CallCloseReason_Admission )
		_HSThreadSendMessage(tQid,HS_QM_PP_CALL_END,2,(HS_UINT)tQm);
	else
		_HSThreadSendMessage(tQid,HS_QM_PP_CALL_END,1,(HS_UINT)tQm);
}





/* timeout callbacks
*/
void AppOnRegistrationTimeout(HS_STACK_HANDLE pStack)
{
	HS_QID tQid;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rrq timeout");
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_REGIST_FAIL,1,0);
}


void AppOnRasMessageTimeout(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, ASNH225RasMessageChoice pType, HS_USHORT pSN )
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: ras msg timeout,call(%u),msg(%s),sn(%u)",pCall,AppGetRasMessageName(pType),pSN);
#endif
}





/* message received callbacks
*/
BOOL AppOnReceiveRasRawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rcv ras raw,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif

	return TRUE;
}


BOOL AppOnReceiveRasMessage(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, RasMsg *pMsg)
{
	HS_QID tQid;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rcv ras msg,call(%u)",pCall);
#endif

	if( pMsg==NULL ) return FALSE;
	
#ifdef HS_DEBUG_H323
	HSPrint("msg(%s)",AppGetRasMessageName(pMsg->choice));
#ifdef HS_DEBUG_H323_MSG
	RasMsg_Print(pMsg,0,"\n\nRAS[RECV] ");
#endif
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return TRUE;
	switch(pMsg->choice)
	{
		case e_ASNH225RasMessageChoice_registrationConfirm:
			_HSThreadSendMessage(tQid,HS_QM_PP_REGIST_SUCC,1,0);
			break;
		case e_ASNH225RasMessageChoice_registrationReject:
		case e_ASNH225RasMessageChoice_unregistrationRequest:
		case e_ASNH225RasMessageChoice_unregistrationConfirm:
			_HSThreadSendMessage(tQid,HS_QM_PP_REGIST_FAIL,1,0);
			break;
	}

	return TRUE;
}


BOOL AppOnReceiveQ931RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rcv q931 raw,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif

	return TRUE;
}


BOOL AppOnReceiveQ931Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, Q931Message *pMsg)
{
	HS_QID tQid;
	char tCidString[128];
	Q931Element *tQ931Element = NULL;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rcv q931 msg,call(%u)",pCall);
#endif

	if( pMsg==NULL ) return FALSE;
	if( pMsg->uuie==NULL ) return FALSE;

#ifdef HS_DEBUG_H323
	HSPrint(",msg(%s)",
		AppGetQ931MessageName(
			(ASNH225H323_UU_PDU_h323_message_bodyChoice)
			(pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice)
		)
	);
#ifdef HS_DEBUG_H323_MSG
	Q931Message_Print(pMsg,0,"\n\nQ931[RECV] ");
#endif
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return TRUE;

	switch(pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice)
	{
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup:
			if( (tQ931Element=Q931Message_GetElement(pMsg,e_Q931ElementType_CallingPartyNumber))==NULL ) break;
			if( (tQ931Element->value)==NULL ) break;
			if( tQ931Element->nlen < 2 ) break;
			memcpy(tCidString,tQ931Element->value+1,tQ931Element->nlen-1);
			tCidString[tQ931Element->nlen-1] = PP_EOS;
			_HSThreadSendMessage(tQid,HS_QM_PP_CID,1,(HS_UINT)HSStringAlloc(tCidString));
			break;
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting:
			_HSThreadSendMessage(tQid,HS_QM_PP_RING_BACK,1,(HS_UINT)pCall);
			break;
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect:
			_HSThreadSendMessage(tQid,HS_QM_PP_CONNECTED,1,(HS_UINT)pCall);
			break;
	}

	return TRUE;
}


BOOL AppOnReceiveH245RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rcv h245 raw,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif

	return TRUE;
}


BOOL AppOnReceiveH245Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, ControlMsg *pMsg)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: rcv h245 msg,call(%u),msg(%s)",pCall,AppGetH245MessageName(pMsg));
#ifdef HS_DEBUG_H323_MSG
	ControlMsg_Print(pMsg,0,"\n\nH245[RECV] ");
#endif
#endif

	return TRUE;
}


/* message sending
*/
BOOL AppOnSendRasMessage(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, RasMsg *pMsg)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: snd ras msg,call(%u)",pCall);
	if( pMsg != NULL )
	{
		HSPrint(",msg(%s)", AppGetRasMessageName(pMsg->choice));
#ifdef HS_DEBUG_H323_MSG
		RasMsg_Print(pMsg,0,"\n\nRAS[SEND] ");
#endif
	}
#endif

	return TRUE;
}


BOOL AppOnSendRasRawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: snd ras raw,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif

	return TRUE;
}


BOOL AppOnSendQ931Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, Q931Message *pMsg)
{
	HS_QID tQid;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: snd q931 msg,call(%u)",pCall);
#endif

	if( pMsg==NULL ) return FALSE;
	if( pMsg->uuie==NULL ) return FALSE;

#ifdef HS_DEBUG_H323
		HSPrint(",msg(%s)",
			AppGetQ931MessageName(
				(ASNH225H323_UU_PDU_h323_message_bodyChoice)
				(pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice)
			)
		);
#endif

#ifdef HS_DEBUG_H323_MSG
	Q931Message_Print(pMsg,0,"\n\nQ931[SEND] ");
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return TRUE;

	switch(pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice)
	{
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect:
			_HSThreadSendMessage(tQid,HS_QM_PP_CONNECTED,1,pCall);
			break;
	}

	return TRUE;
}


BOOL AppOnSendQ931RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: snd q931 raw,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif

	return TRUE;
}


/* ! NOTE: if call is a h245 tunneling mode, hStack is a invalid handle
*/
BOOL AppOnSendH245Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, ControlMsg *pMsg)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: snd h245 msg,call(%u),msg(%s)",pCall,AppGetH245MessageName(pMsg));
#ifdef HS_DEBUG_H323_MSG
	ControlMsg_Print(pMsg,0,"\n\nH245[SEND] ");
#endif
#endif

	return TRUE;
}


/* ! NOTE: if call is a h245 tunneling mode, hStack is a invalid handle
*/
BOOL AppOnSendH245RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm)
{
#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: snd h245 raw,call(%u)",pCall);
#ifdef HS_DEBUG_H323_RAW
	AsnStream_Print(pStrm);
#endif
#endif

	return TRUE;
}



/****************************************************************************************/
/* Media callback functions
*/
/* media channel check
*/
HS_RESULT AppOnCheckFastStart(AsnSequenceOf *pOctetString, NoLockList *pCapabilities, void *pCall)
{
	ICall *tCall = (ICall*)pCall;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: check faststart");
	if( tCall != NULL ) HSPrint(",call(%u)",tCall->handle);
#endif

#if 0
	return AppCheckFastStart(pOctetString, pCapabilities, (ICall*)pCall);
#else
	return HS_NOK;
#endif
}


HS_RESULT AppOnCheckTerminalCapabilitySet(HS_STACK_HANDLE pStack, void *pEndpoint, void *pCall, ASNH245TerminalCapabilitySet* pTcs)
{
	ICall *tCall = (ICall*)pCall;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: check terminal_capability_set");
	if( tCall != NULL ) HSPrint(",call(%u)",tCall->handle);
#endif

#if 0
	return AppCheckTerminalCapabilitySet(hStack, (IEndpoint*)pEndpoint, (ICall*)pCall, pTcs);
#else
	return HS_NOK;
#endif
}





/* reverse media channel open
*/
void AppOnOpenReceiveMedia(
	HS_CALL_HANDLE pCall,HS_USHORT pRtpPort,HS_USHORT pRtcpPort,ASNH245DataType *pType
)
{
	HS_QID tQid;
	QmMediaInfo *tInfo = NULL;
	RtpPayloadType tAudioType;
	HS_UINT tFpp = 1;
	struct sockaddr_in tAddrIn;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: open reverse rtp,call(%u),rtp_port(%u),rtcp_port(%u)",
		pCall,pRtpPort,pRtcpPort
	);
#endif

	if( pType==NULL ) return;
	if( pType->choice==e_ASNH245DataTypeChoice_audioData )
	{
		ASNH245AudioCapability *tAudio = (ASNH245AudioCapability*)(pType->alter);
		if( tAudio != NULL )
		{
			switch(tAudio->choice)
			{
				case e_ASNH245AudioCapabilityChoice_g711Alaw64k:
				case e_ASNH245AudioCapabilityChoice_g711Alaw56k:
					tAudioType = e_RtpPayloadType_Pcma;
					tFpp = 4;
					break;
				case e_ASNH245AudioCapabilityChoice_g711Ulaw64k:
				case e_ASNH245AudioCapabilityChoice_g711Ulaw56k:
					tAudioType = e_RtpPayloadType_Pcmu;
					tFpp = 4;
					break;
				case e_ASNH245AudioCapabilityChoice_g729:
				case e_ASNH245AudioCapabilityChoice_g729AnnexA:
				case e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB:
					tAudioType = e_RtpPayloadType_G729;
					tFpp = 2;
					break;
				default:
#ifdef HS_DEBUG_H323
					HSPrint(",codec(err:unknown)");
#endif
					return;
			}
		}
	}

#ifdef HS_DEBUG_H323
	HSPrint(",codec(%s)",AppGetCodecName(tAudioType));
#endif

	tAddrIn.sin_family = AF_MAX;
	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tInfo=newm_QmMediaInfo(tAddrIn,pRtpPort,tAudioType,tFpp))==NULL ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_SESSION,0,(HS_UINT)tInfo);
}


/* forward media channel open
*/
void AppOnOpenSendMedia(
	HS_CALL_HANDLE pCall,struct sockaddr_in pRtpIn,struct sockaddr_in pRtcpIn,ASNH245DataType *pType
)
{
	HS_QID tQid;
	QmMediaInfo *tInfo = NULL;
	RtpPayloadType tAudioType;
	HS_UINT tFpp = 1;
	HS_USHORT tRtpPort, tRtcpPort;

	tRtpPort = pRtpIn.sin_port;
	tRtcpPort = pRtcpIn.sin_port;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: open forward rtp,call(%u),rtp_addr(%08x:%u),rtcp_addr(%08x:%u)",
		pCall,pRtpIn.sin_addr.s_addr,htons(tRtpPort),pRtcpIn.sin_addr.s_addr,htons(tRtcpPort)
	);
#endif

	if( pType==NULL ) return;
	if( pType->choice==e_ASNH245DataTypeChoice_audioData )
	{
		ASNH245AudioCapability *tAudio = (ASNH245AudioCapability*)(pType->alter);

		if( tAudio != NULL )
		{
			switch(tAudio->choice)
			{
				case e_ASNH245AudioCapabilityChoice_g711Alaw64k:
				case e_ASNH245AudioCapabilityChoice_g711Alaw56k:
					tAudioType = e_RtpPayloadType_Pcma;
					tFpp = 4;
					break;
				case e_ASNH245AudioCapabilityChoice_g711Ulaw64k:
				case e_ASNH245AudioCapabilityChoice_g711Ulaw56k:
					tAudioType = e_RtpPayloadType_Pcmu;
					tFpp = 4;
					break;
				case e_ASNH245AudioCapabilityChoice_g729:
				case e_ASNH245AudioCapabilityChoice_g729AnnexA:
				case e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB:
					tAudioType = e_RtpPayloadType_G729;
					tFpp = 2;
					break;
				default:
#ifdef HS_DEBUG_H323
					HSPrint(",codec(err:unknown)");
#endif
					return;
			}
		}
	}

#ifdef HS_DEBUG_H323
	HSPrint(",codec(%s)",AppGetCodecName(tAudioType));
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tInfo=newm_QmMediaInfo(pRtpIn,HS_USHORT_MAX,tAudioType,tFpp))==NULL ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_SESSION,0,(HS_UINT)tInfo);
}





/* reverse media channel close
*/
void AppOnCloseReceiveMedia(HS_CALL_HANDLE pCall, ASNH245DataType *pType)
{
	HS_QID tQid;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: close reverse rtp,call(%u)",pCall);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	_HSThreadSendMessage(tQid,HS_QM_PP_UNSESSION,0,e_PPDirection_Reverse);
}


/* forward media channel close
*/
void AppOnCloseSendMedia(HS_CALL_HANDLE pCall, ASNH245DataType *pType)
{
	HS_QID tQid;

#ifdef HS_DEBUG_H323
	HSPrint("\n :inf:323:cb-: close reverse rtp,call(%u)",pCall);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	_HSThreadSendMessage(tQid,HS_QM_PP_UNSESSION,0,e_PPDirection_Forward);
}
