/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<MessageName.cpp>	2005-05-30,13:53

*/

#include "MessageName.h"



const char *GetH245RequestMessageTypeName(HS_UCHAR pSubType)
{
	switch(pSubType)
	{
		case 0:		return "nonStandard";
		case 1:		return "masterSlaveDetermination";
		case 2:		return "terminalCapabilitySet";
		case 3:		return "openLogicalChannel";
		case 4:		return "closeLogicalChannel";
		case 5:		return "requestChannelClose";
		case 6:		return "multiplexEntrySend";
		case 7:		return "requestMultiplexEntry";
		case 8:		return "requestMode";
		case 9:		return "roundTripDelayRequest";
		case 10:	return "maintenanceLoopRequest";
		case 11:	return "communicationModeRequest";
		case 12:	return "conferenceRequest";
		case 13:	return "multilinkRequest";
		case 14:	return "logicalChannelRateRequest";
	}
	return "UnknownRequest";
}
const char *GetH245ResponseMessageTypeName(HS_UCHAR pSubType)
{
	switch(pSubType)
	{
		case 0:		return "nonStandard";
		case 1:		return "masterSlaveDeterminationAck";
		case 2:		return "masterSlaveDeterminationReject";
		case 3:		return "terminalCapabilitySetAck";
		case 4:		return "terminalCapabilitySetReject";
		case 5:		return "openLogicalChannelAck";
		case 6:		return "openLogicalChannelReject";
		case 7:		return "closeLogicalChannelAck";
		case 8:		return "requestChannelCloseAck";
		case 9:		return "requestChannelCloseReject";
		case 10:	return "multiplexEntrySendAck";
		case 11:	return "multiplexEntrySendReject";
		case 12:	return "requestMultiplexEntryAck";
		case 13:	return "requestMultiplexEntryReject";
		case 14:	return "requestModeAck";
		case 15:	return "requestModeReject";
		case 16:	return "roundTripDelayResponse";
		case 17:	return "maintenanceLoopAck";
		case 18:	return "maintenanceLoopReject";
		case 19:	return "communicationModeResponse";
		case 20:	return "conferenceResponse";
		case 21:	return "multilinkResponse";
		case 22:	return "logicalChannelRateAcknowledge";
		case 23:	return "logicalChannelRateReject";
	}
	return "UnknownResponse";
}
const char *GetH245CommandMessageTypeName(HS_UCHAR pSubType)
{
	switch(pSubType)
	{
		case 0:		return "nonStandard";
		case 1:		return "maintenanceLoopOffCommand";
		case 2:		return "sendTerminalCapabilitySet";
		case 3:		return "encryptionCommand";
		case 4:		return "flowControlCommand";
		case 5:		return "endSessionCommand";
		case 6:		return "miscellaneousCommand";
		case 7:		return "communicationModeCommand";
		case 8:		return "conferenceCommand";
		case 9:		return "h223MultiplexReconfiguration";
		case 10:	return "newATMVCCommand";
		case 11:	return "mobileMultilinkReconfigurationCommand";
	}
	return "UnknownCommand";
}
const char *GetH245IndicationMessageTypeName(HS_UCHAR pSubType)
{
	switch(pSubType)
	{
		case 0:		return "nonStandard";
		case 1:		return "functionNotUnderstood";
		case 2:		return "masterSlaveDeterminationRelease";
		case 3:		return "terminalCapabilitySetRelease";
		case 4:		return "openLogicalChannelConfirm";
		case 5:		return "requestChannelCloseRelease";
		case 6:		return "multiplexEntrySendRelease";
		case 7:		return "requestMultiplexEntryRelease";
		case 8:		return "requestModeRelease";
		case 9:		return "miscellaneousIndication";
		case 10:	return "jitterIndication";
		case 11:	return "h223SkewIndication";
		case 12:	return "newATMVCIndication";
		case 13:	return "userInput";
		case 14:	return "h2250MaximumSkewIndication";
		case 15:	return "mcLocationIndication";
		case 16:	return "conferenceIndication";
		case 17:	return "vendorIdentification";
		case 18:	return "functionNotSupported";
		case 19:	return "multilinkIndication";
		case 20:	return "logicalChannelRateRelease";
		case 21:	return "flowControlIndication";
		case 22:	return "mobileMultilinkReconfigurationIndication";
	}
	return "UnknownIndication";
}



const char *GetH245MessageTypeName(HS_UCHAR *pData)
{
	HS_UCHAR tSubType = 0;

	if( pData == HS_NULL ) return "CONFLICT";

	if( pData[0] & 0x10 )
	{
		tSubType  = ( pData[0] & 0x0f ) << 3;
		tSubType += ( pData[1] & 0xe0 ) >> 5;
	}

	switch( pData[0] & 0x60 )
	{
		case 0x00:
			if( tSubType == 0 ) tSubType = pData[0] & 0x0f;
			return GetH245RequestMessageTypeName(tSubType);
		case 0x20:
			if( tSubType == 0 ) tSubType = (( pData[0] & 0x0f ) << 1) + (( pData[1] & 0x80 ) >> 7);
			return GetH245ResponseMessageTypeName(tSubType);
		case 0x40:
			if( tSubType == 0 ) tSubType = ( pData[0] & 0x0e ) >> 1;
			return GetH245CommandMessageTypeName(tSubType);
		case 0x60:
			if( tSubType == 0 ) tSubType = pData[0] & 0x0f;
			return GetH245IndicationMessageTypeName(tSubType);
	}

	return "Unknown";
}



const char *GetQ931MessageTypeName(HS_UCHAR pType)
{
	switch(pType)
	{
		case 0x05: return "setup";
		case 0x02: return "callProceeding";
		case 0x07: return "connect";
		case 0x01: return "alerting";
		case 0x7b: return "information";
		case 0x5a: return "releaseComplete";
		case 0x62: return "facility";
		case 0x03: return "progress";
		/* Empty is a Facility in the Q.931 Recommandation
		case : return "empty";*/
		case 0x7d: return "status";
		case 0x75: return "statusInquiry";
		case 0x0d: return "setupAcknowledge";
		case 0x6e: return "notify";
	}
	return "Unknown";
}



const char *GetRasMessageTypeName(HS_UCHAR pType)
{
	switch(pType)
	{
	case 0:		return "GRQ";
	case 1:		return "GCF";
	case 2:		return "GRJ";
	case 3:		return "RRQ";
	case 4:		return "RCF";
	case 5:		return "RRJ";
	case 6:		return "URQ";
	case 7:		return "UCF";
	case 8:		return "URJ";
	case 9:		return "ARQ";
	case 10:	return "ACF";
	case 11:	return "ARJ";
	case 12:	return "BRQ";
	case 13:	return "BCF";
	case 14:	return "BRJ";
	case 15:	return "DRQ";
	case 16:	return "DCF";
	case 17:	return "DRJ";
	case 18:	return "LRQ";
	case 19:	return "LCF";
	case 20:	return "LRJ";
	case 21:	return "IRQ";
	case 22:	return "IRR";
	case 23:	return "NSM";
	case 24:	return "UMR";
	case 25:	return "RIP";
	case 26:	return "RAI";
	case 27:	return "RAC";
	case 28:	return "IRA";
	case 29:	return "IRN";
	case 30:	return "SCI";
	case 31:	return "SCR";
	}
	return "Unknown";
}
