/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<App245Dtmf.c>	2005-05-17,21:15

*/

#include "App245Dtmf.h"

#undef HS_APP_SIGNAL_DTMF



static HS_RESULT AppSetDtmfH245UserInputIndication(
	ASNH245MultimediaSystemControlMessage *pMsg, char pSignal, HS_USHORT pDuration
)
{
	HS_UCHAR tValue[4];
	ASNH245UserInputIndication *uii = HS_NULL;
	ASNH245IndicationMessage *tIndication = HS_NULL;

#ifdef HS_APP_SIGNAL_DTMF
	ASNH245UserInputIndication_signal *uiiSignal = HS_NULL;
#else
	AsnSingleString *tAlphaNumeric = HS_NULL;
#endif

	if( pMsg == HS_NULL ) return HS_ERR_NULL_PARAM;

	/* set asn choice
	*/
	tIndication = (ASNH245IndicationMessage*)
		ASNH245MultimediaSystemControlMessage_SetChoice(pMsg, e_ASNH245MultimediaSystemControlMessageChoice_indication);
	if( tIndication == HS_NULL ) return HS_ERR_H323_MAKE_MESSAGE;

	uii = (ASNH245UserInputIndication*)
		ASNH245IndicationMessage_SetChoice(tIndication, e_ASNH245IndicationMessageChoice_userInput);
	if( uii == HS_NULL ) return HS_ERR_H323_MAKE_MESSAGE;

#ifdef HS_APP_SIGNAL_DTMF
	uiiSignal = (ASNH245UserInputIndication_signal*)
		ASNH245UserInputIndication_SetChoice(uii, e_ASNH245UserInputIndicationChoice_signal);
	if( uiiSignal == HS_NULL ) return HS_ERR_H323_MAKE_MESSAGE;

	/* set value
	*/
	tValue[0] = (HS_UCHAR)pSignal;
	AsnSingleString_SetValue( &(uiiSignal->m_signalType), tValue, 1 );
	AsnInteger_SetValue( &(uiiSignal->m_duration), pDuration );

#else
	tAlphaNumeric = (AsnSingleString*)
		ASNH245UserInputIndication_SetChoice(uii, e_ASNH245UserInputIndicationChoice_alphanumeric);
	if( tAlphaNumeric == HS_NULL ) return HS_ERR_H323_MAKE_MESSAGE;

	/* set value
	*/
	tValue[0] = (HS_UCHAR)pSignal;
	AsnSingleString_SetValue( tAlphaNumeric, tValue, 1 );
#endif


	return HS_OK;
}



ControlMsg *AppMakeDtmfH245UserInputIndication(char pSignal, HS_USHORT pDuration)
{
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	/* check signal range
	*/
	if( (pSignal < '0' && pSignal != '!' && pSignal != '#' && pSignal != '*') ||
		(pSignal > '9' && pSignal != 'A' && pSignal != 'B' && pSignal != 'C' && pSignal != 'D')
	) return HS_NULL;

	if( (msg=(ControlMsg*)HSMalloc(sizeof(ControlMsg))) == HS_NULL )
		return HS_NULL;

	new_ControlMsg(msg);
	ControlMsg_MakeMold(msg);

	if( AppSetDtmfH245UserInputIndication(msg,pSignal,pDuration) != HS_OK )
	{
		delete_ControlMsg(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}