/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<EpSample.c>	2006-01-18,23:07

*/

#include "EpSample.h"

#include <stdio.h>
#include <conio.h>





#define HS_DEBUG_H323_APP_MBODY





typedef enum
{
	e_App_AddressType_Ip,
	e_App_AddressType_H323id,
	e_App_AddressType_E164id,
	e_App_AddressTypeMax
} App_AddressType;





HS_STACK_HANDLE	gHStack	= HS_INVALID_STACK_HANDLE;
HS_CALL_HANDLE	gHCall	= HS_INVALID_HANDLE;

HS_RTP_HANDLE	gRtpHandle = HS_INVALID_RTP_HANDLE;





char *gPrimeGk = NULL;
char *gSecondGk = NULL;
BOOL gIsRegTry = FALSE;
BOOL gIsPrimeGk = TRUE;





/*
 *
 * callback functions
 *
 */
/* error, exception, call droping
*/
void AppOnException(HSException pException, HS_RESULT tRet)
{
	HSPrint( "\n <APP> OnException(exc:%d,tRet:%u)", pException, tRet );
}


void AppOnAsnDecodingError(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, AsnStream *tStrm)
{
	HSPrint( "\n <APP> OnAsnDecodingError(!)" );
	AsnStream_Print(tStrm);
}


void AppOnCallIncoming(HS_STACK_HANDLE hStack, void* pCall)
{
	ICall *tCall = (ICall*)pCall;

	if( tCall == HS_NULL ) return;

	/* set capabilities
	*/
	gHCall = HapiGetCallHandle(tCall);
	HapiAddG711Alaw64k(tCall, HS_AUDIO_SIMUL_GROUP, 10);
	HapiAddG711Ulaw64k(tCall, HS_AUDIO_SIMUL_GROUP, 10);
	HapiAddG729(tCall, HS_AUDIO_SIMUL_GROUP, 10);
}


void AppOnCallRemoved(HS_CALL_HANDLE pHandle, CallCloseReason pReason, Q931CauseType pCause)
{
	HSPrint( "\n[APP] callback:AppOnCallRemoved:handle(%u):reason(%s):Q931Cause(%d)", pHandle, AppGetCallCloseReasonName(pReason), (int)pCause );
	gHCall = HS_INVALID_HANDLE;
}


/* timeout
*/
void AppOnRegistrationTimeout(HS_STACK_HANDLE hStack)
{
	if( gIsRegTry==TRUE )
	{
		if( gIsPrimeGk==TRUE )
		{
			HapiCommandChangeGatekeeper(hStack,gSecondGk);
			gIsPrimeGk = FALSE;
		}
		else
		{
			HapiCommandChangeGatekeeper(hStack,gPrimeGk);
			gIsPrimeGk = TRUE;
		}
	}
}


void AppOnRasMessageTimeout(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, ASNH225RasMessageChoice pType, HS_USHORT pSN )
{
	HSPrint( "\n[APP] callback:AppOnRasMessageTimeout:name(%s):sn(%u)", AppGetRasMessageName(pType), pSN );
}


/* message received
*/
BOOL AppOnReceiveRasRawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, AsnStream *pStrm)
{
	HSPrint( "\n[APP] callback:AppOnReceiveRasRawData:size(%d)", pStrm==NULL? 0:pStrm->size );
	return TRUE;
}


BOOL AppOnReceiveRasMessage(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, RasMsg *pMsg)
{
	if( pMsg == HS_NULL )
	{
		HSPrint( "\n[APP] callback:AppOnReceiveRasMessage:ERROR" );
		return FALSE;
	}
	
	HSPrint( "\n[APP] callback:AppOnReceiveRasMessage:name(%s)", AppGetRasMessageName(pMsg->choice) );
#ifdef HS_DEBUG_H323_APP_MBODY
	RasMsg_Print(pMsg,3,"RAS");
#endif
	return TRUE;
}


BOOL AppOnReceiveQ931RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	HSPrint( "\n[APP] callback:AppOnReceiveQ931RawData:size(%d)", pStrm==NULL? 0:pStrm->size );
	return TRUE;
}


BOOL AppOnReceiveQ931Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, Q931Message *pMsg)
{
	int tType = 256;

	if( pMsg != HS_NULL )
	{
		if( pMsg->uuie != HS_NULL )
			tType = pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice;
	}

	HSPrint( "\n[APP] callback:AppOnReceiveQ931Message:name(%s)", AppGetQ931MessageName(tType) );
#ifdef HS_DEBUG_APP_MBODY
	Q931Message_Print(pMsg,3,"Q.931");
#endif

	switch(tType)
	{
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting:
			{
				/* PlayRingbackTone();
				*/
				break;
			}
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect:
			{
				/* send brq
					: some H.323 service provider want to receive BRQ on connection,
					  for BILLING.  when service operate on 'Q.931 non-routed mode.
				*/
				HapiCommandChangeBandwidth(hStack,pHandle,HS_BANDWIDTH_DEFAULT);
				break;
			}
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup:
			break;
		default:
			break;
	}

	return TRUE;
}


BOOL AppOnReceiveH245RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	HSPrint( "\n[APP] callback:AppOnReceiveH245RawData:size(%d)", pStrm==NULL? 0:pStrm->size );
	return TRUE;
}


BOOL AppOnReceiveH245Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, ControlMsg *pMsg)
{
	if( pMsg == HS_NULL )
	{
		HSPrint( "\n[APP] callback:AppOnReceiveH245Message:ERROR" );
		return FALSE;
	}

	HSPrint( "\n[APP] callback:AppOnReceiveH245Message:name(%s)", AppGetH245MessageName(pMsg) );
#ifdef HS_DEBUG_H323_APP_MBODY
	ControlMsg_Print(pMsg,3,"H.245");
#endif
	return TRUE;
}


/* message sending
*/
BOOL AppOnSendRasMessage(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, RasMsg *pMsg)
{
	if( pMsg == HS_NULL )
	{
		HSPrint( "\n[APP] callback:AppOnSendRasMessage:ERROR" );
		return FALSE;
	}
	
	HSPrint( "\n[APP] callback:AppOnSendRasMessage:name(%s)", AppGetRasMessageName(pMsg->choice) );
#ifdef HS_DEBUG_H323_APP_MBODY
	RasMsg_Print(pMsg,3,"RAS");
#endif
	return TRUE;
}


BOOL AppOnSendRasRawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	HSPrint( "\n[APP] callback:AppOnSendRasRawData:size(%d)", pStrm==NULL? 0:pStrm->size );
	return TRUE;
}


BOOL AppOnSendQ931Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, Q931Message *pMsg)
{
	int tType = 256;

	if( pMsg != HS_NULL )
	{
		if( pMsg->uuie != HS_NULL )
			tType = pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice;
	}

	HSPrint( "\n[APP] callback:AppOnSendQ931Message:name(%s)", AppGetQ931MessageName(tType) );
#ifdef HS_DEBUG_APP_MBODY
	Q931Message_Print(pMsg,3,"Q.931");
#endif

	switch(tType)
	{
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting:
			{
				/* PlayPowerRing();
				*/
				break;
			}
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect:
			{
				/* send brq
					: some H.323 service provider want to receive BRQ on connection,
					  for BILLING.  when service operate on 'Q.931 non-routed mode.
				*/
				HapiCommandChangeBandwidth(hStack,pHandle,HS_BANDWIDTH_DEFAULT);
				break;
			}
		case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup:
			break;
		default:
			break;
	}

	return TRUE;
}


BOOL AppOnSendQ931RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	HSPrint( "\n[APP] callback:AppOnSendQ931RawData:size(%d)", pStrm==NULL? 0:pStrm->size );
	return TRUE;
}
/* WARNING:if call is a h245 tunneling mode, hStack is a invalid handle
*/
BOOL AppOnSendH245Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, ControlMsg *pMsg)
{
	if( pMsg == HS_NULL )
	{
		HSPrint( "\n[APP] callback:AppOnSendH245Message:ERROR" );
		return FALSE;
	}

	HSPrint( "\n[APP] callback:AppOnSendH245Message:name(%s)", AppGetH245MessageName(pMsg) );
#ifdef HS_DEBUG_H323_APP_MBODY
	ControlMsg_Print(pMsg,3,"H.245");
#endif
	return TRUE;
}
/* WARNING:if call is a h245 tunneling mode, hStack is a invalid handle
*/
BOOL AppOnSendH245RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	HSPrint( "\n[APP] callback:AppOnSendH245RawData:size(%d)", pStrm==NULL? 0:pStrm->size );
	return TRUE;
}


/* media channel
*/
HS_RESULT AppOnCheckFastStart(AsnSequenceOf *pOctetString, NoLockList *pCapabilities, void *pCall)
{
	HSPrint( "\n[APP] callback:AppOnCheckFastStart" );
	return AppCheckFastStart(pOctetString, pCapabilities, pCall);
}


HS_RESULT AppOnCheckTerminalCapabilitySet(HS_STACK_HANDLE hStack, void *pEndpoint, void *pCall, ASNH245TerminalCapabilitySet* pTcs)
{
	HSPrint( "\n[APP] callback:AppOnCheckTerminalCapabilitySet" );
	return AppCheckTerminalCapabilitySet(hStack, pEndpoint, pCall, pTcs);
}


void AppOnOpenReceiveMedia(
	HS_CALL_HANDLE pHandle,	HS_USHORT pRtpPort, HS_USHORT pRtcpPort, ASNH245DataType *pType
)
{
	ASNH245AudioCapability *tAudio = NULL;
	RtpPayloadType tRtpType = e_RtpPayloadTypeMax;

	HSPrint( "\n[APP] callback:AppOnOpenReceiveMedia:rtp(%u):rtcp(%u)", pRtpPort, pRtcpPort );

	/* StopRingbackTone();
	*/

	if( pType==NULL ) return;
	if( pType->choice != e_ASNH245DataTypeChoice_audioData ) return;
	if( (tAudio=(ASNH245AudioCapability*)(pType->alter))==NULL ) return;

	if( gRtpHandle==HS_INVALID_RTP_HANDLE )
	{
		if( (gRtpHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
			return;
	}

	switch(tAudio->choice)
	{
		case e_ASNH245AudioCapabilityChoice_g711Alaw64k:
		case e_ASNH245AudioCapabilityChoice_g711Alaw56k:
			tRtpType = e_RtpPayloadType_Pcma;
			break;
		case e_ASNH245AudioCapabilityChoice_g711Ulaw64k:
		case e_ASNH245AudioCapabilityChoice_g711Ulaw56k:
			tRtpType = e_RtpPayloadType_Pcmu;
			break;
		case e_ASNH245AudioCapabilityChoice_g729:
		case e_ASNH245AudioCapabilityChoice_g729AnnexA:
		case e_ASNH245AudioCapabilityChoice_g729wAnnexB:
		case e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB:
			tRtpType = e_RtpPayloadType_G729;
			break;
		default:
			return;
	}
	
	StartReverseRtp(gRtpHandle,tRtpType,pRtpPort);
	HSPrint( "\n[APP] reverse.rtp.started:codec(%d):port(%d)", tRtpType, pRtpPort );
}


void AppOnOpenSendMedia(
	HS_CALL_HANDLE pHandle,
	struct sockaddr_in pRtpIn, struct sockaddr_in pRtcpIn, ASNH245DataType *pType
)
{
	HS_UINT tFpp = 1;
	ASNH245AudioCapability *tAudio = NULL;
	RtpPayloadType tRtpType = e_RtpPayloadTypeMax;

	HSPrint( "\n[APP] callback:AppOnOpenSendMedia:ip(%08x):rtp(%u):rtcp(%u)",
		pRtpIn.sin_addr.s_addr, htons(pRtpIn.sin_port), htons(pRtcpIn.sin_port)
	);

	if( pType==NULL ) return;
	if( pType->choice != e_ASNH245DataTypeChoice_audioData ) return;
	if( (tAudio=(ASNH245AudioCapability*)(pType->alter))==NULL ) return;

	if( gRtpHandle==HS_INVALID_RTP_HANDLE )
	{
		if( (gRtpHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
			return;
	}

	switch(tAudio->choice)
	{
		case e_ASNH245AudioCapabilityChoice_g711Alaw64k:
		case e_ASNH245AudioCapabilityChoice_g711Alaw56k:
			tRtpType = e_RtpPayloadType_Pcma;
			break;
		case e_ASNH245AudioCapabilityChoice_g711Ulaw64k:
		case e_ASNH245AudioCapabilityChoice_g711Ulaw56k:
			tRtpType = e_RtpPayloadType_Pcmu;
			break;
		case e_ASNH245AudioCapabilityChoice_g729:
		case e_ASNH245AudioCapabilityChoice_g729AnnexA:
		case e_ASNH245AudioCapabilityChoice_g729wAnnexB:
		case e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB:
			tRtpType = e_RtpPayloadType_G729;
			break;
		default:
			return;
	}

	switch((RtpPayloadType)tRtpType)
	{
		case e_RtpPayloadType_Pcma:
		case e_RtpPayloadType_Pcmu:
			tFpp = 4;
			break;
		case e_RtpPayloadType_G729:
			tFpp = 2;
			break;
		default:
			tFpp = 1;
			break;
	}

	StartForwardRtpEx(gRtpHandle,tRtpType,pRtpIn,tFpp);
	HSPrint( "\n[APP] forward.rtp.started:codec(%d):ip(%08x):port(%d)", tRtpType, pRtpIn.sin_addr.s_addr, htons(pRtpIn.sin_port) );
}


void AppOnCloseReceiveMedia(HS_CALL_HANDLE pHandle, ASNH245DataType *pType)
{
	HSPrint( "\n[APP] callback:AppOnCloseReceiveMedia" );

	if( gRtpHandle==HS_INVALID_RTP_HANDLE ) return;

	CloseRtp(gRtpHandle);
	gRtpHandle = HS_INVALID_RTP_HANDLE;
}


void AppOnCloseSendMedia(HS_CALL_HANDLE pHandle, ASNH245DataType *pType)
{
	HSPrint( "\n[APP] callback:AppOnCloseSendMedia" );

	if( gRtpHandle==HS_INVALID_RTP_HANDLE ) return;

	CloseRtp(gRtpHandle);
	gRtpHandle = HS_INVALID_RTP_HANDLE;
}





/*
 *
 * rapping functions
 *
 */
/* Application Functions
*/
IEndpoint *AppH323MakeEndpoint(char *pLocalIp)
{
	IEndpoint *tEndpoint;

	if( (tEndpoint=(IEndpoint*)HSMalloc(sizeof(IEndpoint))) == HS_NULL )
	{
		printf( "\n <APP> Endpoint Alloc Error." );
		return HS_NULL;
	}
	new_IEndpoint(tEndpoint);

	tEndpoint->type = e_EndpointType_gateway;
	HapiSetRasAddress(tEndpoint,pLocalIp,1729);
	HapiSetCallSignalingAddress(tEndpoint,pLocalIp,1720);

#if 0
	HapiAddEndpointAliasDial	(tEndpoint, "023337777");
	HapiAddEndpointAliasH323Id	(tEndpoint, "TZ-1977-11-20");
	HapiAddEndpointAliasUrlId	(tEndpoint, "www.cryptack.com");
	HapiAddEndpointAliasEmailId	(tEndpoint, "admin@cryptack.com");
#else
	HapiAddEndpointAliasDial	(tEndpoint, "070323");
	HapiAddEndpointAliasH323Id	(tEndpoint, "070323");
#endif

	strcpy(tEndpoint->productId,"CRYPTACK-H323");
	strcpy(tEndpoint->versionId,"0.001");

	tEndpoint->gatekeeper.ttl = 120;
	tEndpoint->gatekeeper.ttlForce = FALSE;
	tEndpoint->gatekeeper.attemptTime = 5;
	tEndpoint->gatekeeper.isGRQ = FALSE;
	tEndpoint->gatekeeper.isUseLightRRQ = TRUE;

	tEndpoint->CallbackException			= AppOnException;
	tEndpoint->CallbackAsnDecodingError		= AppOnAsnDecodingError;
	tEndpoint->CallbackCallIncoming			= AppOnCallIncoming;
	tEndpoint->CallbackCallRemoved			= AppOnCallRemoved;
	
	tEndpoint->CallbackRegistrationTimeout	= AppOnRegistrationTimeout;
	tEndpoint->CallbackRasMessageTimeout	= AppOnRasMessageTimeout;

	tEndpoint->CallbackReceiveRasRawData	= AppOnReceiveRasRawData;
	tEndpoint->CallbackReceiveRasMessage	= AppOnReceiveRasMessage;
	tEndpoint->CallbackReceiveQ931RawData	= AppOnReceiveQ931RawData;
	tEndpoint->CallbackReceiveQ931Message	= AppOnReceiveQ931Message;
	tEndpoint->CallbackReceiveH245RawData	= AppOnReceiveH245RawData;
	tEndpoint->CallbackReceiveH245Message	= AppOnReceiveH245Message;
	tEndpoint->CallbackSendRasMessage		= AppOnSendRasMessage;
	tEndpoint->CallbackSendRasRawData		= AppOnSendRasRawData;
	tEndpoint->CallbackSendQ931Message		= AppOnSendQ931Message;
	tEndpoint->CallbackSendQ931RawData		= AppOnSendQ931RawData;
	tEndpoint->CallbackSendH245Message		= AppOnSendH245Message;
	tEndpoint->CallbackSendH245RawData		= AppOnSendH245RawData;

	tEndpoint->CallbackCheckFastStart		= AppOnCheckFastStart;
	tEndpoint->CallbackCheckTerminalCapabilitySet = AppOnCheckTerminalCapabilitySet;
	tEndpoint->CallbackOpenReceiveMedia		= AppOnOpenReceiveMedia;
	tEndpoint->CallbackOpenSendMedia		= AppOnOpenSendMedia;
	tEndpoint->CallbackCloseReceiveMedia	= AppOnCloseReceiveMedia;
	tEndpoint->CallbackCloseSendMedia		= AppOnCloseSendMedia;

	return tEndpoint;
}


HS_CALL_HANDLE AppH323MakeCall( HS_STACK_HANDLE pHandle, char *pLocalIp, char *pDest, App_AddressType pType )
{
	ICall *tCall = HS_NULL;

	if( pHandle == HS_INVALID_STACK_HANDLE || pDest == HS_NULL || pType >= e_App_AddressTypeMax )
		return HS_INVALID_CALL_HANDLE;

	/* check address type
	*/
	if( pType == e_App_AddressType_Ip )
	{
		if( IsIp(pDest) != HS_YES )
			return HS_INVALID_CALL_HANDLE;
	}
	else if( pType == e_App_AddressType_E164id )
	{
		if( IsE164(pDest) != HS_YES )
			return HS_INVALID_CALL_HANDLE;
	}

	/* get call object
	*/
	if( (tCall=HapiCallOpen()) == HS_NULL ) return HS_INVALID_CALL_HANDLE;


/** TO DO USER SETTING OF CALL { **/

	/* set canMapAlias
	*/
	tCall->canMapAlias = HS_YES;

	/* set destination address
	*/
	if( pType == e_App_AddressType_Ip )
	{
		HS_UINT lDestIp;
		HS_UCHAR tDestIp[4];

		lDestIp = htonl( inet_addr( pDest ) );
		Uint2Uchar(tDestIp, &lDestIp);

		Tsap2ASNH225TransportAddress( &(tCall->dcsaTsap), tDestIp, 1720 );
	}
	else if( pType == e_App_AddressType_E164id )
		HapiAddCalledAliasDial(tCall, pDest);
	else
		HapiAddCalledAliasH323Id(tCall, pDest);

	/* set source address
	*/
#if 0
	HapiAddCallingAliasH323Id(tCall, "T771120-Z760124");
	HapiAddCallingAliasDial(tCall, "023337777" );
#else
	HapiAddCallingAliasH323Id	(tCall, "070323");
	HapiAddCallingAliasDial		(tCall, "070323");
#endif


	/* set source call tsap
	*/
	Tsap2ASNH225TransportAddress( &(tCall->scsaTsap), pLocalIp, 1720 );

	/* set options
	*/
	tCall->isTunneling = FALSE;
	tCall->isFastStart = TRUE;
	tCall->h245ListenPoint = e_H245ListenPoint_Alert;

	/* set capabilities
	*/
	HapiAddG711Alaw64k(tCall, HS_AUDIO_SIMUL_GROUP, 10);
	HapiAddG711Ulaw64k(tCall, HS_AUDIO_SIMUL_GROUP, 10);
	HapiAddG729(tCall, HS_AUDIO_SIMUL_GROUP, 10);

	/* set q931 field
	*/
	strcpy( tCall->callingParty, "070323" );
	strcpy(tCall->calledParty,pDest);

/** TO DO USER SETTING OF CALL } **/


	if( HapiCommandMakeCall(pHandle, tCall) != HS_OK ) return HS_INVALID_CALL_HANDLE;
	return tCall->handle;
}



HS_RESULT AppChangeEndpointAlias(HS_STACK_HANDLE hStack)
{
	HS_RESULT tRet = HS_OK;
	NoLockList *tAliases = HS_NULL;

	if( (tAliases=HapiMakeAliasList()) == HS_NULL ) return HS_ERR_H323_MALLOC;

	if( (tRet=HapiAddAliasH323Id(tAliases, "5happylife")) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}
	if( (tRet=HapiAddAliasDial(tAliases, "01119771120")) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}
	if( (tRet=HapiAddAliasUrlId(tAliases, "mail.cryptack.com")) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}
	if( (tRet=HapiAddAliasEmailId(tAliases, "admin@cryptack.co.kr")) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}

	return HapiCommandChangeEndpointAliases(hStack, tAliases);
}





/*
 *
 * main function
 *
 */
static HS_UCHAR gLocalIp[4];
#define P_LOCAL_IP		argv[1]
#define P_PRIGK_IP		argv[2]
#define P_SNDGK_IP		argv[3]
#define P_H323ID		argv[4]
#define P_E164			argv[5]
#define SHOW_MANUAL									\
	printf(											\
		"\n =========================="				\
		"\n     MiniX-Phone Manual"					\
		"\n =========================="				\
		"\n 'h' : show help"						\
		"\n 'z' : clear screen"						\
		"\n 'e' : exit program"						\
		"\n 's' : show status"						\
		"\n 'r' : try registration"					\
		"\n 'u' : try unregistration"				\
		"\n 'g' : use grq or not"					\
		"\n 'c' : calling"							\
		"\n 'a' : accept call"						\
		"\n 'd' : drop call"						\
		"\n 'i' : change aliases test"				\
		"\n '/' : Send Dtmf by H245UserInputIndication"\
		"\n =========================="				\
	)



int main(int argc, char **argv)
{
	char tCommand[256];
	BOOL tStackOut = FALSE;

	/* check arguments
	*/
	if( argc != 6 )
	{
		printf( "Usage: MiniXPhone <local IP> <prime GK 'port@ip(dns)'> <second GK 'port@ip(dns)'> <H.323 id> <E.164 id (phone number)>\n" );
		printf( "example> MiniXPhone 192.168.1.1 1719@gk.cryptack.com 1719@gk.voiper.co.kr h323id 0119771120\n" );
		return 0;
	}
	gPrimeGk = P_PRIGK_IP;
	gSecondGk = P_SNDGK_IP;
	*((HS_UINT*)gLocalIp) = inet_addr(P_LOCAL_IP);

	/* application demon
	*/
	LoadHSResource(100);
	HSPrintToStdOutOn();
	SHOW_MANUAL;

	/* start stack
	*/
	if( (gHStack=HapiStartStack(AppH323MakeEndpoint(gLocalIp)))==HS_INVALID_STACK_HANDLE )
	{
		printf( "H.323 Cryptack Starting Error.\n" );
		return 0;
	}

	/* prompt demon
	*/
	while(tStackOut==FALSE)
	{
		printf( "\nh323> " );

		switch(getch())
		{
			case 'r':/*registration*/
				printf( "\n - Registration..." );
				HapiCommandChangeGatekeeper(gHStack,P_PRIGK_IP);
				gIsRegTry = TRUE;
				break;

			case 'u':/*unregistration*/
				printf( "\n - Unregistration..." );
				HapiCommandChangeGatekeeper(gHStack,"");
				gIsPrimeGk = TRUE;
				gIsRegTry = FALSE;
				break;

			case 'c':/*calling*/
				if( gHCall != HS_INVALID_HANDLE )
				{
					printf( "\n - call is active!" );
					break;
				}

				printf( "\nAddress Type('i':ip address, 'h':h323 id, 'e':e164 id):" );
				switch(getche())
				{
					case 'i':
						printf( "\nh323> Destination : " );
						scanf( "%s", tCommand );
						gHCall = AppH323MakeCall(gHStack,gLocalIp,tCommand,e_App_AddressType_Ip);
						break;
					case 'h':
						printf( "\nh323> Destination : " );
						scanf( "%s", tCommand );
						gHCall = AppH323MakeCall(gHStack,gLocalIp,tCommand,e_App_AddressType_H323id);
						break;
					case 'e':
						printf( "\nh323> Destination : " );
						scanf( "%s", tCommand );
						gHCall = AppH323MakeCall(gHStack,gLocalIp,tCommand,e_App_AddressType_E164id);
						break;
					default:
						printf( "\n - ignored." );
						break;
				}

				if( gHCall==HS_INVALID_CALL_HANDLE )
					printf( " <err> failed" );
				break;

			case 's':/*show status*/
				printf( "\n> Show What! uhh? ('c':call, 's':skip)" );
				break;

			case 'a':/*accept call*/
				if( gHCall == HS_INVALID_HANDLE )
				{
					printf( "\n - no call to accept" );
					break;
				}
				HapiCommandAcceptCall(gHStack,gHCall);
				break;

			case 'd':/*drop call*/
				if( gHCall == HS_INVALID_HANDLE )
				{
					printf( "\n - no call to drop" );
					break;
				}
				HapiCommandRemoveCall(gHStack,gHCall,e_CallCloseReason_Normal);
				printf( "\n - dropping..." );
				gHCall = HS_INVALID_HANDLE;
				break;

			case 'g':/*set using grq or not*/
				printf( "\nUse grq? ('y':yes, 'n':no, 's':skip):" );
				switch(getch())
				{
					case 'y':
						printf( "\n - Set use grq." );
						HapiCommandUseGRQ(gHStack,TRUE);
						break;
					case 'n':
						printf( "\n - Set unuse grq." );
						HapiCommandUseGRQ(gHStack,FALSE);
						break;
					default:
						printf( "\n - Skipped." );
						break;
				}
				break;

			case 'z':/*clear DOS screen*/
				system("cls");
			case 'h':/*show menual*/
				SHOW_MANUAL;
				break;

			case 'i':/*change alias test*/
				AppChangeEndpointAlias(gHStack);
				break;

			case 'e':/*process ending*/
				printf( "\n - Ending Application..." );
				tStackOut = TRUE;
				break;

			case '/':
			{
				ControlMsg *tUserInput = NULL;

				if( gHCall==HS_INVALID_HANDLE || gRtpHandle==HS_INVALID_RTP_HANDLE )
				{
					printf( " <err> no active media channel" );
					break;
				}

				printf( "Type Dtmf Charactor:" );
				if( (tUserInput=AppMakeDtmfH245UserInputIndication((char)getch(),100))==NULL )
				{
					printf( " <err> fail to make h.245 message" );
					break;
				}

				HapiCommandH245UserInputIndication(gHStack,gHCall,tUserInput);
				break;
			}
			default:/*any key*/
				printf( "\n - Type 'h' to see the help." );
				break;
		}
	}

	/* stop stack
	*/
	HapiStopStack(gHStack);

	/* unload resource
	   ! NOTE: all of stack handle must closed before unload-resource.
	*/
	Sleep(500);
	UnloadHSResource(1000);
	return 0;
}


