/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipUI.c>	2005-11-01,24:14

*/

#ifdef _WIN32_WCE
#include <winbase.h>
#endif

#include "SipUI.h"





#if defined(_WIN32) || defined(_WIN32_WCE)
HANDLE gNetHandle;
HANDLE gStackHandle;
#endif



/*call handle generator:
	odd numbered handle is a originated call.
*/
HSSemaphore gSemaUaHandleInSipUI;
HSSemaphore gSemaCallHandleInSipUI;

static HS_UA_HANDLE gUaHandleSeed = HS_UA_HANDLE_MIN;
static HS_CALL_HANDLE gCallHandleSeed = HS_CALL_HANDLE_MIN+1;

static HS_UA_HANDLE GetUaHandleInSipUI()
{
	HS_UINT tResult;

	HSLockSemaphore(gSemaUaHandleInSipUI);
	if( gUaHandleSeed > HS_UA_HANDLE_MAX )
		gUaHandleSeed = HS_UA_HANDLE_MIN;
	tResult = gUaHandleSeed;
	gUaHandleSeed += 2;
	HSUnlockSemaphore(gSemaUaHandleInSipUI);

	return tResult;
}

static HS_CALL_HANDLE GetCallHandleInSipUI()
{
	HS_UINT tResult;

	HSLockSemaphore(gSemaCallHandleInSipUI);
	if( gCallHandleSeed > HS_CALL_HANDLE_MAX )
		gCallHandleSeed = HS_CALL_HANDLE_MIN;
	tResult = gCallHandleSeed;
	gCallHandleSeed += 2;
	HSUnlockSemaphore(gSemaCallHandleInSipUI);

	return tResult;
}





/* IStack setting functions
*/
HS_STACK_HANDLE SapiMakeStackHandle(char *pLocalIp,char *pUserAgentName)
{
	IStack *tResult = NULL;

	/* check licence time
	*/
	if( SipUaCheckLicenceTime() != HS_OK ) return NULL;

	if( pLocalIp==NULL ) return NULL;
	if( (tResult=(IStack*)HSMalloc(sizeof(IStack)))==NULL ) return NULL;
	new_IStack(tResult,pLocalIp,pUserAgentName);

	return tResult;
}


HS_RESULT SapiRemoveStackHandle(HS_STACK_HANDLE pHandle)
{
	IStack *pObj = (IStack*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	delete_IStack(pObj);
	HSFree(pObj);
	return HS_OK;
}


HS_RESULT SapiStartStack(HS_STACK_HANDLE pHandle, HS_USHORT pUdpPort, HS_USHORT pTcpPort)
{
	HS_QID tSipQ, tNetQ;
	SipDemon *tDemon = NULL;
	SipEnetDemon *tEnetDemon = NULL;
	HS_UINT tActiveCnt = 0;
	IStack *tStack = (IStack*)pHandle;

	/* make thread objects
	*/
	if( tStack==NULL )
		return HS_ERR_NULL_PARAM;
	if( (tEnetDemon=newm_SipEnetDemon(pUdpPort,pTcpPort))==NULL )
	{
		SapiRemoveStackHandle(tStack);
		return HS_ERR_MALLOC;
	}
	if( (tDemon=newm_SipDemon(tStack))==NULL )
	{
		SapiRemoveStackHandle(tStack);
		deletem_SipEnetDemon(tEnetDemon);
		return HS_ERR_MALLOC;
	}

	/* TSAP port setting
	*/
	tStack->mUdpPort = pUdpPort;
	tStack->mTcpPort = pTcpPort;

	/* semaphore Initialize
	*/
	HSOpenSemaphore(gSemaCallHandleInSipUI);
	HSOpenSemaphore(gSemaUaHandleInSipUI);

	/* start threads
	*/
	tSipQ = HSThreadStart(tDemon,NULL,SipDemon_Main);
	tNetQ = HSThreadStart(tEnetDemon,NULL,SipEnetDemon_Main);
	if( tSipQ==HS_INVALID_QID || tNetQ==HS_INVALID_QID )
	{
		return HS_ERR;
	}

	/* learn each Queue Id
	*/
	tDemon->mNetQ = tNetQ;
	tEnetDemon->mSipQ = tSipQ;
	tStack->mNetQ = tNetQ;
	tStack->mSipQ = tSipQ;

	/* wait for starting thread
	*/
	tActiveCnt = 0;
	while( ! HS_THREAD_IS_ACTIVE(tDemon) || ! HS_THREAD_IS_ACTIVE(tEnetDemon) )
	{
		HSSleep(50);
		tActiveCnt++;
		if( tActiveCnt==20 ) break;
	}
	if( tActiveCnt==20 )
	{
		_HSThreadStop(tSipQ);
		_HSThreadStop(tNetQ);
		return HS_ERR;
	}
	HSSleep(100);

	return HS_OK;
}


HS_RESULT SapiStopStack(HS_STACK_HANDLE pHandle)
{
	IStack *tStack = (IStack*)pHandle;

	/* check parameter
	*/
	if( tStack==NULL )
		return HS_ERR_NULL_PARAM;

	/* stop threads
	*/
	_HSThreadStop(tStack->mNetQ);
	_HSThreadStop(tStack->mSipQ);

	/* clear semaphores
	*/
	HSCloseSemaphore(gSemaCallHandleInSipUI);
	HSCloseSemaphore(gSemaUaHandleInSipUI);
    return HS_OK;
}





/* IUa setting functions
*/
IUa *SapiMakeUa(
	char *pProxy,
	char *pOutBoundProxy,
	HS_USHORT pProxyPort,
	HS_UINT pExpires
)
{
	IUa *tResult = NULL;

	if( pProxy==NULL ) return NULL;

	if( (tResult=(IUa*)HSMalloc(sizeof(IUa)))==NULL ) return NULL;
	new_IUa_ByUser(tResult,pExpires);

	tResult->mHandle = GetUaHandleInSipUI();
	strcpy(tResult->mProxy,pProxy);
	if( pOutBoundProxy!=NULL ) strcpy(tResult->mOutBoundProxy,pOutBoundProxy);
	tResult->mProxyPort = pProxyPort;
	return tResult;
}


HS_RESULT SapiRemoveUa(IUa *pUa)
{
	if( pUa==NULL ) return HS_ERR_NULL_PARAM;
	delete_IUa(pUa);
	HSFree(pUa);
	return HS_OK;
}


HS_RESULT SapiAddContactToUa(
	HS_STACK_HANDLE pHandle,
	IUa *pUa,
	char *pDisplayName,
	char *pUserName,
	char *pLocal,
	HS_USHORT pLocalPort,
	HS_UINT pExpires
)
{
	IStack *tStack = (IStack*)pHandle;
	SipContact *tContact = NULL;
	SipContactUnit *tContactUnit = NULL;

	if( pUa==NULL || pUserName==NULL || pLocal==NULL )
		return HS_ERR_NULL_PARAM;
	if( (tContactUnit=newm_SipContactUnit(FALSE))==NULL )
		return HS_ERR_MALLOC;
	if( (tContact=newm_SipContact())==NULL )
	{
		delete_SipContactUnit(tContactUnit);
		HSFree(tContactUnit);
		return HS_ERR_MALLOC;
	}

	if( pDisplayName!=NULL )
		tContactUnit->mDisplayName = SipStringAlloc(pDisplayName);
	if( pExpires!=HS_UINT_MAX )
		tContactUnit->mExpire = SipUintAlloc(pExpires);
	if( pLocalPort != HS_INVALID_TSAP_PORT )
		tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)pLocalPort);
	tContactUnit->mUri.mProtocol = SipStringAlloc(tStack->mProtocol);
	tContactUnit->mUri.mUserName = SipStringAlloc(pUserName);
	tContactUnit->mUri.mAddress = SipStringAlloc(pLocal);

	NoLockList_AttachData(&(tContact->mContactUnits),tContactUnit);
	return NoLockList_AttachData(&(pUa->mContacts),tContact);
}


HS_RESULT SapiSetPasswordToUa(IUa *pUa, char *pPassword)
{
	if( pUa==NULL || pPassword==NULL ) return HS_ERR_NULL_PARAM;

	strcpy(pUa->mPassword,pPassword);
	return HS_OK;
}


HS_RESULT SapiSetAuthUserToUa(IUa *pUa, char *pAuthUser)
{
	if( pUa==NULL || pAuthUser==NULL ) return HS_ERR_NULL_PARAM;

	if( pUa->mAuthUser != NULL )
		HSFree(pUa->mAuthUser);

	pUa->mAuthUser = SipStringAlloc(pAuthUser);
	return HS_OK;
}





/* Dialogue setting functions
*/
IDialogue *SapiMakeDialogue(
	char *pDisplayName,
	char *pUserName,
	char *pAddress,
	HS_USHORT pPort,
	BOOL pIsTcp
)
{
	IDialogue *tResult = NULL;

	if( pUserName==NULL )
		return NULL;
	if( (tResult=(IDialogue*)HSMalloc(sizeof(IDialogue)))==NULL )
		return NULL;
	new_IDialogue_ByUser(tResult);

	tResult->mHandle = GetCallHandleInSipUI();
	tResult->mIsTcp = pIsTcp;
	if( pDisplayName!=NULL )
		tResult->mDestDisplayName = SipStringAlloc(pDisplayName);
	if( pAddress!=NULL )
		tResult->mDestAddress = SipStringAlloc(pAddress);
	tResult->mDestPort=pPort;
	tResult->mDestUser = SipStringAlloc(pUserName);
	return tResult;
}


HS_RESULT SapiRemoveDialogue(IDialogue *pDialogue)
{
	if( pDialogue==NULL ) return HS_ERR_NULL_PARAM;
	delete_IDialogue(pDialogue);
	HSFree(pDialogue);
	return HS_OK;
}


HS_CALL_HANDLE SapiGetDialogueHandle(IDialogue *pDialogue)
{
	if( pDialogue==NULL ) return HS_INVALID_HANDLE;
	return pDialogue->mHandle;
}





/* media capability setting functions
*/
HS_RESULT SapiAddMediaCapabilityToDialogue(
	HS_STACK_HANDLE pHandle,
	IDialogue *pDialogue,
	char *pType,
	HS_UINT pRtpIndex
)
{
	HS_RESULT tRet = HS_OK;
	HS_USHORT tMediaPort = HS_INVALID_TSAP_PORT;
	BOOL tIsNewDescription = FALSE;

	SdpMessage *tSdp = NULL;
	SdpAttribute *tMediaAttr = NULL;
	SdpMediaDescription *tMediaDesc = NULL;
	IStack *tStack = (IStack*)pHandle;

	if( tStack==NULL || pDialogue==NULL || pType==NULL )
		return HS_ERR_NULL_PARAM;
	tSdp = &(pDialogue->mSdp);

	if( (tMediaDesc=SdpMessage_FindMediaDescription(tSdp,pType))==NULL )
	{
		tIsNewDescription = TRUE;
		if( (tMediaDesc=(SdpMediaDescription*)HSMalloc(sizeof(SdpMediaDescription)))==NULL )
			return HS_ERR_MALLOC;
		new_SdpMediaDescription(tMediaDesc);

		if( (tMediaPort=IStack_MakeMediaTsapPort(tStack))==HS_INVALID_TSAP_PORT )
		{
			delete_SdpMediaDescription(tMediaDesc);
			HSFree(tMediaDesc);
			return HS_ERR;
		}
		tMediaDesc->mTsapPort = SipUintAlloc((HS_UINT)tMediaPort);
		tMediaDesc->mMediaType = SipStringAlloc(pType);

		if( (tMediaAttr=(SdpAttribute*)HSMalloc(sizeof(SdpAttribute)))==NULL )
		{
			delete_SdpMediaDescription(tMediaDesc);
			HSFree(tMediaDesc);
			return HS_ERR_MALLOC;
		}
	}
	else
	{
		tIsNewDescription = FALSE;
		if( (tMediaAttr=(SdpAttribute*)HSMalloc(sizeof(SdpAttribute)))==NULL )
			return HS_ERR_MALLOC;
	}
	new_SdpAttribute(tMediaAttr);

	if( (tRet=SdpAttribute_SetAttrNumber(tMediaAttr,pRtpIndex)) != HS_OK )
	{
		delete_SdpAttribute(tMediaAttr);
		HSFree(tMediaAttr);
		if( tIsNewDescription==TRUE )
		{
			delete_SdpMediaDescription(tMediaDesc);
			HSFree(tMediaDesc);
		}
		return tRet;
	}

	NoLockList_AttachData(&(tMediaDesc->mAttributes),tMediaAttr);
	if( tIsNewDescription==TRUE )
		NoLockList_AttachData(&(tSdp->mDescriptions),tMediaDesc);
	return HS_OK;
}





/*
 *
 * user command APIs
 *
 */
HS_UA_HANDLE SapiCommandAddUa(HS_STACK_HANDLE pHandle, IUa *pUa)
{
	HS_UA_HANDLE tResult = HS_INVALID_HANDLE;
	IStack *tStack = (IStack*)pHandle;

	if( tStack==NULL || pUa==NULL ) return HS_INVALID_HANDLE;
	tResult = pUa->mHandle;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_ADD_UA,0,(LPARAM)pUa);
	return tResult;
}


HS_RESULT SapiCommandRegistUa(HS_STACK_HANDLE pStackHandle, HS_UA_HANDLE pUaHandle)
{
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL || pUaHandle==HS_INVALID_HANDLE )
		return HS_ERR_INVALID_PARAM;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_REGIST_UA,0,(LPARAM)pUaHandle);
	return HS_OK;
}


HS_RESULT SapiCommandRemoveUa(HS_STACK_HANDLE pStackHandle, HS_UA_HANDLE pUaHandle)
{
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL || pUaHandle==HS_INVALID_HANDLE )
		return HS_ERR_INVALID_PARAM;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_REMOVE_UA,0,(LPARAM)pUaHandle);
	return HS_OK;
}


HS_CALL_HANDLE SapiCommandMakeCall(HS_STACK_HANDLE pStackHandle, HS_UA_HANDLE pUaHandle, IDialogue *pDialogue)
{
	QmMakeCall *tMakeCall = NULL;
	IStack *tStack = (IStack*)pStackHandle;
	HS_CALL_HANDLE tResult = HS_INVALID_HANDLE;

	if( tStack==NULL || pUaHandle==HS_INVALID_HANDLE || pDialogue==NULL )
		return HS_INVALID_HANDLE;

	tResult = pDialogue->mHandle;
	if( (tMakeCall=newm_QmMakeCall(pDialogue,pUaHandle))==NULL )
		return HS_INVALID_HANDLE;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_MAKE_CALL,0,(LPARAM)tMakeCall);
	return tResult;
}




HS_RESULT SapiCommandAcceptCall(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle)
{
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL || pCallHandle==HS_INVALID_HANDLE )
		return HS_ERR_INVALID_PARAM;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_ACCEPT_CALL,0,(LPARAM)pCallHandle);
	return HS_OK;
}


HS_RESULT SapiCommandRemoveCall(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, SipResponse pReason)
{
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL || pCallHandle==HS_INVALID_HANDLE )
		return HS_ERR_INVALID_PARAM;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_REMOVE_CALL,(WPARAM)pReason,(LPARAM)pCallHandle);
	return HS_OK;
}


HS_RESULT SapiCommandSendINFO(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, char *pType, char *pBody)
{
	QmMessageBody *tBody = NULL;
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL || pCallHandle==HS_INVALID_HANDLE || pBody==NULL ) return HS_ERR_NULL_PARAM;
	if( (tBody=newm_QmMessageBody(pCallHandle,pType,pBody))==NULL ) return HS_ERR_MALLOC;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_SEND_MESSAGE_INFO,(WPARAM)0,(LPARAM)tBody);
	return HS_OK;
}


HS_RESULT SapiCommandSendMESSAGE(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, char *pType, char *pBody)
{
	QmMessageBody *tBody = NULL;
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL || pCallHandle==HS_INVALID_HANDLE || pBody==NULL ) return HS_ERR_NULL_PARAM;
	if( (tBody=newm_QmMessageBody(pCallHandle,pType,pBody))==NULL ) return HS_ERR_MALLOC;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_SEND_MESSAGE_MESSAGE,(WPARAM)0,(LPARAM)tBody);
	return HS_OK;
}


HS_RESULT SapiCommandChangeListenPort(HS_STACK_HANDLE pStackHandle, BOOL pIsUdp, HS_USHORT pPort)
{
	HS_UINT tType;
	IStack *tStack = (IStack*)pStackHandle;

	if( tStack==NULL ) return HS_ERR_NULL_PARAM;
	if( pIsUdp==TRUE )	tType=0;
	else				tType=1;

	_HSThreadSendMessage(tStack->mSipQ,HS_QM_CHANGE_LISTEN_PORT,(WPARAM)pPort,(LPARAM)tType);
	return HS_OK;
}





/* check SIP UA licence time
*/
HS_RESULT SipUaCheckLicenceTime()
{
	if		( !strcmp(RELEASED_VENDOR,"voiper") )
		return HSCheckLicenceTime();
	else if	( !strcmp(RELEASED_VENDOR,"my vendor") )
		return HS_OK;

	return HS_ERR;
}