/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SocketSet.h>	2005-03-13,13:59

*/

#ifndef __2005_03_13__13_59__SIPSOCKETSET_H__
#define __2005_03_13__13_59__SIPSOCKETSET_H__


#include "SipDefine.h"
#include "UaDefine.h"
#include "SipQmessage.h"



typedef struct
{
	SOCKET			mSocket;
	HS_TR_HANDLE	mHandle;
	/* message ready to send until TCP connection
	*/
	QmEnetMessage	*mReady;
} SipSocketSet;

HS_RESULT new_SipSocketSet(void *pObject, HS_TR_HANDLE pHandle);
HS_RESULT delete_SipSocketSet(void *pObject);

HS_RESULT SipSocketSet_FdSet(void *pObject, fd_set *pSet, HS_UINT *pMax );
HS_RESULT SipSocketSet_FdIsSet(void *pObject, fd_set *pSet, HS_QID pDestQ, HS_UCHAR *pBuffer, int pLen);



#define SipSocketList		NoLockList

ChainUnit *NoLockList_FindSipSocketSetByHandle(NoLockList *pObj, HS_TR_HANDLE pHandle);
HS_RESULT NoLockList_SipFdSet(NoLockList *pObj, fd_set *pSet, HS_UINT *pMax);
HS_RESULT NoLockList_SipFdIsSet(NoLockList *pObj, fd_set *pSet, HS_QID pSipDemonQ, HS_UCHAR *pBuffer, int pLen);



#endif/*__2005_03_13__13_59__SIPSOCKETSET_H__*/



