/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipQmessage.c>		2005-10-22,22:55

*/

#include "SipQmessage.h"





/* QmMakeCall member functions
*/
QmMakeCall *newm_QmMakeCall(IDialogue *pDialogue, HS_UA_HANDLE pHandle)
{
	QmMakeCall *pObj = NULL;

	if( (pObj=(QmMakeCall*)HSMalloc(sizeof(QmMakeCall))) == NULL )
		return NULL;
	pObj->mDialogue = pDialogue;
	pObj->mHandle = pHandle;
	return pObj;
}


HS_RESULT delete_QmMakeCall(void *pObject)
{
	QmMakeCall *pObj = (QmMakeCall*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mDialogue != NULL )
	{
		delete_IDialogue(pObj->mDialogue);
		HSFree(pObj->mDialogue);
		pObj->mDialogue = NULL;
	}

	return HS_OK;
}


HS_RESULT deletem_QmMakeCall(void *pObject)
{
	HS_RESULT tRet;

	HS_TRY( delete_QmMakeCall(pObject) );
	HSFree(pObject);
	return HS_OK;
}





/* QmRemodelCall member functions
*/
QmRemodelCall *newm_QmRemodelCall(IDialogue *pDialogue, HS_CALL_HANDLE pHandle)
{
	QmRemodelCall *pObj = NULL;

	if( (pObj=(QmRemodelCall*)HSMalloc(sizeof(QmRemodelCall)))==NULL )
		return NULL;

	pObj->mDialogue = pDialogue;
	pObj->mHandle = pHandle;
	return pObj;
}


HS_RESULT delete_QmRemodelCall(void *pObject)
{
	QmRemodelCall *pObj = (QmRemodelCall*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mDialogue != NULL )
	{
		delete_IDialogue(pObj->mDialogue);
		HSFree(pObj->mDialogue);
		pObj->mDialogue = NULL;
	}
	return HS_OK;
}


HS_RESULT deletem_QmRemodelCall(void *pObject)
{
	HS_RESULT tRet;

	HS_TRY( delete_QmRemodelCall(pObject) );
	HSFree(pObject);
	return HS_OK;
}





/* supplementary message sending commands - INFO,MESSAGE
*/
/* QmMessageBody member functions
*/
QmMessageBody *newm_QmMessageBody(HS_CALL_HANDLE pHandle,char *pType,char *pBody)
{
	QmMessageBody *tResult = NULL;

	if( pBody==NULL ) return NULL;
	if( (tResult=(QmMessageBody*)HSMalloc(sizeof(QmMessageBody)))==NULL )
		return NULL;

	tResult->mHandle = pHandle;
	if( pType != NULL ) tResult->mType = SipStringAlloc(pType);
	else tResult->mType = NULL;
	tResult->mBody = SipStringAlloc(pBody);

	return tResult;
}


HS_RESULT delete_QmMessageBody(void *pObject)
{
	QmMessageBody *pObj = (QmMessageBody*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mType != NULL )
	{
		HSFree(pObj->mType);
		pObj->mType= NULL;
	}
	if( pObj->mBody != NULL )
	{
		HSFree(pObj->mBody);
		pObj->mBody = NULL;
	}

	return HS_OK;
}


HS_RESULT deletem_QmMessageBody(void *pObject)
{
	QmMessageBody *pObj = (QmMessageBody*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	delete_QmMessageBody(pObj);
	HSFree(pObj);

	return HS_OK;
}





/* QmEnetMessage member functions
*/
QmEnetMessage *newm_QmEnetMessage(
	HS_UCHAR *pRaw,
	int pLen,
	HS_TR_HANDLE pHandle,
	struct sockaddr_in pAddr
)
{
	QmEnetMessage *pObj = NULL;

	if( (pObj=(QmEnetMessage*)HSMalloc(sizeof(QmEnetMessage)))==NULL )
		return NULL;
	if( (pObj->mRaw=(HS_UCHAR*)HSMalloc(pLen+1))==NULL )
	{
		HSFree(pObj);
		return NULL;
	}
	memcpy(pObj->mRaw,pRaw,pLen);
	pObj->mRaw[pLen] = '\0';
	pObj->mLen = pLen;
	pObj->mHandle = pHandle;
	pObj->mAddr = pAddr;
	return pObj;
}


HS_RESULT delete_QmEnetMessage(void *pObject)
{
	QmEnetMessage *pObj = (QmEnetMessage*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mRaw != NULL )
	{
		HSFree(pObj->mRaw);
		pObj->mRaw = NULL;
	}
	pObj->mLen = 0;
	pObj->mHandle = HS_INVALID_HANDLE;
	pObj->mAddr.sin_family = AF_MAX;
	return HS_OK;
}


HS_RESULT deletem_QmEnetMessage(void *pObject)
{
	HS_RESULT tRet;

	HS_TRY( delete_QmEnetMessage(pObject) );
	HSFree(pObject);
	return HS_OK;
}



