/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipMessageMaker.h>		2005-10-20,22:17

*/

#ifndef __2005_10_20__22_17__SIPMESSAGEMAKER_H__
#define __2005_10_20__22_17__SIPMESSAGEMAKER_H__



#include "SipDefine.h"
#include "UaDefine.h"
#include "SipUtility.h"





#define HS_SIP_MSG_CLEAR(ret)		\
	delete_SipMessage(tMessage);	\
	HSFree(tMessage);					\
	return ret





SipMessage *MakeMessage	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);



/* request message
*/
SipMessage *MakeRequest			(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody, BOOL pIsRegisterMessage);
SipMessage *MakeRequestRegister	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeRequestInvite	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeRequestAck		(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeRequestBye		(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeRequestCancel	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeRequestInfo		(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeRequestMESSAGE	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);



/* response message
*/
SipMessage *MakeResponse		(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody);
SipMessage *MakeResponseXxx		(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody, SipResponse pValue);





#endif/*__2005_10_20__22_17__SIPMESSAGEMAKER_H__*/


