/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipDemonHandler.c>		2005-10-31,24:45

*/

#include "SipDemonHandler.h"





HS_RESULT SipDemonEventAddUa(IStack *pStack, IUa *pUa)
{
	if( pUa==NULL ) return HS_ERR_NULL_PARAM;
	if( pStack==NULL )
	{
		delete_IUa(pUa);
		HSFree(pUa);
		return HS_ERR_INVALID_PARAM;
	}

	pUa->mStack = pStack;
	return NoLockList_AttachData(&(pStack->mUas),pUa);
}


HS_RESULT SipDemonEventRegistUa(IStack *pStack, HS_UA_HANDLE pHandle)
{
	IUa *tUa = NULL;
	HS_RESULT tRet = HS_OK;

	if( pStack==NULL ) return HS_ERR_NULL_PARAM;

	if( (tUa=IStack_FindUaByHandle(pStack,pHandle))==NULL )
	{
		if( pStack->CallbackRegisterFail != NULL )
			pStack->CallbackRegisterFail(pHandle);
		return HS_ERR_SIP_NO_EXIST;
	}

	IUa_MakeTag(tUa,((IDialogue*)(tUa->mRegistrar))->mLocalTag);
	IUa_MakeCallId(tUa,((IDialogue*)(tUa->mRegistrar))->mCallId);
	if( (tRet=TrySipRegistration(tUa)) != HS_OK )
	{
		if( pStack->CallbackRegisterFail != NULL )
			pStack->CallbackRegisterFail(pHandle);
	}

	return tRet;
}


HS_RESULT SipDemonEventRemoveUa(IStack *pStack, HS_UA_HANDLE pHandle)
{
	IUa *tUa = NULL;
	HS_RESULT tRet = HS_OK;

	if( pStack==NULL ) return HS_ERR_NULL_PARAM;

	if( (tUa=IStack_FindUaByHandle(pStack,pHandle))==NULL )
		return HS_ERR_SIP_NO_EXIST;

	if( tUa->mIsRegisted==TRUE)
		HSKillTimer(HS_TID_SIP_REGISTER,tUa->mHandle);
	if( tUa->mIsRegisted==FALSE && tUa->mDialogues.size==0 )
		return IStack_DeleteUa(pStack,tUa->mHandle);

	tUa->mState = e_UaState_KillMe;
	if( tUa->mIsRegisted==FALSE ) return HS_OK;

	tRet = TrySipRegistration(tUa);
	tUa->mIsRegisted = FALSE;
	return tRet;
}


HS_RESULT SipDemonEventMakeCall(IStack *pStack, QmMakeCall *pMakeCall)
{
	char tPacket[2048];
	HS_RESULT tRet = HS_OK;

	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	SipContactUnit *tContactUnit = NULL;

	if( pMakeCall==NULL ) return HS_ERR_NULL_PARAM;
	if( pStack==NULL )
	{
		deletem_QmMakeCall(pMakeCall);
		return HS_ERR_INVALID_PARAM;
	}

	/* find ua
	*/
	if( (tUa=IStack_FindUaByHandle(pStack,pMakeCall->mHandle))==NULL )
	{
		deletem_QmMakeCall(pMakeCall);
		return HS_ERR_SIP_NO_EXIST;
	}
	tDialogue = pMakeCall->mDialogue;
	pMakeCall->mDialogue = NULL;
	deletem_QmMakeCall(pMakeCall);
	tDialogue->mUa = tUa;

	/* make target
	*/
	if( tUa->mOutBoundProxy[0]=='\0' )
		strcpy(tDialogue->mTarget,tUa->mOutBoundProxy);
	else
		strcpy(tDialogue->mTarget,tUa->mProxy);
	tDialogue->mTargetPort = tUa->mProxyPort;

	/* make callid
	*/
	IUa_MakeTag(tUa,tDialogue->mLocalTag);
	IUa_MakeCallId(tUa,tDialogue->mCallId);

	/* make sdp
	*/
	if( (tContactUnit=IUa_GetPrimeContactUnit(tUa))==NULL )
	{
		delete_IDialogue(tDialogue);
		HSFree(tDialogue);
		return HS_ERR;
	}

	tDialogue->mSdp.mVersion = SipStringAlloc("0");
	sprintf(tPacket,"%s %s %s IN IP4 %s",
		tContactUnit->mUri.mUserName,
		tDialogue->mSessionId, tDialogue->mSessionId,
		tContactUnit->mUri.mAddress
	);
	tDialogue->mSdp.mOwner = SipStringAlloc(tPacket);
	tDialogue->mSdp.mSessionName = SipStringAlloc("-");
	tDialogue->mSdp.mConnection.mAddr = SipStringAlloc(pStack->mLocalIp);
	tDialogue->mSdp.mConnection.mAddrType = SipStringAlloc("IP4");
	tDialogue->mSdp.mConnection.mNetworkType = SipStringAlloc("IN");

	if( (tRet=SdpMessage_Encode(&(tDialogue->mSdp),tPacket,2000))!=HS_OK )
	{
		delete_IDialogue(tDialogue);
		HSFree(tDialogue);
		return tRet;
	}

	if( (tRet=StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Invite,"application/sdp",tPacket))!=HS_OK )
	{
		delete_IDialogue(tDialogue);
		HSFree(tDialogue);
		return tRet;
	}

	/* dialogue state change
	*/
	tDialogue->mState = e_DialogueState_Invite;

	/* sdp state change
	*/
	tDialogue->mSdpState = SdpState_ChangeSend(tDialogue->mSdpState);

	return NoLockList_AttachData(&(tUa->mDialogues),tDialogue);
}


HS_RESULT SipDemonEventAcceptCall(IStack *pStack, HS_CALL_HANDLE pHandle)
{
	HS_UINT tPos = 0;
	char tPacket[2048];
	HS_RESULT tRet = HS_OK;
	SipMessage *tMessage = NULL;
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	ITransaction *tTransaction = NULL;

	if( pStack==NULL ) return HS_ERR_NULL_PARAM;

	if( (tDialogue=IStack_FindDialogueByHandle(pStack,pHandle))==NULL )
		return HS_ERR_SIP_NO_EXIST;
	if( (tUa=tDialogue->mUa)==NULL )
		return HS_ERR_CONFLICT;
	if( tDialogue->mState != e_DialogueState_ReadyConnect )
		return HS_ERR_CONFLICT;
	if( (tTransaction=IDialogue_FindTransactionByMethod(tDialogue,"INVITE"))==NULL )
		return HS_ERR_SIP_NO_EXIST;

	if( tDialogue->mSdpState==e_SdpState_Received )
	{
		if( MakeSdpAnswer(tDialogue,tPacket,2000) != HS_OK )
			return HS_ERR_SIP_MAKE_MESSAGE;
		if( (tMessage=MakeResponseXxx(pStack,tUa,tDialogue,tTransaction,"application/sdp",tPacket,e_SipResponse_Ok))==NULL )
			return HS_ERR_SIP_MAKE_MESSAGE;
	}
	else
	{
		if( (tMessage=MakeResponseXxx(pStack,tUa,tDialogue,tTransaction,NULL,NULL,e_SipResponse_Ok))==NULL )
			return HS_ERR_SIP_MAKE_MESSAGE;
	}

	/* send response
	*/
	tPos = 0;
	if( (tRet=SendSipMessage(pStack,tUa,tDialogue,tTransaction,tMessage,tPacket,&tPos,2000)) != HS_OK )
	{
		HS_SIP_MSG_CLEAR(tRet);
	}

	tTransaction->mState = e_TransactionState_Terminated;
	HSSetTimer(HS_SIP_TIMER_K,pStack->mSipQ,HS_TID_SIP_TIMER_K,tTransaction->mHandle,e_TimerType_Once);

	if( tDialogue->mSdpState==e_SdpState_Received )
	{
		tDialogue->mSdpState = SdpState_ChangeSend(tDialogue->mSdpState);
		if( tDialogue->mSdpState == e_SdpState_Idle )
			IDialogue_CallbackOpenMedia(tDialogue,pStack);
	}
	tDialogue->mState = e_DialogueState_Connect;
	return HS_OK;
}


HS_RESULT SipDemonEventRemoveCall(IStack *pStack, SipResponse pReason, HS_CALL_HANDLE pHandle)
{
	HS_UINT tPos = 0;
	char tPacket[2048];
	HS_RESULT tRet = HS_OK;
	SipMessage *tMessage = NULL;
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	ITransaction *tTransaction = NULL;

	if( pStack==NULL ) return HS_ERR_NULL_PARAM;

	if( (tDialogue=IStack_FindDialogueByHandle(pStack,pHandle))==NULL )
		return HS_ERR_SIP_NO_EXIST;
	if( (tUa=tDialogue->mUa)==NULL )
		return HS_ERR_CONFLICT;

	/* close media channel
	*/
	IDialogue_CallbackCloseMedia(tDialogue,pStack);
	if( tDialogue->mAudio != NULL )
	{
		delete_MediaInfo(tDialogue->mAudio);
		HSFree(tDialogue->mAudio);
		tDialogue->mAudio = NULL;
	}
	if( tDialogue->mVideo != NULL )
	{
		delete_MediaInfo(tDialogue->mVideo);
		HSFree(tDialogue->mVideo);
		tDialogue->mVideo = NULL;
	}

	switch(tDialogue->mState)
	{
		case e_DialogueState_Idle:
			tDialogue->mState = e_DialogueState_KillMe;
			if( tDialogue->mTransactions.size==0 )
			{
				IUa_DeleteDialogue(tDialogue->mUa,tDialogue->mHandle);
				if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
					IStack_DeleteUa(pStack,tUa->mHandle);
			}
			return HS_OK;

		case e_DialogueState_Invite:
			tDialogue->mState = e_DialogueState_KillMe;
			return StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Cancel,NULL,NULL);

		case e_DialogueState_ReadyConnect:
			if( (tTransaction=IDialogue_FindTransactionByMethod(tDialogue,"INVITE"))==NULL )
				return HS_ERR_SIP_NO_EXIST;
			if( (tMessage=MakeResponseXxx(pStack,tUa,tDialogue,tTransaction,NULL,NULL,pReason))==NULL )
				return HS_ERR_SIP_MAKE_MESSAGE;

			tPos = 0;
			if( (tRet=SendSipMessage(pStack,tUa,tDialogue,tTransaction,tMessage,tPacket,&tPos,2000)) != HS_OK )
			{
				HS_SIP_MSG_CLEAR(tRet);
			}

			tTransaction->mState = e_TransactionState_Completed;
			tTransaction->mTimer = HS_SIP_TIMER_G;
			HSSetTimer(tTransaction->mTimer,pStack->mSipQ,HS_TID_SIP_TIMER_G,tTransaction->mHandle,e_TimerType_Once);
			HSSetTimer(HS_SIP_TIMER_H,pStack->mSipQ,HS_TID_SIP_TIMER_H,tTransaction->mHandle,e_TimerType_Once);

			IDialogue_StateToKillMe(tDialogue,pStack,tUa,
				(pReason==e_SipResponse_RequestTerminated)?
				e_RemoveReason_Cancel:e_RemoveReason_Reject
			);
			return HS_OK;
			
		case e_DialogueState_Connect:
			tDialogue->mState = e_DialogueState_KillMe;
			return StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Bye,NULL,NULL);

		case e_DialogueState_KillMe:
		case e_DialogueStateMax:
		default:
			return HS_ERR_CONFLICT;
	}

	/* warning protection
	*/
	return HS_ERR;
}


HS_RESULT SipDemonEventSendMessageINFO(IStack *pStack,QmMessageBody* pMBody)
{
	HS_RESULT tRet = HS_OK;
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;

	if( pStack==NULL || pMBody==NULL ) return HS_ERR_NULL_PARAM;

	if( (tDialogue=IStack_FindDialogueByHandle(pStack,pMBody->mHandle))==NULL )
	{
		deletem_QmMessageBody(pMBody);
		return HS_ERR_SIP_NO_EXIST;
	}
	if( (tUa=tDialogue->mUa)==NULL )
	{
		deletem_QmMessageBody(pMBody);
		return HS_ERR_CONFLICT;
	}
	if( tDialogue->mState != e_DialogueState_Connect )
	{
		deletem_QmMessageBody(pMBody);
		return HS_ERR_CONFLICT;
	}

	if( pMBody->mType == NULL )
		tRet = StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Info,"application/dtmf-relay",pMBody->mBody);
	else
		tRet = StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Info,pMBody->mType,pMBody->mBody);

	deletem_QmMessageBody(pMBody);
	return tRet;
}


HS_RESULT SipDemonEventSendMessageMESSAGE(IStack *pStack,QmMessageBody* pMBody)
{
	HS_RESULT tRet = HS_OK;
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;

	if( pStack==NULL || pMBody==NULL ) return HS_ERR_NULL_PARAM;

	if( (tDialogue=IStack_FindDialogueByHandle(pStack,pMBody->mHandle))==NULL )
	{
		deletem_QmMessageBody(pMBody);
		return HS_ERR_SIP_NO_EXIST;
	}
	if( (tUa=tDialogue->mUa)==NULL )
	{
		deletem_QmMessageBody(pMBody);
		return HS_ERR_CONFLICT;
	}
	if( tDialogue->mState != e_DialogueState_Connect )
	{
		deletem_QmMessageBody(pMBody);
		return HS_ERR_CONFLICT;
	}

	if( pMBody->mType == NULL )
		tRet = StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Message,"text/plain",pMBody->mBody);
	else
		tRet = StartNewTransaction(pStack,tUa,tDialogue,e_SipMethod_Message,pMBody->mType,pMBody->mBody);

	deletem_QmMessageBody(pMBody);
	return tRet;
}


HS_RESULT SipDemonEventEnetMessage(IStack *pStack, QmEnetMessage *pMessage)
{
	HS_RESULT tRet = HS_OK;

	if( pMessage==NULL ) return HS_ERR_NULL_PARAM;
	if( pStack==NULL )
	{
		deletem_QmEnetMessage(pMessage);
		return HS_ERR_INVALID_PARAM;
	}

	tRet = HandleSipMessage(pStack,pMessage);
	deletem_QmEnetMessage(pMessage);
	return tRet;
}


HS_RESULT SipDemonEventChangeListenPort(IStack *pStack, HS_USHORT pPort, HS_UINT pType)
{
	if( pStack==NULL ) return HS_ERR_NULL_PARAM;

	_HSThreadSendMessage(pStack->mNetQ,HS_QM_CHANGE_LISTEN_PORT,(WPARAM)pPort,(LPARAM)pType);
	return HS_OK;
}


HS_RESULT SipDemonEventRemoveSocketSet(IStack *pStack, HS_TR_HANDLE pHandle)
{
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	ITransaction *tTransaction = NULL;

	if( pStack==NULL ) return HS_ERR_NULL_PARAM;

	if( (tTransaction=IStack_FindTransactionByHandle(pStack,pHandle))==NULL )
		return HS_ERR_SIP_NO_EXIST;
	if( (tDialogue=tTransaction->mDialogue)==NULL )
		return HS_ERR_CONFLICT;
	if( (tUa=tDialogue->mUa)==NULL )
		return HS_ERR_CONFLICT;

	IDialogue_DeleteTransaction(tDialogue,tTransaction->mHandle);
	if( tDialogue->mState==e_DialogueStateMax && tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
		IStack_DeleteUa(pStack,tUa->mHandle);
	if( tDialogue->mState == e_DialogueState_KillMe && tDialogue->mTransactions.size==0 )
	{
		IUa_DeleteDialogue(tUa,tDialogue->mHandle);
		if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
			IStack_DeleteUa(pStack,tUa->mHandle);
	}

	return HS_OK;
}


HS_RESULT SipDemonEventTimer(IStack *pStack, HSTimerEvent *pEvent)
{
	IUa *tUa = NULL;
	HS_RESULT tRet = HS_ERR_SIP_NO_EXIST;

	if( pEvent==NULL ) return HS_ERR_NULL_PARAM;
	if( pStack==NULL )
	{
		deletem_HSTimerEvent(pEvent);
		return HS_ERR_CONFLICT;
	}

#ifdef HS_DEBUG_SIPDEMON
	HSPrint(":(%u/%u)",pEvent->mTid,pEvent->mSub);
#endif

	if( pEvent->mTid < HS_TID_SIP_TIMER_MAX )
		tRet = HandleSipTimer(pStack,pEvent);
	else if( pEvent->mTid == HS_TID_SIP_REGISTER )
	{
		if( (tUa=IStack_FindUaByHandle(pStack,pEvent->mSub))==NULL )
			tRet = HS_ERR_SIP_NO_EXIST;
		else
		{
			tUa->mIsRegisted = FALSE;
			tRet = StartNewTransaction(pStack,tUa,(IDialogue*)(tUa->mRegistrar),e_SipMethod_Register,NULL,NULL);
		}
	}

	deletem_HSTimerEvent(pEvent);
	return tRet;
}







