/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipDemon.c>	2005-11-01,23:44

*/

#include "SipDemon.h"





/* thread objects
*/
SipDemon *newm_SipDemon(IStack *pStack)
{
	SipDemon *tResult = NULL;

	if( pStack==NULL ) return NULL;

	if( (tResult=(SipDemon*)HSMalloc(sizeof(SipDemon)))==NULL )
		return NULL;

	HS_THREAD_INIT(tResult,"SipDemon");

	tResult->mStack = pStack;
	tResult->mNetQ = HS_INVALID_QID;
	return tResult;
}


HS_RESULT deletem_SipDemon(void *pObject)
{
	SipDemon *pObj = (SipDemon*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	HSFree(pObj);
	return HS_OK;
}





/* SipDemon Main function
*/
HS_RESULT SipDemon_Main(HS_TQ pQ,void *pObject,void *pArg)
{
	HSQmsg tQmsg;
	HS_RESULT tRet = HS_OK;

	IStack *tStack = NULL;
	SipDemon *pObj = (SipDemon*)pObject;

	HSSrand();

	if( pObj==NULL )
		return HSExitThread(pQ,HS_ERR_NULL_PARAM);
	if( (tStack=pObj->mStack)==NULL )
	{
		deletem_SipDemon(pObj);
		return HSExitThread(pQ,HS_ERR_INVALID_PARAM);
	}

	pObj->mActive = TRUE;
	while(pObj->mActive)
	{
		if( HSThreadGetMessage(pQ,&tQmsg,HS_QM,HS_QM_MAX,TRUE)==HS_OK )
		{
			switch(tQmsg.message)
			{
				case HS_QM_STOP:
					pObj->mActive = FALSE;
					break;
				case HS_QM_CHECK:
					HSPrint("\n%s alive.",pObj->mName);
					break;
				case HS_QM_ADD_UA:
					HSPrint( "\n[+] SIP->ADD_UA" );
					tRet=SipDemonEventAddUa(tStack,(IUa*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_REGIST_UA:
					HSPrint( "\n[+] SIP->REGIST_UA" );
					tRet=SipDemonEventRegistUa(tStack,(HS_UA_HANDLE)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_REMOVE_UA:
					HSPrint( "\n[+] SIP->REMOVE_UA" );
					tRet=SipDemonEventRemoveUa(tStack,(HS_UA_HANDLE)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_MAKE_CALL:
					HSPrint( "\n[+] SIP->MAKE_CALL" );
					tRet=SipDemonEventMakeCall(tStack,(QmMakeCall*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_ACCEPT_CALL:
					HSPrint( "\n[+] SIP->ACCEPT_CALL" );
					tRet=SipDemonEventAcceptCall(tStack,(HS_CALL_HANDLE)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_REMOVE_CALL:
					HSPrint( "\n[+] SIP->REMOVE_CALL" );
					tRet=SipDemonEventRemoveCall(tStack,(SipResponse)(tQmsg.wParam),(HS_CALL_HANDLE)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				/* not implemented yet
				case HS_QM_REMODEL_CALL:
					HSPrint( "\n[+] SIP->REMODEL_CALL" );
					tRet=SipDemonEventRemodelCall(tStack,(QmMakeCall*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				*/
				case HS_QM_SEND_MESSAGE_INFO:
					HSPrint( "\n[+] SIP->MESSAGE_INFO" );
					tRet=SipDemonEventSendMessageINFO(tStack,(QmMessageBody*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_SEND_MESSAGE_MESSAGE:
					HSPrint( "\n[+] SIP->MESSAGE_MESSAGE" );
					tRet=SipDemonEventSendMessageMESSAGE(tStack,(QmMessageBody*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_ENET_MESSAGE:
					HSPrint( "\n[+] SIP->ENET_MESSAGE" );
					tRet=SipDemonEventEnetMessage(tStack,(QmEnetMessage*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_CHANGE_LISTEN_PORT:
					HSPrint( "\n[+] SIP->CHANGE_LISTEN_PORT" );
					tRet=SipDemonEventChangeListenPort(tStack,(HS_USHORT)(tQmsg.wParam),(HS_UINT)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_REMOVE_SOCKET_SET:
					HSPrint( "\n[+] SIP->REMOVE_SOCKET_SET" );
					tRet=SipDemonEventRemoveSocketSet(tStack,(HS_TR_HANDLE)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
				case HS_QM_TIMER:
					HSPrint( "\n[+] SIP->TIMER" );
					tRet=SipDemonEventTimer(tStack,(HSTimerEvent*)(tQmsg.lParam));
					HSPrint( "\n[-] SIP:%u", tRet );
					break;
			}
		}
	}

	delete_IStack(pObj->mStack);
	HSFree(pObj->mStack);
	pObj->mStack = NULL;
	deletem_SipDemon(pObj);
	return HSExitThread(pQ,HS_OK);
}




