/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ITransaction.c>	2005-10-17,21:22

*/

#include "ITransaction.h"





HS_RESULT new_ITransaction(
	void *pObject,
	IDialogue *pDialogue,
	BOOL pIsInvite,
	BOOL pIsClient,
	BOOL pIsTcp,
	HS_UINT pCseq
)
{
	ITransaction *pObj = (ITransaction*)pObject;

	if( pObj==NULL || pDialogue==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mBranchId = NULL;
	pObj->mCseq = pCseq;
	pObj->mMethod = NULL;
	pObj->mIsInvite = pIsInvite;
	pObj->mIsClient = pIsClient;
	pObj->mIsTcp = pIsTcp;
	new_NoLockList(&(pObj->mVias),delete_SipVia);
	new_NoLockList(&(pObj->mRoutes),delete_SipRoute);

	pObj->mIsNewPeerTag = FALSE;
	memset(pObj->mLocalTag,0,MAX_NAME_SIZE);
	memset(pObj->mRemoteTag,0,MAX_NAME_SIZE);

	pObj->mState = e_TransactionStateMax;
	pObj->mTimer = 0;
	pObj->mLingerMessage = NULL;
	pObj->mLingerLen = 0;

	/* ! NOTE : DON'T remove on ITransaction level
	*/pObj->mDialogue = pDialogue;
	NoLockList_AttachData(&(pDialogue->mTransactions),pObj);

	pObj->mHandle = HS_INVALID_HANDLE;
	return HS_OK;
}


HS_RESULT delete_ITransaction(void *pObject)
{
	ITransaction *pObj = (ITransaction*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mBranchId != NULL )
	{
		HSFree(pObj->mBranchId);
		pObj->mBranchId = NULL;
	}
	if( pObj->mMethod != NULL )
	{
		HSFree(pObj->mMethod);
		pObj->mMethod = NULL;
	}
	delete_NoLockList(&(pObj->mVias));
	delete_NoLockList(&(pObj->mRoutes));

	if( pObj->mLingerMessage != NULL )
	{
		HSFree(pObj->mLingerMessage);
		pObj->mLingerMessage = NULL;
	}
	pObj->mLingerLen = 0;

	return HS_OK;
}


HS_RESULT ITransaction_MakeLocalVia(void *pObject)
{
	SipVia *tVia = NULL;
	SipContactUnit *tPrimeUnit = NULL;
	SipContactUnit *tContactUnit = NULL;

	IStack *tStack = NULL;
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	ITransaction *pObj = (ITransaction*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mDialogue==NULL ) return HS_ERR;
	tDialogue = pObj->mDialogue;
	if( tDialogue->mUa==NULL ) return HS_ERR;
	tUa = tDialogue->mUa;
	if( tUa->mStack==NULL ) return HS_ERR;
	tStack = tUa->mStack;

	if( (tPrimeUnit=IUa_GetPrimeContactUnit(tUa))==NULL )
		return HS_ERR_SIP_NO_EXIST;
	if( (tContactUnit=(SipContactUnit*)HSMalloc(sizeof(SipContactUnit))) == NULL )
		return HS_ERR_MALLOC;
	new_SipContactUnit(tContactUnit,TRUE);

	if( (tVia=(SipVia*)HSMalloc(sizeof(SipVia))) == NULL )
	{
		delete_SipContactUnit(tContactUnit);
		HSFree(tContactUnit);
		return HS_ERR_MALLOC;
	}
	new_SipVia(tVia);

	tContactUnit->mUri.mVersion = SipStringAlloc(tStack->mVersion);
	tContactUnit->mUri.mProtocol = SipStringAlloc( (pObj->mIsTcp)? "TCP":"UDP" );
	tContactUnit->mUri.mAddress = SipStringAlloc(tPrimeUnit->mUri.mAddress);
	if( tPrimeUnit->mUri.mPort != NULL )
		tContactUnit->mUri.mPort = SipStringAlloc(tPrimeUnit->mUri.mPort);
	tContactUnit->mUri.mBranch = SipStringAlloc(pObj->mBranchId);

	NoLockList_AttachData(&(tVia->mContactUnits),tContactUnit);
	NoLockList_AttachData(&(pObj->mVias),tVia);
	return HS_OK;
}


SipContactUnit *ITransaction_GetPrimeContactUnit(void *pObject)
{
	ChainUnit *tChain = NULL;
	SipVia *tVia= NULL;
	SipContactUnit *tContactUnit = NULL;

	ITransaction *pObj = (ITransaction*)pObject;

	if( pObj==NULL ) return NULL;

	if( (tChain=(ChainUnit*)(pObj->mVias.units)) == NULL ) return NULL;
	if( (tVia=(SipVia*)(tChain->data)) == NULL ) return NULL;
	if( (tChain=(ChainUnit*)(tVia->mContactUnits.units)) == NULL ) return NULL;

	return (SipContactUnit*)(tChain->data);
}


HS_RESULT ITransaction_SetLinger(void *pObject,char *pLinger,HS_UINT pLen)
{
	ITransaction *pObj = (ITransaction*)pObject;

	if( pObj==NULL || pLinger==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mLingerMessage != NULL )
	{
		HSFree(pObj->mLingerMessage);
		pObj->mLingerMessage = NULL;
	}
	pObj->mLingerLen = 0;

	if( (pObj->mLingerMessage=(char*)HSMalloc(pLen+1))==NULL )
		return HS_ERR_MALLOC;

	memcpy(pObj->mLingerMessage,pLinger,pLen);
	pObj->mLingerLen = pLen;
	return HS_OK;
}

