/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipHeader.c>	2005-10-13,23:01

*/

#ifdef _WIN32_WCE
#include <winbase.h>
#else
#include <time.h>
#endif

#include "SipHeader.h"





#define HS_SAME_FUNCTION(tOld,tNew,tBig,tCompact)									\
tNew *newm_##tNew()																	\
{																					\
	tNew *pObj = NULL;																\
																					\
	if( (pObj=(tNew*)HSMalloc(sizeof(tNew)))==NULL ) return NULL;						\
	if( new_##tNew(pObj) != HS_OK )													\
	{																				\
		HSFree(pObj);																	\
		return NULL;																\
	}																				\
	return pObj;																	\
}																					\
HS_RESULT new_##tNew(void *pObject)													\
{																					\
	HS_RESULT tRet;																	\
	tNew *pObj = (tNew*)pObject;													\
																					\
	if( (tRet=new_##tOld(pObject)) == HS_OK )										\
	{																				\
		strcpy(pObj->mHeaderName,HS_##tBig##_HEADER);								\
		pObj->mCompactHeader = (char)tCompact;										\
	}																				\
																					\
	return tRet;																	\
}																					\
HS_RESULT delete_##tNew(void *pObject)												\
{return delete_##tOld(pObject);}													\
HS_RESULT tNew##_Encode(void *pObject, char *pData, HS_UINT pMax)					\
{return tOld##_Encode(pObject,pData,pMax);}											\
HS_RESULT tNew##_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)	\
{return tOld##_EncodeEx(pObject,pData,pPos,pMax);}									\
HS_RESULT tNew##_Decode(void *pObject, char *pData, HS_UINT pMax)					\
{return tOld##_Decode(pObject,pData,pMax);}											\
HS_RESULT tNew##_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)	\
{return tOld##_DecodeEx(pObject,pData,pPos,pMax);}


#define HS_SAME_FUNCTION_EX(tOld,tNew,tBig,tCompact)								\
tNew *newm_##tNew()																	\
{																					\
	tNew *pObj = NULL;																\
																					\
	if( (pObj=(tNew*)HSMalloc(sizeof(tNew)))==NULL ) return NULL;						\
	if( new_##tNew(pObj) != HS_OK )													\
	{																				\
		HSFree(pObj);																	\
		return NULL;																\
	}																				\
	return pObj;																	\
}																					\
HS_RESULT new_##tNew(void *pObject)													\
{																					\
	HS_RESULT tRet;																	\
	tNew *pObj = (tNew*)pObject;													\
																					\
	if( (tRet=new_##tOld(pObject)) == HS_OK )										\
	{																				\
		strcpy(pObj->mHeaderName,HS_##tBig##_HEADER);								\
		pObj->mCompactHeader = (char)tCompact;										\
	}																				\
																					\
	return tRet;																	\
}																					\
HS_RESULT delete_##tNew(void *pObject)												\
{return delete_##tOld(pObject);}													\
HS_RESULT tNew##_Encode(void *pObject, char *pData, HS_UINT pMax, BOOL pIsRequest)	\
{return tOld##_Encode(pObject,pData,pMax,pIsRequest);}								\
HS_RESULT tNew##_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax, BOOL pIsRequest)	\
{return tOld##_EncodeEx(pObject,pData,pPos,pMax,pIsRequest);}						\
HS_RESULT tNew##_Decode(void *pObject, char *pData, HS_UINT pMax)					\
{return tOld##_Decode(pObject,pData,pMax);}											\
HS_RESULT tNew##_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)	\
{return tOld##_DecodeEx(pObject,pData,pPos,pMax);}


#define HS_HEADER_CHECK																\
if( (pMax-tPos)>strlen(pObj->mHeaderName) &&										\
    !memcmp(pData+tPos,pObj->mHeaderName,strlen(pObj->mHeaderName)) )				\
	tPos += strlen(pObj->mHeaderName);												\
else if( pObj->mCompactHeader != (char)HS_UCHAR_MAX )								\
{																					\
	if( pData[tPos] == pObj->mCompactHeader )										\
		tPos++;																		\
	else																			\
		return HS_ERR_SIP_HEADER;													\
}																					\
else																				\
	return HS_ERR_SIP_HEADER;


#define HS_FIRST_CLAUSE																\
if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,':')) == HS_INVALID_POS )			\
	return HS_ERR_SIP_END_OF_LINE;													\
tPos += (tTokenPos+1);																\
while( pData[tPos]==' ' || pData[tPos]=='\t' ) tPos++;


#define HS_SKIP_WSHT	\
while( tPos<pMax && ( pData[tPos]==' ' || pData[tPos]=='\t' ) ) tPos++





/*
 *
 * Utility Functions
 *
 */
int SipRand(int mModulus)
{
	return (rand()%mModulus);
}


char *SipStringAlloc(char *pString)
{
	char *tRet = NULL;

	if( pString==NULL ) return NULL;
	/*if( strlen(pString)==0 ) return NULL;*/
	if( (tRet=(char*)HSMalloc(strlen(pString)+1))==NULL ) return NULL;
	strcpy(tRet,pString);
	return tRet;
}


char *SipStringAllocEx(char *pString, HS_UINT pSize)
{
	char *tRet = NULL;

	if( pString==NULL ) return NULL;
	/*if( pSize==0 ) return NULL;*/
	if( (tRet=(char*)HSMalloc(pSize+1))==NULL ) return NULL;
	memcpy(tRet,pString,pSize);
	tRet[pSize]='\0';
	return tRet;
}


char *SipUintAlloc(HS_UINT pUint)
{
	char tString[32];
	char *tCharp = NULL;

	sprintf(tString,"%u",pUint);
	if( (tCharp=(char*)HSMalloc(strlen(tString)+1)) == NULL )
		return NULL;

	strcpy(tCharp,tString);
	return tCharp;
}


HS_UINT SipFindEndOfLine(char *pData, HS_UINT pPos, HS_UINT pMax)
{
	HS_UINT tRet;

	if( pData==NULL ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( !memcmp(pData+pPos+tRet,HS_SIP_END_OF_LINE,2) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextToken(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( pData[pPos+tRet]==pToken )
			return tRet;
		else if( !memcmp(pData+pPos+tRet,HS_SIP_END_OF_LINE,2) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextToken2(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken1, char pToken2)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( pData[pPos+tRet]==pToken1 || pData[pPos+tRet]==pToken2 )
			return tRet;
		else if( !memcmp(pData+pPos+tRet,HS_SIP_END_OF_LINE,2) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextToken3(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken1, char pToken2, char pToken3)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( pData[pPos+tRet]==pToken1 || pData[pPos+tRet]==pToken2 || pData[pPos+tRet]==pToken3 )
			return tRet;
		else if( !memcmp(pData+pPos+tRet,HS_SIP_END_OF_LINE,2) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextToken4(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken1, char pToken2, char pToken3, char pToken4)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( pData[pPos+tRet]==pToken1 || pData[pPos+tRet]==pToken2 || pData[pPos+tRet]==pToken3 || pData[pPos+tRet]==pToken4 )
			return tRet;
		else if( !memcmp(pData+pPos+tRet,HS_SIP_END_OF_LINE,2) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextTokenEx(char *pData, HS_UINT pPos, HS_UINT pMax, char *pToken)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( !memcmp(pData+pPos+tRet,pToken,strlen(pToken)) )
			return tRet;
		else if( !memcmp(pData+pPos+tRet,HS_SIP_END_OF_LINE,2) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextTokenOnly(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( pData[pPos+tRet]==pToken )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindNextTokenOnlyEx(char *pData, HS_UINT pPos, HS_UINT pMax, char *pToken)
{
	HS_UINT tRet;

	if( pData==NULL || pPos>pMax ) return HS_INVALID_POS;

	for( tRet=0; tRet<(pMax-pPos); tRet++ )
	{
		if( !memcmp(pData+pPos+tRet,pToken,strlen(pToken)) )
			return tRet;
	}
	return HS_INVALID_POS;
}


HS_UINT SipFindEndOfClause(char *pData, HS_UINT pPos, HS_UINT pMax)
{
	HS_UINT tRet;

	if( pData==NULL ) return HS_INVALID_POS;

	for( tRet=0; (pPos+tRet)<pMax; tRet++ )
	{
		if( pData[pPos-tRet] == '\r' ) return tRet;
		if( pData[pPos-tRet] == ' ' ) return tRet;
	}

	return HS_INVALID_POS;
}


HS_UINT SipFindStartOfClause(char *pData, HS_UINT pPos, HS_UINT pMax)
{
	HS_UINT tRet;

	if( pData==NULL ) return HS_INVALID_POS;

	for( tRet=0; (pPos-tRet)>0; tRet++ )
	{
		if( pData[pPos-tRet] == '\n' ) return HS_INVALID_POS;
		if( pData[pPos-tRet] == ' ' ) return tRet;
	}

	return HS_INVALID_POS;
}





/*
 *
 * SIP Message Structures
 *
 */
/* SipUri member functions
*/
HS_RESULT new_SipUri(void *pObject)
{
	SipUri *pObj = (SipUri*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mVersion = NULL;
	pObj->mTransactionType = NULL;
	pObj->mProtocol = NULL;
	pObj->mUserName = NULL;
	pObj->mAddress = NULL;
	pObj->mBranch = NULL;
	pObj->mReceived = NULL;
	pObj->mTtl = NULL;
	pObj->mMaddr = NULL;
	pObj->mSubject = NULL;
	pObj->mPort = NULL;
	pObj->mLooseRoute = FALSE;

	pObj->mIsVia = FALSE;
	return HS_OK;
}


HS_RESULT delete_SipUri(void *pObject)
{
	SipUri *pObj = (SipUri*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mVersion != NULL )	{	HSFree(pObj->mVersion);	pObj->mVersion=NULL;	}
	if( pObj->mTransactionType != NULL ) {	HSFree(pObj->mTransactionType);	pObj->mTransactionType=NULL;	}
	if( pObj->mProtocol != NULL )	{	HSFree(pObj->mProtocol);	pObj->mProtocol=NULL;	}
	if( pObj->mUserName != NULL )	{	HSFree(pObj->mUserName);	pObj->mUserName=NULL;	}
	if( pObj->mAddress != NULL )	{	HSFree(pObj->mAddress);	pObj->mAddress=NULL;	}
	if( pObj->mBranch != NULL )		{	HSFree(pObj->mBranch);	pObj->mBranch=NULL;		}
	if( pObj->mReceived != NULL )	{	HSFree(pObj->mReceived);	pObj->mReceived=NULL;	}
	if( pObj->mTtl != NULL )		{	HSFree(pObj->mTtl);		pObj->mTtl=NULL;		}
	if( pObj->mMaddr != NULL )		{	HSFree(pObj->mMaddr);		pObj->mMaddr=NULL;		}
	if( pObj->mSubject != NULL )	{	HSFree(pObj->mSubject);	pObj->mSubject=NULL;	}
	if( pObj->mPort != NULL )		{	HSFree(pObj->mPort);		pObj->mPort=NULL;		}
	pObj->mLooseRoute = FALSE;

	return HS_OK;
}





/* SipHeadLine member functions
*/
HS_RESULT new_SipHeadLine(void *pObject, SipResponse pResponseValue)
{
	SipHeadLine *pObj = (SipHeadLine*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mResponseValue = pResponseValue;
	pObj->mMethod = NULL;
	new_SipUri(&(pObj->mUri));
	pObj->mUri.mIsVia = TRUE;

	return HS_OK;
}


HS_RESULT delete_SipHeadLine(void *pObject)
{
	SipHeadLine *pObj = (SipHeadLine*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mMethod != NULL) HSFree(pObj->mMethod);
	delete_SipUri(&(pObj->mUri));

	return HS_OK;
}


HS_RESULT SipHeadLine_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipHeadLine_EncodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipHeadLine_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipHeadLine *pObj = (SipHeadLine*)pObject;
	HS_UINT tPos = *pPos;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMethod==NULL ) return HS_ERR_INVALID_PARAM;

	if( pObj->mResponseValue > e_SipResponse_Request )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mMethod)+14,pMax);
		sprintf(pData+tPos,"SIP/%s %u %s\r\n",pObj->mUri.mVersion,(HS_UINT)(pObj->mResponseValue),pObj->mMethod);
		tPos += (strlen(pObj->mMethod)+14);

		*pPos = tPos;
		return HS_OK;
	}

	if( pObj->mUri.mProtocol==NULL || pObj->mUri.mAddress==NULL )
		return HS_ERR_INVALID_PARAM;

	HS_CHECK_OVER(tPos,strlen(pObj->mMethod)+strlen(pObj->mUri.mProtocol)+2,pMax);
	sprintf(pData+tPos,"%s %s:",pObj->mMethod,pObj->mUri.mProtocol);
	tPos += (strlen(pObj->mMethod)+strlen(pObj->mUri.mProtocol)+2);

	if( pObj->mUri.mUserName != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mUserName)+1,pMax);
		sprintf(pData+tPos,"%s@",pObj->mUri.mUserName);
		tPos += (strlen(pObj->mUri.mUserName)+1);
	}

	HS_CHECK_OVER(tPos,strlen(pObj->mUri.mAddress),pMax);
	sprintf(pData+tPos,"%s",pObj->mUri.mAddress);
	tPos += strlen(pObj->mUri.mAddress);

	if( pObj->mUri.mPort != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mPort)+1,pMax);
		sprintf(pData+tPos,":%s",pObj->mUri.mPort);
		tPos += (strlen(pObj->mUri.mPort)+1);
	}

	HS_CHECK_OVER(tPos,10,pMax);
	sprintf(pData+tPos," SIP/%s\r\n",pObj->mUri.mVersion);
	tPos += 10;

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipHeadLine_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipHeadLine_DecodeEx(pObject,pData,&tPos,pMax);
}

HS_RESULT SipHeadLine_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipHeadLine *pObj = (SipHeadLine*)pObject;
	char tString[16];
	HS_UINT tPos = *pPos;
	HS_UINT tEndPos = 0;
	HS_UINT tTokenPos = 0;
	BOOL tIsResponse = FALSE;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;

	/* data clear
	*/
	if( pObj->mMethod != NULL ){	HSFree(pObj->mMethod);	pObj->mMethod=NULL;		}
	if( pObj->mUri.mProtocol != NULL ){	HSFree(pObj->mUri.mProtocol);	pObj->mUri.mProtocol=NULL;	}
	if( pObj->mUri.mUserName != NULL ){	HSFree(pObj->mUri.mUserName);	pObj->mUri.mUserName=NULL;	}
	if( pObj->mUri.mAddress != NULL ){	HSFree(pObj->mUri.mAddress);	pObj->mUri.mAddress=NULL;	}
	if( pObj->mUri.mPort != NULL ){	HSFree(pObj->mUri.mPort);	pObj->mUri.mPort=NULL;	}
	if( pObj->mUri.mVersion != NULL ){	HSFree(pObj->mUri.mVersion);	pObj->mUri.mVersion=NULL;	}
	if( pObj->mUri.mTransactionType != NULL ){	HSFree(pObj->mUri.mTransactionType);	pObj->mUri.mTransactionType=NULL;	}
	pObj->mResponseValue = e_SipResponseMax;

	HS_CHECK_OVER(tPos,3,pMax);
	if( !memcmp(pData+tPos,"SIP",3) )
	{
		tPos += 3;
		if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,pMax,'/')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		tPos += (tTokenPos+1);
		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;

		/* get version and transfer type
		*/
		if( (tEndPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;

		if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,tPos+tEndPos,'/')) == HS_INVALID_POS )
		{
			/* "SIP/2.0" form
			*/
			if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mUri.mVersion=(char*)HSMalloc(tTokenPos+1))==NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mVersion,pData+tPos,tTokenPos);
			pObj->mUri.mVersion[tTokenPos] = '\0';
			tPos += tTokenPos;
			while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
		}
		else
		{
			/* "SIP/2.0/UDP" form
			*/
			if( (pObj->mUri.mVersion=(char*)HSMalloc(tTokenPos+1))==NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mVersion,pData+tPos,tTokenPos);
			pObj->mUri.mVersion[tTokenPos] = '\0';
			tPos += (tTokenPos+1);

			while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
			if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mUri.mTransactionType=(char*)HSMalloc(tTokenPos+1))==NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mTransactionType,pData+tPos,tTokenPos);
			pObj->mUri.mTransactionType[tTokenPos] = '\0';
			tPos += tTokenPos;
			while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
		}

		/* get response number
		*/
		if( !memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) || tPos>=pMax ) return HS_ERR_SIP_END_OF_LINE;
		if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( tTokenPos!=3 ) return HS_ERR_SIP_NOT_SUPPORT;
		HS_CHECK_OVER(tPos,tTokenPos,pMax);
		memcpy(tString,pData+tPos,tTokenPos);
		tString[tTokenPos] = '\0';
		pObj->mResponseValue = (SipResponse)atoi(tString);

		tPos += tTokenPos;
		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;

		/* get response name
		*/
		if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax)) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( tTokenPos==0 )
			return HS_ERR_SIP_NO_EXIST;
		if( (pObj->mMethod=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mMethod,pData+tPos,tTokenPos);
		pObj->mMethod[tTokenPos] = '\0';
		tPos += (tTokenPos+2);

		*pPos=tPos;
		return HS_OK;
	}

	/* get request method
	*/
	pObj->mResponseValue = e_SipResponse_Request;
	if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t'))==HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	if( (pObj->mMethod=(char*)HSMalloc(tTokenPos+1))==NULL )
		return HS_ERR_MALLOC;
	memcpy(pObj->mMethod,pData+tPos,tTokenPos);
	pObj->mMethod[tTokenPos] = '\0';

	tPos += tTokenPos;
	HS_SKIP_WSHT;
	if( !memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) ) return HS_ERR_SIP_END_OF_LINE;

	/* get uri protocol name
	*/
	if( pData[tPos]=='<' )
	{
		tPos++;
		if( SipFindNextTokenOnly(pData,tPos,pMax,'>') == HS_INVALID_POS )
			return HS_ERR_SIP_PAIR;
		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
	}
	if( (tTokenPos=SipFindNextToken3(pData,tPos,pMax,' ','\t',':')) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	if( (pObj->mUri.mProtocol=(char*)HSMalloc(tTokenPos+1))==NULL )
		return HS_ERR_MALLOC;
	memcpy(pObj->mUri.mProtocol,pData+tPos,tTokenPos);
	pObj->mUri.mProtocol[tTokenPos] = '\0';
	tPos += tTokenPos;
	while( tPos<pMax && ( pData[tPos]==' ' || pData[tPos]=='\t' || pData[tPos]==':' ) ) tPos++;

	/* find end of uri
	*/
	if( (tEndPos=SipFindNextToken4(pData,tPos,pMax,'?',' ','>',';')) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	else
		tEndPos += tPos;
	/* get user name
	*/
	if( (tTokenPos=SipFindNextToken(pData,tPos,tEndPos,'@')) != HS_INVALID_POS )
	{
		if( (pObj->mUri.mUserName=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mUserName,pData+tPos,tTokenPos);
		pObj->mUri.mUserName[tTokenPos] = '\0';
		tPos += (tTokenPos+1);
	}
	/* get address
	*/
	if( (tTokenPos=SipFindNextToken(pData,tPos,tEndPos,':')) == HS_INVALID_POS )
		tTokenPos = tEndPos-tPos;
	if( (pObj->mUri.mAddress=(char*)HSMalloc(tTokenPos+1))==NULL )
		return HS_ERR_MALLOC;
	memcpy(pObj->mUri.mAddress,pData+tPos,tTokenPos);
	pObj->mUri.mAddress[tTokenPos] = '\0';
	tPos += tTokenPos;
	/* get tsap port
	*/
	if( (tPos+1)<tEndPos )
	{
		tPos++;
		if( (pObj->mUri.mPort=(char*)HSMalloc(tEndPos-tPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mPort,pData+tPos,tEndPos-tPos);
		pObj->mUri.mPort[tEndPos-tPos] = '\0';
	}

	tPos = tEndPos+1;
	HS_SKIP_WSHT;
	if( !memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) ) return HS_ERR_SIP_END_OF_LINE;

	/* get "SIP/2.0/UDP" datas
	*/
	if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,pMax,'/')) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	tPos += (tTokenPos+1);
	while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;

	/* get version and transfer type
	*/
	if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,pMax,'/')) == HS_INVALID_POS )
	{
		/* "SIP/2.0" form
		*/
		if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (pObj->mUri.mVersion=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mVersion,pData+tPos,tTokenPos);
		pObj->mUri.mVersion[tTokenPos] = '\0';
		tPos += tTokenPos;
		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
	}
	else
	{
		/* "SIP/2.0/UDP" form
		*/
		if( (pObj->mUri.mVersion=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mVersion,pData+tPos,tTokenPos);
		pObj->mUri.mVersion[tTokenPos] = '\0';
		tPos += (tTokenPos+1);

		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
		if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (pObj->mUri.mTransactionType=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mTransactionType,pData+tPos,tTokenPos);
		pObj->mUri.mTransactionType[tTokenPos] = '\0';
		tPos += tTokenPos;
		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
	}

	if( memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) )
		return HS_ERR_SIP_END_OF_LINE;
	tPos += 2;

	*pPos = tPos;
	return HS_OK;
}





/* SipHeader member functions
*/
SipHeader *newm_SipHeader()
{
	SipHeader *pObj = NULL;

	if( (pObj=(SipHeader*)HSMalloc(sizeof(SipHeader)))==NULL ) return NULL;
	if( new_SipHeader(pObj) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipHeader(void *pObject)
{
	SipHeader *pObj = (SipHeader*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	strcpy(pObj->mHeaderName,"Header");
	pObj->mCompactHeader = (char)HS_UCHAR_MAX;
	pObj->mInfo = NULL;
	return HS_OK;
}


HS_RESULT delete_SipHeader(void *pObject)
{
	SipHeader *pObj = (SipHeader*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mInfo != NULL )
	{
		HSFree(pObj->mInfo);
		pObj->mInfo = NULL;
	}
	return HS_OK;
}


HS_RESULT SipHeader_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipHeader_EncodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipHeader_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipHeader *pObj = (SipHeader*)pObject;
	HS_UINT tPos = *pPos;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;
	if( pObj->mInfo == NULL ) return HS_OK;

	HS_CHECK_OVER(tPos,strlen(pObj->mHeaderName),pMax);
	sprintf( pData+tPos,"%s: ",pObj->mHeaderName );
	tPos += (strlen(pObj->mHeaderName)+2);

	HS_CHECK_OVER(tPos,strlen(pObj->mInfo),pMax);
	sprintf(pData+tPos,"%s\r\n",pObj->mInfo);
	tPos += (strlen(pObj->mInfo)+2);

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipHeader_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipHeader_DecodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipHeader_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipHeader *pObj = (SipHeader*)pObject;
	HS_UINT tPos = *pPos;
	HS_UINT tTokenPos=0;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_HEADER_CHECK
	HS_FIRST_CLAUSE

	/* data clear
	*/
	if( pObj->mInfo != NULL )
	{
		HSFree(pObj->mInfo);
		pObj->mInfo = NULL;
	}
	
	/* get the header data
	*/
	if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax)) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	if( (pObj->mInfo=(char*)HSMalloc(tTokenPos+1)) == NULL )
		return HS_ERR_MALLOC;
	memcpy(pObj->mInfo,pData+tPos,tTokenPos);
	pObj->mInfo[tTokenPos] = '\0';
	tPos += (tTokenPos+2);

	*pPos = tPos;
	return HS_OK;
}





/* 20.1 SipAccept member functions
*/
SipAccept *newm_SipAccept()
{
	SipAccept *pObj = NULL;

	if( (pObj=(SipAccept*)HSMalloc(sizeof(SipAccept)))==NULL ) return NULL;
	if( new_SipAccept(pObj) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipAccept(void *pObject)
{
	SipAccept *pObj = (SipAccept*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	strcpy(pObj->mHeaderName,HS_ACCEPT_HEADER);
	pObj->mCompactHeader = (char)HS_UCHAR_MAX;
	new_NoLockList(&(pObj->mList),NULL);
	return HS_OK;
}


HS_RESULT delete_SipAccept(void *pObject)
{
	SipAccept *pObj = (SipAccept*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_NoLockList(&(pObj->mList));
	return HS_OK;
}


HS_RESULT SipAccept_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipAccept_EncodeEx(pObject,pData,&tPos,pMax);
}
HS_RESULT SipAccept_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipAccept *pObj = (SipAccept*)pObject;
	HS_UINT i;
	HS_UINT tPos = *pPos;
	char *tUnit = NULL;
	ChainUnit *rounder = NULL;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_CHECK_OVER(tPos,strlen(pObj->mHeaderName),pMax);
	sprintf( pData+tPos,"%s: ",pObj->mHeaderName );
	tPos += (strlen(pObj->mHeaderName)+2);

	rounder = pObj->mList.units;
	for( i=0; i<pObj->mList.size; i++ )
	{
		if( (tUnit=(char*)(rounder->data)) != NULL )
		{
			HS_CHECK_OVER(tPos,strlen(tUnit)+2,pMax);
			sprintf(pData+tPos,"%s, ",tUnit);
			tPos += (strlen(tUnit)+2);
		}

		rounder = rounder->next;
	}

	if( tPos>2 )
	{
		if( !memcmp(pData+tPos-2,", ",2) )
			tPos -=2;
	}
	HS_CHECK_OVER(tPos,2,pMax);
	strcpy(pData+tPos,HS_SIP_END_OF_LINE);
	tPos += 2;

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipAccept_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipAccept_DecodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipAccept_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipAccept *pObj = (SipAccept*)pObject;
	char *tUnit = NULL;
	HS_UINT tPos = *pPos;
	HS_UINT tTokenPos = 0;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_HEADER_CHECK
	HS_FIRST_CLAUSE

	/* get datas
	*/
	delete_NoLockList(&(pObj->mList));
	while(TRUE)
	{
		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,',')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		while( tTokenPos && ( pData[tPos+tTokenPos-1]==' ' || pData[tPos+tTokenPos-1]=='\t' ) ) tTokenPos--;

		if( tTokenPos > 0 )
		{
			if( (tUnit=(char*)HSMalloc(tTokenPos+1)) == NULL )
				return HS_ERR_MALLOC;
			memcpy(tUnit,pData+tPos,tTokenPos);
			tUnit[tTokenPos] = '\0';
			NoLockList_AttachData(&(pObj->mList),tUnit);

			tPos += tTokenPos;
		}

		while( tPos<pMax && ( pData[tPos]==' ' || pData[tPos]=='\t' || pData[tPos]==',' ) ) tPos++;
		if( !memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) )
		{
			tPos += 2;
			*pPos = tPos;
			return HS_OK;
		}
	}

	/* warning protection
	*/
	return HS_ERR;
}





/* 20.2 SipAcceptEncoding member
*/
HS_SAME_FUNCTION(SipAccept,SipAcceptEncoding,ACCEPT_ENCODING,HS_UCHAR_MAX)


/* 20.3 SipAcceptLanguage member
*/
HS_SAME_FUNCTION(SipAccept,SipAcceptLanguage,ACCEPT_LANGUAGE,HS_UCHAR_MAX)


/* 20.4 SipAlertInfo member
*/
HS_SAME_FUNCTION(SipHeader,SipAlertInfo,ALERT_INFO,HS_UCHAR_MAX)


/* 20.5 SipAllow member functions
*/
HS_SAME_FUNCTION(SipAccept,SipAllow,ALLOW,HS_UCHAR_MAX)


/* 20.6 SipAuthenticationInfo member functions
*/
HS_SAME_FUNCTION(SipHeader,SipAuthenticationInfo,AUTHENTICATION_INFO,HS_UCHAR_MAX)





/* 20.7 SipAuthorization member functions
*/
SipAuthorization *newm_SipAuthorization()
{
	SipAuthorization *pObj = NULL;

	if( (pObj=(SipAuthorization*)HSMalloc(sizeof(SipAuthorization)))==NULL ) return NULL;
	if( new_SipAuthorization(pObj) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipAuthorization(void *pObject)
{
	SipAuthorization *pObj = (SipAuthorization*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	strcpy(pObj->mHeaderName,HS_AUTHORIZATION_HEADER);
	pObj->mCompactHeader = (char)HS_UCHAR_MAX;
	pObj->mType = NULL;
	pObj->mUserName = NULL;
	pObj->mRealm = NULL;
	pObj->mQop = NULL;
	pObj->mNc = NULL;
	pObj->mCnonce = NULL;
	pObj->mNonce = NULL;
	pObj->mOpaque = NULL;
	pObj->mUri = NULL;
	pObj->mResponse = NULL;
	pObj->mStale = NULL;
	pObj->mAlgorithm = NULL;
	return HS_OK;
}


HS_RESULT deletem_SipAuthorization(void *pObject)
{
	if( pObject==NULL ) return HS_ERR_NULL_PARAM;

	delete_SipAuthorization(pObject);
	HSFree(pObject);
	return HS_OK;
}


HS_RESULT delete_SipAuthorization(void *pObject)
{
	SipAuthorization *pObj = (SipAuthorization*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mType != NULL ) HSFree(pObj->mType);
	if( pObj->mUserName != NULL ) HSFree(pObj->mUserName);
	if( pObj->mRealm != NULL ) HSFree(pObj->mRealm);
	if( pObj->mQop != NULL ) HSFree(pObj->mQop);
	if( pObj->mNc != NULL ) HSFree(pObj->mNc);
	if( pObj->mCnonce != NULL ) HSFree(pObj->mCnonce);
	if( pObj->mNonce != NULL ) HSFree(pObj->mNonce);
	if( pObj->mOpaque != NULL ) HSFree(pObj->mOpaque);
	if( pObj->mUri != NULL ) HSFree(pObj->mUri);
	if( pObj->mResponse != NULL ) HSFree(pObj->mResponse);
	if( pObj->mStale!= NULL ) HSFree(pObj->mStale);
	if( pObj->mAlgorithm!= NULL ) HSFree(pObj->mAlgorithm);
	return HS_OK;
}


HS_RESULT SipAuthorization_Encode(void *pObject, char *pData, HS_UINT pMax, BOOL pIsRequest)
{
	HS_UINT tPos=0;
	return SipAuthorization_EncodeEx(pObject,pData,&tPos,pMax,pIsRequest);
}


HS_RESULT SipAuthorization_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax, BOOL pIsRequest)
{
	SipAuthorization *pObj = (SipAuthorization*)pObject;
	HS_UINT tPos = *pPos;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_CHECK_OVER(tPos,strlen(pObj->mHeaderName),pMax);
	sprintf( pData+tPos,"%s: ",pObj->mHeaderName );
	tPos += (strlen(pObj->mHeaderName)+2);

	if(pObj->mType!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mType)+1,pMax);
		sprintf(pData+tPos,"%s ",pObj->mType);
		tPos += (strlen(pObj->mType)+1);
	}
	if(pObj->mUserName!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUserName)+13,pMax);
		sprintf(pData+tPos,"username=\"%s\", ",pObj->mUserName);
		tPos += (strlen(pObj->mUserName)+13);
	}
	if(pObj->mRealm!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mRealm)+10,pMax);
		sprintf(pData+tPos,"realm=\"%s\", ",pObj->mRealm);
		tPos += (strlen(pObj->mRealm)+10);
	}
	if(pObj->mQop!=NULL)
	{
		/* ! NOTE:	'qop' should include quotation marks in response message.
					'qop' should not include quotation marks in request message.
		*/
		if( pIsRequest==TRUE )
		{
			HS_CHECK_OVER(tPos,strlen(pObj->mQop)+6,pMax);
			sprintf(pData+tPos,"qop=%s, ",pObj->mQop);
			tPos += (strlen(pObj->mQop)+6);
		}
		else
		{
			HS_CHECK_OVER(tPos,strlen(pObj->mQop)+8,pMax);
			sprintf(pData+tPos,"qop=\"%s\", ",pObj->mQop);
			tPos += (strlen(pObj->mQop)+8);
		}
	}
	if(pObj->mNc!=NULL)
	{
		/* ! NOTE: 'nc' should include quotation marks.
		*/
		HS_CHECK_OVER(tPos,strlen(pObj->mNc)+5,pMax);
		sprintf(pData+tPos,"nc=%s, ",pObj->mNc);
		tPos += (strlen(pObj->mNc)+5);
	}
	if(pObj->mCnonce!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mCnonce)+11,pMax);
		sprintf(pData+tPos,"cnonce=\"%s\", ",pObj->mCnonce);
		tPos += (strlen(pObj->mCnonce)+11);
	}
	if(pObj->mNonce!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mNonce)+10,pMax);
		sprintf(pData+tPos,"nonce=\"%s\", ",pObj->mNonce);
		tPos += (strlen(pObj->mNonce)+10);
	}
	if(pObj->mOpaque!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mOpaque)+11,pMax);
		sprintf(pData+tPos,"opaque=\"%s\", ",pObj->mOpaque);
		tPos += (strlen(pObj->mOpaque)+11);
	}
	if(pObj->mUri!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri)+8,pMax);
		sprintf(pData+tPos,"uri=\"%s\", ",pObj->mUri);
		tPos += (strlen(pObj->mUri)+8);
	}
	if(pObj->mResponse!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mResponse)+13,pMax);
		sprintf(pData+tPos,"response=\"%s\", ",pObj->mResponse);
		tPos += (strlen(pObj->mResponse)+13);
	}
	if(pObj->mStale!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mStale)+8,pMax);
		sprintf(pData+tPos,"stale=%s, ",pObj->mStale);
		tPos += (strlen(pObj->mStale)+8);
	}
	if(pObj->mAlgorithm!=NULL)
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mAlgorithm)+12,pMax);
		sprintf(pData+tPos,"algorithm=%s, ",pObj->mAlgorithm);
		tPos += (strlen(pObj->mAlgorithm)+12);
	}

	if( !memcmp(pData+tPos-2,", ",2) )
		tPos -= 2;

	strcpy(pData+tPos,HS_SIP_END_OF_LINE);
	tPos += 2;
	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipAuthorization_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipAuthorization_DecodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipAuthorization_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipAuthorization *pObj = (SipAuthorization*)pObject;
	char *tString = NULL;
	HS_UINT tPos = *pPos;
	HS_UINT tTokenPos = 0;
	HS_UINT tEqualPos = 0;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_HEADER_CHECK
	HS_FIRST_CLAUSE

	/* data clear
	*/
	if( pObj->mType != NULL )		{ HSFree(pObj->mType);		pObj->mType=NULL;		}
	if( pObj->mUserName != NULL )	{ HSFree(pObj->mUserName);	pObj->mUserName=NULL;	}
	if( pObj->mRealm != NULL )		{ HSFree(pObj->mRealm);		pObj->mRealm=NULL;		}
	if( pObj->mQop != NULL )		{ HSFree(pObj->mQop);			pObj->mQop=NULL;		}
	if( pObj->mNc != NULL )			{ HSFree(pObj->mNc);			pObj->mNc=NULL;			}
	if( pObj->mCnonce != NULL )		{ HSFree(pObj->mCnonce);		pObj->mCnonce=NULL;		}
	if( pObj->mNonce != NULL )		{ HSFree(pObj->mNonce);		pObj->mNonce=NULL;		}
	if( pObj->mOpaque != NULL )		{ HSFree(pObj->mOpaque);		pObj->mOpaque=NULL;		}
	if( pObj->mUri != NULL )		{ HSFree(pObj->mUri);			pObj->mUri=NULL;		}
	if( pObj->mResponse != NULL )	{ HSFree(pObj->mResponse);	pObj->mResponse=NULL;	}
	if( pObj->mStale != NULL )		{ HSFree(pObj->mStale);		pObj->mStale=NULL;		}
	if( pObj->mAlgorithm != NULL )	{ HSFree(pObj->mAlgorithm);	pObj->mAlgorithm=NULL;	}

	/* get authentication type
	   : may be 'Digest'
	*/
	if( memcmp(pData+tPos,"username",8) && memcmp(pData+tPos,"realm",5) && memcmp(pData+tPos,"qop",3) &&
		memcmp(pData+tPos,"nc",2) && memcmp(pData+tPos,"cnonce",6) &&
		memcmp(pData+tPos,"nonce",5) && memcmp(pData+tPos,"opaque",6) && memcmp(pData+tPos,"uri",3) &&
		memcmp(pData+tPos,"response",8) && memcmp(pData+tPos,"stale",5) && memcmp(pData+tPos,"algorithm",9)
	)
	{
		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' ')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (pObj->mType=(char*)HSMalloc(tTokenPos+1)) == NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mType,pData+tPos,tTokenPos);
		pObj->mType[tTokenPos] = '\0';
		tPos += tTokenPos;
	}

	/* get authentication parameters
	*/
	while(TRUE)
	{
		/* find start of clause
		*/
		while( tPos<pMax && ( pData[tPos]==' ' || pData[tPos]=='\t' || pData[tPos]==',' ) ) tPos++;
		if( !memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) )
		{
			tPos += 2;
			*pPos = tPos;
			return HS_OK;
		}

		/* find end of clause
		*/
		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,',')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		while( tTokenPos && ( pData[tPos+tTokenPos-1]==' ' || pData[tPos+tTokenPos-1]=='\t' ) ) tTokenPos--;
		if( (tString=(char*)HSMalloc(tTokenPos)) == NULL )
			return HS_ERR_MALLOC;

		/* find parameters
		*/
		if( !memcmp(pData+tPos,"username",8) )
		{
			if( pObj->mUserName != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUserName = tString;
		}
		else if	( !memcmp(pData+tPos,"realm",5) )
		{
			if(pObj->mRealm != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mRealm = tString;
		}
		else if	( !memcmp(pData+tPos,"qop",3) )
		{
			if(pObj->mQop != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mQop = tString;
		}
		else if	( !memcmp(pData+tPos,"nc",2) )
		{
			if(pObj->mNc != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mNc = tString;
		}
		else if	( !memcmp(pData+tPos,"cnonce",6) )
		{
			if(pObj->mCnonce != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mCnonce = tString;
		}
		else if	( !memcmp(pData+tPos,"nonce",5) )
		{
			if(pObj->mNonce != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mNonce = tString;
		}
		else if	( !memcmp(pData+tPos,"opaque",6) )
		{
			if(pObj->mOpaque != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mOpaque = tString;
		}
		else if	( !memcmp(pData+tPos,"uri",3) )
		{
			if(pObj->mUri != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUri = tString;
		}
		else if	( !memcmp(pData+tPos,"response",8) )
		{
			if(pObj->mResponse != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mResponse = tString;
		}
		else if	( !memcmp(pData+tPos,"stale",5) )
		{
			if(pObj->mStale != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mStale = tString;
		}
		else if	( !memcmp(pData+tPos,"algorithm",9) )
		{
			if(pObj->mAlgorithm != NULL)
				return HS_ERR_SIP_DUPLICATE;
			pObj->mAlgorithm = tString;
		}
		else
		{	/* unknown parameter
			*/
			HSFree(tString);
			tString = NULL;
			tPos += tTokenPos;
			continue;
		}

		/* find start of data
		*/
		tTokenPos += tPos;
		if( (tEqualPos=SipFindNextTokenOnly(pData,tPos,pMax,'=')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		tPos += (tEqualPos+1);
		while( tPos<pMax && ( pData[tPos]==' ' || pData[tPos]=='\t' ) ) tPos++;

		if( tPos>tTokenPos )
			return HS_ERR_SIP;

		if( pData[tPos]=='\"' )
		{
			if( pData[tTokenPos-1] != '\"' )
				return HS_ERR_SIP_PAIR;
			memcpy(tString,pData+tPos+1,tTokenPos-tPos-2);
			tString[tTokenPos-tPos-2] = '\0';
		}
		else
		{
			memcpy(tString,pData+tPos,tTokenPos-tPos);
			tString[tTokenPos-tPos] = '\0';
		}
		tPos = tTokenPos;
	}

	/* warning protection
	*/
	return HS_ERR;
}





/* 20.8 SipCallId member functions
*/
HS_SAME_FUNCTION(SipHeader,SipCallId,CALL_ID,'i')


/* 20.9 SipCallInfo member functions
*/
HS_SAME_FUNCTION(SipHeader,SipCallInfo,CALL_INFO,HS_UCHAR_MAX)





/* 20.10 SipContact member functions
*/
SipContactUnit *newm_SipContactUnit(BOOL pIsVia)
{
	SipContactUnit *pObj = NULL;

	if( (pObj=(SipContactUnit*)HSMalloc(sizeof(SipContactUnit)))==NULL ) return NULL;
	if( new_SipContactUnit(pObj,pIsVia) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipContactUnit(void *pObject, BOOL pIsVia)
{
	SipContactUnit *pObj = (SipContactUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mDisplayName = NULL;
	new_SipUri(&(pObj->mUri));
	pObj->mUri.mIsVia = pIsVia;
	pObj->mTag = NULL;
	pObj->mQ = NULL;
	pObj->mExpire = NULL;
	return HS_OK;
}


HS_RESULT delete_SipContactUnit(void *pObject)
{
	SipContactUnit *pObj = (SipContactUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mDisplayName != NULL )
	{
		HSFree(pObj->mDisplayName);
		pObj->mDisplayName = NULL;
	}
	delete_SipUri(&(pObj->mUri));
	if( pObj->mTag != NULL )
	{
		HSFree(pObj->mTag);
		pObj->mTag = NULL;
	}
	if( pObj->mQ != NULL )
	{
		HSFree(pObj->mQ);
		pObj->mQ = NULL;
	}
	pObj->mExpire = NULL;
	return HS_OK;
}


HS_RESULT SipContactUnit_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	char tString[64];
	SipContactUnit *pObj = (SipContactUnit*)pObject;
	HS_UINT tPos = *pPos;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	/* encode via prefix or display name
	*/
	if( pObj->mUri.mIsVia )
	{
		sprintf(tString,"SIP/%s/%s ", pObj->mUri.mVersion, (pObj->mUri.mTransactionType==NULL)? "UDP":pObj->mUri.mTransactionType );
		HS_CHECK_OVER(tPos,strlen(tString),pMax);
		sprintf( pData+tPos, "%s", tString );
		tPos += strlen(tString);
	}
	else if( pObj->mDisplayName!=NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mDisplayName)+1,pMax);
		sprintf( pData+tPos, "%s ", pObj->mDisplayName );
		tPos += (strlen(pObj->mDisplayName)+1);
	}

	/* encode uri formate
	*/
	if( pObj->mUri.mIsVia==FALSE )
	{
		strcpy(pData+tPos,"<");
		tPos++;

		if( pObj->mUri.mProtocol != NULL )
		{
			HS_CHECK_OVER(tPos,strlen(pObj->mUri.mProtocol)+1,pMax);
			sprintf( pData+tPos, "%s:", pObj->mUri.mProtocol );
			tPos += (strlen(pObj->mUri.mProtocol)+1);
		}
	}
	if( pObj->mUri.mUserName != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mUserName)+1,pMax);
		sprintf( pData+tPos, "%s@", pObj->mUri.mUserName );
		tPos += (strlen(pObj->mUri.mUserName)+1);
	}
	if( pObj->mUri.mAddress != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mAddress),pMax);
		sprintf( pData+tPos, "%s", pObj->mUri.mAddress );
		tPos += strlen(pObj->mUri.mAddress);
	}
	if( pObj->mUri.mPort != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mPort)+1,pMax);
		sprintf( pData+tPos, ":%s", pObj->mUri.mPort );
		tPos += (strlen(pObj->mUri.mPort)+1);
	}
	if( pObj->mUri.mLooseRoute == TRUE )
	{
		HS_CHECK_OVER(tPos,3,pMax);
		strcpy(pData+tPos,";lr");
		tPos += 3;
	}
	if( pObj->mUri.mIsVia==FALSE )
	{
		strcpy(pData+tPos,">");
		tPos++;
	}

	/* encode parameter
	*/
	if( pObj->mQ != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mQ)+4,pMax);
		sprintf( pData+tPos, "; q=%s", pObj->mQ );
		tPos += (strlen(pObj->mQ)+4);
	}
	if( pObj->mExpire != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mExpire)+10,pMax);
		sprintf( pData+tPos, "; expires=%s", pObj->mExpire );
		tPos += (strlen(pObj->mExpire)+10);
	}
	if( pObj->mTag != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mTag)+5,pMax);
		sprintf( pData+tPos, ";tag=%s", pObj->mTag );
		tPos += (strlen(pObj->mTag)+5);
	}
	if( pObj->mUri.mBranch != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mBranch)+8,pMax);
		sprintf( pData+tPos, ";branch=%s", pObj->mUri.mBranch );
		tPos += (strlen(pObj->mUri.mBranch)+8);
	}
	if( pObj->mUri.mReceived != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mReceived)+11,pMax);
		sprintf( pData+tPos, "; received=%s", pObj->mUri.mReceived );
		tPos += (strlen(pObj->mUri.mReceived)+11);
	}
	if( pObj->mUri.mTtl != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mTtl)+6,pMax);
		sprintf( pData+tPos, "; ttl=%s", pObj->mUri.mTtl );
		tPos += (strlen(pObj->mUri.mTtl)+6);
	}
	if( pObj->mUri.mMaddr != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mMaddr)+8,pMax);
		sprintf( pData+tPos, "; maddr=%s", pObj->mUri.mMaddr );
		tPos += (strlen(pObj->mUri.mMaddr)+8);
	}
	if( pObj->mUri.mSubject != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mUri.mSubject)+10,pMax);
		sprintf( pData+tPos, "; subject=%s", pObj->mUri.mSubject );
		tPos += (strlen(pObj->mUri.mSubject)+10);
	}

	HS_CHECK_OVER(tPos,2,pMax);
	strcpy(pData+tPos,", ");
	tPos += 2;

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipContactUnit_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipContactUnit *pObj = (SipContactUnit*)pObject;
	char *tCharp = NULL;
	HS_UINT tPos = *pPos;
	HS_UINT tTokenPos = 0;
	HS_UINT tEndPos = 0;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	while( pData[tPos]==' ' || pData[tPos]=='\t' ) tPos++;

	if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,',')) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	pMax = tPos+tTokenPos;

	if( pObj->mUri.mIsVia == FALSE )
	{
		/* think case: "  liotliol  <  sip  :"
		*/
		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,':')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		while( tTokenPos && ( pData[tPos+tTokenPos-1]==' ' || pData[tPos+tTokenPos-1]=='\t' ) ) tTokenPos--;
		while( tTokenPos &&   pData[tPos+tTokenPos-1]!=' ' && pData[tPos+tTokenPos-1]!='\t' && pData[tPos+tTokenPos-1]!='<' ) tTokenPos--;
		while( tTokenPos && ( pData[tPos+tTokenPos-1]==' ' || pData[tPos+tTokenPos-1]=='\t' || pData[tPos+tTokenPos-1]=='<' ) ) tTokenPos--;

		/* get display name or transport type of Via header style.
		*/
		if( tTokenPos > 0 )
		{
			if( (pObj->mDisplayName=(char*)HSMalloc(tTokenPos+1)) == NULL )
				return HS_ERR_MALLOC;
			HS_CHECK_OVER(tPos,tTokenPos,pMax);
			memcpy(pObj->mDisplayName,pData+tPos,tTokenPos);
			pObj->mDisplayName[tTokenPos] = '\0';
			tPos += tTokenPos;

			while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t' || pData[tPos]==';') ) tPos++;
		}

		/* get uri protocol name
		*/
		if( pData[tPos]=='<' )
		{
			tPos++;
			if( SipFindNextTokenOnly(pData,tPos,pMax,'>') == HS_INVALID_POS )
				return HS_ERR_SIP_PAIR;
			while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t') ) tPos++;
		}
		if( (tTokenPos=SipFindNextToken3(pData,tPos,pMax,' ','\t',':')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (pObj->mUri.mProtocol=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mProtocol,pData+tPos,tTokenPos);
		pObj->mUri.mProtocol[tTokenPos] = '\0';
		tPos += tTokenPos;
		while( tPos<pMax && ( pData[tPos]==' ' || pData[tPos]=='\t' || pData[tPos]==':' ) ) tPos++;

		/* find end of uri
		*/
		if( (tEndPos=SipFindNextToken4(pData,tPos,pMax,'?',' ','>',';')) == HS_INVALID_POS )
			tEndPos = pMax;
		else
			tEndPos += tPos;
		/* get user name
		*/
		if( (tTokenPos=SipFindNextToken(pData,tPos,tEndPos,'@')) != HS_INVALID_POS )
		{
			if( (pObj->mUri.mUserName=(char*)HSMalloc(tTokenPos+1))==NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mUserName,pData+tPos,tTokenPos);
			pObj->mUri.mUserName[tTokenPos] = '\0';
			tPos += (tTokenPos+1);
		}
		/* get address
		*/
		if( (tTokenPos=SipFindNextToken(pData,tPos,tEndPos,':')) == HS_INVALID_POS )
			tTokenPos = tEndPos-tPos;
		if( (pObj->mUri.mAddress=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mAddress,pData+tPos,tTokenPos);
		pObj->mUri.mAddress[tTokenPos] = '\0';
		tPos += tTokenPos;
		/* get tsap port
		*/
		if( (tPos+1)<tEndPos )
		{
			tPos++;
			if( (pObj->mUri.mPort=(char*)HSMalloc(tEndPos-tPos+1))==NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mPort,pData+tPos,tEndPos-tPos);
			pObj->mUri.mPort[tEndPos-tPos] = '\0';
		}
		tPos = tEndPos+1;
	}/*if(pObj->mUri.mIsVia==FALSE)*/
	else
	{
		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,'/')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		tPos += (tTokenPos+1);

		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,'/')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (pObj->mUri.mVersion=(char*)HSMalloc(tTokenPos+1)) == NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mVersion,pData+tPos,tTokenPos);
		pObj->mUri.mVersion[tTokenPos] = '\0';
		tPos += (tTokenPos+1);

		if( (tTokenPos=SipFindNextToken2(pData,tPos,pMax,' ','\t')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (pObj->mUri.mTransactionType=(char*)HSMalloc(tTokenPos+1)) == NULL )
			return HS_ERR_MALLOC;
		memcpy(pObj->mUri.mTransactionType,pData+tPos,tTokenPos);
		pObj->mUri.mTransactionType[tTokenPos] = '\0';
		tPos += (tTokenPos+1);

		HS_SKIP_WSHT;
		if( (tEndPos=SipFindNextToken3(pData,tPos,pMax,' ','\t',';')) == HS_INVALID_POS )
			tEndPos = pMax;
		else
			tEndPos += tPos;

		if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,tEndPos,':')) != HS_INVALID_POS )
		{
			if( (pObj->mUri.mAddress=(char*)HSMalloc(tTokenPos+1)) == NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mAddress,pData+tPos,tTokenPos);
			pObj->mUri.mAddress[tTokenPos] = '\0';
			tPos += (tTokenPos+1);

			if( tPos<tEndPos )
			{
				if( (pObj->mUri.mPort=(char*)HSMalloc(tEndPos-tPos+1)) == NULL )
					return HS_ERR_MALLOC;
				memcpy(pObj->mUri.mPort,pData+tPos,tEndPos-tPos);
				pObj->mUri.mPort[tEndPos-tPos] = '\0';
			}
			tPos = tEndPos;
		}
		else
		{
			if( (pObj->mUri.mAddress=(char*)HSMalloc(tEndPos-tPos+1)) == NULL )
				return HS_ERR_MALLOC;
			memcpy(pObj->mUri.mAddress,pData+tPos,tEndPos-tPos);
			pObj->mUri.mAddress[tEndPos-tPos] = '\0';
			tPos = tEndPos;
		}
	}/*if(pObj->mUri.mIsVia==TRUE)*/

	/* get parameters
	*/
	while(TRUE)
	{
		while( tPos<pMax && (pData[tPos]==' ' || pData[tPos]=='\t' || pData[tPos]==';' || pData[tPos]=='>') ) tPos++;
		if( pData[tPos]==',' )
		{
			tPos++;
			*pPos = tPos;
			return HS_OK;
		}
		if( !memcmp(pData+tPos,"\r\n",2) )
		{
			tPos += 2;
			*pPos = tPos;
			return HS_OK_SIP;
		}

		if( (tTokenPos=SipFindNextToken4(pData,tPos,pMax,' ',';','>','\t')) == HS_INVALID_POS )
			tTokenPos = pMax-tPos;

		if( tTokenPos == 0 ) continue;
		if( (tCharp=(char*)HSMalloc(tTokenPos+1))==NULL )
			return HS_ERR_MALLOC;
		tTokenPos += tPos;

		/* get parameters
		*/
		if( !memcmp(pData+tPos,"q",1) )
		{
			if( pObj->mQ != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mQ = tCharp;
		}
		else if( !memcmp(pData+tPos,"tag",3) )
		{
			if( pObj->mTag != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mTag = tCharp;
		}
		else if( !memcmp(pData+tPos,"expires",7) )
		{
			if( pObj->mExpire != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mExpire = tCharp;
		}
		else if( !memcmp(pData+tPos,"branch",6) )
		{
			if( pObj->mUri.mBranch != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUri.mBranch = tCharp;
		}
		else if( !memcmp(pData+tPos,"received",8) )
		{
			if( pObj->mUri.mReceived != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUri.mReceived = tCharp;
		}
		else if( !memcmp(pData+tPos,"ttl",3) )
		{
			if( pObj->mUri.mTtl != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUri.mTtl = tCharp;
		}
		else if( !memcmp(pData+tPos,"maddr",5) )
		{
			if( pObj->mUri.mMaddr != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUri.mMaddr = tCharp;
		}
		else if( !memcmp(pData+tPos,"subject",7) )
		{
			if( pObj->mUri.mSubject != NULL )
				return HS_ERR_SIP_DUPLICATE;
			pObj->mUri.mSubject = tCharp;
		}
		else
		{
			if( !memcmp(pData+tPos,"lr",2) )
				pObj->mUri.mLooseRoute = TRUE;
			tPos = tTokenPos;
			HSFree(tCharp);
			tCharp=NULL;
			continue;
		}

		if( (tEndPos=SipFindNextTokenOnly(pData,tPos,pMax,'=')) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		tPos += (tEndPos+1);
		HS_SKIP_WSHT;

		memcpy(tCharp,pData+tPos,tTokenPos-tPos);
		tCharp[tTokenPos-tPos] = '\0';
		tCharp = NULL;
		tPos = tTokenPos;
	}/*while*/

	/* warning protection
	*/
	return HS_ERR;
}


SipContact *newm_SipContact()
{
	SipContact *pObj = NULL;

	if( (pObj=(SipContact*)HSMalloc(sizeof(SipContact)))==NULL ) return NULL;
	if( new_SipContact(pObj) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipContact(void *pObject)
{
	SipContact *pObj = (SipContact*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	strcpy(pObj->mHeaderName,HS_CONTACT_HEADER);
	pObj->mCompactHeader = 'm';

	pObj->mIsStar = FALSE;
	new_NoLockList(&(pObj->mContactUnits),delete_SipContactUnit);
	return HS_OK;
}


HS_RESULT delete_SipContact(void *pObject)
{
	SipContact *pObj = (SipContact*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_NoLockList(&(pObj->mContactUnits));
	return HS_OK;
}


HS_RESULT SipContact_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipContact_EncodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipContact_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipContact *pObj = (SipContact*)pObject;
	HS_UINT tPos = *pPos;
	HS_UINT i;
	ChainUnit *tChain = NULL;
	SipContactUnit *tUnit = NULL;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_CHECK_OVER(tPos,strlen(pObj->mHeaderName)+2,pMax);
	sprintf( pData+tPos,"%s: ",pObj->mHeaderName );
	tPos += (strlen(pObj->mHeaderName)+2);

	/* check star (*)
	*/
	if( pObj->mIsStar == TRUE )
	{
		HS_CHECK_OVER(tPos,3,pMax);
		strcpy(pData+tPos,"*\r\n");
		tPos += 3;

		*pPos = tPos;
		return HS_OK;
	}

	/* encode contact units
	*/
	tChain = pObj->mContactUnits.units;
	for( i=0; i<pObj->mContactUnits.size; i++ )
	{
		if( (tUnit=(SipContactUnit*)(tChain->data))!=NULL )
			SipContactUnit_EncodeEx(tUnit,pData,&tPos,pMax);

		tChain = (ChainUnit*)(tChain->next);
	}

	if( !memcmp(pData+tPos-2,", ",2) )
		tPos -= 2;
	strcpy(pData+tPos,"\r\n");
	tPos += 2;

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipContact_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipContact_DecodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipContact_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipContact *pObj = (SipContact*)pObject;
	HS_UINT tPos = *pPos;
	HS_UINT tTokenPos = 0;
	HS_RESULT tRet = HS_OK;
	SipContactUnit *tUnit = NULL;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_HEADER_CHECK
	HS_FIRST_CLAUSE

	/* structure clear
	*/
	pObj->mIsStar = FALSE;
	delete_NoLockList(&(pObj->mContactUnits));

	/* check star (*)
	*/
	if( pData[tPos] == '*' && 
		(pData[tPos+1] == ' ' || pData[tPos+1] == '\t' || !memcmp(pData+tPos+1,HS_SIP_END_OF_LINE,2))
	)
	{
		if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax)) == HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		pObj->mIsStar = TRUE;
		tPos += (tTokenPos+2);

		*pPos = tPos;
		return HS_OK;
	}

	/* decode contact units
	*/
	while(TRUE)
	{
		if( (tUnit=(SipContactUnit*)HSMalloc(sizeof(SipContactUnit))) == NULL )
			return HS_ERR_MALLOC;

		new_SipContactUnit(tUnit,(pObj->mCompactHeader=='v'));
		switch(tRet=SipContactUnit_DecodeEx(tUnit,pData,&tPos,pMax))
		{
			case HS_OK:
				NoLockList_AttachData(&(pObj->mContactUnits),tUnit);
				break;
			case HS_OK_SIP:
				NoLockList_AttachData(&(pObj->mContactUnits),tUnit);
				*pPos = tPos;
				return HS_OK;
			default:
				delete_SipContactUnit(tUnit);
				HSFree(tUnit);
				return tRet;
		}
	}

	/* warning protection
	*/
	return HS_ERR;
}


SipContactUnit *SipContact_GetPrimeContactUnit(void *pObject)
{
	ChainUnit *tChain = NULL;
	SipContact *pObj = (SipContact*)pObject;

	if( pObj==NULL ) return NULL;
	if( (tChain=pObj->mContactUnits.units)==NULL ) return NULL;
	return (SipContactUnit*)(tChain->data);
}


SipContactUnit* SipContacts_GetPrimeContactUnit(NoLockList *pList)
{
	ChainUnit *tChain = NULL;

	if( pList==NULL ) return NULL;
	if( (tChain=pList->units)==NULL ) return NULL;
	return SipContact_GetPrimeContactUnit(tChain->data);
}





/* 20.11 SipContentDisposition member functions
*/
HS_SAME_FUNCTION(SipHeader,SipContentDisposition,CONTENT_DISPOSITION,HS_UCHAR_MAX)


/* 20.12 SipContentEncoding member functions
*/
HS_SAME_FUNCTION(SipHeader,SipContentEncoding,CONTENT_ENCODING,'e')


/* 20.13 SipContentLanguage member functions
*/
HS_SAME_FUNCTION(SipHeader,SipContentLanguage,CONTENT_LANGUAGE,HS_UCHAR_MAX)


/* 20.14 SipContentLength member functions
*/
HS_SAME_FUNCTION(SipHeader,SipContentLength,CONTENT_LENGTH,'l')


/* 20.15 SipContentType member functions
*/
HS_SAME_FUNCTION(SipHeader,SipContentType,CONTENT_TYPE,'c')





/* 20.16 SipCSeq member functions
*/
SipCSeq *newm_SipCSeq()
{
	SipCSeq *pObj = NULL;

	if( (pObj=(SipCSeq*)HSMalloc(sizeof(SipCSeq)))==NULL ) return NULL;
	if( new_SipCSeq(pObj) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipCSeq(void *pObject)
{
	SipCSeq *pObj = (SipCSeq*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	strcpy(pObj->mHeaderName,HS_CSEQ_HEADER);
	pObj->mCompactHeader = (char)HS_UCHAR_MAX;
	pObj->mNumber = NULL;
	pObj->mMethod = NULL;

	return HS_OK;
}


HS_RESULT delete_SipCSeq(void *pObject)
{
	SipCSeq *pObj = (SipCSeq*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mNumber != NULL ) {	HSFree(pObj->mNumber);	pObj->mNumber=NULL;	}
	if( pObj->mMethod != NULL )	{	HSFree(pObj->mMethod);	pObj->mMethod=NULL;	}
	return HS_OK;
}


HS_RESULT SipCSeq_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipCSeq_EncodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipCSeq_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipCSeq *pObj = (SipCSeq*)pObject;
	HS_UINT tPos = *pPos;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_CHECK_OVER(tPos,strlen(pObj->mHeaderName)+2,pMax);
	sprintf( pData+tPos,"%s: ",pObj->mHeaderName );
	tPos += (strlen(pObj->mHeaderName)+2);

	if( pObj->mNumber != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mNumber)+1,pMax);
		sprintf(pData+tPos,"%s ",pObj->mNumber);
		tPos += (strlen(pObj->mNumber)+1);
	}
	if( pObj->mMethod != NULL )
	{
		HS_CHECK_OVER(tPos,strlen(pObj->mMethod),pMax);
		strcpy(pData+tPos,pObj->mMethod);
		tPos += strlen(pObj->mMethod);
	}

	HS_CHECK_OVER(tPos,2,pMax);
	strcpy(pData+tPos,HS_SIP_END_OF_LINE);
	tPos += 2;

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SipCSeq_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipCSeq_DecodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipCSeq_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipCSeq *pObj = (SipCSeq*)pObject;
	HS_UINT tPos = *pPos;
	HS_UINT tTokenPos = 0;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;
	if( tPos>pMax ) return HS_ERR_OVER;

	HS_HEADER_CHECK
	HS_FIRST_CLAUSE

	/* data clear
	*/
	if( pObj->mNumber != NULL )	{	HSFree(pObj->mNumber);	pObj->mNumber=NULL;	}
	if( pObj->mMethod != NULL )	{	HSFree(pObj->mMethod);	pObj->mMethod=NULL;	}

	if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,pMax,' ')) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	if( (pObj->mNumber=(char*)HSMalloc(tTokenPos+1)) == NULL )
		return HS_ERR_MALLOC;
	memcpy(pObj->mNumber,pData+tPos,tTokenPos);
	pObj->mNumber[tTokenPos] = '\0';
	tPos += (tTokenPos+1);

	while( pData[tPos]==' ' || pData[tPos]=='\t' ) tPos++;

	if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax)) == HS_INVALID_POS )
		return HS_ERR_SIP_END_OF_LINE;
	if( (pObj->mMethod=(char*)HSMalloc(tTokenPos+1)) == NULL )
		return HS_ERR_MALLOC;
	memcpy(pObj->mMethod,pData+tPos,tTokenPos);
	pObj->mMethod[tTokenPos] = '\0';
	tPos += (tTokenPos+2);

	*pPos = tPos;
	return HS_OK;
}





/* 20.17 SipDate member functions
*/
HS_SAME_FUNCTION(SipHeader,SipDate,DATE,HS_UCHAR_MAX)


/* 20.18 SipErrorInfo member functions
*/
HS_SAME_FUNCTION(SipHeader,SipErrorInfo,ERROR_INFO,HS_UCHAR_MAX)


/* 20.19 SipExpires member functions
*/
HS_SAME_FUNCTION(SipHeader,SipExpires,EXPIRES,HS_UCHAR_MAX)


/* 20.20 SipFrom member functions
*/
HS_SAME_FUNCTION(SipContact,SipFrom,FROM,'f')
SipContactUnit *SipFrom_GetPrimeContactUnit(void *pObject)
{
	ChainUnit *tChain = NULL;
	SipFrom *pObj = (SipFrom*)pObject;

	if( pObj==NULL ) return NULL;

	if( (tChain=pObj->mContactUnits.units)==NULL ) return NULL;
	return ((SipContactUnit*)(tChain->data));
}


/* 20.21 SipInReplyTo member functions
*/
HS_SAME_FUNCTION(SipHeader,SipInReplyTo,IN_REPLY_TO,HS_UCHAR_MAX)


/* 20.22 SipMaxForwards member functions
*/
HS_SAME_FUNCTION(SipHeader,SipMaxForwards,MAX_FORWARDS,HS_UCHAR_MAX)


/* 20.23 SipMinExpires member functions
*/
HS_SAME_FUNCTION(SipHeader,SipMinExpires,MIN_EXPIRES,HS_UCHAR_MAX)


/* 20.24 SipMIMEVersion member functions
*/
HS_SAME_FUNCTION(SipHeader,SipMIMEVersion,MIME_VERSION,HS_UCHAR_MAX)


/* 20.25 SipOrganization member functions
*/
HS_SAME_FUNCTION(SipHeader,SipOrganization,ORGANIZATION,HS_UCHAR_MAX)


/* 20.26 SipPriority member functions
*/
HS_SAME_FUNCTION(SipHeader,SipPriority,PRIORITY,HS_UCHAR_MAX)


/* 20.27 SipProxyAuthenticate member functions
*/
HS_SAME_FUNCTION_EX(SipAuthorization,SipProxyAuthenticate,PROXY_AUTHENTICATE,HS_UCHAR_MAX)


/* 20.28 SipProxyAuthorization member functions
*/
HS_SAME_FUNCTION_EX(SipAuthorization,SipProxyAuthorization,PROXY_AUTHORIZATION,HS_UCHAR_MAX)


/* 20.29 SipProxyRequire member functions
*/
HS_SAME_FUNCTION(SipHeader,SipProxyRequire,PROXY_REQUIRE,HS_UCHAR_MAX)


/* 20.30 SipRecordRoute member functions
*/
HS_SAME_FUNCTION(SipContact,SipRecordRoute,RECORD_ROUTE,HS_UCHAR_MAX)
SipContactUnit *SipRecordRoute_GetPrimeContactUnit(void *pObject)
{
	ChainUnit *tChain = NULL;
	SipRecordRoute *pObj = (SipRecordRoute*)pObject;

	if( pObj==NULL ) return NULL;

	if( (tChain=pObj->mContactUnits.units)==NULL ) return NULL;
	return ((SipContactUnit*)(tChain->data));
}
SipContactUnit *SipRecordRoutes_GetPrimeContactUnit(NoLockList *pList)
{
	ChainUnit *tChain = NULL;

	if( pList==NULL ) return NULL;
	if( (tChain=pList->units)==NULL ) return NULL;
	return SipRecordRoute_GetPrimeContactUnit(tChain->data);
}


/* 20.31 SipReplyTo member functions
*/
HS_SAME_FUNCTION(SipContact,SipReplyTo,REPLY_TO,HS_UCHAR_MAX)


/* 20.32 SipRequire member functions
*/
HS_SAME_FUNCTION(SipAccept,SipRequire,REQUIRE,HS_UCHAR_MAX)


/* 20.33 SipRetryAfter member functions
*/
HS_SAME_FUNCTION(SipHeader,SipRetryAfter,RETRY_AFTER,HS_UCHAR_MAX)


/* 20.34 SipRoute member functions
*/
HS_SAME_FUNCTION(SipContact,SipRoute,ROUTE,HS_UCHAR_MAX)


/* 20.35 SipServer member functions
*/
HS_SAME_FUNCTION(SipHeader,SipServer,SERVER,HS_UCHAR_MAX)


/* 20.36 SipSubject member functions
*/
HS_SAME_FUNCTION(SipHeader,SipSubject,SUBJECT,'s')


/* 20.37 SipSupported member functions
*/
HS_SAME_FUNCTION(SipAccept,SipSupported,SUPPORTED,HS_UCHAR_MAX)


/* 20.38 SipTimestamp member functions
*/
HS_SAME_FUNCTION(SipHeader,SipTimestamp,TIMESTAMP,HS_UCHAR_MAX)


/* 20.39 SipTo member functions
*/
HS_SAME_FUNCTION(SipContact,SipTo,TO,'t')
SipContactUnit *SipTo_GetPrimeContactUnit(void *pObject)
{return SipFrom_GetPrimeContactUnit(pObject);}


/* 20.40 SipUnsupported member functions
*/
HS_SAME_FUNCTION(SipAccept,SipUnsupported,UNSUPPORTED,HS_UCHAR_MAX)


/* 20.41 SipUserAgent member functions
*/
HS_SAME_FUNCTION(SipHeader,SipUserAgent,USER_AGENT,HS_UCHAR_MAX)


/* 20.42 SipVia member functions
*/
HS_SAME_FUNCTION(SipContact,SipVia,VIA,'v')


/* 20.43 SipWarning member functions
*/
HS_SAME_FUNCTION(SipHeader,SipWarning,WARNING,HS_UCHAR_MAX)


/* 20.44 SipWWWAuthenticate member functions
*/
HS_SAME_FUNCTION_EX(SipAuthorization,SipWWWAuthenticate,WWW_AUTHENTICATE,HS_UCHAR_MAX)



