/*

	<HashMac.h>		2005-12-07,23:49

*/

#ifndef __2005_12_07__23_49__HASHMAC_H__
#define __2005_12_07__23_49__HASHMAC_H__





#ifndef MD
#define MD MD5
#define MD5 5
#endif





#include "MD/global.h"
#if MD == 2
#include "MD/md2.h"
#endif
#if MD == 4
#include "MD/md4.h"
#endif
#if MD == 5
#include "MD/md5.h"
#endif
#include "SHA1/sha1.h"





#if MD == 2
#define MD_CTX MD2_CTX
#define MDInit MD2Init
#define MDUpdate MD2Update
#define MDFinal MD2Final
#endif
#if MD == 4
#define MD_CTX MD4_CTX
#define MDInit MD4Init
#define MDUpdate MD4Update
#define MDFinal MD4Final
#endif
#if MD == 5
#define MD_CTX MD5_CTX
#define MDInit MD5Init
#define MDUpdate MD5Update
#define MDFinal MD5Final
#endif





#ifndef NULL
#define NULL 0x00000000
#endif





#define SHA_CBLOCK	64
#define SHA_LBLOCK	16
#define SHA_BLOCK	16
#define SHA_LAST_BLOCK  56
#define SHA_LENGTH_BLOCK 8
#define SHA_DIGEST_LENGTH 20
#define SHA_96_SIZE 96

#define MD5_CBLOCK	64
#define MD5_LBLOCK	16
#define MD5_BLOCK	16
#define MD5_LAST_BLOCK  56
#define MD5_LENGTH_BLOCK 8
#define MD5_DIGEST_LENGTH 16





int Md5Hash(unsigned char *pHash, unsigned char *pData, unsigned int pLen);
int Sha1Hash(unsigned char *pHash, unsigned char *pData, unsigned int pLen);


/* HMAC (Keyed Hash) implemented by RFC 2104 'HMAC'
*/
int Md5Hmac(unsigned char *pMac,
	unsigned char *pKey, unsigned int pKeyLen,
	unsigned char *pData, unsigned int pDataLen
);
int Sha1Hmac(unsigned char *pMac,
	unsigned char *pKey, unsigned int pKeyLen,
	unsigned char *pData, unsigned int pDataLen
);





#endif/*__2005_12_07__23_49__HASHMAC_H__*/