/*

	<des.c>		2005-12-04,12:01

*/

#include "des.h"
#include <memory.h>





#define DESXor(out,in1,in2)																\
{																						\
	((unsigned int*)(out))[0] = ((unsigned int*)(in1))[0] ^ ((unsigned int*)(in2))[0];	\
	((unsigned int*)(out))[1] = ((unsigned int*)(in1))[1] ^ ((unsigned int*)(in2))[1];	\
}


static int DesMakeRoundKey(unsigned long *pRoundKey, unsigned char *pKey)
{
	unsigned long   v0, v1, l0, l1, tt;
    unsigned short  i;

	if( pKey==NULL || pRoundKey==NULL ) return 2/*null param*/;

    l0 = *((unsigned long*)pKey);
    l1 = *(((unsigned long*)pKey) + 1);

    bit_swap(l1, l0, 4, 0x0f0f0f0f);
    bit_swap(l0, l1, 4, 0x01010101);
    bit_swap(l0, l0, 9, 0x00550055);
    bit_swap(l1, l1, 9, 0x00550055);
    bit_swap(l0, l0, 18, 0x00003333);
    bit_swap(l1, l1, 18, 0x00003333);
    bit_swap(l1, l1, 16, 0x000000ff);

    for(i = 0; i < 16; i++)
    {   
        l0 &= 0x0fffffffL; l1 &= 0x0fffffffL;

        if(ks_tab[i])
        {   
            l0 = (l0 >> 2) | (l0 << 26); 
            l1 = (l1 >> 2) | (l1 << 26);
        }
        else
        {   
            l0 = (l0 >> 1) | (l0 << 27); 
            l1 = (l1 >> 1) | (l1 << 27);
        }

        v0 = p2_tab[0][byte(l0,0) & 0x3f]
           | p2_tab[1][(byte(l0,1) >> 1) & 0x3f] | p2_tab[2][byte(l0,2) & 0x1d
                        | (byte(l0,2) >> 1) & 0x20 | (byte(l0,2) >> 6) & 0x02]
           | p2_tab[3][(byte(l0,0) >> 2) & 0x30 | (byte(l0,1) >> 7) & 0x01
                        | byte(l0,3) & 0x0e];

        v1 = p2_tab[4][byte(l1,0) & 0x3f]
           | p2_tab[5][byte(l1,1) & 0x3d | (byte(l1,1) >> 6) & 0x02]
           | p2_tab[6][byte(l1,2) & 0x3f]
           | p2_tab[7][(byte(l1,0) >> 6) & 0x02 | (byte(l1,2) >> 2) & 0x30 
                        | byte(l1,3) & 0x0d];

        pRoundKey[2 * i]     = (v0 & 0x0000ffff) | (v1 << 16);
        pRoundKey[2 * i + 1] = (v1 & 0xffff0000) | (v0 >> 16);
    }

	return 0;
}





/* DesContext member functions.
*/
int new_DesContext(void *pObject)
{
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL ) return 2/*null param*/;

	memset(pObj->mKey,0,8);
	memset((unsigned char*)(pObj->mRoundKey),0,128);
	pObj->mResult = NULL;
	pObj->mResultLen = 0;

	return 0/*ok*/;
}


DesContext *newm_DesContext()
{
	DesContext *tResult = NULL;

	if( (tResult=(DesContext*)HSMalloc(sizeof(DesContext)))==NULL )
		return NULL;

	if( new_DesContext(tResult) != 0 )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


int delete_DesContext(void *pObject)
{
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL ) return 2/*null param*/;

	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	pObj->mResultLen = 0;

	return 0;
}


int deletem_DesContext(void *pObject)
{
	int tRet;

	if( (tRet=delete_DesContext(pObject)) != 0 ) return tRet;

	HSFree(pObject);
	return 0;
}


int DesContext_SetKey(void *pObject, unsigned char *pKey)
{
	int tRet = 0;
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL || pKey==NULL ) return 2/*null param*/;

	if( (tRet=DesMakeRoundKey(pObj->mRoundKey,pKey)) != 0 ) return tRet;
	memcpy(pObj->mKey,pKey,8);
	return 0;
}


/* input, output is a 8 byte data.
*/
static void DesEncryptEcb(void *pOutput, const void *pInput, void *pRoundKey)
{
	unsigned long   q0, q1, l0, l1, tt;

    q0 = *(((unsigned long*)pInput) + 1);
    q1 = *(((unsigned long*)pInput));

    ip(q0, q1);

    round(q0,q1,0,pRoundKey);
    round(q1,q0,2,pRoundKey);
    round(q0,q1,4,pRoundKey);
    round(q1,q0,6,pRoundKey);
    round(q0,q1,8,pRoundKey);
    round(q1,q0,10,pRoundKey);
    round(q0,q1,12,pRoundKey);
    round(q1,q0,14,pRoundKey);
    round(q0,q1,16,pRoundKey);
    round(q1,q0,18,pRoundKey);
    round(q0,q1,20,pRoundKey);
    round(q1,q0,22,pRoundKey);
    round(q0,q1,24,pRoundKey);
    round(q1,q0,26,pRoundKey);
    round(q0,q1,28,pRoundKey);
    round(q1,q0,30,pRoundKey);

    fp(q1, q0);

    *(((unsigned long*)pOutput)) = q0; 
    *(((unsigned long*)pOutput) + 1) = q1;
}
void DesDecryptEcb(void *pOutput, const void *pInput, void *pRoundKey)
{
	unsigned long   q0, q1, l0, l1, tt;

    q0 = *(((unsigned long*)pInput) + 1); 
    q1 = *(((unsigned long*)pInput));

    ip(q0, q1);
    
    round(q0,q1,30,pRoundKey);
    round(q1,q0,28,pRoundKey);
    round(q0,q1,26,pRoundKey);
    round(q1,q0,24,pRoundKey);
    round(q0,q1,22,pRoundKey);
    round(q1,q0,20,pRoundKey);
    round(q0,q1,18,pRoundKey);
    round(q1,q0,16,pRoundKey);
    round(q0,q1,14,pRoundKey);
    round(q1,q0,12,pRoundKey);
    round(q0,q1,10,pRoundKey);
    round(q1,q0,8,pRoundKey);
    round(q0,q1,6,pRoundKey);
    round(q1,q0,4,pRoundKey);
    round(q0,q1,2,pRoundKey);
    round(q1,q0,0,pRoundKey);

    fp(q1, q0);

    *(((unsigned long*)pOutput)) = q0; 
    *(((unsigned long*)pOutput) + 1) = q1;
}


int DesContext_EncryptEcb(void *pObject, unsigned char *pData, unsigned int pLen)
{
	unsigned int i, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	for(i=0; i<tBlockSize; i++)
		DesEncryptEcb(pObj->mResult+i*8,pData+i*8,pObj->mRoundKey);

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int DesContext_DecryptEcb(void *pObject, unsigned char *pData, unsigned int pLen)
{
	unsigned int i, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	for(i=0; i<tBlockSize; i++)
		DesDecryptEcb(pObj->mResult+i*8,pData+i*8,pObj->mRoundKey);

	/* do not decrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int DesContext_EncryptCbc(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
		DesEncryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey);
		memcpy(tXorer,pObj->mResult+i*8,8);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int DesContext_DecryptCbc(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesDecryptEcb(pObj->mResult+i*8,pData+i*8,pObj->mRoundKey);
		DESXor(pObj->mResult+i*8,pObj->mResult+i*8,tXorer);
		memcpy(tXorer,pData+i*8,8);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int DesContext_EncryptOfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, j, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
	}

	if( tRemainLen != 0 )
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*8+j] = pData[i*8+j] ^ tXorer[j];
	}

	return 0;
}


int DesContext_DecryptOfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	return DesContext_EncryptOfb(pObject,pIv,pData,pLen);
}


int DesContext_EncryptCfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, j, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
		memcpy(tXorer,pObj->mResult+i*8,8);
	}

	if( tRemainLen != 0 )
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*8+j] = pData[i*8+j] ^ tXorer[j];
	}

	return 0;
}


int DesContext_DecryptCfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, j, tBlockSize, tRemainLen;
	DesContext *pObj = (DesContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
		memcpy(tXorer,pData+i*8,8);
	}

	if( tRemainLen != 0 )
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*8+j] = pData[i*8+j] ^ tXorer[j];
	}

	return 0;
}


unsigned char *DesContext_GetResult(void *pObject, unsigned int *pLen)
{
	unsigned char *tResult = NULL;
	DesContext *pObj = (DesContext*)pObject;

	if( pObj==NULL ) return NULL;

	tResult = pObj->mResult;
	pObj->mResult = NULL;
	*pLen = pObj->mResultLen;
	pObj->mResultLen = 0;
	return tResult;
}





/* Des3Context member functions.
*/
int new_Des3Context(void *pObject)
{
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL ) return 2/*null param*/;

	memset(pObj->mKey1,0,8);
	memset(pObj->mKey2,0,8);
	memset(pObj->mKey3,0,8);
	memset((unsigned char*)(pObj->mRoundKey1),0,128);
	memset((unsigned char*)(pObj->mRoundKey2),0,128);
	memset((unsigned char*)(pObj->mRoundKey3),0,128);
	pObj->mResult = NULL;
	pObj->mResultLen = 0;

	return 0/*ok*/;
}


Des3Context *newm_Des3Context()
{
	int tRet = 0;
	Des3Context *tResult = NULL;

	if( (tResult=(Des3Context*)HSMalloc(sizeof(Des3Context)))==NULL ) return NULL;
	if( (tRet=new_Des3Context(tResult)) != 0 )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


int delete_Des3Context(void *pObject)
{
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL ) return 2/*null param*/;

	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	pObj->mResultLen = 0;
	return 0;
}


int deletem_Des3Context(void *pObject)
{
	int tRet = 0;

	if( (tRet=delete_Des3Context(pObject)) != 0 ) return tRet;
	HSFree(pObject);
	return 0;
}


int Des3Context_SetKey(void *pObject, unsigned char *pKey1, unsigned char *pKey2, unsigned char *pKey3)
{
	int tRet = 0;
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL || pKey1==NULL || pKey2==NULL || pKey3==NULL ) return 2/*null param*/;

	if( (tRet=DesMakeRoundKey(pObj->mRoundKey1,pKey1)) != 0 ) return tRet;
	if( (tRet=DesMakeRoundKey(pObj->mRoundKey2,pKey2)) != 0 ) return tRet;
	if( (tRet=DesMakeRoundKey(pObj->mRoundKey3,pKey3)) != 0 ) return tRet;
	memcpy(pObj->mKey1,pKey1,8);
	memcpy(pObj->mKey2,pKey2,8);
	memcpy(pObj->mKey3,pKey3,8);
	return 0;
}


int Des3Context_EncryptEcb(void *pObject, unsigned char *pData, unsigned int pLen)
{
	unsigned int i, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(pObj->mResult+i*8,pData+i*8,pObj->mRoundKey1);
		DesDecryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey2);
		DesEncryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey3);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int Des3Context_DecryptEcb(void *pObject, unsigned char *pData, unsigned int pLen)
{
	unsigned int i, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	for(i=0; i<tBlockSize; i++)
	{
		DesDecryptEcb(pObj->mResult+i*8,pData+i*8,pObj->mRoundKey3);
		DesEncryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey2);
		DesDecryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey1);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int Des3Context_EncryptCbc(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
		DesEncryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey1);
		DesDecryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey2);
		DesEncryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey3);
		memcpy(tXorer,pObj->mResult+i*8,8);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int Des3Context_DecryptCbc(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesDecryptEcb(pObj->mResult+i*8,pData+i*8,pObj->mRoundKey3);
		DesEncryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey2);
		DesDecryptEcb(pObj->mResult+i*8,pObj->mResult+i*8,pObj->mRoundKey1);
		DESXor(pObj->mResult+i*8,pObj->mResult+i*8,tXorer);
		memcpy(tXorer,pData+i*8,8);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*8,pData+i*8,tRemainLen);

	return 0;
}


int Des3Context_EncryptOfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, j, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey1);
		DesDecryptEcb(tXorer,tXorer,pObj->mRoundKey2);
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey3);
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
	}

	if( tRemainLen != 0 )
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey1);
		DesDecryptEcb(tXorer,tXorer,pObj->mRoundKey2);
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey3);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*8+j] = pData[i*8+j] ^ tXorer[j];
	}

	return 0;
}


int Des3Context_DecryptOfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	return Des3Context_EncryptOfb(pObject,pIv,pData,pLen);
}


int Des3Context_EncryptCfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, j, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey1);
		DesDecryptEcb(tXorer,tXorer,pObj->mRoundKey2);
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey3);
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
		memcpy(tXorer,pObj->mResult+i*8,8);
	}

	if( tRemainLen != 0 )
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey1);
		DesDecryptEcb(tXorer,tXorer,pObj->mRoundKey2);
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey3);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*8+j] = pData[i*8+j] ^ tXorer[j];
	}

	return 0;
}


int Des3Context_DecryptCfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[8];
	unsigned int i, j, tBlockSize, tRemainLen;
	Des3Context *pObj = (Des3Context*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/8);
	tRemainLen = (unsigned int)(pLen%8);

	memcpy(tXorer,pIv,8);
	for(i=0; i<tBlockSize; i++)
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey1);
		DesDecryptEcb(tXorer,tXorer,pObj->mRoundKey2);
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey3);
		DESXor(pObj->mResult+i*8,pData+i*8,tXorer);
		memcpy(tXorer,pData+i*8,8);
	}

	if( tRemainLen != 0 )
	{
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey1);
		DesDecryptEcb(tXorer,tXorer,pObj->mRoundKey2);
		DesEncryptEcb(tXorer,tXorer,pObj->mRoundKey3);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*8+j] = pData[i*8+j] ^ tXorer[j];
	}

	return 0;
}


unsigned char *Des3Context_GetResult(void *pObject, unsigned int *pLen)
{
	unsigned char *tResult = NULL;
	Des3Context *pObj = (Des3Context*)pObject;

	if( pObj==NULL ) return NULL;

	tResult = pObj->mResult;
	pObj->mResult = NULL;
	*pLen = pObj->mResultLen;
	pObj->mResultLen = 0;
	return tResult;
}
