/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/
/*

	<UcharRing.c>		2006-01-10,19:46

*/

#include <malloc.h>
#include <string.h>

#include "UcharRing.h"





HS_RESULT new_UcharRing(void *pObject,HS_UINT pMax)
{
	UcharRing *pObj = (UcharRing*)pObject;

	if( pObj==NULL || pMax==0 ) return HS_ERR_NULL_PARAM;
	if( (pObj->mData=(HS_UCHAR*)HSMalloc(pMax))==NULL ) return HS_ERR_MALLOC;

	pObj->mA = 0;
	pObj->mZ = 0;
	pObj->mMax = pMax;
	pObj->mSize = 0;
	return HS_OK;
}


UcharRing *newm_UcharRing(HS_UINT pMax)
{
	UcharRing *tResult = NULL;

	if( (tResult=(UcharRing*)HSMalloc(sizeof(UcharRing)))==NULL ) return NULL;
	if( new_UcharRing(tResult,pMax) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}
	return tResult;
}


HS_RESULT delete_UcharRing(void *pObject)
{
	UcharRing *pObj = (UcharRing*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mData != NULL )
	{
		HSFree(pObj->mData);
		pObj->mData = NULL;
	}

	pObj->mA = 0;
	pObj->mZ = 0;
	pObj->mMax = 0;
	pObj->mSize = 0;
	return HS_OK;
}


HS_RESULT deletem_UcharRing(void *pObject)
{
	HS_RESULT tRet = HS_OK;
	UcharRing *pObj = (UcharRing*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	delete_UcharRing(pObj);
	HSFree(pObj);
	return HS_OK;
}


HS_RESULT UcharRing_Put(void *pObject,HS_UCHAR *pIn,HS_UINT pSize)
{
	UcharRing *pObj = (UcharRing*)pObject;

	if( pObj==NULL || pIn==NULL || pSize==0 ) return HS_ERR_NULL_PARAM;
	if( pObj->mSize + pSize > pObj->mMax ) return HS_ERR_OVER;

	if( UcharRing_LA(pObj) == pSize )
	{
		memcpy(UcharRing_A(pObj),pIn,pSize);
		pObj->mA = 0;
	}
	else if( UcharRing_LA(pObj) > pSize )
	{
		memcpy(UcharRing_A(pObj),pIn,pSize);
		pObj->mA += pSize;
	}
	else
	{
		memcpy(UcharRing_A(pObj),pIn,UcharRing_LA(pObj));
		memcpy(pObj->mData,pIn+UcharRing_LA(pObj),pSize-UcharRing_LA(pObj));
		pObj->mA = pSize-UcharRing_LA(pObj);
	}

	pObj->mSize += pSize;
	return HS_OK;
}


HS_RESULT UcharRing_ForcePut(void *pObject,HS_UCHAR *pIn,HS_UINT pSize)
{
	HS_UINT pForceSize=0;
	UcharRing *pObj = (UcharRing*)pObject;

	if( pObj==NULL || pIn==NULL || pSize==0 ) return HS_ERR_NULL_PARAM;
	if( pObj->mSize + pSize > pObj->mMax*2 ) return HS_ERR_OVER;
	if( pObj->mSize + pSize > pObj->mMax )
	{
		HSPrint("\ntp> force put");
		pForceSize = pObj->mSize + pSize - pObj->mMax;
		pSize -= pForceSize;
	}

	if( pSize > 0 )
	{
		if( UcharRing_LA(pObj) == pSize )
		{
			memcpy(UcharRing_A(pObj),pIn,pSize);
			pObj->mA = 0;
		}
		else if( UcharRing_LA(pObj) > pSize )
		{
			memcpy(UcharRing_A(pObj),pIn,pSize);
			pObj->mA += pSize;
		}
		else
		{
			memcpy(UcharRing_A(pObj),pIn,UcharRing_LA(pObj));
			memcpy(pObj->mData,pIn+UcharRing_LA(pObj),pSize-UcharRing_LA(pObj));
			pObj->mA = pSize-UcharRing_LA(pObj);
		}

		pObj->mSize += pSize;
	}

	if( pForceSize > 0 )
	{
		pObj->mZ = (pObj->mZ+pForceSize) % pObj->mMax;
		pObj->mSize -= pForceSize;
		return UcharRing_Put(pObj,pIn+pSize,pForceSize);
	}

	return HS_OK;
}


HS_UCHAR *UcharRing_Get(void *pObject,HS_UINT pSize)
{
	HS_UCHAR *tResult = NULL;
	UcharRing *pObj = (UcharRing*)pObject;

	if( pObj==NULL || pSize==0 ) return NULL;
	if( pObj->mSize < pSize ) return NULL;
	if( (tResult=(HS_UCHAR*)HSMalloc(pSize))==NULL ) return NULL;

	if( pObj->mA > pObj->mZ )
	{
		memcpy(tResult,UcharRing_Z(pObj),pSize);
		pObj->mZ += pSize;
	}
	else if( UcharRing_LZ(pObj) < pSize )
	{
		memcpy(tResult,UcharRing_Z(pObj),UcharRing_LZ(pObj));
		memcpy(tResult+UcharRing_LZ(pObj),pObj->mData,pSize-UcharRing_LZ(pObj));
		pObj->mZ = pSize-UcharRing_LZ(pObj);
	}
	else
	{
		memcpy(tResult,UcharRing_Z(pObj),pSize);
		pObj->mZ = (pObj->mZ+pSize) % pObj->mMax;
	}

	pObj->mSize -= pSize;
	return tResult;
}