/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpUI.h>		2006-01-16,21:00

*/

#ifndef __2006_01_16__21_00__RTPUI_H__
#define __2006_01_16__21_00__RTPUI_H__





#include "RtpDefine.h"
#include "RtpRcver.h"





HS_RTP_HANDLE OpenRtp();
HS_RESULT CloseRtp(HS_RTP_HANDLE pHandle);
HS_RESULT CheckRtp(HS_RTP_HANDLE pHandle);

HS_RESULT StartForwardRtp(HS_RTP_HANDLE pHandle,RtpPayloadType pCodec,char *pIp,HS_USHORT pPort,HS_UINT pFpp);
HS_RESULT StartForwardRtpEx(HS_RTP_HANDLE pHandle,RtpPayloadType pCodec,struct sockaddr_in pAddrIn,HS_UINT pFpp);
HS_RESULT StartReverseRtp(HS_RTP_HANDLE pHandle,RtpPayloadType pCodec,HS_USHORT pPort);
HS_RESULT StopForwardRtp(HS_RTP_HANDLE pHandle);
HS_RESULT StopReverseRtp(HS_RTP_HANDLE pHandle);

HS_RESULT HoldForwardRtp(HS_RTP_HANDLE pHandle);
HS_RESULT ResumeForwardRtp(HS_RTP_HANDLE pHandle);
HS_RESULT HoldReverseRtp(HS_RTP_HANDLE pHandle);
HS_RESULT ResumeReverseRtp(HS_RTP_HANDLE pHandle);

HS_RESULT RtpCommandAddDtmfInband(HS_RTP_HANDLE pHandle,char pSignal,HS_UINT pVolume);
HS_RESULT RtpCommandAddDtmfRfc2833(HS_RTP_HANDLE pHandle,char pSignal);

/* Call-Progress-Tone/DTMF-Tone control
*/
typedef RtpSpeakerout* tone_handle;
tone_handle OpenToneHandle();
HS_RESULT CloseToneHandle(tone_handle pHandle);
HS_RESULT StartCptTone(tone_handle pHandle,DtmfSignal pSignal,HS_UINT pVolume);
HS_RESULT StopCptTone(tone_handle pHandle);





#endif/*__2006_01_16__21_00__RTPUI_H__*/