/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/
/*

	<RtpMicin.c>	2006-01-10,21:15

*/

#ifndef _WIN32_WCE
#include <process.h>
#endif

#include "RtpMicin.h"





/*
 *
 * WAVEHDR creator/destoryer
 *
 */
WAVEHDR *CreateWaveHeader(HS_UINT pSize)
{
	WAVEHDR *tResult = NULL;

	if( pSize == 0 ) return NULL;

	tResult = (WAVEHDR*)HSMalloc(sizeof(WAVEHDR));
	if( tResult == NULL ) return NULL;

	tResult->lpData = (char*)HSMalloc(pSize);
	if( tResult->lpData==NULL )
	{
		HSFree(tResult);
		return NULL;
	}

    tResult->dwBufferLength = pSize;
	tResult->dwFlags = 0;
	return tResult;
}


void DestroyWaveHeader(WAVEHDR *pObj)
{
	if( pObj == NULL ) return;

	if( pObj->lpData )
		HSFree(pObj->lpData);

	HSFree(pObj);
	return;
}





/*
 *
 * RtpMicin member functions
 *
 */
HS_RESULT new_RtpMicin(void *pObject,int mHertz)
{
	RtpMicin *pObj = (RtpMicin*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	memset(&(pObj->mFormat),0,sizeof(pObj->mFormat));
	pObj->mFormat.wFormatTag = WAVE_FORMAT_PCM;
	pObj->mFormat.nChannels = 1;
	pObj->mFormat.wBitsPerSample = 16;
	pObj->mFormat.cbSize = 0;
	pObj->mFormat.nSamplesPerSec = mHertz;
	pObj->mFormat.nAvgBytesPerSec = 
		(pObj->mFormat.nSamplesPerSec) * (pObj->mFormat.wBitsPerSample/8);
	pObj->mFormat.nBlockAlign = 
		(pObj->mFormat.wBitsPerSample/8) * pObj->mFormat.nChannels;

	pObj->mHandle = NULL;
	pObj->mMyQ = HS_INVALID_QID;
	pObj->mIntoQ = HS_INVALID_QID;

	pObj->mStopping = FALSE;
	pObj->mDevOpened = FALSE;

	pObj->mWaveHeaderNumber = 0;
	return HS_OK;
}


RtpMicin *newm_RtpMicin(int mHertz)
{
	RtpMicin *tResult = NULL;

	if( (tResult=(RtpMicin*)HSMalloc(sizeof(RtpMicin)))==NULL )
		return NULL;
	if( new_RtpMicin(tResult,mHertz) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


HS_RESULT delete_RtpMicin(void *pObject)
{
	RtpMicin *pObj = (RtpMicin*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mHandle = NULL;
	pObj->mMyQ = HS_INVALID_QID;
	pObj->mIntoQ = HS_INVALID_QID;
	return HS_OK;
}


HS_RESULT deletem_RtpMicin(void *pObject)
{
	RtpMicin *pObj = (RtpMicin*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_RtpMicin(pObj);
	HSFree(pObj);
	return HS_OK;
}





/*
 *
 * RtpMicin thread member functions
 *
 */
void RtpMicin_Demon(void *pObject)
{
	MSG tQmsg;
	BOOL tThreadOut = FALSE;
	MMRESULT tRes;
	WAVEHDR *tWaveHeader = NULL;
	RtpMicin *pObj = (RtpMicin*)pObject;

	if( pObj==NULL ) return;

	while(tThreadOut==FALSE)
	{
		if( GetMessage(&tQmsg,NULL,MM_WIM_OPEN-1,HS_QM_RTP_MAX) )
		{
            switch(tQmsg.message)
			{
				case HS_QM_STOP:
					pObj->mStopping = TRUE;
					if( pObj->mWaveHeaderNumber==0 )
						tThreadOut = TRUE;
					break;
				case HS_QM_CHECK:
					HSPrint("\nthread checking> RtpMicin-live");
					break;
				case MM_WIM_OPEN:
					pObj->mDevOpened = TRUE;
					break;
				case MM_WIM_DATA:
					if( pObj->mDevOpened==FALSE ) break;
					if( (tWaveHeader=(WAVEHDR*)(tQmsg.lParam)) == NULL ) break;

					if( (tRes=waveInUnprepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR))) == MMSYSERR_NOERROR )
					{
						if( pObj->mStopping==FALSE && pObj->mIntoQ != HS_INVALID_QID )
							PostThreadMessage(pObj->mIntoQ,HS_QM_PCM,0,(LPARAM)tWaveHeader);
						else
							DestroyWaveHeader(tWaveHeader);
					}
					else
					{
						DestroyWaveHeader(tWaveHeader);
					}

					if( pObj->mWaveHeaderNumber != 0 )
						pObj->mWaveHeaderNumber--;

					if(pObj->mStopping==TRUE)
					{
						if( pObj->mWaveHeaderNumber==0 )
							tThreadOut = TRUE;
						break;
					}

					if( (tWaveHeader=CreateWaveHeader(pObj->mFormat.nBlockAlign * HS_SOUND_SAMPLES)) != NULL )
					{
						if( (tRes=waveInPrepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR))) == MMSYSERR_NOERROR )
						{
							waveInAddBuffer(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR));
							pObj->mWaveHeaderNumber++;
						}
					}
					break;

				case MM_WIM_CLOSE:
				default:
					break;
			}
		}
	}

	return;
}


unsigned __stdcall RtpMicin_Thread(void* pArg)
{
	HS_UINT i;
	MMRESULT tRes;
	LPWAVEHDR tWaveHeader = NULL;
	RtpMicin *pObj = (RtpMicin*)pArg;

	if( pObj == NULL )
	{
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex(0);
#endif
		return 0;
	}

	if( waveInOpen(
		&(pObj->mHandle),WAVE_MAPPER,&(pObj->mFormat),
		pObj->mMyQ,0,CALLBACK_THREAD
	))
	{
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex(0);
#endif
		return 0;
	}

	for(i=0; i<HS_MAX_MIC_BUFFER; i++)
	{
		if( (tWaveHeader=CreateWaveHeader(pObj->mFormat.nBlockAlign * HS_SOUND_SAMPLES)) != NULL )
		{
			if( (tRes=waveInPrepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR))) == MMSYSERR_NOERROR )
			{
				waveInAddBuffer(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR));
				pObj->mWaveHeaderNumber++;
			}
		}
	}

	if( (tRes=waveInStart(pObj->mHandle)) != MMSYSERR_NOERROR )
	{
		waveInClose(pObj->mHandle);
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex(0);
#endif
		return 0;
	}

	/* demon
	*/
	RtpMicin_Demon(pObj);

	tRes = waveInStop(pObj->mHandle);
	if(!tRes)
		tRes = waveInReset(pObj->mHandle);

	Sleep(200);
	if(!tRes)
		waveInClose(pObj->mHandle);

	deletem_RtpMicin(pObj);
	HSPrint("\nRtpMicin-End");

#ifdef _WIN32_WCE
	ExitThread(0);
#else
	_endthreadex(0);
#endif
	return 0;
}





HS_QID RtpMicin_Start(void *pObject)
{
	RtpMicin *pObj = (RtpMicin*)pObject;
	if( pObj==NULL ) return HS_INVALID_QID;

#ifdef _WIN32_WCE
	CreateThread(NULL,0,&RtpMicin_Thread,pObj,0,&(pObj->mMyQ));
#else
	_beginthreadex(NULL,0,&RtpMicin_Thread,pObj,0,&(pObj->mMyQ));
#endif

	/* give to mic thread some time for starting
	*/
	Sleep(200);

	return pObj->mMyQ;
}


HS_RESULT RtpMicin_Stop(void *pObject)
{
	RtpMicin *pObj = (RtpMicin*)pObject;
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMyQ == HS_INVALID_QID ) return HS_ERR;

	PostThreadMessage(pObj->mMyQ,HS_QM_STOP,(WPARAM)0,(LPARAM)NULL);
	return HS_OK;
}


HS_RESULT RtpMicin_Check(void *pObject)
{
	RtpMicin *pObj = (RtpMicin*)pObject;
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMyQ == HS_INVALID_QID ) return HS_ERR;

	PostThreadMessage(pObj->mMyQ,HS_QM_CHECK,(WPARAM)0,(LPARAM)NULL);
	return HS_OK;
}



