/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpDtmf.h>		2006-06-11,21:12

*/

#ifndef __2006_06_11__21_12__RTPDTMF_H__
#define __2006_06_11__21_12__RTPDTMF_H__





#define HS_PI					3.1415926535897932384626433832795029L

#define HS_CPT_DIAL_FREQ_X		440
#define HS_CPT_DIAL_FREQ_Y		350
#define HS_CPT_DIAL_TIME_X		1000
#define HS_CPT_DIAL_TIME_Y		0
#define HS_CPT_RINGBACK_FREQ_X	440
#define HS_CPT_RINGBACK_FREQ_Y	480
#define HS_CPT_RINGBACK_TIME_X	2000
#define HS_CPT_RINGBACK_TIME_Y	4000
#define HS_CPT_BUSY_FREQ_X		480
#define HS_CPT_BUSY_FREQ_Y		620
#define HS_CPT_BUSY_TIME_X		500
#define HS_CPT_BUSY_TIME_Y		500
#define HS_CPT_REORDER_FREQ_X	480
#define HS_CPT_REORDER_FREQ_Y	620
#define HS_CPT_REORDER_TIME_X	250
#define HS_CPT_REORDER_TIME_Y	250

#define HS_DTMF_FREQ_X1			697
#define HS_DTMF_FREQ_X2			770
#define HS_DTMF_FREQ_X3			852
#define HS_DTMF_FREQ_X4			941
#define HS_DTMF_FREQ_Y1			1209
#define HS_DTMF_FREQ_Y2			1336
#define HS_DTMF_FREQ_Y3			1477
#define HS_DTMF_FREQ_Y4			1633
/*
                    Y1             Y2             Y3             Y4

     X1 ----------> 1              2              3              (flash overide)

     X2 ----------> 4              5              6              (flash)

     X3 ----------> 7              8              9              (immediate/priority)

     X4 ----------> *              0              #              (none)
*/
#define DTMF_SIN(pos,f_x,f_y,bps,vol)				\
	(HS_UCHAR)(										\
	(sin(HS_PI*pos*f_x/bps) * vol) + (vol*2) +		\
	(sin(HS_PI*pos*f_y/bps) * vol) + (vol*2) )





typedef enum
{
	e_DtmfSignal_0,
	e_DtmfSignal_1,
	e_DtmfSignal_2,
	e_DtmfSignal_3,
	e_DtmfSignal_4,
	e_DtmfSignal_5,
	e_DtmfSignal_6,
	e_DtmfSignal_7,
	e_DtmfSignal_8,
	e_DtmfSignal_9,
	e_DtmfSignal_Star,
	e_DtmfSignal_Shap,
	e_DtmfSignal_FlashOverride,
	e_DtmfSignal_Flash,
	e_DtmfSignal_Priority,

	e_DtmfSignal_Dial,
	e_DtmfSignal_Ringback,
	e_DtmfSignal_Busy,
	e_DtmfSignal_Reorder,
	e_DtmfSignalMax
} DtmfSignal;


typedef struct
{
	DtmfSignal	mSignal;
	HS_UINT		mPos;
	HS_UINT		mBytesPerSec;
	HS_UINT		mVolume;	/*maximum:60*/

	HS_UINT		mFreqX;
	HS_UINT		mFreqY;
	HS_UINT		mTimeX;
	HS_UINT		mTimeY;
} RtpDtmf;


HS_RESULT new_RtpDtmf(void *pObject, DtmfSignal pSignal, HS_UINT pBPS, HS_UINT pVolume);
HS_RESULT delete_RtpDtmf(void *pObject);
RtpDtmf *newm_RtpDtmf(DtmfSignal pSignal, HS_UINT pBPS, HS_UINT pVolume);
HS_RESULT deletem_RtpDtmf(void *pObject);

HS_RESULT RtpDtmf_Generate(void *pObject, HS_UCHAR *pData, HS_UINT pSize);





#endif/*__2006_06_11__21_12__RTPDTMF_H__*/