/*--------------------------------------------------------------------------------*
 *                                                                                *
 * This material is strictly confidential and shall remain as such.               *
 *                                                                                *
 * Copyright  2004 - VoiceAge Corporation. All Rights Reserved. No part of this  *
 * material may be reproduced, stored in a retrieval system, or transmitted, in   *
 * any form or by any means: photocopying, electronic, mechanical, recording, or  *
 * otherwise, without the prior written permission of the copyright holder.       *
 *                                                                                *
 * This material is subject to continuous developments and improvements. All      *
 * warranties implied or expressed, including but not limited to implied          *
 * warranties of merchantability, or fitness for purpose, are excluded.           *
 *                                                                                *
 * ACELP is registered trademark of VoiceAge Corporation in Canada and / or other *
 * countries. Any unauthorized use is strictly prohibited.                        *
 *                                                                                *
 *--------------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h> 
#include <stdarg.h> 
#include <memory.h> 
#include "OS_depend_func.h"


//--------------------------------------------------------------------------------
//  OS dependent functions
//--------------------------------------------------------------------------------

void VA_printf( char *fmt, ...)
{
	va_list ap;
	char txbuf[256];

	va_start(ap,fmt);
	vsprintf(txbuf,fmt,ap);
	va_end(ap);
	printf("%s", txbuf);
}

void *VA_malloc(size_t n) { return(HSMalloc(n)); }
void VA_free(void *ptr) { HSFree(ptr); }
void *VA_realloc(void *ptr,size_t n) { return (realloc(ptr,n)); }
void *VA_memcpy(void *ptr1, const void *ptr2, size_t n) { return(memcpy(ptr1, ptr2, n)); }
void *VA_memset(void *ptr, int i, size_t n) { return (memset(ptr, i, n)); }
void *VA_calloc(size_t n, size_t t) { return (calloc(n, t)); }
void VA_fatal_error(int ec) { exit(ec); }
