/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<TimerHandler.c>	2005-05-22,21:08

*/

#include "TimerHandler.h"



/* RAS response message timeout
*/
HS_RESULT RasTransactionTimerHandler(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, HSTimerEvent *pTimerEvent)
{
	int tRasType;
	ChainUnit *tChain = HS_NULL;
	RasWaitSet *tWaitSet = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pCalls==HS_NULL ||
		pWaits==HS_NULL || pTimerEvent==HS_NULL ) return HS_ERR_NULL_PARAM;

	/* finding wait set
	*/
	tChain = NoLockList_FindRasWaitSetBySequenceNumber(pWaits,(HS_USHORT)(pTimerEvent->mSub));
	if( tChain == HS_NULL ) return HS_ERR_H323_NOTFOUND;
	if( (tWaitSet=(RasWaitSet*)(tChain->data)) == HS_NULL )
	{
		NoLockList_DeleteChain(pWaits, tChain);
		return HS_ERR_H323_NOTFOUND;
	}
	/* retransmission
	*/
	if( tWaitSet->retryCount > 0 )
	{
		SendRasMessage(pStack,tWaitSet);
		return HS_OK;
	}

	/* retransmission expired */

	/* get RAS message type
	*/
	tRasType = e_ASNH225RasMessageChoiceSizeExt;
	if( tWaitSet->raw != HS_NULL )
	{
		if( tWaitSet->raw[0]&0x80 != 0x00 )
			tRasType = tWaitSet->raw[0]&0x7F;
		else
			tRasType = ((tWaitSet->raw[0]&0x7C)>>2);
	}
	/* timeout callback
	*/
	if( pEndpoint->CallbackRasMessageTimeout != HS_NULL )
		pEndpoint->CallbackRasMessageTimeout(pStack,tWaitSet->handle,tRasType,tWaitSet->sequenceNumber);

	/* 1. registration timeout processing
	*/
	if( tRasType == e_ASNH225RasMessageChoice_gatekeeperRequest ||
		tRasType == e_ASNH225RasMessageChoice_registrationRequest
	)
	{
		if( pEndpoint->gatekeeper.registrar != HS_NULL )
		{
			delete_Registrar( pEndpoint->gatekeeper.registrar );
			HSFree( pEndpoint->gatekeeper.registrar );
			pEndpoint->gatekeeper.registrar = HS_NULL;
		}

		HSSetTimer(
			pEndpoint->gatekeeper.attemptTime*1000,
			pStack->h323DemonQ, HS_TID_REGISTER, 0, e_TimerType_Once
		);
	}
	/* 2. admission timeout processing
	*/
	else if( tRasType == e_ASNH225RasMessageChoice_admissionRequest )
	{
		ICall *tCall = HS_NULL;
		ChainUnit *tCallChain = HS_NULL;
		
		tCallChain = NoLockList_FindCallByHandle(pCalls, tWaitSet->handle);
		if( tCallChain != HS_NULL )
		{
			if( (tCall=(ICall*)(tCallChain->data)) != HS_NULL )
				CallClosing(
					pStack, pEndpoint, pCalls, pWaits, tCall, e_CallCloseReason_Admission,
					e_ASNH225DisengageReasonChoice_normalDrop, e_Q931CauseType_NormalCallClearing
				);
			else
				NoLockList_DeleteChain(pCalls, tCallChain);
		}
	}
	/* detete wait set
	*/
	NoLockList_DeleteChain(pWaits, tChain);
	return HS_OK;
}


/* registration TTL expired or registration retry timer expired
*/
HS_RESULT RegisterTimerHandler(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits)
{
	HS_RESULT tRet = HS_OK;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL ) return HS_ERR_NULL_PARAM;

	/* registration retry timer expired
	*/
	if( pEndpoint->gatekeeper.registrar == HS_NULL )
	{
		if( pEndpoint->CallbackRegistrationTimeout != HS_NULL )
			pEndpoint->CallbackRegistrationTimeout(pStack);

		return HS_OK;
	}

	/* registartion TTL expired
	*/
	if( pEndpoint->gatekeeper.registrar->registed == HS_YES )
	{
		/* lightweight RRQ
		*/
		if( (tRet=TryRegistration(pStack, pEndpoint, pWaits, TRUE)) == HS_OK )
			return HS_OK;
	}
	else
		tRet = HS_ERR_H323_CONFLICT;

	/* start registration retry timer
	*/
	delete_Registrar( pEndpoint->gatekeeper.registrar );
	HSFree( pEndpoint->gatekeeper.registrar );
	pEndpoint->gatekeeper.registrar = HS_NULL;

	HSSetTimer(
		pEndpoint->gatekeeper.attemptTime*1000,
		pStack->h323DemonQ, HS_TID_REGISTER, 0, e_TimerType_Once
	);

	return tRet;
}


/* irrFrequency timer expired
*/
HS_RESULT IRRTimerHandler(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, HSTimerEvent *pTimerEvent)
{
	HS_USHORT tSN;
	HS_RESULT tRet = HS_OK;
	RasMsg *tIrr = HS_NULL;
	ICall *tCall = HS_NULL;
	ChainUnit *tChain = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pCalls==HS_NULL ||
		pWaits==HS_NULL || pTimerEvent==HS_NULL ) return HS_ERR_NULL_PARAM;

	/* finding call
	*/
	if( (tChain=NoLockList_FindCallByHandle(pCalls, pTimerEvent->mSub)) == HS_NULL ) return HS_ERR_H323_NOTFOUND;
	if( (tCall=(ICall*)(tChain->data)) == HS_NULL )
	{
		NoLockList_DeleteChain(pCalls, tChain);
		return HS_ERR_H323_CONFLICT;
	}

	/* sending irr message
	*/
	if( (tIrr=MakeIRRwithTimer(pEndpoint, tCall, &tSN)) == HS_NULL ) return HS_ERR_H323_MAKE_MESSAGE;

	tRet = AttemptRasMessage(pStack, pEndpoint, pWaits, tCall->handle, HS_INVALID_RAS_SEQUENCE_NUMBER, tIrr);
	delete_RasMsg(tIrr);
	HSFree(tIrr);

	return tRet;
}
