/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<TcpConnect.c>		2005-03-27,16:42

*/

#include "TcpConnect.h"



unsigned __stdcall ConnectThread( void* pArg )
{
	HS_UINT				lDest;
	HS_SOCKET			tSock;
	struct sockaddr_in	tSockIn;

	QMTcpTry	*request = HS_NULL;
	QMConnected *tConnected = HS_NULL;

	if( (request=(QMTcpTry*)pArg) == HS_NULL )
	{
		_endthreadex(0);
		return 0;
	}

	if( (tSock=socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET )
		tConnected = new_QMConnected( HS_INVALID_SOCKET, request->handle );
	else
	{
		Uchar2Uint(&lDest, request->ip);
		memset( &tSockIn, 0, sizeof(tSockIn) );
		tSockIn.sin_family		= AF_INET;
		tSockIn.sin_addr.s_addr	= htonl( lDest );
		tSockIn.sin_port		= htons( request->port );

		if( connect(tSock,(struct sockaddr*)(&tSockIn),sizeof(tSockIn)) == 0 )
			tConnected = new_QMConnected( tSock, request->handle );
		else
			tConnected = new_QMConnected( HS_INVALID_SOCKET, request->handle );
	}

	PostThreadMessage(request->back, HS_QMESSAGE_CONNECTED, 0, (LPARAM)tConnected );
	delete_QMTcpTry(request);
	_endthreadex(0);
	return 0;
}



HS_RESULT HSConnect( HS_UCHAR *pDest, HS_USHORT pPort, HS_QUEUE_ID pQ, HS_CALL_HANDLE pHandle )
{
	HS_QUEUE_ID tQ;
	QMTcpTry *request = HS_NULL;

	if( pDest == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( (request=new_QMTcpTry(pDest,pPort,pQ,pHandle)) == HS_NULL ) return HS_ERR_H323_MALLOC;

	_beginthreadex( NULL, 0, &ConnectThread, request, 0, &(tQ) );
	return HS_OK;
}



HS_RESULT HSConnectEx( QMTcpTry *pTry )
{
	HS_QUEUE_ID tQ;

	if( pTry == HS_NULL ) return HS_ERR_NULL_PARAM;

	_beginthreadex( NULL, 0, &ConnectThread, pTry, 0, &(tQ) );
	return HS_OK;
}
