/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RasMessageMaker.h>		2005-03-13,11:45

*/

#ifndef __2005_03_13__11_45__RASMESSAGEMAKER_H__
#define __2005_03_13__11_45__RASMESSAGEMAKER_H__


#include "H323Define.h"
#include "EpDefine.h"
#include "CallMessageMaker.h"



/* endpoint RAS request messages
*/
RasMsg *MakeGRQ( IEndpoint *pEndpoint, HS_USHORT *pSN );
RasMsg *MakeRRQ( IEndpoint *pEndpoint, HS_USHORT *pSN );
RasMsg *MakeURQ( IEndpoint *pEndpoint, HS_USHORT *pSN );
RasMsg *MakeARQ( IEndpoint *pEndpoint, ICall *pCall, HS_USHORT *pSN );
RasMsg *MakeBRQ( IEndpoint *pEndpoint, ICall *pCall, HS_UINT pBandwidth, HS_USHORT *pSN );
RasMsg *MakeDRQ( IEndpoint *pEndpoint, ICall *pCall, ASNH225DisengageReasonChoice pReason, HS_USHORT *pSN );



/* endpoint RAS response messages:
	cause by
	FORCE URQ, DRQ and BRQ
	or IRQ for information from GK
	or receiving unknown message.
*/
RasMsg *MakeUCF( HS_USHORT pMsgSN );
RasMsg *MakeURJ( HS_USHORT pMsgSN, ASNH225UnregRejectReasonChoice pReason );
RasMsg *MakeDCF( HS_USHORT pMsgSN );
RasMsg *MakeDRJ( HS_USHORT pMsgSN, ASNH225DisengageRejectReasonChoice pReason );
RasMsg *MakeBCF( HS_USHORT pMsgSN, HS_UINT pBandwidth );
RasMsg *MakeBRJ( HS_USHORT pMsgSN, ASNH225BandRejectReasonChoice pReason, HS_UINT pBandwidth );
RasMsg *MakeXRS( HS_USHORT pMsgSN );
/* IRR message by IRQ that include unique CRV
*/
RasMsg *MakeIRRwithOne( IEndpoint *pEndpoint, HS_USHORT pMsgSN, ICall *pCall );
/* IRR message by IRQ that include '0' CRV
*/
RasMsg *MakeIRRwithAll( IEndpoint *pEndpoint, HS_USHORT pMsgSN, NoLockList *pCalls );
/* IRR message by UUIEsRequest Field on ACF
*/
RasMsg *MakeIRRwithPDU( IEndpoint *pEndpoint, ICall *pCall, ASNH225H323_UU_PDU *pPdu, BOOL pIsSent, HS_USHORT *pSN );
/* IRR message by irrFrequency Field on ACF
*/
RasMsg *MakeIRRwithTimer( IEndpoint *pEndpoint, ICall *pCall, HS_USHORT *pSN );



#endif/*__2005_03_13__11_45__RASMESSAGEMAKER_H__*/


