/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<QMessage.h>	2005-03-20,11:45

*/

#ifndef __2005_03_20__11_45__QMESSAGE_H__
#define __2005_03_20__11_45__QMESSAGE_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "H323Utility.h"



/****************************************************************************************/
/*
	User Command Messages : Command Message Type {
*/
#define HS_QMESSAGE_MAKE_CALL			HS_QM_USER+1	/* body is a ICall's Pointer */
#define HS_QMESSAGE_CHANGE_GK			HS_QM_USER+2	/* body is a Registrar's Pointer */


#define HS_QMESSAGE_ACCEPT_CALL			HS_QM_USER+3	/* body is a HS_CALL_HANDLE */
#define HS_QMESSAGE_REMOVE_CALL			HS_QM_USER+4
typedef struct
{
	CallCloseReason		reason;
	HS_CALL_HANDLE		handle;
} QMRemoveCall;
QMRemoveCall *new_QMRemoveCall(CallCloseReason pReason, HS_CALL_HANDLE pHandle );
void delete_QMRemoveCall( QMRemoveCall *pObj );


#define HS_QMESSAGE_USE_GRQ				HS_QM_USER+5	/* body is HS_YES or HS_NO */
#define HS_QMESSAGE_CHANGE_BANDWIDTH	HS_QM_USER+6	/* body is a HS_CALL_HANDLE */
typedef struct
{
	HS_UINT			bandwidth;
	HS_CALL_HANDLE	handle;
} QMBandwidth;
QMBandwidth *new_QMBandwidth( HS_UINT pBandwidth, HS_CALL_HANDLE pHandle );
void delete_QMBandwidth( QMBandwidth *pObj );


#define HS_QMESSAGE_H245USERINPUTINDICATION		HS_QM_USER+7
typedef struct
{
	ControlMsg *msg;
	HS_CALL_HANDLE handle;
} QMH245UserInputIndication;
QMH245UserInputIndication *new_QMH245UserInputIndication(ControlMsg *pMsg, HS_CALL_HANDLE pHandle);
void delete_QMH245UserInputIndication( QMH245UserInputIndication* pObj );


#define HS_QMESSAGE_CHANGE_ALIASES				HS_QM_USER+8	/*body is a NoLockList of AliasAddress*/


#define HS_QMESSAGE_USER_COMMAND_MAX			HS_QMESSAGE_CHANGE_ALIASES
/*
	User Command Messages : Command Message Type }
*/
/****************************************************************************************/


#define HS_QMESSAGE_MAKE_SOCKET_SET		HS_QMESSAGE_USER_COMMAND_MAX+1	/* lparam is a call handle */
#define HS_QMESSAGE_Q931_CONNECTED		HS_QMESSAGE_USER_COMMAND_MAX+2
#define HS_QMESSAGE_H245_CONNECTED		HS_QMESSAGE_USER_COMMAND_MAX+3

#define HS_QMESSAGE_RECV_RAS_MESSAGE	HS_QMESSAGE_USER_COMMAND_MAX+4
typedef struct
{
	HS_UCHAR	*raw;
	int			len;
} QMRasMessage;
QMRasMessage *new_QMRasMessage( HS_UCHAR *pRaw, int pLen );
void delete_QMRasMessage( QMRasMessage *pObj );



/*
	ENET -> H323 : Receive Event
	H323 -> ENET : Send Command
*/
#define HS_QMESSAGE_Q931_MESSAGE	HS_QMESSAGE_USER_COMMAND_MAX+5
#define HS_QMESSAGE_H245_MESSAGE	HS_QMESSAGE_USER_COMMAND_MAX+6
typedef struct
{
	HS_UCHAR	*raw;
	int			len;
	HS_CALL_HANDLE	handle;
} QMTcpMessage;
QMTcpMessage *new_QMTcpMessage( HS_UCHAR *pRaw, int pLen, HS_CALL_HANDLE pHandle );
void delete_QMTcpMessage( QMTcpMessage *pObj );


#define HS_QMESSAGE_TRY_CONNECT			HS_QMESSAGE_USER_COMMAND_MAX+7
#define HS_QMESSAGE_TRY_LISTEN			HS_QMESSAGE_USER_COMMAND_MAX+8

#define HS_QMESSAGE_Q931_ACCEPTED		HS_QMESSAGE_USER_COMMAND_MAX+9
#define HS_QMESSAGE_H245_ACCEPTED		HS_QMESSAGE_USER_COMMAND_MAX+10
typedef struct
{
	HS_UCHAR	ip[4];
	HS_USHORT	port;

	HS_SOCKET		socket;
	HS_CALL_HANDLE	handle;
} QMAccepted;
QMAccepted *new_QMAccepted( HS_SOCKET pSocket, HS_CALL_HANDLE pHandle );
void delete_QMAccepted( QMAccepted *pObj );
HS_RESULT SockAddr2QMAccepted( QMAccepted *pTo, struct sockaddr_in *pFrom );



#define HS_QMESSAGE_Q931_CLOSE			HS_QMESSAGE_USER_COMMAND_MAX+11	/*lparam is a call handle*/
#define HS_QMESSAGE_H245_CLOSE			HS_QMESSAGE_USER_COMMAND_MAX+12	/*lparam is a call handle*/
#define HS_QMESSAGE_REMOVE_SOCKET_SET	HS_QMESSAGE_USER_COMMAND_MAX+13	/*lparam is a call handle*/





#if 0
#define HS_QMESSAGE_MAKE_CALL			HS_QMESSAGE+1	/* body is a ICall's Pointer */
#define HS_QMESSAGE_CHANGE_GK			HS_QMESSAGE+2	/* body is a Registrar's Pointer */
#define HS_QMESSAGE_REMOVE_CALL			HS_QMESSAGE+3
#define HS_QMESSAGE_USE_GRQ				HS_QMESSAGE+4	/* body is HS_YES or HS_NO */
#define HS_QMESSAGE_USER_COMMAND_MAX	HS_QMESSAGE_USE_GRQ
#define HS_QMESSAGE_TIMER				HS_QMESSAGE_USER_COMMAND_MAX+1	/* lparam is a timer ID */
#define HS_QMESSAGE_MAKE_SOCKET_SET		HS_QMESSAGE_USER_COMMAND_MAX+2	/* lparam is a call handle */
#define HS_QMESSAGE_CONNECTED			HS_QMESSAGE_USER_COMMAND_MAX+3
#define HS_QMESSAGE_Q931_CONNECTED		HS_QMESSAGE_USER_COMMAND_MAX+4
#define HS_QMESSAGE_H245_CONNECTED		HS_QMESSAGE_USER_COMMAND_MAX+5
#define HS_QMESSAGE_RECV_RAS_MESSAGE	HS_QMESSAGE_USER_COMMAND_MAX+6
#define HS_QMESSAGE_Q931_MESSAGE		HS_QMESSAGE_USER_COMMAND_MAX+7
#define HS_QMESSAGE_H245_MESSAGE		HS_QMESSAGE_USER_COMMAND_MAX+8
#define HS_QMESSAGE_TRY_CONNECT			HS_QMESSAGE_USER_COMMAND_MAX+9
#define HS_QMESSAGE_TRY_LISTEN			HS_QMESSAGE_USER_COMMAND_MAX+10
#define HS_QMESSAGE_Q931_ACCEPTED		HS_QMESSAGE_USER_COMMAND_MAX+11	/*lparam is a call handle*/
#define HS_QMESSAGE_H245_ACCEPTED		HS_QMESSAGE_USER_COMMAND_MAX+12	/*lparam is a call handle*/
#define HS_QMESSAGE_Q931_CLOSE			HS_QMESSAGE_USER_COMMAND_MAX+13	/*lparam is a call handle*/
#define HS_QMESSAGE_H245_CLOSE			HS_QMESSAGE_USER_COMMAND_MAX+14	/*lparam is a call handle*/
#define HS_QMESSAGE_REMOVE_SOCKET_SET	HS_QMESSAGE_USER_COMMAND_MAX+15	/*lparam is a call handle*/
#define HS_QMESSAGE_START_THREAD		HS_QMESSAGE_USER_COMMAND_MAX+16	/*lparam is a StackInfo pointer*/
#define HS_QMESSAGE_END_THREAD			HS_QMESSAGE_USER_COMMAND_MAX+17	/*no parameter*/
#define HS_QMESSAGE_MAX					HS_QMESSAGE_USER_COMMAND_MAX+18
#endif

#endif/*__2005_03_20__11_45__QMESSAGE_H__*/



