/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<MessageUtility.h>	2005-04-17,10:37

*/

#ifndef __2005_04_17__10_37__MESSAGEUTILITY_H__
#define __2005_04_17__10_37__MESSAGEUTILITY_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "ICall.h"
#include "RasWaitSet.h"
#include "EnetDemon.h"



/**********************************************************************************/
/* protocol message sending process
*/
/* RAS message sending function
*/
HS_RESULT SendRasMessage(StackInfo *pStack, RasWaitSet *pWaitSet);
/* send RAS message object to ethernet:
	check user callback functions, asn encoding,
	attach #RasWaitSet#(if request) and send rawdata on ethernet.
	NOTE : if the #pSN# parameter is 0(invalid requestSeqNum) mean that 'message is not a request'.
*/
HS_RESULT AttemptRasMessage(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, HS_CALL_HANDLE pHandle, HS_USHORT pSN, ASNH225RasMessage *pMsg);

/* Q.931 message sending function
*/
BOOL	  IsIRRwithPDU(ASNH225H323_UU_PDU_h323_message_bodyChoice pChoice, ASNH225UUIEsRequested *pRequested);
HS_RESULT StartIRRTimer(StackInfo *pStack, ICall *pCall);
HS_RESULT StopIRRTimer(ICall *pCall);
HS_RESULT AttemptQ931Message(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, Q931Message *pMsg, ICall *pCall);

/* H.245 message sending function
*/
HS_RESULT AttemptH245Message(StackInfo *pStack, IEndpoint *pEndpoint, ControlMsg *pMsg, ICall *pCall);



/**************************************************************************************/
/* h245 processing
*/
/*discharging :
	h245 message will be charged for preparation tunneling mode.
*/
HS_RESULT DischargeH245Message(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);

/*tunneling*/
HS_RESULT TunnelingH245Message(IEndpoint *pEndpoint, ICall *pCall, ASNH225H323_UserInformation *pMsg);



/**************************************************************************************/
/* media negotiation
*/
/*by FastStart*/
HS_RESULT AddForwardFastStart(void *pCall, ASNH245OpenLogicalChannel *pOlc);
HS_RESULT AddReverseFastStart(void *pCall, ASNH245OpenLogicalChannel *pOlc);
HS_RESULT CheckFastStart(AsnSequenceOf *pSequenceOf, ICall *pCall);
HS_RESULT OpenMediaWithFastStart(StackInfo *pStack, IEndpoint *pEndpoint, ICall *pCall);
HS_RESULT CloseMediaWithFastStart(StackInfo *pStack, IEndpoint *pEndpoint, ICall *pCall);

/*by TerminalCapabilitySet*/
HS_RESULT AddOpenLogicalChannel(IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapa);
HS_RESULT AddOpenLogicalChannelEx(IEndpoint *pEndpoint, ICall *pCall, HS_UINT pIndex);
HS_RESULT CheckTerminalCapabilitySet(StackInfo *pStack, IEndpoint *pEndpoint, ICall *pCall, ASNH245TerminalCapabilitySet *pTcs);
/* NO!    OpenMedia(...) : media channel by h245 channel is separately process,
						so, there is no OpenMedia FUNCTION.  it's functional process
						lie on (Send)H245OpenLogicalChannelAckHandler FUNCTION.
*/
/*use in receiving H.245 CloseLogicalChannel Message*/
HS_RESULT CloseMediaUnit(OpenLogicalChannelSet *pOlcSet, IEndpoint *pEndpoint, ICall *pCall, BOOL isSending);
HS_RESULT CloseMedia(StackInfo *pStack, IEndpoint *pEndpoint, ICall *pCall);



#endif/*__2005_04_17__10_37__MESSAGEUTILITY_H__*/


