/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IEndpoint.h>	2005-03-13,14:51

*/

#ifndef __2005_03_13__14_51__IENDPOINT_H__
#define __2005_03_13__14_51__IENDPOINT_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "ICapability.h"
#include "IGatekeeper.h"



typedef enum
{
	e_EndpointType_terminal = 50,
	e_EndpointType_gateway = 60
} EndpointType;


typedef struct
{
	IGatekeeper		gatekeeper;

	EndpointType			type;

	ASNH225TransportAddress	csaTsap;
	ASNH225TransportAddress	rasTsap;
	HS_USHORT				callListenPort;
	HS_USHORT				rasListenPort;
	
	NoLockList				aliases;

	unsigned char	countryCode;
	unsigned char	extensionCode;
	unsigned short	manufactureCode;
	char productId[HS_MAX_LETTER];
	char versionId[HS_MAX_LETTER];

	HS_USHORT rasSN;
	HS_USHORT h245ListenPort;
	HS_USHORT rtpListenPort;

	/* Callback Function Pointer */
	void (*CallbackStackError)(HS_STACK_HANDLE,int pReason);
	BOOL (*CallbackReceiveRasRawData)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);
	BOOL (*CallbackReceiveRasMessage)(HS_STACK_HANDLE,HS_CALL_HANDLE,RasMsg*);
	BOOL (*CallbackReceiveQ931RawData)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);
	BOOL (*CallbackReceiveQ931Message)(HS_STACK_HANDLE,HS_CALL_HANDLE,Q931Message*);
	BOOL (*CallbackReceiveH245RawData)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);
	BOOL (*CallbackReceiveH245Message)(HS_STACK_HANDLE,HS_CALL_HANDLE,ControlMsg*);
	BOOL (*CallbackSendRasMessage)(HS_STACK_HANDLE,HS_CALL_HANDLE,RasMsg*);
	BOOL (*CallbackSendRasRawData)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);
	BOOL (*CallbackSendQ931Message)(HS_STACK_HANDLE,HS_CALL_HANDLE,Q931Message*);
	BOOL (*CallbackSendQ931RawData)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);
	BOOL (*CallbackSendH245Message)(HS_STACK_HANDLE,HS_CALL_HANDLE,ControlMsg*);
	BOOL (*CallbackSendH245RawData)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);

	void (*CallbackException)(HSException,HS_RESULT);
	void (*CallbackAsnDecodingError)(HS_STACK_HANDLE,HS_CALL_HANDLE,AsnStream*);

	void (*CallbackRasMessageTimeout)(HS_STACK_HANDLE,HS_CALL_HANDLE,ASNH225RasMessageChoice,HS_USHORT);
	void (*CallbackRegistrationTimeout)(HS_STACK_HANDLE);

	HS_RESULT (*CallbackCheckFastStart)(AsnSequenceOf*,NoLockList*,void*);
	HS_RESULT (*CallbackCheckTerminalCapabilitySet)(HS_STACK_HANDLE,void*,void*,ASNH245TerminalCapabilitySet*);
	void (*CallbackOpenReceiveMedia)(HS_CALL_HANDLE,HS_USHORT,HS_USHORT,ASNH245DataType*);
	void (*CallbackOpenSendMedia)(HS_CALL_HANDLE,struct sockaddr_in,struct sockaddr_in,ASNH245DataType*);
	void (*CallbackCloseReceiveMedia)(HS_CALL_HANDLE,ASNH245DataType*);
	void (*CallbackCloseSendMedia)(HS_CALL_HANDLE,ASNH245DataType*);

	void (*CallbackCallIncoming)(HS_STACK_HANDLE,void*);
	void (*CallbackCallRemoved)(HS_CALL_HANDLE,CallCloseReason,Q931CauseType);
} IEndpoint;

HS_RESULT new_IEndpoint( IEndpoint *pObj );
IEndpoint *newm_IEndpoint();
HS_RESULT delete_IEndpoint( IEndpoint *pObj );

HS_USHORT IEndpoint_MakeRasRequestSequenceNumber( IEndpoint *pObj );
HS_RESULT IEndpoint_MakeIdentifierOfCall( IEndpoint *pObj, HS_UCHAR *pCallId, HS_UCHAR *pConfId );

HS_UINT IEndpoint_MakeH245ListenPort( IEndpoint *pObj );
HS_UINT IEndpoint_MakeRTPListenPort( IEndpoint *pObj );

#endif/*__2005_03_13__14_51__IENDPOINT_H__*/


