/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ICapability.c>		2005-03-13,17:02

*/

#include "ICapability.h"



/***************************************************************/
/* Capability member
*/
/* new_Capability */
HS_RESULT new_ICapability( ICapability *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	pObj->simul = HS_UINT_MAX;
	new_ASNH245Capability( &(pObj->capability) );
	ASNH245Capability_MakeMold( &(pObj->capability) );
	return HS_OK;
}


/* delete_Capability */
HS_RESULT delete_ICapability( ICapability *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	return delete_ASNH245Capability( &(pObj->capability) );
}





/****************************************************************/
/* Capabilities member
*/
#define HS_MAX_SIMUL_TABLE		64
#define HS_MAX_SIMUL_UNIT		128
typedef struct
{
	unsigned short simulUnit[HS_MAX_SIMUL_UNIT];
	HS_UINT size;
	HS_UINT simul;
} SimultaneousUnit;


/* ICapabilities_MakeTCS */
HS_RESULT ICapabilities_MakeTCS( NoLockList *pObj, ASNH245TerminalCapabilitySet *tcs )
{
	HS_UINT i, j;
	HS_RESULT tRet;
	ICapability *capa = HS_NULL;
	ChainUnit *rounder = HS_NULL;
	ASNH245CapabilityTableEntry *cte = HS_NULL;
	ASNH245CapabilityDescriptor *descriptor = HS_NULL;
	ASNH245AlternativeCapabilitySet *acs = HS_NULL;
	ASNH245CapabilityTableEntryNumber *cten = HS_NULL;

	SimultaneousUnit	simulTable[HS_MAX_SIMUL_TABLE];
	HS_UINT				simulTableSize=0;

	if( pObj == HS_NULL || tcs == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( (tRet=AsnSequenceOf_SetSize( &(tcs->m_capabilityTable), pObj->size )) != HS_OK ) return tRet;

	for( j=0; j<HS_MAX_SIMUL_TABLE; j++ )
	{
		simulTable[j].size = 0;
		simulTable[j].simul = HS_UINT_MAX;
	}


	ASNH245TerminalCapabilitySet_IncludeOptionField( tcs, e_ASNH245TerminalCapabilitySetOptionMap_capabilityTable );

	rounder = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_ERR_ASN_CONFLICT;
		if( rounder->data == HS_NULL ) return HS_ERR_ASN_CONFLICT;

		capa = (ICapability*)(rounder->data);
		cte = (ASNH245CapabilityTableEntry*)AsnSequenceOf_GetUnit(&(tcs->m_capabilityTable),i);
		if( cte == HS_NULL ) return HS_ERR_INVALID_VALUE;
		AsnInteger_SetValue( &(cte->m_capabilityTableEntryNumber.inheritance), i+1120 );

		ASNH245CapabilityTableEntry_IncludeOptionField( cte, e_ASNH245CapabilityTableEntryOptionMap_capability );
		tRet=ASNH245Capability_Copy( &(cte->m_capability), &(capa->capability) );
		if( tRet != HS_OK ) return tRet;

		if( simulTableSize == 0 )
		{
			simulTable[0].simul = capa->simul;
			simulTable[0].simulUnit[ simulTable[0].size++ ] = i+1120;
			simulTableSize = 1;
		}
		else
		{
			for( j=0; j<simulTableSize; j++ )
			{
				if( simulTable[j].simul == capa->simul )
				{
					simulTable[j].simulUnit[ simulTable[j].size++ ] = i+1120;
					break;
				}
			}

			if( j == simulTableSize )
			{
				simulTable[ simulTableSize ].simul = capa->simul;
				simulTable[ simulTableSize ].simulUnit[ simulTable[simulTableSize].size++ ] = i + 1120;
				simulTableSize ++;
			}
		}

		rounder = rounder->next;
	}


	ASNH245TerminalCapabilitySet_IncludeOptionField( tcs, e_ASNH245TerminalCapabilitySetOptionMap_capabilityDescriptors );

	AsnSequenceOf_SetSize( &(tcs->m_capabilityDescriptors), 1 );
	descriptor = (ASNH245CapabilityDescriptor*)
		AsnSequenceOf_GetUnit( &(tcs->m_capabilityDescriptors), 0 );

	if( descriptor == HS_NULL ) return HS_ERR_INVALID_VALUE;

	AsnInteger_SetValue( &(descriptor->m_capabilityDescriptorNumber.inheritance), 1 );

	ASNH245CapabilityDescriptor_IncludeOptionField( descriptor, e_ASNH245CapabilityDescriptorOptionMap_simultaneousCapabilities );
	AsnSequenceOf_SetSize( &(descriptor->m_simultaneousCapabilities), simulTableSize );

	for( i=0; i<simulTableSize; i++ )
	{
		acs = (ASNH245AlternativeCapabilitySet*)AsnSequenceOf_GetUnit( &(descriptor->m_simultaneousCapabilities), i );
		if( acs == HS_NULL ) return HS_ERR_INVALID_VALUE;

		AsnSequenceOf_SetSize( &(acs->inheritance), simulTable[i].size );
		for( j=0; j<simulTable[i].size; j++ )
		{
			cten = (ASNH245CapabilityTableEntryNumber*)AsnSequenceOf_GetUnit( &(acs->inheritance), j );
			if( cten == HS_NULL ) return HS_ERR_INVALID_VALUE;

			AsnInteger_SetValue( &(cten->inheritance), simulTable[i].simulUnit[j] );
		}
	}

	return HS_OK;
}



/**********************************************************************/
/* Compare Functions
*/
BOOL CompareCapability( ASNH245Capability *pCapa1, ASNH245Capability *pCapa2 )
{
	if( pCapa1 == HS_NULL || pCapa2 == HS_NULL ) return HS_NO;

	switch( pCapa1->choice )
	{
		case e_ASNH245CapabilityChoice_receiveVideoCapability:
		case e_ASNH245CapabilityChoice_transmitVideoCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability:
			if( pCapa2->choice == e_ASNH245CapabilityChoice_receiveVideoCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_transmitVideoCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability
			) return CompareVideoCapability( pCapa1->alter, pCapa2->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveAudioCapability:
		case e_ASNH245CapabilityChoice_transmitAudioCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability:
			if( pCapa2->choice == e_ASNH245CapabilityChoice_receiveAudioCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_transmitAudioCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability
			) return CompareAudioCapability( pCapa1->alter, pCapa2->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveDataApplicationCapability:
		case e_ASNH245CapabilityChoice_transmitDataApplicationCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability:
			if( pCapa2->choice == e_ASNH245CapabilityChoice_receiveDataApplicationCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_transmitDataApplicationCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability
			) return CompareDataApplicationCapability( pCapa1->alter, pCapa2->alter );
			break;
	}
	return HS_NO;
}


BOOL CompareCapabilityWithDataType( ASNH245Capability *pCapa, ASNH245DataType *pType )
{
	if( pCapa == HS_NULL || pType == HS_NULL ) return HS_NO;

	switch( pCapa->choice )
	{
		case e_ASNH245CapabilityChoice_receiveVideoCapability:
		case e_ASNH245CapabilityChoice_transmitVideoCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability:
			if( pType->choice == e_ASNH245DataTypeChoice_videoData )
				return CompareVideoCapability( pCapa->alter, pType->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveAudioCapability:
		case e_ASNH245CapabilityChoice_transmitAudioCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability:
			if( pType->choice == e_ASNH245DataTypeChoice_audioData )
				return CompareAudioCapability( pCapa->alter, pType->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveDataApplicationCapability:
		case e_ASNH245CapabilityChoice_transmitDataApplicationCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability:
			if( pType->choice == e_ASNH245DataTypeChoice_data )
				return CompareDataApplicationCapability( pCapa->alter, pType->alter );
			break;
	}
	return HS_NO;
}


BOOL CompareAudioCapability( ASNH245AudioCapability *pAudio1, ASNH245AudioCapability *pAudio2 )
{
	if( pAudio1==HS_NULL || pAudio2==HS_NULL ) return HS_NO;
	if( pAudio1->choice != pAudio2->choice ) return HS_NO;

	switch( pAudio1->choice )
	{
		case e_ASNH245AudioCapabilityChoice_nonStandard:	break;
		case e_ASNH245AudioCapabilityChoice_g711Alaw64k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g711Alaw56k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g711Ulaw64k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g711Ulaw56k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g722_64k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g722_56k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g722_48k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g7231:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g728:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g729:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g729AnnexA:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_is11172AudioCapability:
		case e_ASNH245AudioCapabilityChoice_is13818AudioCapability:	break;
		case e_ASNH245AudioCapabilityChoice_g729wAnnexB:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g7231AnnexCCapability:
		case e_ASNH245AudioCapabilityChoice_gsmFullRate:
		case e_ASNH245AudioCapabilityChoice_gsmHalfRate:
		case e_ASNH245AudioCapabilityChoice_gsmEnhancedFullRate:
		case e_ASNH245AudioCapabilityChoice_genericAudioCapability:
		case e_ASNH245AudioCapabilityChoice_g729Extensions:	break;
	}
	return HS_NO;
}


BOOL CompareVideoCapability( ASNH245VideoCapability *pVideo1, ASNH245VideoCapability *pVideo2 )
{
	if( pVideo1==HS_NULL || pVideo2==HS_NULL ) return HS_NO;
	if( pVideo1->choice != pVideo2->choice ) return HS_NO;

	switch( pVideo1->choice )
	{
		case e_ASNH245VideoCapabilityChoice_nonStandard:
		case e_ASNH245VideoCapabilityChoice_h261VideoCapability:
		case e_ASNH245VideoCapabilityChoice_h262VideoCapability:
		case e_ASNH245VideoCapabilityChoice_h263VideoCapability:
		case e_ASNH245VideoCapabilityChoice_is11172VideoCapability:
		case e_ASNH245VideoCapabilityChoice_genericVideoCapability:	break;
	}
	return HS_NO;
}


BOOL CompareDataApplicationCapability(
	ASNH245DataApplicationCapability *pData1,
	ASNH245DataApplicationCapability *pData2
)
{
	if( pData1==HS_NULL || pData2==HS_NULL ) return HS_NO;
	if( pData1->m_application.choice != pData2->m_application.choice ) return HS_NO;

	switch( pData1->m_application.choice )
	{
		case e_ASNH245DataApplicationCapability_applicationChoice_nonStandard:
		case e_ASNH245DataApplicationCapability_applicationChoice_t120:
		case e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc:
		case e_ASNH245DataApplicationCapability_applicationChoice_userData:
		case e_ASNH245DataApplicationCapability_applicationChoice_t84:
		case e_ASNH245DataApplicationCapability_applicationChoice_t434:
		case e_ASNH245DataApplicationCapability_applicationChoice_h224:
		case e_ASNH245DataApplicationCapability_applicationChoice_nlpid:
		case e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl:
		case e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning:
		case e_ASNH245DataApplicationCapability_applicationChoice_t30fax:
		case e_ASNH245DataApplicationCapability_applicationChoice_t140:
		case e_ASNH245DataApplicationCapability_applicationChoice_t38fax:
		case e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability:	break;
	}
	return HS_NO;
}








/*set capabilities of endpoint
*/
/*
	Integer Factor Audio Codec List
	===============================
	g711Alaw64k		g711Alaw56k
	g711Ulaw64k		g711Ulaw56k
	g722-64k		g722-56k
	g722-48k		g728
	g729			g729AnnexA
	g729wAnnexB		g729AnnexAwAnnexB
*/
/* ICapabilities_AddIntegerFactor */
HS_RESULT ICapabilities_AddIntegerFactor( NoLockList *pObj, HS_UINT pSimul, IntegerFactor pFactor, HS_UCHAR pValue )
{
	ICapability *capa = HS_NULL;
	ASNH245AudioCapability *aCapa = HS_NULL;

	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	capa = (ICapability*)HSMalloc( sizeof(ICapability) );
	new_ICapability( capa );

	capa->simul = pSimul;
	aCapa = (ASNH245AudioCapability *)ASNH245Capability_SetChoice( &(capa->capability), e_ASNH245CapabilityChoice_receiveAudioCapability );

	if( aCapa != HS_NULL )
	{
		AsnInteger *tInteger = HS_NULL;
		switch( pFactor )
		{
			case e_IntegerFactor_g711Alaw64k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g711Alaw64k );
				break;
			case e_IntegerFactor_g711Alaw56k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g711Alaw56k );
				break;
			case e_IntegerFactor_g711Ulaw64k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g711Ulaw64k );
				break;
			case e_IntegerFactor_g711Ulaw56k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g711Ulaw56k );
				break;
			case e_IntegerFactor_g722_64k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g722_64k );
				break;
			case e_IntegerFactor_g722_56k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g722_56k );
				break;
			case e_IntegerFactor_g722_48k:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g722_48k );
				break;
			case e_IntegerFactor_g728:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g728 );
				break;
			case e_IntegerFactor_g729:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g729 );
				break;
			case e_IntegerFactor_g729AnnexA:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g729AnnexA );
				break;
			case e_IntegerFactor_g729wAnnexB:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g729wAnnexB );
				break;
			case e_IntegerFactor_g729AnnexAwAnnexB:
				tInteger = (AsnInteger *)ASNH245AudioCapability_SetChoice( aCapa, e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB );
				break;
			default:
				delete_ICapability( capa );
				HSFree( capa );
				return HS_ERR_INVALID_VALUE;
		}

		if( tInteger == HS_NULL ) return HS_ERR_INVALID_VALUE;
		AsnInteger_SetValue( tInteger, (HS_UINT)pValue );
	}
	else
	{
		delete_ICapability( capa );
		HSFree( capa );
		return HS_ERR_INVALID_VALUE;
	}

	return NoLockList_AttachData( pObj, capa );
}


/* ICapabilities_FindIntegerFactor */
ChainUnit *ICapabilities_FindIntegerFactor( NoLockList *pObj, HS_UINT pSimul, IntegerFactor pFactor )
{
	HS_UINT i;
	ChainUnit *rounder = HS_NULL;
	ICapability *capa = HS_NULL;

	if( pObj == HS_NULL ) return HS_NULL;
	if( pObj->size == 0 ) return HS_NULL;
	
	rounder = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_NULL;
		if( rounder->data == HS_NULL ) return HS_NULL;

		capa = (ICapability *)(rounder->data);

		if( capa->simul != pSimul ) continue;
		if( capa->capability.choice == e_ASNH245CapabilityChoice_receiveAudioCapability )
		{
			ASNH245AudioCapability *aCapa = (ASNH245AudioCapability *)(capa->capability.alter);
			if( aCapa != HS_NULL )
			{
				switch( pFactor )
				{
					case e_IntegerFactor_g711Alaw64k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g711Alaw64k ) return rounder;
						break;
					case e_IntegerFactor_g711Alaw56k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g711Alaw56k ) return rounder;
						break;
					case e_IntegerFactor_g711Ulaw64k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g711Ulaw64k ) return rounder;
						break;
					case e_IntegerFactor_g711Ulaw56k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g711Ulaw56k ) return rounder;
						break;
					case e_IntegerFactor_g722_64k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g722_64k ) return rounder;
						break;
					case e_IntegerFactor_g722_56k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g722_56k ) return rounder;
						break;
					case e_IntegerFactor_g722_48k:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g722_48k ) return rounder;
						break;
					case e_IntegerFactor_g728:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g728 ) return rounder;
						break;
					case e_IntegerFactor_g729:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g729 ) return rounder;
						break;
					case e_IntegerFactor_g729AnnexA:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g729AnnexA ) return rounder;
						break;
					case e_IntegerFactor_g729wAnnexB:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g729wAnnexB ) return rounder;
						break;
					case e_IntegerFactor_g729AnnexAwAnnexB:
						if( aCapa->choice == e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB ) return rounder;
						break;
					default:
						return HS_NULL;
				}/*switch*/
			}/* aCapa==NULL */
		}/*audioCapa*/
	}

	return HS_NULL;
}


/* ICapabilities_DeleteIntegerFactor */
HS_RESULT ICapabilities_DeleteIntegerFactor( NoLockList *pObj, HS_UINT pSimul, IntegerFactor pFactor )
{
	ChainUnit *tUnit = ICapabilities_FindIntegerFactor( pObj, pSimul, pFactor );
	
	if( tUnit != HS_NULL )
		return NoLockList_DeleteChain( pObj, tUnit );

	return HS_ERR_INVALID_VALUE;
}


/* ICapabilities_AddG7231 */
HS_RESULT  ICapabilities_AddG7231( NoLockList *pObj, HS_UINT pSimul, HS_UCHAR pMaxAl, BOOL pSilence )
{
	ICapability *capa = HS_NULL;
	ASNH245AudioCapability *aCapa = HS_NULL;
	ASNH245AudioCapability_g7231 *tG7231 = HS_NULL;

	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( (capa=(ICapability*)HSMalloc(sizeof(ICapability))) == HS_NULL ) return HS_ERR_H323_MALLOC;
	if( new_ICapability(capa) != HS_OK )
	{
		HSFree(capa);
		return HS_ERR_H323;
	}

	capa->simul = pSimul;
	aCapa = (ASNH245AudioCapability *)ASNH245Capability_SetChoice( &(capa->capability), e_ASNH245CapabilityChoice_receiveAudioCapability );
	if( aCapa == HS_NULL )
	{
		delete_ICapability(capa);
		HSFree(capa);
		return HS_ERR_H323;
	}

	tG7231 = (ASNH245AudioCapability_g7231*)
		ASNH245AudioCapability_SetChoice(aCapa, e_ASNH245AudioCapabilityChoice_g7231);
	if( tG7231 == HS_NULL )
	{
		delete_ICapability(capa);
		HSFree(capa);
		return HS_ERR_H323;
	}

	AsnInteger_SetValue( &(tG7231->m_maxAl_sduAudioFrames), pMaxAl );
	tG7231->m_silenceSuppression.value = pSilence;

	if( NoLockList_AttachData(pObj, capa) != HS_OK )
	{
		delete_ICapability(capa);
		HSFree(capa);
		return HS_ERR_H323;
	}

	return HS_OK;
}