/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<iCall.h>	2005-03-13,16:36

*/

#ifndef __2005_03_13__16_36__ICALL_H__
#define __2005_03_13__16_36__ICALL_H__



#if defined(_WIN32) || defined(_WIN32_WCE)
#include <winsock.h>
#endif

#include "H323Define.h"
#include "EpDefine.h"
#include "IEndpoint.h"



typedef enum
{
	e_RouteState_Idle,
	e_RouteState_Direct,
	e_RouteState_Route,
} RouteState;


typedef enum
{
	e_Q931State_Idle,
	e_Q931State_ReadySetup,		/*called*/
	e_Q931State_Setup,			/*caller*/
	e_Q931State_CallProceed,	/*caller*/
	e_Q931State_Alert,			/*caller*/
	e_Q931State_ReadyConnect,	/*called*/
	e_Q931State_Connect,		/*caller / called*/
	e_Q931StateMax
} Q931State;


typedef struct
{
	BOOL sAudio;
	BOOL rAudio;
	BOOL sVideo;
	BOOL rVideo;
	BOOL sData;
	BOOL rData;
} MediaChannelState;
HS_RESULT new_MediaChannelState(MediaChannelState *pObj);
HS_RESULT delete_MediaChannelState(MediaChannelState *pObj);



typedef enum
{
	e_MasterSlaveState_Idle,
	e_MasterSlaveState_Master,
	e_MasterSlaveState_Slave
} MasterSlaveState;


typedef enum
{
	e_H245ListenPoint_Idle,
	e_H245ListenPoint_Setup,
	e_H245ListenPoint_CallProceed,
	e_H245ListenPoint_Alert,
	e_H245ListenPoint_Connect,
	e_H245ListenPoint_Facility/*,
	e_H245ListenPoint_Progress*/
} H245ListenPoint;


typedef enum
{
	e_FastStartResponsePoint_Idle,
	e_FastStartResponsePoint_Setup,
	e_FastStartResponsePoint_CallProceed,
	e_FastStartResponsePoint_Alert,
	e_FastStartResponsePoint_Connect,
	/*e_FastStartResponsePoint_Information,*/
	e_FastStartResponsePoint_Facility/*,
	e_FastStartResponsePoint_Progress*/
} FastStartResponsePoint;


typedef struct
{
	BOOL	session;

	BOOL	sendTCS;	BOOL	recvTCSack;
	BOOL	sendMSD;	BOOL	recvMSDack;
	BOOL	sendOLC;	BOOL	recvOLCack;
	BOOL	sendCLC;	BOOL	recvCLCack;
	BOOL	recvTCS;	BOOL	sendTCSack;
	BOOL	recvMSD;	BOOL	sendMSDack;
	BOOL	recvOLC;	BOOL	sendOLCack;
	BOOL	recvCLC;	BOOL	sendCLCack;

	MasterSlaveState	mss;
	
	HS_UINT	msdValue;
	HS_UCHAR tcsSN;
} H245State;

HS_RESULT new_H245State( H245State *pObj );
HS_RESULT delete_H245State( H245State *pObj );
HS_UINT H245State_MakeTCSSequenceNumber( H245State *pObj );



typedef struct
{
	BOOL isOpen;
	ControlMsg *olcMsg;
} OpenLogicalChannelSet;
HS_RESULT new_OpenLogicalChannelSet( OpenLogicalChannelSet *pObj );
HS_RESULT delete_OpenLogicalChannelSet( OpenLogicalChannelSet *pObj );
HS_RESULT NoLockList_AttachOpenLogicalChannelSet( NoLockList *pList, ControlMsg *pOlcMsg );
ChainUnit *NoLockList_FindOpenLogicalChannelSetByChannelNumber( NoLockList *pList, HS_UINT pChannelNumber );



typedef struct
{
	BOOL isAdmission;

	RouteState routeState;
	Q931State q931State;
	H245State h245State;

	HS_USHORT	crv;
	HS_UCHAR	confId[16];
	HS_UCHAR	callId[16];

	BOOL		canMapAlias;
	NoLockList	sourceAliases;
	NoLockList	destAliases;
	NoLockList	destExtraCallInfo;
	NoLockList	remoteExtensionAddress;
	char		callingParty[HS_MAX_DIGIT];
	char		calledParty[HS_MAX_DIGIT];

	ASNH225TransportAddress scsaTsap;
	ASNH225TransportAddress dcsaTsap;

	HS_UINT			bandwidth;
	BOOL			isAnswerCall;
	BOOL			isFastStart;
	BOOL			isTunneling;

	HS_USHORT				irrFrequency;
	ASNH225CallModelChoice	callModel;
	ASNH225UUIEsRequested	uuiesRequested;

	/*if (fastStartPoint == e_FastStartResponsePoint_Idle) then refusing FastStart*/
	FastStartResponsePoint	fastStartPoint;
	/*FastStart Matched List (List Of ASNH245OpenLogicalChannel)*/
	NoLockList		fsList;
	/*It Indicate that LC has opened by fastStart or not*/
	BOOL			fsActive;

	NoLockList		h245Charge;
	H245ListenPoint	h245ListenPoint;
	HS_UINT			h245ListenPort;
	HS_UINT			rtpListenPort;

	/*capabilities*/
	NoLockList				capabilities;
	/*remote capabilities*/
	ControlMsg				*remoteTCS;
	/*sended, received OpenLogicalChannel list*/
	NoLockList				sendedOlcSetList;
	NoLockList				receivedOlcSetList;
	/*audio type channel*/
	struct sockaddr_in	aRtpIn;
	struct sockaddr_in	aRtcpIn;
	/*video type channel*/
	struct sockaddr_in	vRtpIn;
	struct sockaddr_in	vRtcpIn;
	/*data type channel*/
	struct sockaddr_in	dRtpIn;
	struct sockaddr_in	dRtcpIn;

	HS_USHORT		logicalChannelNumber;

	HS_CALL_HANDLE	handle;
} ICall;

HS_RESULT new_ICall( ICall *pObj, BOOL pIsAnswerCall );
HS_RESULT delete_ICall( ICall *pObj );
HS_RESULT ICall_Make( ICall *pObj, IEndpoint *pEndpoint );
HS_USHORT ICall_MakeOLCChannelNumber( ICall *pObj );

ChainUnit *NoLockList_FindCallByConferenceId( NoLockList *pObj, HS_UCHAR *pId );
ChainUnit *NoLockList_FindCallByCRV(NoLockList *pObj, HS_USHORT pCrv);
ChainUnit *NoLockList_FindCallByHandle( NoLockList *pObj, HS_CALL_HANDLE pHandle );
HS_RESULT NoLockList_DeleteCallByHandle( NoLockList *pObj, HS_CALL_HANDLE pHandle );


/**********************************************************************************/
/* Capsulation for Application User Protection
*/
HS_UINT ICall_GetFastStartListSize(void *pCapsule);



#endif/*__2005_03_13__16_36__ICALL_H__*/


