/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<EnetDemonHandler.c>	2005-04-03,09:59

*/

#include "EnetDemonHandler.h"



/*************************************************************************/
/* Event Handlers
*/
HS_RESULT EnetDemonEventTimer(long pParam)
{
	return HS_OK;
}
HS_RESULT EnetDemonEventMakeSocketSet(long pParam, NoLockList *pSockList)
{
	H323SocketSet *ss = HS_NULL;
	HS_CALL_HANDLE tHandle = (HS_CALL_HANDLE)pParam;

	if( pSockList == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( (ss=(H323SocketSet*)HSMalloc(sizeof(H323SocketSet))) == HS_NULL ) return HS_ERR_H323_MALLOC;
	new_H323SocketSet(ss,tHandle);

	return NoLockList_AttachData( pSockList, ss );
}


HS_RESULT EnetDemonEventConnected(long pParam, NoLockList *pSockList, HS_QID pDestQ)
{
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	TcpConnected *tConnected = (TcpConnected*)pParam;
	if( tConnected == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pSockList == HS_NULL )
	{
		deletem_TcpConnected(tConnected);
		return HS_ERR_NULL_PARAM;
	}

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tConnected->mHandle);
	if( tChain == HS_NULL )
	{
		deletem_TcpConnected(tConnected);
		return HS_ERR_H323_NOTFOUND;
	}

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL )
	{
		deletem_TcpConnected(tConnected);
		return HS_ERR_H323_NOTFOUND;
	}

	if( ss->q931 == HS_INVALID_SOCKET )
	{
		ss->q931 = tConnected->mSocket;
		_HSThreadSendMessage(pDestQ, HS_QMESSAGE_Q931_CONNECTED, 0, (LPARAM)tConnected );
	}
	else if( ss->h245 == HS_INVALID_SOCKET )
	{
		ss->h245 = tConnected->mSocket;
		_HSThreadSendMessage(pDestQ, HS_QMESSAGE_H245_CONNECTED, 0, (LPARAM)tConnected );
	}
	else
	{
#ifdef HS_DEBUG_ENETDEMON
		HSPrint( "\n useless socket made." );
#endif
		closesocket(tConnected->mSocket);
		deletem_TcpConnected(tConnected);
		return HS_ERR_H323;
	}

	return HS_OK;
}


HS_RESULT EnetDemonEventTryConnect(long pParam, HS_QID pDestQ)
{
	HS_RESULT tRet = HS_OK;
	TcpConnect *tTry = (TcpConnect*)(pParam);
	if( tTry == HS_NULL ) return HS_ERR_NULL_PARAM;

	tTry->mTarget = pDestQ;
	if( (tRet=HSConnectEx2(tTry)) != HS_OK )
		deletem_TcpConnect(tTry);

	return tRet;
}


HS_RESULT EnetDemonEventTryListen(long pParam, NoLockList *pSockList)
{
	struct sockaddr_in	sockIn;

	HS_RESULT tRet = HS_OK;
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	TcpConnect *tTry = (TcpConnect*)(pParam);

	if( tTry==NULL ) return HS_ERR_NULL_PARAM;
	if( pSockList==NULL )
	{
		deletem_TcpConnect(tTry);
		return HS_ERR_NULL_PARAM;
	}

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tTry->mHandle);
	if( tChain == HS_NULL )
	{
		deletem_TcpConnect(tTry);
		return HS_ERR_H323_NOTFOUND;
	}

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL )
	{
		deletem_TcpConnect(tTry);
		return HS_ERR_H323_NOTFOUND;
	}

	if( (ss->h245Listen=socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET )
	{
		deletem_TcpConnect(tTry);
		return HS_ERR_H323_SOCKET;
	}

	memset( &sockIn, 0, sizeof(sockIn) );
	sockIn.sin_family		= AF_INET;
	sockIn.sin_addr.s_addr	= htonl( INADDR_ANY );
	sockIn.sin_port			= htons( tTry->mPort );

	if( bind(ss->h245Listen, (struct sockaddr*)&sockIn, sizeof(sockIn)) )
	{
#ifdef HS_DEBUG_ENETDEMON
		HSPrint( "\n <EnetDemon> H245 socket bind error (%d)", WSAGetLastError() );
#endif
		closesocket(ss->h245Listen);
		ss->h245Listen = HS_INVALID_SOCKET;
		deletem_TcpConnect(tTry);
		return HS_ERR_H323;
	}
	if( listen(ss->h245Listen,3) )
	{
#ifdef HS_DEBUG_ENETDEMON
		HSPrint( "\n <EnetDemon> H245 socket listen error (%d)", WSAGetLastError() );
#endif
		closesocket(ss->h245Listen);
		ss->h245Listen = HS_INVALID_SOCKET;
		deletem_TcpConnect(tTry);
		return HS_ERR_H323;
	}

	deletem_TcpConnect(tTry);
	return HS_OK;
}


HS_RESULT EnetDemonEventSendQ931Message(long pParam, NoLockList *pSockList)
{
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	QMTcpMessage *tTcpMessage = (QMTcpMessage*)pParam;

	if( pSockList == HS_NULL || tTcpMessage == HS_NULL ) return HS_ERR_NULL_PARAM;

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tTcpMessage->handle);
	if( tChain == HS_NULL )
	{
		delete_QMTcpMessage(tTcpMessage);
		return HS_ERR_H323_NOTFOUND;
	}

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL )
	{
		delete_QMTcpMessage(tTcpMessage);
		return HS_ERR_H323_NOTFOUND;
	}

	if(ss->q931 != HS_INVALID_SOCKET)
		send(ss->q931, tTcpMessage->raw, tTcpMessage->len, 0);
	else
	{
		delete_QMTcpMessage(tTcpMessage);
		return HS_ERR_H323_SOCKET;
	}

	delete_QMTcpMessage(tTcpMessage);
	return HS_OK;
}


HS_RESULT EnetDemonEventSendH245Message(long pParam, NoLockList *pSockList)
{
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	QMTcpMessage *tTcpMessage = (QMTcpMessage*)pParam;

	if( pSockList == HS_NULL || tTcpMessage == HS_NULL ) return HS_ERR_NULL_PARAM;

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tTcpMessage->handle);
	if( tChain == HS_NULL )
	{
		delete_QMTcpMessage(tTcpMessage);
		return HS_ERR_H323_NOTFOUND;
	}

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL )
	{
		delete_QMTcpMessage(tTcpMessage);
		return HS_ERR_H323_NOTFOUND;
	}

	if(ss->h245 != HS_INVALID_SOCKET)
		send(ss->h245, tTcpMessage->raw, tTcpMessage->len, 0);
	else
	{
		delete_QMTcpMessage(tTcpMessage);
		return HS_ERR_H323_SOCKET;
	}

	delete_QMTcpMessage(tTcpMessage);
	return HS_OK;
}


HS_RESULT EnetDemonEventQ931Close(long pParam, NoLockList *pSockList)
{
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	HS_CALL_HANDLE tHandle = (HS_CALL_HANDLE)pParam;

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tHandle);
	if( tChain == HS_NULL ) return HS_ERR_H323_NOTFOUND;

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL ) return HS_ERR_H323_NOTFOUND;

	if(ss->q931 != HS_INVALID_SOCKET)
	{
		closesocket(ss->q931);
		ss->q931 = HS_INVALID_SOCKET;
	}
	
	return HS_OK;
}


HS_RESULT EnetDemonEventH245Close(long pParam, NoLockList *pSockList)
{
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	HS_CALL_HANDLE tHandle = (HS_CALL_HANDLE)pParam;

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tHandle);
	if( tChain == HS_NULL ) return HS_ERR_H323_NOTFOUND;

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL ) return HS_ERR_H323_NOTFOUND;

	if(ss->h245!= HS_INVALID_SOCKET)
	{
		closesocket(ss->h245);
		ss->h245 = HS_INVALID_SOCKET;
	}
	
	return HS_OK;
}


HS_RESULT EnetDemonEventRemoveSocketSet(long pParam, NoLockList *pSockList)
{
	H323SocketSet *ss = HS_NULL;
	ChainUnit *tChain = HS_NULL;
	HS_CALL_HANDLE tHandle = (HS_CALL_HANDLE)pParam;

	tChain = NoLockList_FindH323SocketSetByHandle(pSockList,tHandle);
	if( tChain == HS_NULL ) return HS_ERR_H323_NOTFOUND;

	ss = (H323SocketSet*)(tChain->data);
	if( ss == HS_NULL ) return HS_ERR_H323_NOTFOUND;

	if(ss->q931!= HS_INVALID_SOCKET) closesocket(ss->q931);
	if(ss->h245!= HS_INVALID_SOCKET) closesocket(ss->h245);
	if(ss->h245Listen!= HS_INVALID_SOCKET) closesocket(ss->h245Listen);
	delete_TpktBuffer( &(ss->q931Buffer) );
	delete_TpktBuffer( &(ss->h245Buffer) );

	return NoLockList_DeleteChain(pSockList,tChain);
}
