/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<EnetDemon.c>	2005-03-20,11:33

*/

#include "EnetDemon.h"

#ifdef _WIN32
#include <time.h>
#endif





static SOCKET gGkSock = INVALID_SOCKET;

static HS_USHORT callHandleInEnetDemon=1;
static HS_UINT GetCallHandleInEnetDemon()
{
	HS_UINT result;

	result = (HS_UINT)callHandleInEnetDemon;
	callHandleInEnetDemon += 2;

	return result;
}





/* EnetDemon member functions
*/
EnetDemon *newm_EnetDemon(HS_USHORT pRasPort,HS_USHORT pQ931Port)
{
	EnetDemon *tResult = NULL;

	if( (tResult=(EnetDemon*)HSMalloc(sizeof(EnetDemon)))==NULL ) return NULL;

	HS_THREAD_INIT(tResult,"EnetDemon");
	tResult->mRasPort = pRasPort;
	tResult->mQ931Port = pQ931Port;
	tResult->mStack = NULL;

	tResult->mRasSocket = INVALID_SOCKET;
	tResult->mCallSocket = INVALID_SOCKET;
	return tResult;
}

HS_RESULT deletem_EnetDemon(void *pObject)
{
	EnetDemon *pObj = (EnetDemon*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mRasSocket != INVALID_SOCKET )
	{
		closesocket(pObj->mRasSocket);
		pObj->mRasSocket = INVALID_SOCKET;
	}
	if( pObj->mCallSocket != INVALID_SOCKET )
	{
		closesocket(pObj->mCallSocket);
		pObj->mCallSocket = INVALID_SOCKET;
	}

	HSFree(pObj);
	return HS_OK;
}





/* utility functions
*/
HS_RESULT SendToRas( struct sockaddr_in *pTarget, HS_UCHAR *pRaw, int pLen )
{
	int tLen;

	if( pTarget == HS_NULL || pRaw == HS_NULL || pLen < 1 ) return HS_ERR_NULL_PARAM;
	if( gGkSock == HS_INVALID_SOCKET ) return HS_ERR_H323_SOCKET;

	tLen = sizeof( *pTarget );

	if( sendto(gGkSock, pRaw, pLen, 0, (struct sockaddr*)pTarget, tLen) > 0 ) return HS_OK;
	return HS_ERR_H323;
}





/* thread main functions
*/
void EnetDemon_MainEx(HS_TQ pQ,EnetDemon *pObj)
{
	HSQmsg tQmsg;
	HS_RESULT tRet = HS_OK;
	StackInfo *tStack = NULL;

	int		 rLen;
	HS_UCHAR rBuffer[HS_MAX_PACKET];

	int	sockLen;
	struct sockaddr_in senderAddrIn;
	struct sockaddr_in acceptSockIn;

	HS_UINT	max_fd;
	fd_set	h323SockSet;

	struct timeval	tv;
	NoLockList sockList;

	HSSrand();

	if( pObj==NULL ) return;
	if( (tStack=pObj->mStack)==NULL ) return;

	new_NoLockList( &sockList, delete_H323SocketSet );
	tv.tv_sec  = 0;
	tv.tv_usec = 50000;

	pObj->mActive = TRUE;
    while(pObj->mActive)
    {
		if( HSThreadGetMessage(pQ,&tQmsg,HS_QM,HS_QM_MAX,FALSE)==HS_OK )
		{
            switch(tQmsg.message)
			{
				case HS_QM_TIMER:
					HSPrint( "\n[+] ENET->TIMER" );
					tRet=EnetDemonEventTimer(tQmsg.lParam);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_MAKE_SOCKET_SET:
					HSPrint( "\n[+] ENET->MAKE_SOCKET_SET" );
					tRet=EnetDemonEventMakeSocketSet(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QM_CONNECTED:
					HSPrint( "\n[+] ENET->CONNECTED" );
					tRet=EnetDemonEventConnected(tQmsg.lParam,&sockList,tStack->h323DemonQ);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_TRY_CONNECT:
					HSPrint( "\n[+] ENET->TRY_CONNECT" );
					tRet=EnetDemonEventTryConnect(tQmsg.lParam,tStack->enetDemonQ);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_TRY_LISTEN:
					HSPrint( "\n[+] ENET->TRY_LISTEN" );
					tRet=EnetDemonEventTryListen(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_Q931_MESSAGE:
					HSPrint( "\n[+] ENET->SEND_Q931_MESSAGE" );
					tRet=EnetDemonEventSendQ931Message(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_H245_MESSAGE:
					HSPrint( "\n[+] ENET->SEND_H245_MESSAGE" );
					tRet=EnetDemonEventSendH245Message(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_Q931_CLOSE:
					HSPrint( "\n[+] ENET->Q931_CLOSE" );
					tRet=EnetDemonEventQ931Close(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_H245_CLOSE:
					HSPrint( "\n[+] ENET->H245_CLOSE" );
					tRet=EnetDemonEventH245Close(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QMESSAGE_REMOVE_SOCKET_SET:
					HSPrint( "\n[+] ENET->REMOVE_SOCKET_SET" );
					tRet=EnetDemonEventRemoveSocketSet(tQmsg.lParam,&sockList);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
 				case HS_QM_STOP:
					HSPrint( "\n[+] ENET->END_THREAD" );
					pObj->mActive = FALSE;
					gGkSock = INVALID_SOCKET;
					break;
           }
        }


		FD_ZERO( &h323SockSet );
		/*Q931 Listener Set*/
		FD_SET(pObj->mCallSocket, &h323SockSet );
		max_fd = pObj->mCallSocket;
		/*Ras Listener Set*/
		FD_SET( pObj->mRasSocket, &h323SockSet );
		if( pObj->mRasSocket > max_fd ) max_fd = pObj->mRasSocket;
		/*Call Sockets' Set*/
		NoLockList_FdSet( &sockList, &h323SockSet, &max_fd );
		max_fd++;


		if( select(max_fd+1, &h323SockSet, HS_NULL, HS_NULL, &tv) < 1 ) continue;
		/*CallSocket Accept*/
		if( FD_ISSET(pObj->mCallSocket,&h323SockSet) )
		{
			HS_SOCKET	tSocket;
			
			sockLen = sizeof(acceptSockIn);
			tSocket = accept( pObj->mCallSocket, (struct sockaddr *)(&(acceptSockIn)), &(sockLen) );

			if( tSocket < 0 )
				tSocket = accept( pObj->mCallSocket, (struct sockaddr *)(&(acceptSockIn)), &(sockLen) );

			if( tSocket >= 0 )
			{
				H323SocketSet *ss = HS_NULL;
				QMAccepted *tAccepted = HS_NULL;

				if( (ss=(H323SocketSet*)HSMalloc(sizeof(H323SocketSet))) != HS_NULL )
				{
					new_H323SocketSet(ss, GetCallHandleInEnetDemon());
					ss->q931 = tSocket;

					if( (tAccepted=new_QMAccepted(tSocket,ss->handle)) != HS_NULL )
					{
						SockAddr2QMAccepted(tAccepted,&acceptSockIn);

						NoLockList_AttachData(&sockList, ss);
						_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_Q931_ACCEPTED, 0, (LPARAM)tAccepted );
					}
					else
					{
						HSFree(ss);
						closesocket(tSocket);
					}
				}
				else closesocket(tSocket);
			}
#ifdef HS_DEBUG_ENETDEMON
			else
			{
				HSPrint( "\n <EnetDemon> Q931 Accept Error" );
			}
#endif
		}
		/*Ras Packet*/
		if( FD_ISSET(pObj->mRasSocket,&h323SockSet) )
		{
			QMRasMessage *tRasMessage = HS_NULL;
			sockLen = sizeof(senderAddrIn);

			if( (rLen=recvfrom(pObj->mRasSocket, (char *)rBuffer, HS_MAX_PACKET, 0, (SOCKADDR*)&senderAddrIn, &sockLen)) > 0 )
			{
				HSResponseVendorCheckPacket(rBuffer,rLen,pObj->mRasSocket,senderAddrIn);

				if( (tRasMessage=new_QMRasMessage(rBuffer, rLen)) != HS_NULL )
					_HSThreadSendMessage( tStack->h323DemonQ, HS_QMESSAGE_RECV_RAS_MESSAGE, 0, (LPARAM)tRasMessage );
			}
		}

		NoLockList_FdIsSet( &sockList, &h323SockSet, tStack->h323DemonQ, rBuffer, HS_MAX_PACKET );
    }


#ifdef HS_DEBUG_ENETDEMON
    printf("\n <EnetDemon> Ended");
#endif
	delete_NoLockList(&sockList);
	return;
}


HS_RESULT EnetDemon_Main(HS_TQ pQ,void *pObject,void *pArg)
{
	struct sockaddr_in	tRasIn;
	struct sockaddr_in	tQ931In;

	EnetDemon *pObj = (EnetDemon*)pObject;

	if( pObj==NULL ) return HSExitThread(pQ,HS_ERR_NULL_PARAM);
	if( pObj->mStack==NULL )
	{
		deletem_EnetDemon(pObj);
		return HSExitThread(pQ,HS_ERR_INVALID_PARAM);
	}

	/* make socket
	*/
	if( pObj->mRasSocket==INVALID_SOCKET )
	{
		if( (pObj->mRasSocket=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==INVALID_SOCKET )
		{
			deletem_EnetDemon(pObj);
			return HSExitThread(pQ,HS_ERR_NET_SOCKET);
		}
	}
	if( pObj->mCallSocket==INVALID_SOCKET )
	{
		if( (pObj->mCallSocket=socket(AF_INET,SOCK_STREAM,0))==INVALID_SOCKET )
		{
			deletem_EnetDemon(pObj);
			return HSExitThread(pQ,HS_ERR_NET_SOCKET);
		}
	}

	/* bind socket
	*/
	memset(&tRasIn,0,sizeof(tRasIn));
    tRasIn.sin_family		= AF_INET;
    tRasIn.sin_addr.s_addr	= htonl( INADDR_ANY );
	tRasIn.sin_port			= htons( pObj->mRasPort );
	if( bind(pObj->mRasSocket,(struct sockaddr*)&(tRasIn),sizeof(tRasIn)) != 0 )
	{
		deletem_EnetDemon(pObj);
		return HSExitThread(pQ,HS_ERR_NET_BIND);
	}

	memset(&tQ931In,0,sizeof(tQ931In));
    tQ931In.sin_family		= AF_INET;
    tQ931In.sin_addr.s_addr	= htonl( INADDR_ANY );
	tQ931In.sin_port		= htons( pObj->mQ931Port );
	if( bind(pObj->mCallSocket,(struct sockaddr*)&(tQ931In),sizeof(tQ931In)) != 0 )
	{
		deletem_EnetDemon(pObj);
		return HSExitThread(pQ,HS_ERR_NET_BIND);
	}
	if( listen(pObj->mCallSocket,3) != 0 )
	{
		deletem_EnetDemon(pObj);
		return HSExitThread(pQ,HS_ERR_NET_BIND);
	}

	gGkSock = pObj->mRasSocket;
	EnetDemon_MainEx(pQ,pObj);

	deletem_EnetDemon(pObj);
	return HSExitThread(pQ,HS_OK);
}


