/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<CtrlMessageMaker.h>	2005-03-20,19:53

*/

#ifndef __2005_03_20__19_53__CTRLMESSAGEMAKER_H__
#define __2005_03_20__19_53__CTRLMESSAGEMAKER_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "MessageUtility.h"


/* H.245(v6) Annex B.3.1 */
#define SESSION_ID_AUDIO		1
#define SESSION_ID_VIDEO		2
#define SESSION_ID_DATA			3


ControlMsg *MakeTerminalCapabilitySet( IEndpoint *pEndpoint, ICall *pCall );
ControlMsg *MakeTerminalCapabilitySetAck( ASNH245TerminalCapabilitySet *pTCS );
ControlMsg *MakeMasterSlaveDetermination( IEndpoint *pEndpoint, HS_UINT pRandom );
ControlMsg *MakeMasterSlaveDeterminationAck( ASNH245MasterSlaveDeterminationAck_decisionChoice pDecision );
ControlMsg *MakeOpenLogicalChannel( ICapability *pCapability, IEndpoint *pEndpoint, ICall *pCall );
ControlMsg *MakeOpenLogicalChannelAck( ASNH245OpenLogicalChannel *pOLC, IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapability );
ControlMsg *MakeOpenLogicalChannelReject( ASNH245OpenLogicalChannel *pOlc, ASNH245OpenLogicalChannelReject_causeChoice pCause);
ControlMsg *MakeEndSessionCommandForDisconnect();



#endif/*__2005_03_20__19_53__CTRLMESSAGEMAKER_H__*/


