/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<CtrlMessageMaker.c>		2005-03-20,20:10

*/

#include "CtrlMessageMaker.h"



unsigned char gPID_H245_V7_H245[] = {gPID_H245_V7};
unsigned gSize_PID_H245_V7_H245   = gSize_PID_H245_V7;



/* MakeTerminalCapabilitySet */
ControlMsg *MakeTerminalCapabilitySet( IEndpoint *pEndpoint, ICall *pCall )
{
	HS_UINT tSN=0;
	HS_RESULT ret;
	ASNH245TerminalCapabilitySet *tcs = HS_NULL;
	ASNH245RequestMessage *tRequest = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	if( pEndpoint == HS_NULL || pCall == HS_NULL ) return HS_NULL;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tRequest = (ASNH245RequestMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_request
	);
	if( tRequest == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	tcs = (ASNH245TerminalCapabilitySet*)ASNH245RequestMessage_SetChoice(
		tRequest, e_ASNH245RequestMessageChoice_terminalCapabilitySet
	);
	if( tcs == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}


	tSN = H245State_MakeTCSSequenceNumber( &(pCall->h245State) );
	if( tSN > HS_UCHAR_MAX )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}
	AsnInteger_SetValue( &(tcs->m_sequenceNumber.inheritance), tSN );
	AsnObjectIdentifier_SetValue( &(tcs->m_protocolIdentifier), gPID_H245_V7_H245, gSize_PID_H245_V7_H245 );
	
	ret=ICapabilities_MakeTCS( &(pCall->capabilities), tcs );
	if( ret != HS_OK )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeTerminalCapabilitySetAck */
ControlMsg *MakeTerminalCapabilitySetAck( ASNH245TerminalCapabilitySet *pTCS )
{
	ASNH245TerminalCapabilitySetAck *tcsAck = HS_NULL;
	ASNH245ResponseMessage *tResponse = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	if( pTCS == HS_NULL ) return HS_NULL;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tResponse = (ASNH245ResponseMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_response
	);
	if( tResponse == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	tcsAck = (ASNH245TerminalCapabilitySetAck*)ASNH245ResponseMessage_SetChoice(
		tResponse, e_ASNH245ResponseMessageChoice_terminalCapabilitySetAck
	);
	if( tcsAck == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnInteger_SetValue( &(tcsAck->m_sequenceNumber), pTCS->m_sequenceNumber.inheritance.value );
	return msg;
}


/* MakeMasterSlaveDetermination */
ControlMsg *MakeMasterSlaveDetermination( IEndpoint *pEndpoint, HS_UINT pRandom )
{
	ASNH245MasterSlaveDetermination *msd = HS_NULL;
	ASNH245RequestMessage *tRequest = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	if( pEndpoint == HS_NULL ) return HS_NULL;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tRequest = (ASNH245RequestMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_request
	);
	if( tRequest == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	msd = (ASNH245MasterSlaveDetermination*)ASNH245RequestMessage_SetChoice(
		tRequest, e_ASNH245RequestMessageChoice_masterSlaveDetermination
	);
	if( msd == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnInteger_SetValue( &(msd->m_terminalType), (HS_UINT)(pEndpoint->type) );
	AsnInteger_SetValue( &(msd->m_statusDeterminationNumber), pRandom );
	return msg;
}


/* MakeMasterSlaveDeterminationAck */
ControlMsg *MakeMasterSlaveDeterminationAck( ASNH245MasterSlaveDeterminationAck_decisionChoice pDecision )
{
	ASNH245MasterSlaveDeterminationAck *msdAck = HS_NULL;
	ASNH245ResponseMessage *tResponse = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tResponse = (ASNH245ResponseMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_response
	);
	if( tResponse == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	msdAck = (ASNH245MasterSlaveDeterminationAck*)ASNH245ResponseMessage_SetChoice(
		tResponse, e_ASNH245ResponseMessageChoice_masterSlaveDeterminationAck
	);
	if( msdAck == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	if( ASNH245MasterSlaveDeterminationAck_decision_SetChoice( &(msdAck->m_decision), pDecision ) == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeOpenLogicalChannel */
ControlMsg *MakeOpenLogicalChannel( ICapability *pCapability, IEndpoint *pEndpoint, ICall *pCall )
{
	HS_RESULT ret = HS_OK;
	HS_UCHAR tSessionId = 0;
	HS_UINT tRtpListenPort = HS_INVALID_PORT;
	HS_USHORT tLCN = HS_INVALID_LOGICAL_CHANNEL_NUMBER;

	ASNH245H2250LogicalChannelParameters *h2250 = HS_NULL;
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *lcParam = HS_NULL;
	ASNH245OpenLogicalChannel *olc = HS_NULL;
	ASNH245RequestMessage *tRequest = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	AsnStream tStrm;

	if( pCapability == HS_NULL || pEndpoint == HS_NULL || pCall == HS_NULL ) return HS_NULL;

	new_AsnStream( &tStrm, 128, TRUE );

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tRequest = (ASNH245RequestMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_request
	);
	if( tRequest == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	olc = (ASNH245OpenLogicalChannel*)ASNH245RequestMessage_SetChoice(
		tRequest, e_ASNH245RequestMessageChoice_openLogicalChannel
	);
	if( olc == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	tLCN = ICall_MakeOLCChannelNumber( pCall );
	if( tLCN == HS_INVALID_LOGICAL_CHANNEL_NUMBER )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}
	
	AsnInteger_SetValue( &(olc->m_forwardLogicalChannelNumber.inheritance), tLCN );

	lcParam = &(olc->m_forwardLogicalChannelParameters);

	if( pCapability->capability.choice == e_ASNH245CapabilityChoice_receiveVideoCapability ||
		pCapability->capability.choice == e_ASNH245CapabilityChoice_transmitVideoCapability ||
		pCapability->capability.choice == e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability )
	{
		ASNH245VideoCapability *video = HS_NULL;

		tSessionId = SESSION_ID_VIDEO;
		tRtpListenPort = pCall->rtpListenPort+2;

		ret = ASNH245VideoCapability_Copy(
			ASNH245DataType_SetChoice( &(lcParam->m_dataType), e_ASNH245DataTypeChoice_videoData ),
			pCapability->capability.alter
		);
		if( ret != HS_OK )
		{
			delete_ASNH245MultimediaSystemControlMessage(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else if(
		pCapability->capability.choice == e_ASNH245CapabilityChoice_receiveAudioCapability ||
		pCapability->capability.choice == e_ASNH245CapabilityChoice_transmitAudioCapability ||
		pCapability->capability.choice == e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability )
	{
		ASNH245AudioCapability *audio = HS_NULL;

		tSessionId = SESSION_ID_AUDIO;
		tRtpListenPort = pCall->rtpListenPort;

		ret = ASNH245AudioCapability_Copy(
			ASNH245DataType_SetChoice( &(lcParam->m_dataType), e_ASNH245DataTypeChoice_audioData ),
			pCapability->capability.alter
		);
		if( ret != HS_OK )
		{
			delete_ASNH245MultimediaSystemControlMessage(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
	{
		tSessionId = SESSION_ID_DATA;
		tRtpListenPort = pCall->rtpListenPort+4;

		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	h2250 = (ASNH245H2250LogicalChannelParameters*)
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(
		&(olc->m_forwardLogicalChannelParameters.m_multiplexParameters),
		e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
	);
	if( h2250 == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnInteger_SetValue( &(h2250->m_sessionID), (HS_UINT)tSessionId );
	ASNH245H2250LogicalChannelParameters_IncludeOptionField( h2250, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel );
	ASNH225TransportAddress2ASNH245TransportAddress_WithPort( &(h2250->m_mediaControlChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort+1) );

	return msg;
}


/* MakeOpenLogicalChannelAck */
ControlMsg *MakeOpenLogicalChannelAck( ASNH245OpenLogicalChannel *pOLC, IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapability )
{
	HS_UCHAR tSessionId = 0;	/* not audio, video and data */
	HS_UINT tRtpListenPort = HS_INVALID_PORT;

	ASNH245H2250LogicalChannelParameters *h2250 = HS_NULL;
	ASNH245H2250LogicalChannelAckParameters *h2250Ack = HS_NULL;
	ASNH245OpenLogicalChannelAck *olcAck = HS_NULL;
	ASNH245ResponseMessage *tResponse = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	if( pOLC == HS_NULL || pEndpoint == HS_NULL || pCall == HS_NULL || pCapability == HS_NULL ) return HS_NULL;

	if( pOLC->m_forwardLogicalChannelParameters.m_multiplexParameters.choice !=
		e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
	) return HS_NULL;

	h2250 = (ASNH245H2250LogicalChannelParameters*)(pOLC->m_forwardLogicalChannelParameters.m_multiplexParameters.alter);
	tSessionId = h2250->m_sessionID.value;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tResponse = (ASNH245ResponseMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_response
	);
	if( tResponse == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	olcAck = (ASNH245OpenLogicalChannelAck*)ASNH245ResponseMessage_SetChoice(
		tResponse, e_ASNH245ResponseMessageChoice_openLogicalChannelAck
	);
	if( olcAck == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnInteger_SetValue( &(olcAck->m_forwardLogicalChannelNumber.inheritance), pOLC->m_forwardLogicalChannelNumber.inheritance.value );

	ASNH245OpenLogicalChannelAck_IncludeOptionField( olcAck, e_ASNH245OpenLogicalChannelAckOptionMap_forwardMultiplexAckParameters );
	
	h2250Ack = (ASNH245H2250LogicalChannelAckParameters*)
	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice(
		&(olcAck->m_forwardMultiplexAckParameters),
		e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters
	);
	if( h2250Ack == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	ASNH245H2250LogicalChannelAckParameters_IncludeOptionField( h2250Ack, e_ASNH245H2250LogicalChannelAckParametersOptionMap_sessionID );
	AsnInteger_SetValue( &(h2250Ack->m_sessionID), tSessionId );

	ASNH245H2250LogicalChannelAckParameters_IncludeOptionField( h2250Ack, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaChannel );
	ASNH245H2250LogicalChannelAckParameters_IncludeOptionField( h2250Ack, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaControlChannel );

	if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveVideoCapability )
		tRtpListenPort = pCall->rtpListenPort+4;
	else if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveAudioCapability )
		tRtpListenPort = pCall->rtpListenPort+2;
	else if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability )
		tRtpListenPort = pCall->rtpListenPort;
	else
		tRtpListenPort = pCall->rtpListenPort+4;

	ASNH225TransportAddress2ASNH245TransportAddress_WithPort( &(h2250Ack->m_mediaChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort) );
	ASNH225TransportAddress2ASNH245TransportAddress_WithPort( &(h2250Ack->m_mediaControlChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort+1) );

	ASNH245H2250LogicalChannelAckParameters_IncludeOptionField( h2250Ack, e_ASNH245H2250LogicalChannelAckParametersOptionMap_flowControlToZero );
	h2250Ack->m_flowControlToZero.value = FALSE;

	return msg;
}


ControlMsg *MakeOpenLogicalChannelReject( ASNH245OpenLogicalChannel *pOlc, ASNH245OpenLogicalChannelReject_causeChoice pCause)
{
	ASNH245OpenLogicalChannelReject *tReject = HS_NULL;
	ASNH245ResponseMessage *tResponse = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	if( pOlc==HS_NULL ) return HS_NULL;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tResponse = (ASNH245ResponseMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_response
	);
	if( tResponse == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	tReject = (ASNH245OpenLogicalChannelReject*)ASNH245ResponseMessage_SetChoice(
		tResponse, e_ASNH245ResponseMessageChoice_openLogicalChannelReject
	);
	if( tReject == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	tReject->m_forwardLogicalChannelNumber.inheritance.value =
		pOlc->m_forwardLogicalChannelNumber.inheritance.value;

	ASNH245OpenLogicalChannelReject_cause_SetChoice(
		&(tReject->m_cause), pCause
	);

	return msg;
}


ControlMsg *MakeEndSessionCommandForDisconnect()
{
	ASNH245EndSessionCommand *esc = HS_NULL;
	ASNH245CommandMessage *tCommand = HS_NULL;
	ASNH245MultimediaSystemControlMessage *msg = HS_NULL;

	msg=(ASNH245MultimediaSystemControlMessage*)HSMalloc( sizeof(ASNH245MultimediaSystemControlMessage) );
	if( msg == HS_NULL ) return HS_NULL;
	new_ASNH245MultimediaSystemControlMessage( msg );
	ASNH245MultimediaSystemControlMessage_MakeMold( msg );

	tCommand = (ASNH245CommandMessage*)ASNH245MultimediaSystemControlMessage_SetChoice(
		msg, e_ASNH245MultimediaSystemControlMessageChoice_command
	);
	if( tCommand == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	esc = (ASNH245EndSessionCommand*)ASNH245CommandMessage_SetChoice(
		tCommand, e_ASNH245CommandMessageChoice_endSessionCommand
	);
	if( esc == HS_NULL )
	{
		delete_ASNH245MultimediaSystemControlMessage(msg);
		HSFree(msg);
		return HS_NULL;
	}

	if( ASNH245EndSessionCommand_SetChoice( esc, e_ASNH245EndSessionCommandChoice_disconnect ) == HS_NULL ) return HS_NULL;
	return msg;
}
