/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<CallMessageMaker.h>	2005-03-20,10:47

*/

#ifndef __2005_03_20__10_47__CALLMESSAGEMAKER_H__
#define __2005_03_20__10_47__CALLMESSAGEMAKER_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "CtrlMessageMaker.h"



/*faststart makers*/
HS_RESULT MakeFastStartRequest( AsnSequenceOf *pSequenceOf, IEndpoint *pEndpoint, ICall *pCall );
HS_RESULT MakeFastStartResponse( AsnSequenceOf *pSequenceOf, IEndpoint *pEndpoint, ICall *pCall );


/*
	h245Address      : Setup, Alert, CallProceed, Connect, Facility, Progress.
	FastStart        : Setup, Alert, CallProceed, Connect, Facility, Progress, Information.
	FastStart Refuse :        Alert, CallProceed, Connect, Facility, Progress, Information.
*/
ASNH225H323_UserInformation *MakeSetup			(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
ASNH225H323_UserInformation *MakeCallProceed	(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
ASNH225H323_UserInformation *MakeAlert			(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
ASNH225H323_UserInformation *MakeConnect		(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
ASNH225H323_UserInformation *MakeFacility		(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall, ASNH225FacilityReasonChoice pReason);
ASNH225H323_UserInformation *MakeEmpty			(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
ASNH225H323_UserInformation *MakeReleaseComplete(StackInfo *pStack, NoLockList *pWaits, ICall *pCall);

Q931Message *MakeQ931Setup			(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
Q931Message *MakeQ931CallProceed	(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
Q931Message *MakeQ931Alert			(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
Q931Message *MakeQ931Connect		(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
Q931Message *MakeQ931Facility		(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall, ASNH225FacilityReasonChoice pReason);
Q931Message *MakeQ931Empty			(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall);
Q931Message *MakeQ931ReleaseComplete(StackInfo *pStack, NoLockList *pWaits, ICall *pCall, Q931CauseType pCause);



#endif/*__2005_03_20__10_47__CALLMESSAGEMAKER_H__*/


