/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnFileCPP.cpp>	2005-02-27,10:15

*/

#include "asnFileCPP.h"
#include <windows.h>



/**********************************************************************************************************/
/*
/*	Make C-PlusPlus Header File
*/
const char *gCppHeaderChoiceString =
"\
class %s : public AsnObject\n\
{\n\
public:\n\
	%s();\n\
	~%s();\n\
\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
	HS_RESULT	Print( HS_UINT pDepth, char *pTypeName );\n\
#endif\n\
\n\
	void*		SetChoice( %sChoice pChoice );\n\
\n\
	HS_RESULT	Encode( AsnStream *pStrm );\n\
	HS_RESULT	Decode( AsnStream *pStrm );\n\
\n\
private:\n\
	HS_RESULT	DeleteAlternation();\n\
\n\
public:\n\
	%sChoice	choice;\n\
	AsnInteger			choiceInteger;\n\
\n\
	BOOL	extensible;\n\
\n\
	void *alter;\n\
};\n\n\n\n\n\n\
";
bool MakeCppStructChoice( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;


	fprintf( pf, "typedef enum\n{\n" );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\n" );
		else
		{
			if(i)	fprintf( pf, ",\n\te_%sChoice_%s", ac->cName, ac->member[i].mName );
			else	fprintf( pf,    "\te_%sChoice_%s",  ac->cName, ac->member[i].mName );
		}
	}
	fprintf( pf, "\n} %sChoice;\n", ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type != e_extension )
		{
			y++;
			if( ! ac->member[i].extended )
				x++;
		}
	}
	fprintf( pf, "\n\n#define e_%sChoiceSize		%d\n", ac->cName, x );
	fprintf( pf, "#define e_%sChoiceSizeExt	%d\n", ac->cName, y );

	fprintf( pf, gCppHeaderChoiceString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	return true;
}


const char *gCppHeaderSequenceStringOptional =
"\
class %s : public AsnObject\n\
{\n\
public:\n\
	%s();\n\
	~%s();\n\
\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
	HS_RESULT	Print( HS_UINT pDepth, char *pTypeName );\n\
#endif\n\
\n\
	HS_RESULT	  IncludeOptionField( %sOptionMap pOptionMap );\n\
	BOOL		IsIncludeOptionField( %sOptionMap pOptionMap );\n\
\n\
	HS_RESULT	MakeMold();\n\
	HS_RESULT	Encode( AsnStream *pStrm );\n\
	HS_RESULT	Decode( AsnStream *pStrm );\n\
\n\
public:\n\
	BOOL			extensible;\n\
	BOOL			extended;\n\
";
const char *gCppHeaderSequenceStringNonOptional =
"\
class %s : public AsnObject\n\
{\n\
public:\n\
	%s();\n\
	~%s();\n\
\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
	HS_RESULT	Print( HS_UINT pDepth, char *pTypeName );\n\
#endif\n\
\n\
	HS_RESULT	MakeMold();\n\
	HS_RESULT	Encode( AsnStream *pStrm );\n\
	HS_RESULT	Decode( AsnStream *pStrm );\n\
\n\
public:\n\
	BOOL			extensible;\n\
	BOOL			extended;\n\
";
bool MakeCppStructSequence( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;
	bool started = false;

	
	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	/*Make Enum*/
	if( x || y )
	{
		fprintf( pf, "typedef enum\n{\n" );
		for( i=0; i<ac->mSize; i++ )
		{
			if( ac->member[i].type == e_extension ) fprintf( pf, "\n" );
			else
			{
				if( ac->member[i].optional || ac->member[i].extended )
				{
					if(started) fprintf( pf, ",\n\te_%sOptionMap_%s", ac->cName, ac->member[i].mName );
					else
					{
						started = true;
						fprintf( pf,    "\te_%sOptionMap_%s",  ac->cName, ac->member[i].mName );
					}
				}
			}
		}
		fprintf( pf, "\n} %sOptionMap;\n\n", ac->cName );
	}

	fprintf( pf, "\n#define e_%sOptionMapSize %d\n", ac->cName, x );
	fprintf( pf, "#define e_%sOptionMapSizeExt %d\n", ac->cName, x+y );

	if( x || y )
		fprintf( pf, gCppHeaderSequenceStringOptional,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);
	else
		fprintf( pf, gCppHeaderSequenceStringNonOptional,
			ac->cName, ac->cName, ac->cName
		);

	if(x) fprintf( pf, "\n\tHS_UCHAR	optionMap[HS_ASN_OPTION_MAP_MAX];\n" );
	if(y)
		fprintf( pf,
			"\n\tHS_UINT		extOptionMapSize;	/* Bit Size */"
			"\n\tHS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];\n"
		);
	fprintf( pf, "\n\t/* Member of ASN */\n" );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
				fprintf( pf, "\tAsnSequenceOf<%s> m_%s;\n", ac->member[i].cName, ac->member[i].mName );
			else
				fprintf( pf, "\t%s m_%s;\n", ac->member[i].cName, ac->member[i].mName );
		}
	}

	fprintf( pf, "};\n\n\n\n\n\n" );
	return true;
}


bool MakeCppStructSet( AsnClass *ac, FILE *pf )
{
	return MakeCppStructSequence(ac,pf);
}


bool MakeCppInheritance( AsnClass *ac, FILE *pf )
{
	if( ac==0 || pf==0 )
	{
		printf( "\n Err:MakeFile:CppStruct:Inherit:NULL" );
		return false;
	}

	switch(ac->type)
	{
		case e_class:
			fprintf( pf, "#define %s %s\n\n", ac->cName, ac->sName );
			break;
		case e_boolean:
			fprintf( pf,
				"class %s : public AsnBoolean\n{\npublic:\n"
				"\t%s(){}\n\t~%s(){}\n};\n\n", ac->cName, ac->cName, ac->cName
			);
			break;
		case e_null:
			fprintf( pf,
				"class %s : public AsnNull\n{\npublic:\n"
				"\t%s(){}\n\t~%s(){}\n};\n\n", ac->cName, ac->cName, ac->cName
			);
			break;
		case e_objectIdentifier:
			fprintf( pf,
				"class %s : public AsnObjectIdentifier\n{\npublic:\n"
				"\t%s(){}\n\t~%s(){}\n};\n\n", ac->cName, ac->cName, ac->cName
			);
			break;
		case e_integer:
			fprintf( pf,
				"class %s : public AsnInteger\n{\npublic:\n"
				"\t%s() : AsnInteger(%s,%d,%u,%d,%u) {}\n\t~%s(){}\n};\n\n",
				ac->cName, ac->cName, GetConstraintTypeNameForParsing(ac->cons.type),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax, ac->cName
			);
			break;
		case e_bitString:
			fprintf( pf,
				"class %s : public AsnBitString\n{\npublic:\n"
				"\t%s() : AsnBitString(%s,%d,%u,%d,%u) {}\n\t~%s(){}\n};\n\n",
				ac->cName, ac->cName, GetConstraintTypeNameForParsing(ac->cons.type),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax, ac->cName
			);
			break;
		case e_octetString:
			fprintf( pf,
				"class %s : public AsnOctetString\n{\npublic:\n"
				"\t%s() : AsnOctetString(%s,%d,%u,%d,%u) {}\n\t~%s(){}\n};\n\n",
				ac->cName, ac->cName, GetConstraintTypeNameForParsing(ac->cons.type),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax, ac->cName
			);
			break;
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
			fprintf( pf,
				"class %s : public AsnSingleString\n{\npublic:\n"
				"\t%s() : AsnSingleString(%s,%s,%d,%u,%d,%u) {",
				ac->cName, ac->cName, GetSingleStringTagName(ac->type),
				GetConstraintTypeNameForParsing(ac->cons.type),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			if( ac->from[0] )
			{
				fprintf( pf,
					"\n\t\t/*From Constraint*/\n"
					"\t\tstrcpy((char*)(fromConstraint), \"%s\");\n"
					"\t\tfromSize = %d;\n"
					"\t\treIndexing = GetStringTypeEncodingBits(\n"
					"\t\t\tfromSize,\n"
					"\t\t\t%s,\n"
					"\t\t\t&(encodingBitsOfAlign),\n"
					"\t\t\t&(encodingBitsOfUnalign)\n"
					"\t\t);\n\t", ac->from, strlen(ac->from), GetSingleStringVmaxName(ac->type)
				);
			}
			fprintf( pf, "}\n\t~%s(){}\n};\n\n", ac->cName );
			break;
		case e_bmpString:
			fprintf( pf,
				"class %s : public AsnDoubleString\n{\npublic:\n"
				"\t%s() : AsnDoubleString(%s,%s,%d,%u,%d,%u) {",
				ac->cName, ac->cName, GetDoubleStringTagName(ac->type),
				GetConstraintTypeNameForParsing(ac->cons.type),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			if( ac->from[0] )
			{
				fprintf( pf,
					"\n\t\t/*From Constraint*/\n"
					"\t\tstrcpy((char*)(fromConstraint), \"%s\");\n"
					"\t\tfromSize = %d;\n"
					"\t\treIndexing = GetStringTypeEncodingBits(\n"
					"\t\t\tfromSize,\n"
					"\t\t\t%s,\n"
					"\t\t\t&(encodingBitsOfAlign),\n"
					"\t\t\t&(encodingBitsOfUnalign)\n"
					"\t\t);\n\t", ac->from, strlen(ac->from), GetDoubleStringVmaxName(ac->type)
				);
			}
			fprintf( pf, "}\n\t~%s(){}\n};\n\n", ac->cName );
			break;
		case e_enumerated:
			printf( "\n Err:MakeFile:CppStruct:Inherit:Enum" );
			return false;
		case e_extension:
		case e_choice:
		case e_set:
		case e_sequence:
		default:
			printf( "\n Err:MakeFile:CppStruct:Inherit:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	return true;
}


bool MakeCppStruct( AsnClass *ac, FILE *pf )
{
	if( ac->handship )
	{
		if( ac->type == e_enumerated )
		{
			printf( "\n Inf:MakeFile:CppStruct:Handship:Enumerated:class[%s]", ac->cName );
			return true;
		}
		if( ac->of )
		{
			printf( "\n Inf:MakeFile:CppStruct:Handship:SomeOf:class[%s],type[%s]", ac->cName, GetAsnTypeName(ac->type) );
			return true;
		}
		return MakeCppInheritance(ac,pf);
	}

	switch(ac->type)
	{
		case e_choice:
			return MakeCppStructChoice(ac,pf);
		case e_set:
			return MakeCppStructSet(ac,pf);
		case e_sequence:
			return MakeCppStructSequence(ac,pf);
		case e_extension:
		case e_class:
		case e_boolean:
		case e_integer:
		case e_bitString:
		case e_octetString:
		case e_null:
		case e_objectIdentifier:
		case e_enumerated:
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
		case e_bmpString:
		default:
			printf( "\n Err:MakeFile:CppStruct:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	return true;
}


bool MakeHeaderCpp( AsnClassBox *bx, CommandSet *cs )
{
	FILE *fp;
	char tName[256];
	unsigned int bxIndex;
	SYSTEMTIME	st;

	sprintf( (char*)tName, ".%soutput\\%s\\%s.h", DEFAULT_DIRECTORY, cs->pFolder, cs->pFile );
	fp = fopen( (const char*)tName, "w" );
	if( fp==0 )
	{
		printf( "\n Err:FileOpen:cpp-header" );
		return false;
	}

	GetSystemTime(&st);
	fprintf( fp, "#ifndef __%04d_%02d_%02d__%02d_%02d__%s_H__\n", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, cs->pFile );
	fprintf( fp, "#define __%04d_%02d_%02d__%02d_%02d__%s_H__\n\n\n", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, cs->pFile );
	fprintf( fp, "#include \"H323Define.h\"\n" );
	fprintf( fp, "#include \"handship.h\"\n\n\n\n" );

#if 0
	if( !strcmp(fName,"H225") )
		fprintf( fp,
			"/*handship{ on H225*/\n"
			"/*IMPORT*/\n"
			"#define ASNH225TimeStamp				ASNH235TimeStamp\n"
			"#include \"h245cpp.h\"\n"
			"#define ASNH225DataProtocolCapability	ASNH245DataProtocolCapability\n"
			"#define ASNH225T38FaxProfile			ASNH245T38FaxProfile\n"
			"/*handship}*/\n"
		);
#else
	cs->MakeCppHeaderFile(fp);
#endif

	for( bxIndex = 0; bxIndex < bx->acSize; bxIndex++ )
	{
		if( ! MakeCppStruct( (AsnClass*)(bx->ac[bxIndex]), fp ) )
		{
			fclose(fp);
			return false;
		}
	}

	fprintf( fp, "\n\n#endif/*__%04d_%02d_%02d__%02d_%02d__%s_H__*/", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, cs->pFile );

	fclose(fp);
	return true;
}







/**********************************************************************************************************/
/*
/*	Make C-PlusPlus Source File
*/
const char *gCppMemberChoiceConstructorString = 
"\
/***************************************************************************************/\n\
/* %s Class\n\
*/\n\
/* %s Constructor */\n\
%s::%s()\n\
: choiceInteger( e_constrained, 0, e_%sChoiceSize -1 )\n\
{\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::%s(NULL) -> null parameter\" );\n\
#endif\n\
		return;\n\
	}\n\
	alter		= HS_NULL;\n\
	extensible	= %s;\n\
	choice		= e_%sChoice_%s;\n\
}\n\
";
bool MakeCppMemberChoiceConstructor( AsnClass *ac, FILE *pf )
{
	fprintf( pf, gCppMemberChoiceConstructorString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName,
		ac->extendable? "TRUE":"FALSE", ac->cName, ac->member[0].mName
	);
	return true;
}


const char *gCppMemberChoiceDestructorString =
"\
/* %s Destructor */\n\
%s::~%s()\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::~%s(NULL) -> null parameter\" );\n\
#endif\n\
		return;\n\
	}\n\
	if( (tRet=DeleteAlternation()) != HS_OK )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::~%s(), tRet(%%u)\", tRet );\n\
#endif\n\
		return;\n\
	}\n\
}\n\
";
bool MakeCppMemberChoiceDestructor( AsnClass *ac, FILE *pf )
{
	fprintf( pf, gCppMemberChoiceDestructorString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);
	return true;
}


const char *gCppMemberChoiceSetChoiceString = 
"\
/* %s SetChoice */\n\
void* %s::SetChoice(%sChoice pChoice)\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::SetChoice(NULL,%%d) -> null parameter\", (int)pChoice );\n\
#endif\n\
		return HS_NULL;\n\
	}\n\
\n\
	if( e_%sChoiceSizeExt ){\n\
		if( pChoice > (%sChoice)(e_%sChoiceSizeExt-1) )\n\
		{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
			HSPrint( \"\\n Error on %s::SetChoice(%%d) -> invalid alternation value\", (int)pChoice );\n\
#endif\n\
			return HS_NULL;\n\
		}\n\
	}\n\
\n\
	if( alter != HS_NULL )\n\
	{\n\
		if( (tRet=DeleteAlternation()) != HS_OK )\n\
		{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
			HSPrint( \"\\n Error on %s::SetChoice(%%d), tRet(%%u)\", (int)pChoice, tRet );\n\
#endif\n\
			return HS_NULL;\n\
		}\n\
	}\n\
	choice = pChoice;\n\
\n\
";
bool MakeCppMemberChoiceSetChoice( AsnClass *ac, FILE *pf )
{
	int i;
	unsigned int lastMember=0;

	if( ac->mSize == 0 )
	{
		printf("\n Err:Abnormal:MakeCppMemberChoiceSetChoice:mSize is 0");
		return false;
	}
	fprintf( pf, gCppMemberChoiceSetChoiceString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );


	for( i=0; i<ac->mSize; i++ )
	{
		switch( ac->member[i].type )
		{
			case e_extension:
				fprintf( pf, "\t/*...,*/\n" );
				break;
			case e_class:
			case e_set:
			case e_choice:
			case e_sequence:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = new %s();\n\t\ttAlter->MakeMold();\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName
				);
				break;
			case e_boolean:
			case e_null:
			case e_objectIdentifier:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = new %s();\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName
				);
				break;
			case e_integer:
			case e_bitString:
			case e_octetString:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = new %s(%s,%d,%u,%d,%u);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
					GetConstraintTypeNameForParsing(ac->member[i].cons.type),
					ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
				);
				break;
			case e_printableString:
			case e_ia5String:
			case e_numericString:
			case e_generalString:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\tAsnSingleString *tAlter = new AsnSingleString(%s,%s,%d,%u,%d,%u);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName,
					GetSingleStringTagName(ac->member[i].type),
					GetConstraintTypeNameForParsing(ac->member[i].cons.type),
					ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
				);
				
				if( ac->member[i].from[0] != 0 )
				{
					fprintf( pf,
						"\t\t/* FROM Constraint */\n"
						"\t\tstrcpy((char*)(tAlter->fromConstraint), \"%s\");\n"
						"\t\ttAlter->fromSize = %d;\n"
						"\t\ttAlter->reIndexing = GetStringTypeEncodingBits(\n"
						"\t\t\ttAlter->fromSize,\n"
						"\t\t\t%s,\n"
						"\t\t\t&(tAlter->encodingBitsOfAlign),\n"
						"\t\t\t&(tAlter->encodingBitsOfUnalign)\n"
						"\t\t);\n",
						ac->member[i].from, strlen(ac->member[i].from), GetSingleStringVmaxName(ac->member[i].type)
					);
				}
				break;

			case e_bmpString:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = new %s(e_asnTagBMPString,%s,%d,%u,%d,%u);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
					GetConstraintTypeNameForParsing(ac->member[i].cons.type),
					ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
				);
				break;
			case e_enumerated:
				printf( "\n Err:MakeFile:cpp-source:MakeCppMemberChoiceSetChoice:enum subType" );
				return true;
			default:
				printf( "\n Err:MakeFile:cpp-source:MakeCppMemberChoiceSetChoice:unknown subType"
					", class:%s, member:%s, type(%d)", ac->cName, ac->member[i].mName, (int)ac->member[i].type
				);
				return false;
		}

		if( ac->member[i].type != e_extension )
		{
			if( ac->member[i].of )
			{
				fprintf( pf,
					"\t\tAsnSequenceOf<%s> *aso = new AsnSequenceOf<%s>();\n"
					"\t\taso->SetMold( tAlter );\n", ac->member[i].cName, ac->member[i].cName
				);
				if( ac->member[i].consOf.type != e_uncons )
				{
					fprintf( pf,
						"\t\t/* Sequence Of constraint */"
						"\t\taso->constraint.type = %s;"
						"\t\taso->constraint.minValue = %d;"
						"\t\taso->constraint.maxValue = %u;"
						"\t\taso->extMinValue = %d;"
						"\t\taso->extMaxValue = %u;",
						GetConstraintTypeNameForParsing(ac->member[i].consOf.type),
						ac->member[i].consOf.nMin, ac->member[i].consOf.nMax, ac->member[i].consOf.eMin, ac->member[i].consOf.eMax
					);
				}
				
				fprintf( pf, "\t\talter = aso;\n\t}\n" );
			}
			else
				fprintf( pf, "\t\talter = tAlter;\n\t}\n" );
		}
	}


	fprintf( pf,
		"\telse{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on %s::SetChoice(%%d) -> out of choice\", (int)pChoice );\n"
		"#endif\n\t\treturn HS_NULL;\n\t}\n"
		"\n\treturn alter;\n}\n\n", ac->cName
	);

	return true;
}


const char *gCppMemberChoiceDeleteAlternationString =
"\
/* %s DeleteAlternation */\n\
HS_RESULT %s::DeleteAlternation()\n\
{\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::DeleteAlternation(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( alter != HS_NULL )\n\
	{\n\
		/* root field datas */\n\
";
bool MakeCppMemberChoiceDeleteAlternation( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCppMemberChoiceDeleteAlternationString, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
			{
				fprintf( pf,
					"\t\t%s( choice == e_%sChoice_%s ){\n"
					"\t\t\tAsnSequenceOf<%s> *m_%s = (AsnSequenceOf<%s>*)alter;\n"
					"\t\t\tdelete m_%s;\n"
					"\t\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName,
					ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName
				);
			}
			else
			{
				fprintf( pf,
					"\t\t%s( choice == e_%sChoice_%s ){\n"
					"\t\t\t%s *m_%s = (%s*)alter;\n"
					"\t\t\tdelete m_%s;\n"
					"\t\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName,
					ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName
				);
			}
		}
	}

	fprintf( pf,
		"\t\telse\n"
		"\t\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\t\tHSPrint( \"\\n Error on %s::DeleteAlternation() -> out of choice, choice(%%d)\", (int)choice );\n"
		"#endif\n"
		"\t\t\talter = HS_NULL;\n"
		"\t\t\treturn HS_ERR_ASN_OUTOF_RANGE;\n"
		"\t\t}\n\n"
		"\t\talter = HS_NULL;\n"
		"\t}\n\n"
		"\treturn HS_OK;\n"
		"}\n\n", ac->cName
	);

	return true;
}


const char *gCppMemberChoiceEncodeString =
"\
/* %s Encode */\n\
HS_RESULT %s::Encode( AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
	BOOL		tExtended = FALSE;\n\
\n\
	if( this == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Encode(%%x,%%x) -> null parameter\", this, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
	if(alter == HS_NULL)\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Encode(pStrm) -> there is no choice\" );\n\
#endif\n\
		return HS_ERR_ASN_NOCHOICE;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( extensible )\n\
	{\n\
		if( e_%sChoiceSize )\n\
		{\n\
			if( choice > ((%sChoice)(e_%sChoiceSize-1)) ) tExtended = TRUE;\n\
			else tExtended = FALSE;\n\
\n\
			pStrm->BitEncoding( tExtended );\n\
		}\n\
		else tExtended = TRUE;\n\
	}\n\
\n\
	/* alternation encoding */\n\
	if( tExtended )\n\
	{\n\
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)choice - (HS_UINT)e_%sChoiceSize)) )\n\
	}\n\
	else\n\
	{\n\
		if( e_%sChoiceSize > 1 )\n\
		{\n\
			choiceInteger.SetValue( (HS_UINT)choice );\n\
			HS_TRY( choiceInteger.Encode(pStrm) )\n\
		}\n\
	}\n\
\n\
	/* root field datas */\n\
";
bool MakeCppMemberChoiceEncode( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCppMemberChoiceEncodeString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\tAsnStream tTempStrm(HS_ASN_MAX_EXTENSION_OCTET);\n"
						"\t\tAsnSequenceOf<%s> *m_%s = (AsnSequenceOf<%s>*)alter;\n"
						"\t\tif( (tRet=WellKnownExtensionEncoding( (AsnObject*)m_%s, pStrm, &tTempStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\tAsnSequenceOf<%s> *m_%s = (AsnSequenceOf<%s>*)alter;\n"
						"\t\tif( (tRet=m_%s->Encode(pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
			}
			else
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\tAsnStream tTempStrm(HS_ASN_MAX_EXTENSION_OCTET);\n"
						"\t\t%s *m_%s = (%s*)alter;\n"
						"\t\tif( (tRet=WellKnownExtensionEncoding( (AsnObject*)m_%s, pStrm, &tTempStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\t%s *m_%s = (%s*)alter;\n"
						"\t\tif( (tRet=m_%s->Encode(pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
			}
		}
	}

	fprintf( pf,
		"\telse\n"
		"\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> out of choice\" );\n"
		"#endif\n"
		"\t\treturn HS_ERR_ASN_OUTOF_RANGE;\n"
		"\t}\n\n"
		"\treturn HS_OK;\n"
		"}\n\n", ac->cName
	);

	return true;
}


const char *gCppMemberChoiceDecodeString =
"\
/* %s Decode */\n\
HS_RESULT %s::Decode( AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
	HS_UINT		tChoice = 0;\n\
	BOOL		tExtended = FALSE;\n\
\n\
	if( this == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Decode(%%x,%%x) -> null parameter\", this, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
	/* extension bit */\n\
	if( extensible ) pStrm->BitDecoding( &tExtended );\n\
	/* alternation decoding */\n\
	if( tExtended )\n\
	{\n\
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )\n\
		tChoice += e_%sChoiceSize;\n\
	}\n\
	else\n\
	{\n\
		if( e_%sChoiceSize > 1 )\n\
		{\n\
			HS_TRY( choiceInteger.Decode(pStrm) )\n\
			tChoice = choiceInteger.value;\n\
		}\n\
	}\n\
\n\
	if( e_%sChoiceSizeExt )\n\
	{\n\
		if( tChoice > (HS_UINT)(e_%sChoiceSizeExt - 1) )\n\
		{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
			HSPrint( \"\\n Error on %s::Decode(pStrm) -> asn range over\" );\n\
#endif\n\
			return HS_ERR_ASN_OUTOF_RANGE;\n\
		}\n\
	}\n\
\n\
	if( SetChoice( (%sChoice)tChoice ) == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Decode(pObj,pStrm) -> SetChoice Fail, choice(%%d)\", tChoice );\n\
#endif\n\
		return HS_ERR_ASN_OUTOF_RANGE;\n\
	}\n\
\n\
	/* root field datas */\n\
";
bool MakeCppMemberChoiceDecode( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCppMemberChoiceDecodeString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\tAsnSequenceOf<%s> *m_%s = (AsnSequenceOf<%s>*)alter;\n"
						"\t\tif( (tRet=WellKnownExtensionDecoding( (AsnObject*)m_%s, pStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\tAsnSequenceOf<%s> *m_%s = (AsnSequenceOf<%s>*)alter;\n"
						"\t\tif( (tRet=m_%s->Decode(pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
			}
			else
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\t%s *m_%s = (%s*)alter;\n"
						"\t\tif( (tRet=WellKnownExtensionDecoding( (AsnObject*)m_%s, pStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( choice == e_%sChoice_%s ){\n"
						"\t\t%s *m_%s = (%s*)alter;\n"
						"\t\tif( (tRet=m_%s->Decode(pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
					);
			}
		}
	}

	fprintf( pf,
		"\telse\n"
		"\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on %s::Decode(Obj,pStrm) -> out of choice\" );\n"
		"#endif\n"
		"\t\treturn HS_ERR_ASN_OUTOF_RANGE;\n"
		"\t}\n\n"
		"\treturn HS_OK;\n"
		"}\n\n", ac->cName
	);

	return true;
}


const char *gCppMemberChoicePrintString =
"\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
/* %s Print */\n\
HS_RESULT %s::Print( HS_UINT pDepth, char *pTypeName )\n\
{\n\
	HS_UINT i;\n\
	if( this == HS_NULL )\n\
	{\n\
		HSPrint( \"\\n Error on %s::Print(NULL,%%u,%%s) -> null parameter\", pDepth, pTypeName==HS_NULL? \"\":pTypeName );\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	HSPrint( \"\\n\" );\n\
	for( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n\
	if( pTypeName != HS_NULL ) HSPrint( \"%%s\", pTypeName );\n\
	HSPrint( \"<CHOICE> = {\" );\n\
\n\
	if( alter == HS_NULL )\n\
	{\n\
		HSPrint( \"  Error : No Value\\n\" );\n\
		for( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n\
		HSPrint( \"}\" );\n\
		return HS_OK;\n\
	}\n\
\n\
	/* root field datas */\n\
";
bool MakeCppMemberChoicePrint( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCppMemberChoicePrintString, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
				fprintf( pf,
					"\t%s( choice == e_%sChoice_%s ){\n"
					"\t\tAsnSequenceOf<%s> *m_%s = (AsnSequenceOf<%s>*)alter;\n"
					"\t\tm_%s->Print( pDepth+1, \"%s\" );\n"
					"\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
					ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->member[i].mName
				);
			else
				fprintf( pf,
					"\t%s( choice == e_%sChoice_%s ){\n"
					"\t\t%s *m_%s = (%s*)alter;\n"
					"\t\tm_%s->Print( pDepth+1, \"%s\" );\n"
					"\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName,
					ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->member[i].mName
				);
		}
	}

	fprintf( pf,
		"\telse\n"
		"\t{\n"
		"\t\tprintf( \"  Error : Unknown Choice\\n\" );\n"
		"\t\tfor( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n"
		"\t\tprintf( \"}\" );\n"
		"\t\treturn HS_OK;\n"
		"\t}\n\n"
		"\tprintf( \"\\n\" );\n"
		"\tfor( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n"
		"\tprintf(\"}\");\n\n"
		"\treturn HS_OK;\n"
		"}\n"
		"#endif\n\n"
	);
	
	return true;
}

bool MakeCppMemberChoice( AsnClass *ac, FILE *pf )
{
	if( ! MakeCppMemberChoiceConstructor(ac,pf) )
		return false;
	if( ! MakeCppMemberChoiceDestructor(ac,pf) )
		return false;
	if( ! MakeCppMemberChoiceSetChoice(ac,pf) )
		return false;
	if( ! MakeCppMemberChoiceDeleteAlternation(ac,pf) )
		return false;
	if( ! MakeCppMemberChoiceEncode(ac,pf) )
		return false;
	if( ! MakeCppMemberChoiceDecode(ac,pf) )
		return false;
	if( ! MakeCppMemberChoicePrint(ac,pf) )
		return false;

	return true;
}



const char *gCppMemberSequenceConstructorString =
"\
{\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::%s(NULL) -> null parameter\" );\n\
#endif\n\
		return;\n\
	}\n\
\n\
	extensible = %s;\n\
	extended = FALSE;\n\
";
bool MakeCppMemberSequenceConstructor( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;
	bool initStarted = false;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	fprintf( pf,
		"/***************************************************************************************/\n"
		"/* %s Class */\n"
		"/*%s Constructor*/\n%s::%s()\n", ac->cName, ac->cName, ac->cName, ac->cName
	);

	for( i=0; i<ac->mSize; i++ )
	{
		if( !(ac->member[i].of) )
		{
			switch( ac->member[i].type )
			{
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
					if( initStarted ) fprintf( pf, ", " );
					else {	fprintf( pf, ": " );	initStarted = true;	}

					fprintf( pf, "m_%s( %s, %s, %d, %u, %d, %u )\n",
						ac->member[i].mName, GetSingleStringTagName( ac->member[i].type ),
						GetConstraintTypeNameForParsing( ac->member[i].cons.type ),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					break;
				case e_bmpString:
					if( initStarted ) fprintf( pf, ", " );
					else {	fprintf( pf, ": " );	initStarted = true;	}

					fprintf( pf, "m_%s( %s, %s, %d, %u, %d, %u )\n",
						ac->member[i].mName, GetDoubleStringTagName( ac->member[i].type ),
						GetConstraintTypeNameForParsing( ac->member[i].cons.type ),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					break;
				case e_integer:
				case e_bitString:
				case e_octetString:
					if( ac->member[i].cons.type != e_uncons )
					{
						if( initStarted ) fprintf( pf, ", " );
						else {	fprintf( pf, ": " );	initStarted = true;	}

						fprintf( pf, "m_%s( %s, %d, %u, %d, %u )\n",
							ac->member[i].mName, GetConstraintTypeNameForParsing( ac->member[i].cons.type ),
							ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
						);
					}
					break;
			}
		}
	}

	fprintf( pf, gCppMemberSequenceConstructorString, ac->cName, ac->cName, ac->extendable? "TRUE":"FALSE" );

	fprintf( pf, "\n" );
	if(x) fprintf( pf, "\tmemset( optionMap, 0, HS_ASN_OPTION_MAP_MAX );\n" );
	if(y)
		fprintf( pf,
			"\tmemset( extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );\n"
			"\textOptionMapSize = 0;\n"
		);
	fprintf( pf, "\n" );

	/* From Constraint */
	initStarted = false;
	for( i=0; i<ac->mSize; i++ )
	{
		if( !(ac->member[i].of) && ac->member[i].from[0] )
		{
			if( initStarted == false ){ fprintf( pf, "\t/* FROM Constraint */\n" );	initStarted = true; }

			fprintf( pf,
				"\tstrcpy((char*)(m_%s.fromConstraint), \"%s\");\n"
				"\tm_%s.fromSize = %d;\n"
				"\tm_%s.reIndexing =	GetStringTypeEncodingBits(\n"
				"\t\tm_%s.fromSize,\n"
				"\t\tASN_IA5_STRING_VMAX,\n"
				"\t\t&(m_%s.encodingBitsOfAlign),\n"
				"\t\t&(m_%s.encodingBitsOfUnalign)\n"
				"\t);\n", ac->member[i].mName, ac->member[i].from, ac->member[i].mName, strlen(ac->member[i].from),
				ac->member[i].mName, ac->member[i].mName, ac->member[i].mName, ac->member[i].mName
			);
		}
	}

	fprintf( pf, "}\n\n" );
	return true;
}


const char *gCppMemberSequenceMakeMoldString =
"\
/* %s MakeMold */\n\
HS_RESULT %s::MakeMold()\n\
{\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::MakeMold(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
";
bool MakeCppMemberSequenceMakeMold( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCppMemberSequenceMakeMoldString, ac->cName, ac->cName, ac->cName );

	/* SequenceOf */
	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].of )
		{
			switch( ac->member[i].type )
			{
				case e_class:
				case e_set:
				case e_sequence:
					fprintf( pf, "\t%s *tmold_%s = new %s();\n\ttmold_%s->MakeMold();\n\tm_%s.SetMold( tmold_%s );\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->member[i].mName, ac->member[i].mName
					);
					break;
				case e_choice:
				case e_boolean:
				case e_null:
				case e_objectIdentifier:
					fprintf( pf, "\t%s *tmold_%s = new %s();\n\tm_%s.SetMold( tmold_%s );\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->member[i].mName
					);
					break;
				case e_integer:
				case e_bitString:
				case e_octetString:
					fprintf( pf, "\t%s *tmold_%s = new %s(%s,%d,%u,%d,%u);\n"
								"\tm_%s.SetMold( tmold_%s );\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, GetConstraintTypeNameForParsing(ac->member[i].cons.type),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax, ac->member[i].mName, ac->member[i].mName
					);
					break;
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
					fprintf( pf, "\tAsnSingleString *tmold_%s = new AsnSingleString(%s,%s,%d,%u,%d,%u);\n",
						ac->member[i].mName, GetSingleStringTagName(ac->member[i].type),
						GetConstraintTypeNameForParsing(ac->member[i].cons.type),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					if( ac->member[i].from[0] != 0 )
					{
						fprintf( pf,
							"\tstrcpy((char*)(tmold_%s->fromConstraint), \"%s\");\n"
							"\ttmold_%s->fromSize = %d;\n"
							"\ttmold_%s->reIndexing = GetStringTypeEncodingBits(\n"
							"\t\ttmold_%s->fromSize,\n"
							"\t\t%s,\n"
							"\t\t&(tmold_%s->encodingBitsOfAlign),\n"
							"\t\t&(tmold_%s->encodingBitsOfUnalign)\n"
							"\t);\n",
							ac->member[i].mName, ac->member[i].from, ac->member[i].mName, strlen(ac->member[i].from),
							ac->member[i].mName, ac->member[i].mName, GetSingleStringVmaxName(ac->member[i].type),
							ac->member[i].mName, ac->member[i].mName
						);
					}
					fprintf( pf, "\tm_%s.SetMold( tmold_%s );\n", ac->member[i].mName, ac->member[i].mName );
					break;

				case e_bmpString:
					fprintf( pf, "\tAsnDoubleString *tmold_%s = new AsnDoubleString(%s,%s,%d,%u,%d,%u);\n\tm_%s.SetMold( tmold_%s );\n",
						ac->member[i].mName, GetDoubleStringTagName(ac->member[i].type),
						GetConstraintTypeNameForParsing(ac->member[i].cons.type),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax, ac->member[i].mName, ac->member[i].mName
					);
					break;
			}

			if( ac->member[i].consOf.type != e_uncons )
				fprintf( pf,
					"\t/* Sequence Of constraint */\n"
					"\tm_%s.constraint.type = %s;\n"
					"\tm_%s.constraint.minValue = %d;\n"
					"\tm_%s.constraint.maxValue = %u;\n"
					"\tm_%s.extMinValue = %d;\n"
					"\tm_%s.extMaxValue = %u;\n",
					ac->member[i].mName, GetConstraintTypeNameForParsing(ac->member[i].consOf.type),
					ac->member[i].mName, ac->member[i].consOf.nMin, ac->member[i].mName, ac->member[i].consOf.nMax,
					ac->member[i].mName, ac->member[i].consOf.eMin, ac->member[i].mName, ac->member[i].consOf.eMax
				);
		}// if(of)
		else
		{
			switch( ac->member[i].type )
			{
				case e_class:
				case e_set:
				case e_sequence:
					fprintf( pf, "\tm_%s.MakeMold();\n", ac->member[i].mName );
					break;
				case e_choice:
				case e_boolean:
				case e_null:
				case e_objectIdentifier:
				case e_integer:
				case e_bitString:
				case e_octetString:
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
				case e_bmpString:
					break;
			}
		}
	}// for

	fprintf( pf, "\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCppMemberSequenceDestructorString =
"\
/* %s Destructor */\n\
%s::~%s()\n\
{\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::~%s(NULL) -> null parameter\" );\n\
#endif\n\
		return;\n\
	}\n\
}\n\n\
";
bool MakeCppMemberSequenceDestructor( AsnClass *ac, FILE *pf )
{
	fprintf( pf, gCppMemberSequenceDestructorString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	return true;
}


const char *gCppMemberSequenceIncludeOptionFieldStringBoth =
"\
/* %s IncludeOptionalField */\n\
HS_RESULT %s::IncludeOptionField( %sOptionMap pOptionMap )\n\
{\n\
	HS_UINT	tExtOptionMap;\n\
	HS_UINT	tByteOffset, tBitOffset;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;\n\
\n\
	if( ((HS_UINT)pOptionMap) < e_%sOptionMapSize )\n\
	{\n\
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
		tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
\n\
		optionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
	}\n\
	else\n\
	{\n\
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
\n\
		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
\n\
		extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
\n\
		if( extOptionMapSize < (tExtOptionMap+1) ) extOptionMapSize = tExtOptionMap + 1 ;\n\
\n\
		extended = TRUE;\n\
	}\n\
\n\
	return HS_OK;\n\
}\n\n\
";
const char *gCppMemberSequenceIncludeOptionFieldStringOpt =
"\
/* %s IncludeOptionalField */\n\
HS_RESULT %s::IncludeOptionField( %sOptionMap pOptionMap )\n\
{\n\
	HS_UINT	tByteOffset, tBitOffset;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;\n\
\n\
	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
	optionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
\n\
	return HS_OK;\n\
}\n\n\
";
const char *gCppMemberSequenceIncludeOptionFieldStringExt =
"\
/* %s IncludeOptionalField */\n\
HS_RESULT %s::IncludeOptionField( %sOptionMap pOptionMap )\n\
{\n\
	HS_UINT	tExtOptionMap;\n\
	HS_UINT	tByteOffset, tBitOffset;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;\n\
\n\
	tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
	extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
\n\
	if( extOptionMapSize < (tExtOptionMap+1) ) extOptionMapSize = tExtOptionMap + 1 ;\n\
	if( extOptionMapSize ) extended = TRUE;\n\
\n\
	return HS_OK;\n\
}\n\n\
";
bool MakeCppMemberSequenceIncludeOptionField( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	if( x && y )
	{
		fprintf( pf, gCppMemberSequenceIncludeOptionFieldStringBoth,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);
	}
	else
	{
		if(x)
			fprintf( pf, gCppMemberSequenceIncludeOptionFieldStringOpt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
		else if(y)
			fprintf( pf, gCppMemberSequenceIncludeOptionFieldStringExt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
	}

	return true;
}


const char *gCppMemberSequenceIsIncludeOptionFieldStringBoth =
"\
/* %s IsIncludeOptionalField */\n\
BOOL %s::IsIncludeOptionField( %sOptionMap pOptionMap )\n\
{\n\
	HS_UCHAR tByte;\n\
\n\
	HS_UINT tExtOptionMap;\n\
	HS_UINT tByteOffset, tBitOffset;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return FALSE;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return FALSE;\n\
\n\
	if( ((HS_UINT)pOptionMap) < e_%sOptionMapSize )\n\
	{\n\
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
		tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
\n\
		tByte = 1<<(7-tBitOffset);\n\
\n\
		if( tByte & optionMap[tByteOffset] ) return TRUE;\n\
		return FALSE;\n\
	}\n\
\n\
	tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
\n\
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
\n\
	tByte = 1<<(7-tBitOffset);\n\
\n\
	if( tByte & extOptionMap[tByteOffset] ) return TRUE;\n\
	return FALSE;\n\
}\n\n\
";
const char *gCppMemberSequenceIsIncludeOptionFieldStringOpt =
"\
/* %s IsIncludeOptionalField */\n\
BOOL %s::IsIncludeOptionField( %sOptionMap pOptionMap )\n\
{\n\
	HS_UCHAR tByte;\n\
\n\
	HS_UINT tByteOffset, tBitOffset;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return FALSE;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSize -1 ) return FALSE;\n\
\n\
	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
	tByte = 1<<(7-tBitOffset);\n\
\n\
	if( tByte & optionMap[tByteOffset] ) return TRUE;\n\
	return FALSE;\n\
}\n\n\
";
const char *gCppMemberSequenceIsIncludeOptionFieldStringExt =
"\
/* %s IsIncludeOptionalField */\n\
BOOL %s::IsIncludeOptionField( %sOptionMap pOptionMap )\n\
{\n\
	HS_UCHAR tByte;\n\
\n\
	HS_UINT tExtOptionMap;\n\
	HS_UINT tByteOffset, tBitOffset;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return FALSE;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return FALSE;\n\
\n\
	tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
\n\
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
\n\
	tByte = 1<<(7-tBitOffset);\n\
\n\
	if( tByte & extOptionMap[tByteOffset] ) return TRUE;\n\
	return FALSE;\n\
}\n\n\
";
bool MakeCppMemberSequenceIsIncludeOptionField( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}
	
	if( x && y )
	{	
		fprintf( pf, gCppMemberSequenceIsIncludeOptionFieldStringBoth,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);
	}
	else
	{
		if(x)
			fprintf( pf, gCppMemberSequenceIsIncludeOptionFieldStringOpt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
		else if(y)
			fprintf( pf, gCppMemberSequenceIsIncludeOptionFieldStringExt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
	}

	return true;
}


const char *gCppMemberSequenceEncodeStringOpt =
"\
/* %s Encode */\n\
HS_RESULT %s::Encode( AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	if( this == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Encode(%%x,%%x) -> null parameter\", this, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( extensible ) pStrm->BitEncoding( extended );\n\
\n\
	/* option map bits */\n\
	if( e_%sOptionMapSize != 0 )\n\
		pStrm->BitsEncoding( optionMap, e_%sOptionMapSize, e_alignLeft );\n\
\n\
	/* root field datas */\n\
";
const char *gCppMemberSequenceEncodeStringNon =
"\
/* %s Encode */\n\
HS_RESULT %s::Encode( AsnStream *pStrm )\n\
{\n\
	%s\n\
	if( this == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Encode(%%x,%%x) -> null parameter\", this, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( extensible ) pStrm->BitEncoding( extended );\n\
\n\
";
bool MakeCppMemberSequenceEncode( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0, z=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	if(ac->extendable)	z = ac->mSize-1;
	else				z = ac->mSize;

	if(x) fprintf( pf, gCppMemberSequenceEncodeStringOpt, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	else  fprintf( pf, gCppMemberSequenceEncodeStringNon, ac->cName, ac->cName, z? "HS_RESULT tRet;\n":"", ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension )
		{
			if(y)
				fprintf( pf,
					"\n\t/* extension field datas */\n"
					"\tif( extOptionMapSize )\n"
					"\t{\n"
					"\t\tAsnStream tTempStrm(HS_ASN_MAX_EXTENSION_OCTET);\n"
					"\t\t/* extension bitMap size */\n"
					"\t\tSmallNumberEncoding( pStrm, (extOptionMapSize-1) );\n"
					"\t\t/* option bitMap encoding */\n"
					"\t\tpStrm->BitsEncoding( extOptionMap, extOptionMapSize, e_alignLeft );\n\n"
					"\t\t/* datas */\n"
				);
		}
		else
		{
			if( ac->member[i].extended )
				fprintf( pf,
					"\t\tif( IsIncludeOptionField( e_%sOptionMap_%s ) ){\n"
					"\t\t\tif( (tRet=WellKnownExtensionEncoding( (AsnObject*)&m_%s, pStrm, &tTempStrm )) != HS_OK )\n"
					"\t\t\t{\n"
					"#ifdef HS_DEBUG_ASN_MEMBER\n"
					"\t\t\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
					"#endif\n"
					"\t\t\t\treturn tRet;\n"
					"\t\t\t}\n"
					"\t\t}\n", ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
				);
			else
			{
				if( ac->member[i].optional )
					fprintf( pf,
						"\tif( IsIncludeOptionField( e_%sOptionMap_%s ) ){\n"
						"\t\tif( (tRet=m_%s.Encode(pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n", ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\tif( (tRet=m_%s.Encode(pStrm)) != HS_OK )\n"
						"\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\tHSPrint( \"\\n Error on %s::Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\treturn tRet;\n"
						"\t}\n", ac->member[i].mName, ac->cName
					);
			}
		}
	}

	if(y) fprintf( pf, "\t}\t" );

	fprintf( pf, "\n\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCppMemberSequenceDecodeStringOpt =
"\
/* %s Decode */\n\
HS_RESULT %s::Decode( AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	if( this == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Decode(%%x,%%x) -> null parameter\", this, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( extensible ) pStrm->BitDecoding( &extended );\n\
\n\
	/* option map bits */\n\
	if( e_%sOptionMapSize != 0 )\n\
		pStrm->BitsDecoding( optionMap, e_%sOptionMapSize, e_alignLeft );\n\
\n\
	/* root field datas */\n\
";
const char *gCppMemberSequenceDecodeStringNon =
"\
/* %s Decode */\n\
HS_RESULT %s::Decode( AsnStream *pStrm )\n\
{\n\
	%s\n\
	if( this == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s::Decode(%%x,%%x) -> null parameter\", this, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( extensible ) pStrm->BitDecoding( &extended );\n\
\n\
	/* root field datas */\n\
";
bool MakeCppMemberSequenceDecode( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0, z=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	if(ac->extendable)	z = ac->mSize-1;
	else				z = ac->mSize;
	
	if(x) fprintf( pf, gCppMemberSequenceDecodeStringOpt, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	else  fprintf( pf, gCppMemberSequenceDecodeStringNon, ac->cName, ac->cName, z? "HS_RESULT tRet;\n":"", ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension )
		{
			if(y)
				fprintf( pf,
					"\n\t/* extension field datas */\n"
					"\tif( ! extended ) return HS_OK;\n"
					"\tif( SmallNumberDecoding(pStrm, &extOptionMapSize) != HS_OK )\n"
					"\t{\n"
					"\t\textOptionMapSize = 0;\n"
					"\t\treturn HS_OK;\n"
					"\t}\n"
					"\textOptionMapSize++;\n"
					"\t/* option bitMap encoding */\n"
					"\tHS_TRY_OK( pStrm->BitsDecoding(extOptionMap, extOptionMapSize, e_alignLeft) )\n\n"
				);
		}
		else
		{
			if( ac->member[i].extended )
				fprintf( pf,
					"\tif( IsIncludeOptionField( e_%sOptionMap_%s ) ){\n"
					"\t\tif( (tRet=WellKnownExtensionDecoding( (AsnObject*)&m_%s, pStrm )) != HS_OK )\n"
					"\t\t{\n"
					"#ifdef HS_DEBUG_ASN_MEMBER\n"
					"\t\t\tHSPrint( \"\\n Error on %s::Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
					"#endif\n"
					"\t\t\treturn tRet;\n"
					"\t\t}\n"
					"\t}\n", ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
				);
			else
			{
				if( ac->member[i].optional )
					fprintf( pf,
						"\tif( IsIncludeOptionField( e_%sOptionMap_%s ) ){\n"
						"\t\tif( (tRet=m_%s.Decode(pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s::Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n", ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\tif( (tRet=m_%s.Decode(pStrm)) != HS_OK )\n"
						"\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\tHSPrint( \"\\n Error on %s::Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\treturn tRet;\n"
						"\t}\n", ac->member[i].mName, ac->cName
					);
			}
		}
	}

	fprintf( pf, "\n\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCppMemberSequencePrintString =
"\
#ifdef HS_DEBUG_ASN_PRINT\n\
/* %s Print */\n\
HS_RESULT %s::Print( HS_UINT pDepth, char *pTypeName )\n\
{\n\
	HS_UINT i;\n\
\n\
	if( this == HS_NULL )\n\
	{\n\
		HSPrint( \"\\n Error on %s::Print(NULL,%%u,%%s) -> null parameter\", pDepth, pTypeName==HS_NULL? \"\":pTypeName );\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	HSPrint( \"\\n\" );\n\
	for( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n\
\n\
	if( pTypeName != HS_NULL ) HSPrint( \"%%s\", pTypeName );\n\
	HSPrint( \"<SEQUENCE> = {\" );\n\n\
";
bool MakeCppMemberSequencePrint( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCppMemberSequencePrintString, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension )
			fprintf( pf,
				"\tprintf( \"\\n\" );\n"
				"\tfor( i=0; i<pDepth+1; i++ ) HSPrint( \"  \" );\n"
				"\tprintf( \"...,\" );\n"
			);
		else
		{
			if( ac->member[i].optional || ac->member[i].extended )
				fprintf( pf,
					"\tif( IsIncludeOptionField( e_%sOptionMap_%s ) )\n"
					"\t\tm_%s.Print( pDepth+1, \"%s\" );\n",
					ac->cName, ac->member[i].mName, ac->member[i].mName, ac->member[i].mName
				);
			else
				fprintf( pf,
					"\tm_%s.Print( pDepth+1, \"%s\" );\n",
					ac->member[i].mName, ac->member[i].mName
				);
		}
	}

	fprintf( pf,
		"\tprintf( \"\\n\" );\n"
		"\tfor( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n"
		"\tprintf(\"}\");\n\n"
		"\treturn HS_OK;\n"
		"}\n"
		"#endif\n\n"
	);

	return true;
}


bool MakeCppMemberSequence( AsnClass *ac, FILE *pf )
{
	if( ! MakeCppMemberSequenceConstructor(ac,pf) )
		return false;
	if( ! MakeCppMemberSequenceDestructor(ac,pf) )
		return false;
	if( ! MakeCppMemberSequenceMakeMold(ac,pf) )
		return false;
	if( ! MakeCppMemberSequenceIncludeOptionField(ac,pf) )
		return false;
	if( ! MakeCppMemberSequenceIsIncludeOptionField(ac,pf) )
		return false;
	if( ! MakeCppMemberSequenceEncode(ac,pf) )
		return false;
	if( ! MakeCppMemberSequenceDecode(ac,pf) )
		return false;
	if( ! MakeCppMemberSequencePrint(ac,pf) )
		return false;
	return true;
}

bool MakeCppMemberSet( AsnClass *ac, FILE *pf )
{
	return MakeCppMemberSequence(ac,pf);
}


bool MakeCppMember( AsnClass *ac, FILE *pf )
{
	if( ac->handship )
	{
		if( ac->type == e_enumerated )
			printf( "\n Inf:MakeFile:CppMember:Handship:Enumerated:class[%s]", ac->cName );

		if( ac->of )
			printf( "\n Inf:MakeFile:CppMember:Handship:SomeOf:class[%s],type[%s]", ac->cName, GetAsnTypeName(ac->type) );

		return true;
	}


	switch(ac->type)
	{
		case e_choice:
			return MakeCppMemberChoice(ac,pf);
		case e_set:
			return MakeCppMemberSet(ac,pf);
		case e_sequence:
			return MakeCppMemberSequence(ac,pf);
		case e_extension:
		case e_class:
		case e_boolean:
		case e_integer:
		case e_bitString:
		case e_octetString:
		case e_null:
		case e_objectIdentifier:
		case e_enumerated:
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
		case e_bmpString:
		default:
			printf( "\n Err:MakeFile:cpp-source:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	return true;
}


bool MakeSourceCpp( AsnClassBox *bx, CommandSet *cs )
{
	FILE *fp;
	char tName[256];
	char hName[256];
	unsigned int bxIndex;
	unsigned int fileCounter=0;

	sprintf( (char*)tName, ".%soutput\\%s\\%s_%d.cpp", DEFAULT_DIRECTORY, cs->pFolder, cs->pFile, fileCounter++ );
	sprintf( (char*)hName, "%s.h", cs->pFile );
	fp = fopen( (const char*)tName, "w" );
	if( fp==0 )
	{
		printf( "\n Err:FileOpen:cpp-source" );
		return false;
	}

	fprintf( fp, "\n\n#include \"%s\"\n\n", hName );
	cs->MakeCppSourceFile(fp);

	for( bxIndex = 0; bxIndex < bx->acSize; bxIndex++ )
	{
		if( ! MakeCppMember( (AsnClass*)(bx->ac[bxIndex]), fp ) )
		{
			fclose(fp);
			return false;
		}

		if( ((bxIndex+1)%150) == 0 )
		{
			sprintf( (char*)tName, ".%soutput\\%s\\%s_%d.cpp", DEFAULT_DIRECTORY, cs->pFolder, cs->pFile, fileCounter++ );
			fp = fopen( (const char*)tName, "w" );
			if( fp==0 )
			{
				printf( "\n Err:FileOpen:cpp-source" );
				return false;
			}
			fprintf( fp, "\n\n#include \"%s\"\n\n", hName );
		}
	}

	fclose(fp);
	return true;
}