/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnFileC.cpp>	2005-02-27,10:15

*/

#include "asnFileC.h"
#include <windows.h>



/**********************************************************************************************************/
/*
/*	Make C Header File
*/
const char *gCHeaderChoiceString =
"\
typedef struct\n\
{\n\
	%sChoice choice;\n\
	AsnInteger choiceInteger;\n\
\n\
	BOOL extensible;\n\
	void *alter;\n\
} %s;\n\
HS_RESULT new_%s( void *pObject );\n\
HS_RESULT delete_%s( void *pObject );\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName );\n\
#endif\n\
void*	  %s_SetChoice( void *pObject, %sChoice pChoice );\n\
HS_RESULT %s_DeleteAlternation( void *pObject );\n\
HS_RESULT %s_MakeMold( void *pObject );\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm );\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm );\n\n\n\n\n\n\
";
bool MakeCStructChoice( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;


	fprintf( pf, "typedef enum\n{\n" );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\n" );
		else
		{
			if(i)	fprintf( pf, ",\n\te_%sChoice_%s", ac->cName, ac->member[i].mName );
			else	fprintf( pf,    "\te_%sChoice_%s",  ac->cName, ac->member[i].mName );
		}
	}
	fprintf( pf, "\n} %sChoice;\n", ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type != e_extension )
		{
			y++;
			if( ! ac->member[i].extended )
				x++;
		}
	}
	fprintf( pf, "\n\n#define e_%sChoiceSize		%d\n", ac->cName, x );
	fprintf( pf, "#define e_%sChoiceSizeExt	%d\n", ac->cName, y );

	fprintf( pf, gCHeaderChoiceString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	return true;
}


const char *gCHeaderSequenceStringOptional =
"\
HS_RESULT new_%s( void *pObject );\n\
HS_RESULT delete_%s( void *pObject );\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName );\n\
#endif\n\
HS_RESULT %s_IncludeOptionField( void *pObject, %sOptionMap pOptionMap );\n\
BOOL	  %s_IsIncludeOptionField( void *pObject, %sOptionMap pOptionMap );\n\
HS_RESULT %s_MakeMold( void *pObject );\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm );\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm );\n\n\n\n\n\n\
";
const char *gCHeaderSequenceStringNonOptional =
"\
HS_RESULT new_%s( void *pObject );\n\
HS_RESULT delete_%s( void *pObject );\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName );\n\
#endif\n\
HS_RESULT %s_MakeMold( void *pObject );\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm );\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm );\n\n\n\n\n\n\
";
bool MakeCStructSequence( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;
	bool started = false;

	
	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	/*Make Enum*/
	if( x || y )
	{
		fprintf( pf, "typedef enum\n{\n" );
		for( i=0; i<ac->mSize; i++ )
		{
			if( ac->member[i].type == e_extension ) fprintf( pf, "\n" );
			else
			{
				if( ac->member[i].optional || ac->member[i].extended )
				{
					if(started) fprintf( pf, ",\n\te_%sOptionMap_%s", ac->cName, ac->member[i].mName );
					else
					{
						started = true;
						fprintf( pf,    "\te_%sOptionMap_%s",  ac->cName, ac->member[i].mName );
					}
				}
			}
		}
		fprintf( pf, "\n} %sOptionMap;\n\n", ac->cName );
	}

	fprintf( pf, "\n#define e_%sOptionMapSize %d\n", ac->cName, x );
	fprintf( pf, "#define e_%sOptionMapSizeExt %d\n", ac->cName, x+y );

	fprintf( pf, "typedef struct\n{\n\tBOOL extensible;\n\tBOOL extended;\n" );

	if(x) fprintf( pf, "\n\tHS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];\n" );
	if(y)
		fprintf( pf,
			"\n\tHS_UINT		extOptionMapSize;	/* Bit Size */"
			"\n\tHS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];\n"
		);
	fprintf( pf, "\n\t/* Member of ASN */\n" );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
				fprintf( pf, "\tAsnSequenceOf m_%s;\n", ac->member[i].mName );
			else
				fprintf( pf, "\t%s m_%s;\n", ac->member[i].cName, ac->member[i].mName );
		}
	}
	fprintf( pf, "} %s;\n", ac->cName );

	if( x || y )
		fprintf( pf, gCHeaderSequenceStringOptional,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);
	else
		fprintf( pf, gCHeaderSequenceStringNonOptional,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);

	return true;
}


bool MakeCStructSet( AsnClass *ac, FILE *pf )
{
	return MakeCStructSequence(ac,pf);
}


bool MakeCInheritance( AsnClass *ac, FILE *pf )
{
	if( ac==0 || pf==0 )
	{
		printf( "\n Err:MakeFile:Inherit:NULL" );
		return false;
	}

	switch(ac->type)
	{
		case e_class:
			if( ac->of )
			{
				fprintf( pf,
					"typedef struct\n{\n\tAsnSequenceOf\tinheritance;\n} %s;\n"
					"HS_RESULT new_%s( void *pObject );\n", ac->cName, ac->cName
				);
				break;
			}
			else
			{
				fprintf( pf,
					"#define %s          %s\n"
					"#define new_%s      new_%s\n"
					"#define delete_%s   delete_%s\n"
					"#define %s_MakeMold %s_MakeMold\n"
					"#define %s_Print    %s_Print\n"
					"#define %s_Encode   %s_Encode\n"
					"#define %s_Decode   %s_Decode\n\n",
					ac->cName, ac->sName, ac->cName, ac->sName, ac->cName, ac->sName, ac->cName, ac->sName,
					ac->cName, ac->sName, ac->cName, ac->sName, ac->cName, ac->sName
				);
				return true;
			}
		case e_boolean:
			fprintf( pf,
				"typedef struct\n{\n\tAsnBoolean\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n", ac->cName, ac->cName
			);
			break;
		case e_null:
			fprintf( pf,
				"typedef struct\n{\n\tAsnNull\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n", ac->cName, ac->cName
			);
			break;
		case e_objectIdentifier:
			fprintf( pf,
				"typedef struct\n{\n\tAsnObjectIdentifier\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n", ac->cName, ac->cName
			);
			break;
		case e_integer:
			fprintf( pf,
				"typedef struct\n{\n\tAsnInteger\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n",
				ac->cName, ac->cName
			);
			break;
		case e_bitString:
			fprintf( pf,
				"typedef struct\n{\n\tAsnBitString\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n",
				ac->cName, ac->cName
			);
			break;
		case e_octetString:
			fprintf( pf,
				"typedef struct\n{\n\tAsnOctetString\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n",
				ac->cName, ac->cName
			);
			break;
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
			fprintf( pf,
				"typedef struct\n{\n\tAsnSingleString\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n",
				ac->cName, ac->cName
			);
			break;
		case e_bmpString:
			fprintf( pf,
				"typedef struct\n{\n\tAsnDoubleString\tinheritance;\n} %s;\n"
				"HS_RESULT new_%s( void *pObject );\n",
				ac->cName, ac->cName
			);
			break;
		case e_enumerated:
			printf( "\n Err:MakeFile:Inherit:Enum" );
			return false;
		case e_extension:
		case e_choice:
		case e_set:
		case e_sequence:
		default:
			printf( "\n Err:MakeFile:CStruct:Inherit:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	fprintf( pf,
		"HS_RESULT delete_%s( void *pObject );\n"
		"#ifdef HS_DEBUG_ASN_PRINT\n"
		"HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName );\n"
		"#endif\n"
		"HS_RESULT %s_MakeMold( void *pObject );\n"
		"HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm );\n"
		"HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm );\n\n",
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);
	return true;
}


bool MakeCStruct( AsnClass *ac, FILE *pf )
{
	if( ac->handship )
	{
		if( ac->type == e_enumerated )
		{
			printf( "\n Inf:MakeFile:CStruct:Handship:Enumerated:class[%s]", ac->cName );
			return true;
		}
		return MakeCInheritance(ac,pf);
	}

	switch(ac->type)
	{
		case e_choice:
			return MakeCStructChoice(ac,pf);
		case e_set:
			return MakeCStructSet(ac,pf);
		case e_sequence:
			return MakeCStructSequence(ac,pf);
		case e_extension:
		case e_class:
		case e_boolean:
		case e_integer:
		case e_bitString:
		case e_octetString:
		case e_null:
		case e_objectIdentifier:
		case e_enumerated:
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
		case e_bmpString:
		default:
			printf( "\n Err:MakeFile:CStruct:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	return true;
}


bool MakeHeaderC( AsnClassBox *bx, CommandSet *cs )
{
	FILE *fp;
	char tName[256];
	unsigned int bxIndex;
	SYSTEMTIME	st;

	if( bx==0 || cs==0 ) return false;

	sprintf( tName, ".%soutput\\%s\\%s.h", DEFAULT_DIRECTORY, cs->pFolder, cs->pFile );
	fp = fopen( (const char*)tName, "w" );
	if( fp==0 )
	{
		printf( "\n Err:FileOpen:%s.h", cs->pFile );
		return false;
	}

	GetSystemTime(&st);
	fprintf( fp, "/*\n\n\t<%s.h>\t%04d-%02d-%02d,%02d:%02d\n\n*/\n", cs->pFile, st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute );
	fprintf( fp, "#ifndef __%04d_%02d_%02d__%02d_%02d__%s_H__\n", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, cs->pFile );
	fprintf( fp, "#define __%04d_%02d_%02d__%02d_%02d__%s_H__\n\n\n", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, cs->pFile );
	fprintf( fp, "#include \"H323Define.h\"\n" );
	fprintf( fp, "#include \"handship.h\"\n\n\n\n" );

	cs->MakeCHeaderFile(fp);
	fprintf( fp, "\n\n" );

	for( bxIndex = 0; bxIndex < bx->acSize; bxIndex++ )
	{
		if( ! MakeCStruct( (AsnClass*)(bx->ac[bxIndex]), fp ) )
		{
			fclose(fp);
			return false;
		}
	}

	fprintf( fp, "\n\n#endif/*__%04d_%02d_%02d__%02d_%02d__%s_HXX__*/", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, cs->pFile );

	fclose(fp);
	return true;
}








/**********************************************************************************************************/
/*
/*	Make C Source File
*/
const char *gCMemberChoiceConstructorString = 
"\
/***************************************************************************************/\n\
/* %s Struct\n\
*/\n\
/* %s Constructor */\n\
HS_RESULT new_%s( void *pObject )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on new_%s(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	pObj->alter		 = HS_NULL;\n\
	pObj->extensible = %s;\n\
	pObj->choice	 = e_%sChoice_%s;\n\
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_%sChoiceSize -1, 0, HS_ASN_MAX_CONSTRAINT );\n\
	return HS_OK;\n\
}\n\
";
bool MakeCMemberChoiceConstructor( AsnClass *ac, FILE *pf )
{
	fprintf( pf, gCMemberChoiceConstructorString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName,
		ac->extendable? "TRUE":"FALSE", ac->cName, ac->member[0].mName, ac->cName
	);
	return true;
}


const char *gCMemberChoiceDestructorString =
"\
/* %s Destructor */\n\
HS_RESULT delete_%s( void *pObject )\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on delete_%s(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( (tRet=%s_DeleteAlternation(pObj)) != HS_OK )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on delete_%s(), tRet(%%u)\", tRet );\n\
#endif\n\
		return tRet;\n\
	}\n\
	return HS_OK;\n\
}\n\
";
bool MakeCMemberChoiceDestructor( AsnClass *ac, FILE *pf )
{
	fprintf( pf, gCMemberChoiceDestructorString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);
	return true;
}


const char *gCMemberChoiceSetChoiceString = 
"\
/* %s SetChoice */\n\
void* %s_SetChoice( void *pObject, %sChoice pChoice)\n\
{\n\
	HS_RESULT	tRet;\n\
	AsnObject *tmold = HS_NULL;\n\
	AsnSequenceOf *aso = HS_NULL;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_SetChoice(NULL,%%d) -> null parameter\", (int)pChoice );\n\
#endif\n\
		return HS_NULL;\n\
	}\n\
\n\
	if( e_%sChoiceSizeExt ){\n\
		if( pChoice > (%sChoice)(e_%sChoiceSizeExt-1) )\n\
		{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
			HSPrint( \"\\n Error on %s_SetChoice(%%d) -> invalid alternation value\", (int)pChoice );\n\
#endif\n\
			return HS_NULL;\n\
		}\n\
	}\n\
\n\
	if( pObj->alter != HS_NULL )\n\
	{\n\
		if( (tRet=%s_DeleteAlternation(pObj)) != HS_OK )\n\
		{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
			HSPrint( \"\\n Error on %s_SetChoice(%%d), tRet(%%u)\", (int)pChoice, tRet );\n\
#endif\n\
			return HS_NULL;\n\
		}\n\
	}\n\
	pObj->choice = pChoice;\n\
\n\
";
bool MakeCMemberChoiceSetChoice( AsnClass *ac, FILE *pf )
{
	int i;
	unsigned int lastMember=0;

	if( ac->mSize == 0 )
	{
		printf("\n Err:Abnormal:MakeCMemberChoiceSetChoice:mSize is 0");
		return false;
	}
	fprintf( pf, gCMemberChoiceSetChoiceString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);


	for( i=0; i<ac->mSize; i++ )
	{
		switch( ac->member[i].type )
		{
			case e_extension:
				fprintf( pf, "\t/*...,*/\n" );
				break;
			case e_choice:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = (%s *)HSMalloc( sizeof(%s) );\n\t\tnew_%s(tAlter);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName
				);
				break;
			case e_class:
			case e_set:
			case e_sequence:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = (%s *)HSMalloc( sizeof(%s) );\n\t\tnew_%s(tAlter);\n\t\t%s_MakeMold(tAlter);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName
				);
				break;
			case e_boolean:
			case e_null:
			case e_objectIdentifier:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = (%s *)HSMalloc( sizeof(%s) );\n\t\tnew_%s(tAlter);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName
				);
				break;
			case e_integer:
			case e_bitString:
			case e_octetString:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = (%s *)HSMalloc( sizeof(%s) );\n\t\tnew_%s(tAlter,%s,%d,%u,%d,%u);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
					 ac->member[i].cName, ac->member[i].cName, GetConstraintTypeNameForParsing(ac->member[i].cons.type),
					ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
				);
				break;
			case e_printableString:
			case e_ia5String:
			case e_numericString:
			case e_generalString:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\tAsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );\n\t\tnew_AsnSingleString(tAlter,%s,%s,%d,%u,%d,%u);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName,
					GetSingleStringTagName(ac->member[i].type),
					GetConstraintTypeNameForParsing(ac->member[i].cons.type),
					ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
				);
				
				if( ac->member[i].from[0] != 0 )
				{
					fprintf( pf,
						"\t\t/* FROM Constraint */\n"
						"\t\tstrcpy((char*)(tAlter->fromConstraint), \"%s\");\n"
						"\t\ttAlter->fromSize = %d;\n"
						"\t\ttAlter->reIndexing = GetStringTypeEncodingBits(\n"
						"\t\t\ttAlter->fromSize,\n"
						"\t\t\t%s,\n"
						"\t\t\t&(tAlter->encodingBitsOfAlign),\n"
						"\t\t\t&(tAlter->encodingBitsOfUnalign)\n"
						"\t\t);\n",
						ac->member[i].from, strlen(ac->member[i].from), GetSingleStringVmaxName(ac->member[i].type)
					);
				}
				break;

			case e_bmpString:
				fprintf( pf, "\t%s( pChoice == e_%sChoice_%s ){\n\t\t%s *tAlter = (%s *)HSMalloc( sizeof(%s) );\n\t\tnew_%s(tAlter,e_asnTagBMPString,%s,%d,%u,%d,%u);\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
					ac->member[i].cName, ac->member[i].cName, GetConstraintTypeNameForParsing(ac->member[i].cons.type),
					ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
				);
				break;
			case e_enumerated:
				printf( "\n Err:MakeFile:c-source:MakeCppMemberChoiceSetChoice:enum subType" );
				return true;
			default:
				printf( "\n Err:MakeFile:c-source:MakeCppMemberChoiceSetChoice:unknown subType"
					", class:%s, member:%s, type(%d)", ac->cName, ac->member[i].mName, (int)ac->member[i].type
				);
				return false;
		}

		if( ac->member[i].type != e_extension )
		{
			if( ac->member[i].of )
			{
				fprintf( pf,
					"\t\taso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );\n\t\tnew_AsnSequenceOf(aso,%s,%d,%u,%d,%u);\n"
					"\t\ttmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );\n"
					"\t\tnew_AsnObject(tmold,tAlter,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
					"#ifdef HS_DEBUG_ASN_PRINT\n"
					"\t\t\t%s_Print,\n"
					"#endif\n"
					"\t\t\tdelete_%s );\n"
					"\t\tAsnSequenceOf_SetMold(aso,tmold);\n",
					GetConstraintTypeNameForParsing(ac->member[i].consOf.type),
					ac->member[i].consOf.nMin, ac->member[i].consOf.nMax, ac->member[i].consOf.eMin, ac->member[i].consOf.eMax,
					ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName,
					ac->member[i].cName, ac->member[i].cName
				);
				if( ac->member[i].consOf.type != e_uncons )
				{
					fprintf( pf,
						"\t\t/* Sequence Of constraint */\n"
						"\t\taso->constraint.type = %s;\n"
						"\t\taso->constraint.minValue = %d;\n"
						"\t\taso->constraint.maxValue = %u;\n"
						"\t\taso->extMinValue = %d;\n"
						"\t\taso->extMaxValue = %u;\n",
						GetConstraintTypeNameForParsing(ac->member[i].consOf.type),
						ac->member[i].consOf.nMin, ac->member[i].consOf.nMax, ac->member[i].consOf.eMin, ac->member[i].consOf.eMax
					);
				}
				
				fprintf( pf, "\t\tpObj->alter = aso;\n\t}\n" );
			}
			else
				fprintf( pf, "\t\tpObj->alter = tAlter;\n\t}\n" );
		}
	}


	fprintf( pf,
		"\telse{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on %s_SetChoice(%%d) -> out of choice\", (int)pChoice );\n"
		"#endif\n\t\treturn HS_NULL;\n\t}\n"
		"\n\treturn pObj->alter;\n}\n\n", ac->cName
	);

	return true;
}


const char *gCMemberChoiceDeleteAlternationString =
"\
/* %s DeleteAlternation */\n\
HS_RESULT %s_DeleteAlternation(void *pObject)\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_DeleteAlternation(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( pObj->alter != HS_NULL )\n\
	{\n\
		/* root field datas */\n\
";
bool MakeCMemberChoiceDeleteAlternation( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberChoiceDeleteAlternationString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
			{
				fprintf( pf,
					"\t\t%s( pObj->choice == e_%sChoice_%s ){\n"
					"\t\t\tdelete_AsnSequenceOf(pObj->alter);\n"
					"\t\t\tfree(pObj->alter);\n"
					"\t\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName
				);
			}
			else
			{
				fprintf( pf,
					"\t\t%s( pObj->choice == e_%sChoice_%s ){\n"
					"\t\t\tdelete_%s(pObj->alter);\n"
					"\t\t\tfree(pObj->alter);\n"
					"\t\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName
				);
			}
		}
	}

	fprintf( pf,
		"\t\telse\n"
		"\t\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\t\tHSPrint( \"\\n Error on %s_DeleteAlternation() -> out of choice, choice(%%d)\", (int)(pObj->choice) );\n"
		"#endif\n"
		"\t\t\tpObj->alter = HS_NULL;\n"
		"\t\t\treturn HS_ERR_ASN_OUTOF_RANGE;\n"
		"\t\t}\n\n"
		"\t\tpObj->alter = HS_NULL;\n"
		"\t}\n\n"
		"\treturn HS_OK;\n"
		"}\n\n", ac->cName
	);

	return true;
}


const char *gCMemberChoiceMakeMoldString =
"\
HS_RESULT %s_MakeMold( void *pObject ){return HS_OK;};\n\n\
";
bool MakeCMemberChoiceMakeMold( AsnClass *ac, FILE *pf )
{
	fprintf( pf, gCMemberChoiceMakeMoldString, ac->cName );
	return true;
}


const char *gCMemberChoiceEncodeString =
"\
/* %s Encode */\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
	BOOL		tExtended = FALSE;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Encode(%%x,%%x) -> null parameter\", pObj, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
	if(pObj->alter == HS_NULL)\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Encode(pStrm) -> there is no choice\" );\n\
#endif\n\
		return HS_ERR_ASN_NOCHOICE;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( pObj->extensible )\n\
	{\n\
		if( e_%sChoiceSize )\n\
		{\n\
			if( pObj->choice > ((%sChoice)(e_%sChoiceSize-1)) ) tExtended = TRUE;\n\
			else tExtended = FALSE;\n\
\n\
			AsnStream_BitEncoding( pStrm, tExtended );\n\
		}\n\
		else tExtended = TRUE;\n\
	}\n\
\n\
	/* alternation encoding */\n\
	if( tExtended )\n\
	{\n\
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_%sChoiceSize)) )\n\
	}\n\
	else\n\
	{\n\
		if( e_%sChoiceSize > 1 )\n\
		{\n\
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );\n\
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )\n\
		}\n\
	}\n\
\n\
	/* root field datas */\n\
";
bool MakeCMemberChoiceEncode( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberChoiceEncodeString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tAsnStream tTempStrm;\n\t\t new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);\n"
						"\t\tif( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tif( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->cName
					);
			}
			else
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tAsnStream tTempStrm;\n\t\tnew_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);\n"
						"\t\tif( (tRet=WellKnownExtensionEncoding( pObj->alter, %s_Encode, pStrm, &tTempStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tif( (tRet=%s_Encode(pObj->alter,pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->cName
					);
			}
		}
	}

	fprintf( pf,
		"\telse\n"
		"\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> out of choice\" );\n"
		"#endif\n"
		"\t\treturn HS_ERR_ASN_OUTOF_RANGE;\n"
		"\t}\n\n"
		"\treturn HS_OK;\n"
		"}\n\n", ac->cName
	);

	return true;
}


const char *gCMemberChoiceDecodeString =
"\
/* %s Decode */\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
	HS_UINT		tChoice = 0;\n\
	BOOL		tExtended = FALSE;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Decode(%%x,%%x) -> null parameter\", pObj, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );\n\
\n\
	/* alternation decoding */\n\
	if( tExtended )\n\
	{\n\
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )\n\
		tChoice += e_%sChoiceSize;\n\
	}\n\
	else\n\
	{\n\
		if( e_%sChoiceSize > 1 )\n\
		{\n\
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )\n\
			tChoice = pObj->choiceInteger.value;\n\
		}\n\
	}\n\
\n\
	if( e_%sChoiceSizeExt )\n\
	{\n\
		if( tChoice > (HS_UINT)(e_%sChoiceSizeExt - 1) )\n\
		{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
			HSPrint( \"\\n Error on %s_Decode(pStrm) -> asn range over\" );\n\
#endif\n\
			return HS_ERR_ASN_OUTOF_RANGE;\n\
		}\n\
	}\n\
\n\
	if( %s_SetChoice( pObj, (%sChoice)tChoice ) == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> SetChoice Fail, choice(%%d)\", tChoice );\n\
#endif\n\
		return HS_ERR_ASN_OUTOF_RANGE;\n\
	}\n\
\n\
	/* root field datas */\n\
";
bool MakeCMemberChoiceDecode( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberChoiceDecodeString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
	);

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tif( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSequenceOf_Decode, pStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tif( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->cName
					);
			}
			else
			{
				if( ac->member[i].extended )
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tif( (tRet=WellKnownExtensionDecoding( pObj->alter, %s_Decode, pStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->cName
					);
				else
					fprintf( pf,
						"\t%s( pObj->choice == e_%sChoice_%s ){\n"
						"\t\tif( (tRet=%s_Decode(pObj->alter,pStrm)) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Decode(Obj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n",
						i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->cName
					);
			}
		}
	}

	fprintf( pf,
		"\telse\n"
		"\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on %s_Decode(Obj,pStrm) -> out of choice\" );\n"
		"#endif\n"
		"\t\treturn HS_ERR_ASN_OUTOF_RANGE;\n"
		"\t}\n\n"
		"\treturn HS_OK;\n"
		"}\n\n", ac->cName
	);

	return true;
}


const char *gCMemberChoicePrintString =
"\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
/* %s Print */\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName )\n\
{\n\
	HS_UINT i;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
		HSPrint( \"\\n Error on %s_Print(NULL,%%u,%%s) -> null parameter\", pDepth, pTypeName==HS_NULL? \"\":pTypeName );\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	HSPrint( \"\\n\" );\n\
	for( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n\
\n\
	if( pTypeName != HS_NULL ) HSPrint( \"%%s\", pTypeName );\n\
	HSPrint( \"<CHOICE> = {\" );\n\
\n\
	if( pObj->alter == HS_NULL )\n\
	{\n\
		HSPrint( \"  Error : No Value\\n\" );\n\
		for( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n\
		HSPrint( \"}\" );\n\
		return HS_OK;\n\
	}\n\
\n\
	/* root field datas */\n\
";
bool MakeCMemberChoicePrint( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberChoicePrintString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension ) fprintf( pf, "\t/*...,*/\n" );
		else
		{
			if( ac->member[i].of )
				fprintf( pf,
					"\t%s( pObj->choice == e_%sChoice_%s ){\n"
					"\t\tAsnSequenceOf_Print( pObj->alter, pDepth+1, \"%s\" );\n"
					"\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].mName
				);
			else
				fprintf( pf,
					"\t%s( pObj->choice == e_%sChoice_%s ){\n"
					"\t\t%s_Print( pObj->alter, pDepth+1, \"%s\" );\n"
					"\t}\n",
					i? "else if ":"if\t\t", ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName
				);
		}
	}

	fprintf( pf,
		"\telse\n"
		"\t{\n"
		"\t\tprintf( \"  Error : Unknown Choice\\n\" );\n"
		"\t\tfor( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n"
		"\t\tprintf( \"}\" );\n"
		"\t\treturn HS_OK;\n"
		"\t}\n\n"
		"\tprintf( \"\\n\" );\n"
		"\tfor( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n"
		"\tprintf(\"}\");\n\n"
		"\treturn HS_OK;\n"
		"}\n"
		"#endif\n\n"
	);
	
	return true;
}

bool MakeCMemberChoice( AsnClass *ac, FILE *pf )
{
	if( ! MakeCMemberChoiceConstructor(ac,pf) )
		return false;
	if( ! MakeCMemberChoiceDestructor(ac,pf) )
		return false;
	if( ! MakeCMemberChoiceSetChoice(ac,pf) )
		return false;
	if( ! MakeCMemberChoiceDeleteAlternation(ac,pf) )
		return false;
	if( ! MakeCMemberChoiceMakeMold(ac,pf) )
		return false;
	if( ! MakeCMemberChoiceEncode(ac,pf) )
		return false;
	if( ! MakeCMemberChoiceDecode(ac,pf) )
		return false;
	if( ! MakeCMemberChoicePrint(ac,pf) )
		return false;

	return true;
}



const char *gCMemberSequenceConstructorString =
"\
/***************************************************************************************/\n\
/* %s Class\n\
*/\n\
/*%s Constructor*/\n\
HS_RESULT new_%s(void *pObject)\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on new_%s(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	pObj->extensible = %s;\n\
	pObj->extended = FALSE;\n\
";
bool MakeCMemberSequenceConstructor( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;
	bool initStarted = false;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	fprintf( pf, gCMemberSequenceConstructorString,
		ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->extendable? "TRUE":"FALSE"
	);

	for( i=0; i<ac->mSize; i++ )
	{
		if( !(ac->member[i].of) )
		{
			switch( ac->member[i].type )
			{
				case e_extension:
					break;
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
					fprintf( pf, "\tnew_AsnSingleString( &(pObj->m_%s), %s, %s, %d, %u, %d, %u );\n",
						ac->member[i].mName, GetSingleStringTagName( ac->member[i].type ),
						GetConstraintTypeNameForParsing( ac->member[i].cons.type ),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					break;
				case e_bmpString:
					fprintf( pf, "\tnew_AsnDoubleString( &(pObj->m_%s), %s, %s, %d, %u, %d, %u );\n",
						ac->member[i].mName, GetDoubleStringTagName( ac->member[i].type ),
						GetConstraintTypeNameForParsing( ac->member[i].cons.type ),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					break;
				case e_integer:
				case e_bitString:
				case e_octetString:
					fprintf( pf, "\tnew_%s( &(pObj->m_%s), %s, %d, %u, %d, %u );\n",
						ac->member[i].cName, ac->member[i].mName, GetConstraintTypeNameForParsing( ac->member[i].cons.type ),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					break;
				default:
					fprintf( pf, "\tnew_%s( &(pObj->m_%s) );\n", ac->member[i].cName, ac->member[i].mName );
					break;
			}
		}
		else
		{
			fprintf( pf, "\tnew_AsnSequenceOf( &(pObj->m_%s), %s,%d,%u,%d,%u );\n",
				ac->member[i].mName, GetConstraintTypeNameForParsing( ac->member[i].consOf.type ),
				ac->member[i].consOf.nMin, ac->member[i].consOf.nMax, ac->member[i].consOf.eMin, ac->member[i].consOf.eMax
			);
		}
	}

	fprintf( pf, "\n" );
	if(x) fprintf( pf, "\tmemset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );\n" );
	if(y)
		fprintf( pf,
			"\tmemset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );\n"
			"\tpObj->extOptionMapSize = 0;\n"
		);

	/* From Constraint */
	initStarted = false;
	for( i=0; i<ac->mSize; i++ )
	{
		if( !(ac->member[i].of) && ac->member[i].from[0] )
		{
			if( initStarted == false ){ fprintf( pf, "\t/* FROM Constraint */\n" );	initStarted = true; }

			fprintf( pf,
				"\tstrcpy((char*)(pObj->m_%s.fromConstraint), \"%s\");\n"
				"\tpObj->m_%s.fromSize = %d;\n"
				"\tpObj->m_%s.reIndexing =	GetStringTypeEncodingBits(\n"
				"\t\tpObj->m_%s.fromSize,\n"
				"\t\tASN_IA5_STRING_VMAX,\n"
				"\t\t&(pObj->m_%s.encodingBitsOfAlign),\n"
				"\t\t&(pObj->m_%s.encodingBitsOfUnalign)\n"
				"\t);\n", ac->member[i].mName, ac->member[i].from, ac->member[i].mName, strlen(ac->member[i].from),
				ac->member[i].mName, ac->member[i].mName, ac->member[i].mName, ac->member[i].mName
			);
		}
	}

	fprintf( pf, "\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCMemberSequenceDestructorString =
"\
/* %s Destructor */\n\
HS_RESULT delete_%s(void *pObject)\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on delete_%s(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
";
bool MakeCMemberSequenceDestructor( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberSequenceDestructorString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( !(ac->member[i].of) )
		{
			switch( ac->member[i].type )
			{
				case e_extension:
					break;
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
				case e_bmpString:
				case e_integer:
				case e_bitString:
				case e_octetString:
				default:
					fprintf( pf, "\tdelete_%s( &(pObj->m_%s) );\n", ac->member[i].cName, ac->member[i].mName );
					break;
			}
		}
		else
			fprintf( pf, "\tdelete_AsnSequenceOf( &(pObj->m_%s) );\n", ac->member[i].mName );
	}

	fprintf( pf, "\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCMemberSequenceMakeMoldString =
"\
/* %s MakeMold */\n\
HS_RESULT %s_MakeMold(void *pObject)\n\
{\n\
	AsnObject *moldObject = HS_NULL;\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_MakeMold(NULL) -> null parameter\" );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
";
bool MakeCMemberSequenceMakeMold( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberSequenceMakeMoldString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );

	/* SequenceOf */
	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].of )
		{
			switch( ac->member[i].type )
			{
				case e_class:
				case e_set:
				case e_sequence:
					fprintf( pf,
						"\t{\n\t%s *tmold_%s = (%s *)HSMalloc( sizeof(%s) );\n\tnew_%s(tmold_%s);\n"
						"\t%s_MakeMold(tmold_%s);\n"
						"\tmoldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );\n"
						"\tnew_AsnObject(moldObject,tmold_%s,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
						"#ifdef HS_DEBUG_ASN_PRINT\n"
						"\t\t%s_Print,\n"
						"#endif"
						"\n\t\tdelete_%s);\n"
						"\tAsnSequenceOf_SetMold( &(pObj->m_%s), moldObject );\n\t}\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].mName
					);
					break;
				case e_choice:
				case e_boolean:
				case e_null:
				case e_objectIdentifier:
					fprintf( pf,
						"\t{\n\t%s *tmold_%s = (%s *)HSMalloc( sizeof(%s) );\n\tnew_%s(tmold_%s);\n"
						"\tmoldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );\n"
						"\tnew_AsnObject(moldObject,tmold_%s,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
						"#ifdef HS_DEBUG_ASN_PRINT\n"
						"\t\t%s_Print,\n"
						"#endif"
						"\n\t\tdelete_%s);\n"
						"\tAsnSequenceOf_SetMold( &(pObj->m_%s), moldObject );\n\t}\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].cName, ac->member[i].mName,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].mName
					);
					break;
				case e_integer:
				case e_bitString:
				case e_octetString:
					fprintf( pf,
						"\t{\n\t%s *tmold_%s = (%s *)HSMalloc( sizeof(%s) );\n"
						"\tnew_%s(tmold_%s,%s,%d,%u,%d,%u);\n"
						"\tmoldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );\n"
						"\tnew_AsnObject(moldObject,tmold_%s,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
						"#ifdef HS_DEBUG_ASN_PRINT\n"
						"\t\t%s_Print,\n"
						"#endif"
						"\n\t\tdelete_%s);\n"
						"\tAsnSequenceOf_SetMold( &(pObj->m_%s), moldObject );\n\t}\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].cName, ac->member[i].mName, GetConstraintTypeNameForParsing(ac->member[i].cons.type),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax,
						ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].mName
					);
					break;
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
					fprintf( pf,
						"\t{\n\tAsnSingleString *tmold_%s = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );\n"
						"\tnew_AsnSingleString(tmold_%s,%s,%s,%d,%u,%d,%u);\n",
						ac->member[i].mName, ac->member[i].mName, GetSingleStringTagName(ac->member[i].type),
						GetConstraintTypeNameForParsing(ac->member[i].cons.type),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					if( ac->member[i].from[0] != 0 )
					{
						fprintf( pf,
							"\tstrcpy((char*)(tmold_%s->fromConstraint), \"%s\");\n"
							"\ttmold_%s->fromSize = %d;\n"
							"\ttmold_%s->reIndexing = GetStringTypeEncodingBits(\n"
							"\t\ttmold_%s->fromSize,\n"
							"\t\t%s,\n"
							"\t\t&(tmold_%s->encodingBitsOfAlign),\n"
							"\t\t&(tmold_%s->encodingBitsOfUnalign)\n"
							"\t);\n",
							ac->member[i].mName, ac->member[i].from, ac->member[i].mName, strlen(ac->member[i].from),
							ac->member[i].mName, ac->member[i].mName, GetSingleStringVmaxName(ac->member[i].type),
							ac->member[i].mName, ac->member[i].mName
						);
					}
					fprintf( pf,
						"\tmoldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );\n"
						"\tnew_AsnObject(moldObject,tmold_%s,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
						"#ifdef HS_DEBUG_ASN_PRINT\n"
						"\t\t%s_Print,\n"
						"#endif"
						"\n\t\tdelete_%s);\n"
						"\tAsnSequenceOf_SetMold( &(pObj->m_%s), moldObject );\n\t}\n",
						ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].mName );
					break;

				case e_bmpString:
					fprintf( pf,
						"\t{\n\tAsnDoubleString *tmold_%s = (AsnDoubleString*)HSMalloc( sizeof(AsnDoubleString) );\n"
						"\tnew_AsnDoubleString(tmold_%s,%s,%s,%d,%u,%d,%u);\n",
						ac->member[i].mName, ac->member[i].mName, GetDoubleStringTagName(ac->member[i].type),
						GetConstraintTypeNameForParsing(ac->member[i].cons.type),
						ac->member[i].cons.nMin, ac->member[i].cons.nMax, ac->member[i].cons.eMin, ac->member[i].cons.eMax
					);
					if( ac->member[i].from[0] != 0 )
					{
						fprintf( pf,
							"\tstrcpy((char*)(tmold_%s->fromConstraint), \"%s\");\n"
							"\ttmold_%s->fromSize = %d;\n"
							"\ttmold_%s->reIndexing = GetStringTypeEncodingBits(\n"
							"\t\ttmold_%s->fromSize,\n"
							"\t\t%s,\n"
							"\t\t&(tmold_%s->encodingBitsOfAlign),\n"
							"\t\t&(tmold_%s->encodingBitsOfUnalign)\n"
							"\t);\n",
							ac->member[i].mName, ac->member[i].from, ac->member[i].mName, strlen(ac->member[i].from),
							ac->member[i].mName, ac->member[i].mName, GetSingleStringVmaxName(ac->member[i].type),
							ac->member[i].mName, ac->member[i].mName
						);
					}
					fprintf( pf,
						"\tmoldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );\n"
						"\tnew_AsnObject(moldObject,tmold_%s,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
						"#ifdef HS_DEBUG_ASN_PRINT\n"
						"\t\t%s_Print,\n"
						"#endif"
						"\n\t\tdelete_%s);\n"
						"\tAsnSequenceOf_SetMold( &(pObj->m_%s), moldObject );\n\t}\n",
						ac->member[i].mName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName, ac->member[i].cName,
						ac->member[i].mName );
					break;
			}

			if( ac->member[i].consOf.type != e_uncons )
				fprintf( pf,
					"\t/* Sequence Of constraint */\n"
					"\tpObj->m_%s.constraint.type = %s;\n"
					"\tpObj->m_%s.constraint.minValue = %d;\n"
					"\tpObj->m_%s.constraint.maxValue = %u;\n"
					"\tpObj->m_%s.extMinValue = %d;\n"
					"\tpObj->m_%s.extMaxValue = %u;\n",
					ac->member[i].mName, GetConstraintTypeNameForParsing(ac->member[i].consOf.type),
					ac->member[i].mName, ac->member[i].consOf.nMin, ac->member[i].mName, ac->member[i].consOf.nMax,
					ac->member[i].mName, ac->member[i].consOf.eMin, ac->member[i].mName, ac->member[i].consOf.eMax
				);
		}// if(of)
		else
		{
			switch( ac->member[i].type )
			{
				case e_class:
				case e_set:
				case e_sequence:
					fprintf( pf, "\t%s_MakeMold(&(pObj->m_%s));\n", ac->member[i].cName, ac->member[i].mName );
					break;
				case e_choice:
				case e_boolean:
				case e_null:
				case e_objectIdentifier:
				case e_integer:
				case e_bitString:
				case e_octetString:
				case e_printableString:
				case e_ia5String:
				case e_numericString:
				case e_generalString:
				case e_bmpString:
					break;
			}
		}
	}// for

	fprintf( pf, "\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCMemberSequenceIncludeOptionFieldStringBoth =
"\
/* %s IncludeOptionalField */\n\
HS_RESULT %s_IncludeOptionField( void *pObject, %sOptionMap pOptionMap )\n\
{\n\
	HS_UINT	tExtOptionMap;\n\
	HS_UINT	tByteOffset, tBitOffset;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;\n\
\n\
	if( ((HS_UINT)pOptionMap) < e_%sOptionMapSize )\n\
	{\n\
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
		tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
\n\
		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
	}\n\
	else\n\
	{\n\
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
\n\
		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
\n\
		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
\n\
		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;\n\
\n\
		pObj->extended = TRUE;\n\
	}\n\
\n\
	return HS_OK;\n\
}\n\n\
";
const char *gCMemberSequenceIncludeOptionFieldStringOpt =
"\
/* %s IncludeOptionalField */\n\
HS_RESULT %s_IncludeOptionField( void *pObject, %sOptionMap pOptionMap )\n\
{\n\
	HS_UINT	tByteOffset, tBitOffset;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;\n\
\n\
	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
\n\
	return HS_OK;\n\
}\n\n\
";
const char *gCMemberSequenceIncludeOptionFieldStringExt =
"\
/* %s IncludeOptionalField */\n\
HS_RESULT %s_IncludeOptionField( void *pObject, %sOptionMap pOptionMap )\n\
{\n\
	HS_UINT	tExtOptionMap;\n\
	HS_UINT	tByteOffset, tBitOffset;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;\n\
\n\
	tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);\n\
\n\
	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;\n\
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;\n\
\n\
	return HS_OK;\n\
}\n\n\
";
bool MakeCMemberSequenceIncludeOptionField( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	if( x && y )
	{
		fprintf( pf, gCMemberSequenceIncludeOptionFieldStringBoth,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);
	}
	else
	{
		if(x)
			fprintf( pf, gCMemberSequenceIncludeOptionFieldStringOpt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
		else if(y)
			fprintf( pf, gCMemberSequenceIncludeOptionFieldStringExt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
	}

	return true;
}


const char *gCMemberSequenceIsIncludeOptionFieldStringBoth =
"\
/* %s IsIncludeOptionalField */\n\
BOOL %s_IsIncludeOptionField( void *pObject, %sOptionMap pOptionMap )\n\
{\n\
	HS_UCHAR tByte;\n\
\n\
	HS_UINT tExtOptionMap;\n\
	HS_UINT tByteOffset, tBitOffset;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return FALSE;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return FALSE;\n\
\n\
	if( ((HS_UINT)pOptionMap) < e_%sOptionMapSize )\n\
	{\n\
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
		tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
\n\
		tByte = 1<<(7-tBitOffset);\n\
\n\
		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;\n\
		return FALSE;\n\
	}\n\
\n\
	tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
\n\
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
\n\
	tByte = 1<<(7-tBitOffset);\n\
\n\
	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;\n\
	return FALSE;\n\
}\n\n\
";
const char *gCMemberSequenceIsIncludeOptionFieldStringOpt =
"\
/* %s IsIncludeOptionalField */\n\
BOOL %s_IsIncludeOptionField( void *pObject, %sOptionMap pOptionMap )\n\
{\n\
	HS_UCHAR tByte;\n\
\n\
	HS_UINT tByteOffset, tBitOffset;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return FALSE;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSize -1 ) return FALSE;\n\
\n\
	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)pOptionMap)%%8);\n\
	tByte = 1<<(7-tBitOffset);\n\
\n\
	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;\n\
	return FALSE;\n\
}\n\n\
";
const char *gCMemberSequenceIsIncludeOptionFieldStringExt =
"\
/* %s IsIncludeOptionalField */\n\
BOOL %s_IsIncludeOptionField( void *pObject, %sOptionMap pOptionMap )\n\
{\n\
	HS_UCHAR tByte;\n\
\n\
	HS_UINT tExtOptionMap;\n\
	HS_UINT tByteOffset, tBitOffset;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_IncludeOptionField(NULL,%%d) -> null parameter\", (int)pOptionMap );\n\
#endif\n\
		return FALSE;\n\
	}\n\
\n\
	if( ((int)pOptionMap) > e_%sOptionMapSizeExt -1 ) return FALSE;\n\
\n\
	tExtOptionMap = ((HS_UINT)pOptionMap) - e_%sOptionMapSize ;\n\
\n\
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);\n\
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%%8);\n\
\n\
	tByte = 1<<(7-tBitOffset);\n\
\n\
	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;\n\
	return FALSE;\n\
}\n\n\
";
bool MakeCMemberSequenceIsIncludeOptionField( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}
	
	if( x && y )
	{	
		fprintf( pf, gCMemberSequenceIsIncludeOptionFieldStringBoth,
			ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
		);
	}
	else
	{
		if(x)
			fprintf( pf, gCMemberSequenceIsIncludeOptionFieldStringOpt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
		else if(y)
			fprintf( pf, gCMemberSequenceIsIncludeOptionFieldStringExt,
				ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName
			);
	}

	return true;
}


const char *gCMemberSequenceEncodeStringOpt =
"\
/* %s Encode */\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Encode(%%x,%%x) -> null parameter\", pObj, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );\n\
\n\
	/* option map bits */\n\
	if( e_%sOptionMapSize != 0 )\n\
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_%sOptionMapSize, e_alignLeft );\n\
\n\
	/* root field datas */\n\
";
const char *gCMemberSequenceEncodeStringNon =
"\
/* %s Encode */\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm )\n\
{\n\
	%s\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Encode(%%x,%%x) -> null parameter\", pObj, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );\n\
\n\
";
bool MakeCMemberSequenceEncode( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0, z=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	if(ac->extendable)	z = ac->mSize-1;
	else				z = ac->mSize;

	if(x) fprintf( pf, gCMemberSequenceEncodeStringOpt, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	else  fprintf( pf, gCMemberSequenceEncodeStringNon, ac->cName, ac->cName, z? "HS_RESULT tRet;\n":"", ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension )
		{
			if(y)
				fprintf( pf,
					"\n\t/* extension field datas */\n"
					"\tif( pObj->extOptionMapSize )\n"
					"\t{\n"
					"\t\tAsnStream tTempStrm;\n\t\tnew_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);\n"
					"\t\t/* extension bitMap size */\n"
					"\t\tSmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );\n"
					"\t\t/* option bitMap encoding */\n"
					"\t\tAsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );\n\n"
					"\t\t/* datas */\n"
				);
		}
		else
		{
			if( ac->member[i].extended )
			{
				if( ac->member[i].of )
					fprintf( pf,
						"\t\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
						"\t\t\tif( (tRet=WellKnownExtensionEncoding( &(pObj->m_%s), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )\n"
						"\t\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\t\treturn tRet;\n"
						"\t\t\t}\n"
						"\t\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\t\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
						"\t\t\tif( (tRet=WellKnownExtensionEncoding( &(pObj->m_%s), %s_Encode, pStrm, &tTempStrm )) != HS_OK )\n"
						"\t\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\t\treturn tRet;\n"
						"\t\t\t}\n"
						"\t\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->member[i].cName, ac->cName
					);
			}
			else
			{
				if( ac->member[i].of )
				{
					if( ac->member[i].optional )
						fprintf( pf,
							"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
							"\t\tif( (tRet=AsnSequenceOf_Encode( &(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\t\treturn tRet;\n"
							"\t\t}\n"
							"\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
						);
					else
						fprintf( pf,
							"\tif( (tRet=AsnSequenceOf_Encode( &(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\treturn tRet;\n"
							"\t}\n", ac->member[i].mName, ac->cName
						);
				}
				else
				{
					if( ac->member[i].optional )
						fprintf( pf,
							"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
							"\t\tif( (tRet=%s_Encode( &(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\t\treturn tRet;\n"
							"\t\t}\n"
							"\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
						);
					else
						fprintf( pf,
							"\tif( (tRet=%s_Encode( &(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\tHSPrint( \"\\n Error on %s_Encode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\treturn tRet;\n"
							"\t}\n", ac->member[i].cName, ac->member[i].mName, ac->cName
						);
				}
			}
		}
	}

	if(y) fprintf( pf, "\t}\t" );

	fprintf( pf, "\n\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCMemberSequenceDecodeStringOpt =
"\
/* %s Decode */\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm )\n\
{\n\
	HS_RESULT	tRet;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Decode(%%x,%%x) -> null parameter\", pObj, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );\n\
\n\
	/* option map bits */\n\
	if( e_%sOptionMapSize != 0 )\n\
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_%sOptionMapSize, e_alignLeft );\n\
\n\
	/* root field datas */\n\
";
const char *gCMemberSequenceDecodeStringNon =
"\
/* %s Decode */\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm )\n\
{\n\
	%s\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL || pStrm == HS_NULL )\n\
	{\n\
#ifdef HS_DEBUG_ASN_MEMBER\n\
		HSPrint( \"\\n Error on %s_Decode(%%x,%%x) -> null parameter\", pObj, pStrm );\n\
#endif\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	/* extension bit */\n\
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );\n\
\n\
	/* root field datas */\n\
";
bool MakeCMemberSequenceDecode( AsnClass *ac, FILE *pf )
{
	int i, x=0, y=0, z=0;

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].extended && ac->member[i].type != e_extension ) y++;
		else
		{
			if( ac->member[i].type != e_extension && ac->member[i].optional ) x++;
		}
	}

	if(ac->extendable)	z = ac->mSize-1;
	else				z = ac->mSize;
	
	if(x) fprintf( pf, gCMemberSequenceDecodeStringOpt, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );
	else  fprintf( pf, gCMemberSequenceDecodeStringNon, ac->cName, ac->cName, z? "HS_RESULT tRet;\n":"", ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension )
		{
			if(y)
				fprintf( pf,
					"\n\t/* extension field datas */\n"
					"\tif( ! pObj->extended ) return HS_OK;\n"
					"\tif( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )\n"
					"\t{\n"
					"\t\tpObj->extOptionMapSize = 0;\n"
					"\t\treturn HS_OK;\n"
					"\t}\n"
					"\tpObj->extOptionMapSize++;\n"
					"\t/* option bitMap encoding */\n"
					"\tHS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )\n\n"
				);
		}
		else
		{
			if( ac->member[i].extended )
			{
				if( ac->member[i].of )
					fprintf( pf,
						"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
						"\t\tif( (tRet=WellKnownExtensionDecoding( &(pObj->m_%s), AsnSequenceOf_Decode, pStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
					);
				else
					fprintf( pf,
						"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
						"\t\tif( (tRet=WellKnownExtensionDecoding( &(pObj->m_%s), %s_Decode, pStrm )) != HS_OK )\n"
						"\t\t{\n"
						"#ifdef HS_DEBUG_ASN_MEMBER\n"
						"\t\t\tHSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
						"#endif\n"
						"\t\t\treturn tRet;\n"
						"\t\t}\n"
						"\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->member[i].cName, ac->cName
					);
			}
			else
			{
				if( ac->member[i].of )
				{
					if( ac->member[i].optional )
						fprintf( pf,
							"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
							"\t\tif( (tRet=AsnSequenceOf_Decode( &(pObj->m_%s),pStrm )) != HS_OK )\n"
							"\t\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\t\tHSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\t\treturn tRet;\n"
							"\t\t}\n"
							"\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->cName
						);
					else
						fprintf( pf,
							"\tif( (tRet=AsnSequenceOf_Decode(&(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\tHSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\treturn tRet;\n"
							"\t}\n",ac->member[i].mName, ac->cName
						);
				}
				else
				{
					if( ac->member[i].optional )
						fprintf( pf,
							"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) ){\n"
							"\t\tif( (tRet=%s_Decode(&(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\t\tHSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\t\treturn tRet;\n"
							"\t\t}\n"
							"\t}\n", ac->cName, ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->cName
						);
					else
						fprintf( pf,
							"\tif( (tRet=%s_Decode(&(pObj->m_%s),pStrm)) != HS_OK )\n"
							"\t{\n"
							"#ifdef HS_DEBUG_ASN_MEMBER\n"
							"\t\tHSPrint( \"\\n Error on %s_Decode(pObj,pStrm) -> tRet(%%d)\", tRet );\n"
							"#endif\n"
							"\t\treturn tRet;\n"
							"\t}\n", ac->member[i].cName, ac->member[i].mName, ac->cName
						);
				}
			}
		}
	}

	fprintf( pf, "\n\treturn HS_OK;\n}\n\n" );
	return true;
}


const char *gCMemberSequencePrintString =
"\
#ifdef HS_DEBUG_ASN_PRINT\n\
/* %s Print */\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName )\n\
{\n\
	HS_UINT i;\n\
\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL )\n\
	{\n\
		HSPrint( \"\\n Error on %s_Print(NULL,%%u,%%s) -> null parameter\", pDepth, pTypeName==HS_NULL? \"\":pTypeName );\n\
		return HS_ERR_NULL_PARAM;\n\
	}\n\
\n\
	HSPrint( \"\\n\" );\n\
	for( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n\
\n\
	if( pTypeName != HS_NULL ) HSPrint( \"%%s\", pTypeName );\n\
	HSPrint( \"<SEQUENCE> = {\" );\n\n\
";
bool MakeCMemberSequencePrint( AsnClass *ac, FILE *pf )
{
	int i;

	fprintf( pf, gCMemberSequencePrintString, ac->cName, ac->cName, ac->cName, ac->cName, ac->cName );

	for( i=0; i<ac->mSize; i++ )
	{
		if( ac->member[i].type == e_extension )
			fprintf( pf,
				"\tprintf( \"\\n\" );\n"
				"\tfor( i=0; i<pDepth+1; i++ ) HSPrint( \"  \" );\n"
				"\tprintf( \"...,\" );\n"
			);
		else
		{
			if( ac->member[i].of )
			{
				if( ac->member[i].optional || ac->member[i].extended )
					fprintf( pf,
						"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) )\n"
						"\t\tAsnSequenceOf_Print( &(pObj->m_%s), pDepth+1, \"%s\" );\n",
						ac->cName, ac->cName, ac->member[i].mName, ac->member[i].mName, ac->member[i].mName
					);
				else
					fprintf( pf,
						"\tAsnSequenceOf_Print( &(pObj->m_%s), pDepth+1, \"%s\" );\n",
						ac->member[i].mName, ac->member[i].mName
					);
			}
			else
			{
				if( ac->member[i].optional || ac->member[i].extended )
					fprintf( pf,
						"\tif( %s_IsIncludeOptionField( pObj, e_%sOptionMap_%s ) )\n"
						"\t\t%s_Print( &(pObj->m_%s), pDepth+1, \"%s\" );\n",
						ac->cName, ac->cName, ac->member[i].mName, ac->member[i].cName, ac->member[i].mName, ac->member[i].mName
					);
				else
					fprintf( pf,
						"\t%s_Print( &(pObj->m_%s), pDepth+1, \"%s\" );\n",
						ac->member[i].cName, ac->member[i].mName, ac->member[i].mName
					);
			}
		}
	}

	fprintf( pf,
		"\tprintf( \"\\n\" );\n"
		"\tfor( i=0; i<pDepth; i++ ) HSPrint( \"  \" );\n"
		"\tprintf(\"}\");\n\n"
		"\treturn HS_OK;\n"
		"}\n"
		"#endif\n\n"
	);

	return true;
}


bool MakeCMemberSequence( AsnClass *ac, FILE *pf )
{
	if( ! MakeCMemberSequenceConstructor(ac,pf) )
		return false;
	if( ! MakeCMemberSequenceDestructor(ac,pf) )
		return false;
	if( ! MakeCMemberSequenceMakeMold(ac,pf) )
		return false;
	if( ! MakeCMemberSequenceIncludeOptionField(ac,pf) )
		return false;
	if( ! MakeCMemberSequenceIsIncludeOptionField(ac,pf) )
		return false;
	if( ! MakeCMemberSequenceEncode(ac,pf) )
		return false;
	if( ! MakeCMemberSequenceDecode(ac,pf) )
		return false;
	if( ! MakeCMemberSequencePrint(ac,pf) )
		return false;
	return true;
}

bool MakeCMemberSet( AsnClass *ac, FILE *pf )
{
	return MakeCMemberSequence(ac,pf);
}


const char *gInheritanceTail =
"\
HS_RESULT delete_%s( void *pObject )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return delete_%s( &(pObj->inheritance) );\n\
}\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return %s_Print( &(pObj->inheritance), pDepth, pTypeName );\n\
}\n\
#endif\n\
HS_RESULT %s_MakeMold( void *pObject ){return HS_OK;}\n\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return %s_Encode( &(pObj->inheritance), pStrm );\n\
}\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return %s_Decode( &(pObj->inheritance), pStrm );\n\
}\n\
";
const char *gSequenceOfInheritanceTailStart =
"\
HS_RESULT delete_%s( void *pObject )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return delete_%s( &(pObj->inheritance) );\n\
}\n\
#ifdef HS_DEBUG_ASN_PRINT\n\
HS_RESULT %s_Print( void *pObject, HS_UINT pDepth, char *pTypeName )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return %s_Print( &(pObj->inheritance), pDepth, pTypeName );\n\
}\n\
#endif\n\
";
const char *gSequenceOfInheritanceTailMold =
"\
HS_RESULT %s_MakeMold( void *pObject ){\n\
	AsnObject *moldObject = HS_NULL;\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\n\
";
const char *gSequenceOfInheritanceTailEnd =
"\
HS_RESULT %s_Encode( void *pObject, AsnStream *pStrm )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return %s_Encode( &(pObj->inheritance), pStrm );\n\
}\n\
HS_RESULT %s_Decode( void *pObject, AsnStream *pStrm )\n\
{\n\
	%s *pObj = (%s *)pObject;\n\
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;\n\
	return %s_Decode( &(pObj->inheritance), pStrm );\n\
}\n\
";
bool MakeCMemberInheritance( AsnClass *ac, FILE *pf )
{
	if( ac==0 || pf==0 )
	{
		printf( "\n Err:MakeFile:Inherit:NULL" );
		return false;
	}

	switch(ac->type)
	{
		case e_class:
			if( ac->of ) break;
			else return true;
		case e_boolean:
		case e_null:
		case e_objectIdentifier:
		case e_integer:
		case e_bitString:
		case e_octetString:
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
		case e_bmpString:
			break;
		case e_enumerated:
			printf( "\n Err:MakeFile:Inherit:Enum" );
			return false;
		case e_extension:
		case e_choice:
		case e_set:
		case e_sequence:
		default:
			printf( "\n Err:MakeFile:CStruct:Inherit:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	fprintf( pf,
		"/*Inheritance*/\n"
		"HS_RESULT new_%s( void *pObject )\n{\n"
		"\tAsnSingleString *ss = HS_NULL;\n"
		"\tAsnDoubleString *ds = HS_NULL;\n"
		"\t%s *pObj = (%s *)pObject;\n"
		"\tif( pObj == HS_NULL )\n"
		"\t{\n"
		"#ifdef HS_DEBUG_ASN_MEMBER\n"
		"\t\tHSPrint( \"\\n Error on new_%s(NULL) -> null parameter\" );\n"
		"#endif\n"
		"\t\treturn HS_ERR_NULL_PARAM;\n"
		"\t}\n", ac->cName, ac->cName, ac->cName, ac->cName
	);

	switch(ac->type)
	{
		case e_class:
			if( ac->of )
			{
				fprintf( pf, "\treturn new_AsnSequenceOf( &(pObj->inheritance), %s,%d,%u,%d,%u );\n}\n",
					GetConstraintTypeNameForParsing( ac->consOf.type ),
					ac->consOf.nMin, ac->consOf.nMax, ac->consOf.eMin, ac->consOf.eMax
				);
				fprintf( pf, gSequenceOfInheritanceTailStart
					, ac->cName, ac->cName, ac->cName, "AsnSequenceOf"
					, ac->cName, ac->cName, ac->cName, "AsnSequenceOf"
				);
				fprintf( pf, gSequenceOfInheritanceTailMold, ac->cName, ac->cName, ac->cName );
				fprintf( pf,
					"\t{\n"
					"\t%s *tmold = (%s *)HSMalloc( sizeof(%s) );\n"
					"\tnew_%s(tmold);\n"
					"\t%s_MakeMold(tmold);\n"
					"\tmoldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );\n"
					"\tnew_AsnObject(moldObject,tmold,sizeof(%s),%s_MakeMold,%s_Encode,%s_Decode,\n"
					"#ifdef HS_DEBUG_ASN_PRINT\n"
					"\t\t%s_Print,\n"
					"#endif\n"
					"\t\tdelete_%s);\n"
					"\tAsnSequenceOf_SetMold( &(pObj->inheritance), moldObject );\n"
					"\t}\n\n"
					"return HS_OK;\n}\n"
					, ac->sName, ac->sName, ac->sName, ac->sName, ac->sName
					, ac->sName, ac->sName, ac->sName, ac->sName, ac->sName, ac->sName
				);
				fprintf( pf, gSequenceOfInheritanceTailEnd
					, ac->cName, ac->cName, ac->cName, "AsnSequenceOf"
					, ac->cName, ac->cName, ac->cName, "AsnSequenceOf"
				);
				break;
			}
			else return true;
		case e_boolean:
			fprintf( pf, "\treturn new_AsnBooelan( &(pObj->inheritance) );\n}\n" );
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnBoolean", ac->cName, ac->cName, ac->cName, "AsnBoolean", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnBoolean", ac->cName, ac->cName, ac->cName, "AsnBoolean"
			);
			break;
		case e_null:
			fprintf( pf, "\treturn new_AsnNull( &(pObj->inheritance) );\n}\n" );
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnNull", ac->cName, ac->cName, ac->cName, "AsnNull", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnNull", ac->cName, ac->cName, ac->cName, "AsnNull"
			);
			break;
		case e_objectIdentifier:
			fprintf( pf, "\treturn new_AsnObjectIdentifier( &(pObj->inheritance) );\n}\n" );
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnObjectIdentifier", ac->cName, ac->cName, ac->cName, "AsnObjectIdentifier", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnObjectIdentifier", ac->cName, ac->cName, ac->cName, "AsnObjectIdentifier"
			);
			break;
		case e_integer:
			fprintf( pf, "\treturn new_AsnInteger( &(pObj->inheritance), %s,%d,%u,%d,%u );\n}\n",
				GetConstraintTypeNameForParsing( ac->cons.type ),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnInteger", ac->cName, ac->cName, ac->cName, "AsnInteger", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnInteger", ac->cName, ac->cName, ac->cName, "AsnInteger"
			);
			break;
		case e_bitString:
			fprintf( pf, "\treturn new_AsnBitString( &(pObj->inheritance), %s,%d,%u,%d,%u );\n}\n",
				GetConstraintTypeNameForParsing( ac->cons.type ),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnBitString", ac->cName, ac->cName, ac->cName, "AsnBitString", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnBitString", ac->cName, ac->cName, ac->cName, "AsnBitString"
			);
			break;
		case e_octetString:
			fprintf( pf, "\treturn new_AsnOctetString( &(pObj->inheritance), %s,%d,%u,%d,%u );\n}\n",
				GetConstraintTypeNameForParsing( ac->cons.type ),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnOctetString", ac->cName, ac->cName, ac->cName, "AsnOctetString", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnOctetString", ac->cName, ac->cName, ac->cName, "AsnOctetString"
			);
			break;
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
			fprintf( pf,
				"\tif( new_AsnSingleString( &(pObj->inheritance), %s,%s,%d,%u,%d,%u ) != HS_OK )\n"
				"\t\treturn HS_ERR_NULL_PARAM;\n",
				GetSingleStringTagName(ac->type),
				GetConstraintTypeNameForParsing( ac->cons.type ),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			if( ac->from[0] )
			{
				fprintf( pf,
					"\t/*From Constraint*/\n"
					"\tss = &(pObj->inheritance);\n"
					"\tstrcpy((char*)(ss->fromConstraint), \"%s\");\n"
					"\tss->fromSize = %d;\n"
					"\tss->reIndexing = GetStringTypeEncodingBits(\n"
					"\t\tss->fromSize,\n"
					"\t\t%s,\n"
					"\t\t&(ss->encodingBitsOfAlign),\n"
					"\t\t&(ss->encodingBitsOfUnalign)\n"
					"\t);\n\n", ac->from, strlen(ac->from), GetSingleStringVmaxName(ac->type)
				);
			}
			fprintf( pf, "\treturn HS_OK;\n}\n" );
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnSingleString", ac->cName, ac->cName, ac->cName, "AsnSingleString", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnSingleString", ac->cName, ac->cName, ac->cName, "AsnSingleString"
			);
			break;
		case e_bmpString:
			fprintf( pf,
				"\tif( new_AsnDoubleString( &(pObj->inheritance), %s,%s,%d,%u,%d,%u ) != HS_OK )\n"
				"\t\treturn HS_ERR_NULL_PARAM;\n",
				GetDoubleStringTagName(ac->type),
				GetConstraintTypeNameForParsing( ac->cons.type ),
				ac->cons.nMin, ac->cons.nMax, ac->cons.eMin, ac->cons.eMax
			);
			if( ac->from[0] )
			{
				fprintf( pf,
					"\t/*From Constraint*/\n"
					"\tds = &(pObj->inheritance);\n"
					"\tstrcpy((char*)(ds->fromConstraint), \"%s\");\n"
					"\tds->fromSize = %d;\n"
					"\tds->reIndexing = GetStringTypeEncodingBits(\n"
					"\t\tds->fromSize,\n"
					"\t\t%s,\n"
					"\t\t&(ds->encodingBitsOfAlign),\n"
					"\t\t&(ds->encodingBitsOfUnalign)\n"
					"\t);\n\n", ac->from, strlen(ac->from), GetSingleStringVmaxName(ac->type)
				);
			}
			fprintf( pf, "\treturn HS_OK;\n}\n" );
			fprintf( pf, gInheritanceTail
				, ac->cName, ac->cName, ac->cName, "AsnDoubleString", ac->cName, ac->cName, ac->cName, "AsnDoubleString", ac->cName
				, ac->cName, ac->cName, ac->cName, "AsnDoubleString", ac->cName, ac->cName, ac->cName, "AsnDoubleString"
			);
			break;
		case e_enumerated:
			printf( "\n Err:MakeFile:Inherit:Enum" );
			return false;
		case e_extension:
		case e_choice:
		case e_set:
		case e_sequence:
		default:
			printf( "\n Err:MakeFile:CStruct:Inherit:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	return true;
}


bool MakeCMember( AsnClass *ac, FILE *pf )
{
	if( ac->handship )
	{
		if( ac->type == e_enumerated )
		{
			printf( "\n Inf:MakeFile:CMember:Handship:Enumerated:class[%s]", ac->cName );
			return true;
		}
		return MakeCMemberInheritance(ac,pf);
	}

	switch(ac->type)
	{
		case e_choice:
			return MakeCMemberChoice(ac,pf);
		case e_set:
			return MakeCMemberSet(ac,pf);
		case e_sequence:
			return MakeCMemberSequence(ac,pf);
		case e_extension:
		case e_class:
		case e_boolean:
		case e_integer:
		case e_bitString:
		case e_octetString:
		case e_null:
		case e_objectIdentifier:
		case e_enumerated:
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:
		case e_bmpString:
		default:
			printf( "\n Err:MakeFile:c-source:type[%s]", GetAsnTypeName(ac->type) );
			return false;
	}

	return true;
}


bool MakeSourceC( AsnClassBox *bx, CommandSet *cs )
{
	FILE *fp;
	char tName[256];
	char hName[256];
	unsigned int bxIndex;
	unsigned int fileCounter=0;

	sprintf( (char*)tName, ".%soutput\\%s\\%s_%d.c", DEFAULT_DIRECTORY, cs->pFolder, cs->pFile, fileCounter++ );
	sprintf( (char*)hName, "%s.h", cs->pFile );
	fp = fopen( (const char*)tName, "w" );
	if( fp==0 )
	{
		printf( "\n Err:FileOpen:c-source" );
		return false;
	}

	fprintf( fp, "\n\n#include \"%s\"\n\n", hName );
	cs->MakeCSourceFile(fp);

	for( bxIndex = 0; bxIndex < bx->acSize; bxIndex++ )
	{
		if( ! MakeCMember( (AsnClass*)(bx->ac[bxIndex]), fp ) )
		{
			fclose(fp);
			return false;
		}

		if( ((bxIndex+1)%150) == 0 )
		{
			fclose(fp);
			sprintf( (char*)tName, ".%soutput\\%s\\%s_%d.c", DEFAULT_DIRECTORY, cs->pFolder, cs->pFile, fileCounter++ );
			fp = fopen( (const char*)tName, "w" );
			if( fp==0 )
			{
				printf( "\n Err:FileOpen:c-source" );
				return false;
			}
			fprintf( fp, "\n\n#include \"%s\"\n\n", hName );
		}
	}

	fclose(fp);
	return true;
}






