/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnFile.cpp>	/AsnParser Project

*/

#include "asnFile.h"



bool MakeAsnFile( AsnClassBox *bx, CommandSet *cs )
{
	char systemCommand[256];

	if( cs->cn == e_c )
	{
		if( MakeHeaderC( bx, cs ) )
			printf( "\n MakeAsnFile() -> C Header File Complete" );
		else
		{
			printf( "\n MakeAsnFile() -> C Header File Failure" );
			return false;	
		}

		if( MakeSourceC( bx, cs ) )
			printf( "\n MakeAsnFile() -> C Source File Complete\n" );
		else
		{
			printf( "\n MakeAsnFile() -> C Source File Failure\n" );
			return false;	
		}

		sprintf( systemCommand, "copy .%sCoder\\H323Define.h .%soutput\\%s\\H323Define.h", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnStream.h .%soutput\\%s\\asnStream.h", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnPrime.h .%soutput\\%s\\asnPrime.h", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnStream.cxx .%soutput\\%s\\asnStream.c", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnPrime.cxx .%soutput\\%s\\asnPrime.c", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
	}

	else if( cs->cn == e_cpp )
	{
		if( MakeHeaderCpp( bx, cs ) )
			printf( "\n MakeAsnFile() -> Cpp Header File Complete" );
		else
		{
			printf( "\n MakeAsnFile() -> Cpp Header File Failure" );
			return false;	
		}

		if( MakeSourceCpp( bx, cs ) )
			printf( "\n MakeAsnFile() -> Cpp Source File Complete" );
		else
		{
			printf( "\n MakeAsnFile() -> Cpp Source File Failure" );
			return false;	
		}

		sprintf( systemCommand, "copy .%sCoder\\H323Define.hpp .%soutput\\%s\\H323Define.h", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnStream.h .%soutput\\%s\\asnStream.h", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnPrime.h .%soutput\\%s\\asnPrime.h", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnStream.cxx .%soutput\\%s\\asnStream.cpp", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
		sprintf( systemCommand, "copy .%sCoder\\asnPrime.cxx .%soutput\\%s\\asnPrime.cpp", DEFAULT_DIRECTORY, DEFAULT_DIRECTORY, cs->pFolder );
		system( systemCommand );
	}

	return true;
}

