/*

	<messageMaker.cpp>	2005-02-23,14:50

*/

#include "messageMaker.h"



const unsigned char OID_0_0_8_2250_4[6] = {0x00,0x80,0x91,0x4a,0x00,0x04};
const unsigned char OID_0_0_8_2250_2[6] = {0x00,0x80,0x91,0x4a,0x00,0x02};
const unsigned char ipHex[4] = {0xC0,0xA8,0x03,0x0C};
unsigned char gDestIpHex[4];



BOOL CopyTransportAddresses( AsnSequenceOf<ASNH225TransportAddress>	*to, AsnSequenceOf<ASNH225TransportAddress>	*from )
{
	unsigned int i, len;

	if( to==HS_NULL || from==HS_NULL )
	{
		printf( "\n Err:CopyTransportAddresses(%x,%x) -> null parameter",to,from );
		return FALSE;
	}

	len = from->GetSize();
	to->SetSize( len );

	for( i=0; i<len; i++ )
	{
		ASNH225TransportAddress *tAddrTo = to->GetUnit(i);
		ASNH225TransportAddress *tAddrFrom = from->GetUnit(i);

		if( tAddrTo==HS_NULL || tAddrFrom==HS_NULL )
		{
			printf( "\n Err:CopyTransportAddresses(to,from) -> invalid SequenceOf size" );
			return HS_NULL;
		}

		if( tAddrFrom->choice != e_ASNH225TransportAddressChoice_ipAddress ) continue;

		ASNH225TransportAddress_ipAddress *ipAddrFrom = (ASNH225TransportAddress_ipAddress *)tAddrFrom->alter;
		ASNH225TransportAddress_ipAddress *ipAddrTo = (ASNH225TransportAddress_ipAddress *)tAddrTo->SetChoice(e_ASNH225TransportAddressChoice_ipAddress);

		if( ipAddrFrom==HS_NULL || ipAddrTo==HS_NULL )
		{
			printf( "\n Err:CopyTransportAddresses(to,from) -> invalid choice" );
			return HS_NULL;
		}

		ipAddrTo->m_ip.SetValue( ipAddrFrom->m_ip.length, ipAddrFrom->m_ip.value );
		ipAddrTo->m_port.value = ipAddrFrom->m_port.value;
	}

	return TRUE;
}


BOOL CopyAliasAddresses( AsnSequenceOf<ASNH225AliasAddress> *to, AsnSequenceOf<ASNH225AliasAddress> *from )
{
	unsigned int i, len;

	if( to==HS_NULL || from==HS_NULL )
	{
		printf( "\n Err:CopyAliasAddresses(%x,%x) -> null parameter",to,from );
		return FALSE;
	}

	len = from->GetSize();
	to->SetSize(len);

	for( i=0; i<len; i++ )
	{
		ASNH225AliasAddress *aliasTo = to->GetUnit(i);
		ASNH225AliasAddress *aliasFrom = from->GetUnit(i);

		if( aliasTo==HS_NULL || aliasFrom==HS_NULL )
		{
			printf( "\n Err:CopyTransportAddresses(to,from) -> invalid SequenceOf size" );
			return HS_NULL;
		}

		switch( aliasFrom->choice )
		{
			case e_ASNH225AliasAddressChoice_dialedDigits:
			{
				AsnSingleString *ia5From = (AsnSingleString *)aliasFrom->alter;
				AsnSingleString *ia5To = (AsnSingleString *)aliasTo->SetChoice(e_ASNH225AliasAddressChoice_dialedDigits);

				if( ia5From==HS_NULL || ia5To==HS_NULL )
				{
					printf( "\n Err:CopyTransportAddresses(to,from) -> invalid choice" );
					return HS_NULL;
				}

				ia5To->SetValue( ia5From->value, ia5From->length );
				break;
			}
			case e_ASNH225AliasAddressChoice_h323_ID:
			{
				AsnDoubleString *bmpFrom = (AsnDoubleString *)aliasFrom->alter;
				AsnDoubleString *bmpTo = (AsnDoubleString *)aliasTo->SetChoice(e_ASNH225AliasAddressChoice_h323_ID);

				if( bmpFrom==HS_NULL || bmpTo==HS_NULL )
				{
					printf( "\n Err:CopyTransportAddresses(to,from) -> invalid choice" );
					return HS_NULL;
				}

				bmpTo->SetValue( bmpFrom->value, bmpFrom->length );
				break;
			}
			default:
				break;
		}
	}

	return TRUE;
}






AsnStream *MakeGCF(ASNH225GatekeeperRequest *grq)
{
	if(grq==HS_NULL)
	{
		printf( "\n Err:MakeGCF(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225GatekeeperConfirm *gcf = (ASNH225GatekeeperConfirm *)ras.SetChoice(e_ASNH225RasMessageChoice_gatekeeperConfirm);
	if(gcf==HS_NULL)
	{
		printf( "\n Err:MakeGCF(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	gcf->m_requestSeqNum.value = grq->m_requestSeqNum.value;
	gcf->m_protocolIdentifier.SetValue( (HS_UCHAR*)OID_0_0_8_2250_4, 6 );
	gcf->IncludeOptionField(e_ASNH225GatekeeperConfirmOptionMap_gatekeeperIdentifier);
	gcf->m_gatekeeperIdentifier.SetValueInVisible("HS_GATEKEEPER");
	ASNH225TransportAddress_ipAddress *ipAddr = 
		(ASNH225TransportAddress_ipAddress *)gcf->m_rasAddress.SetChoice(e_ASNH225TransportAddressChoice_ipAddress);

	ipAddr->m_ip.SetValue( 4, (HS_UCHAR*)ipHex );
	ipAddr->m_port.value = 1719;

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeGCF(NULL) -> GCF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeRCF(ASNH225RegistrationRequest *rrq)
{
	if(rrq==HS_NULL)
	{
		printf( "\n Err:MakeRCF(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225RegistrationConfirm *rcf = (ASNH225RegistrationConfirm *)ras.SetChoice(e_ASNH225RasMessageChoice_registrationConfirm);
	if(rcf==HS_NULL)
	{
		printf( "\n Err:MakeRCF(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	rcf->m_requestSeqNum.value = rrq->m_requestSeqNum.value;
	rcf->m_protocolIdentifier.SetValue( (HS_UCHAR*)OID_0_0_8_2250_4, 6 );
	CopyTransportAddresses( &(rcf->m_callSignalAddress), &(rrq->m_callSignalAddress) );

	rcf->IncludeOptionField(e_ASNH225RegistrationConfirmOptionMap_gatekeeperIdentifier);
	rcf->m_gatekeeperIdentifier.SetValueInVisible("HS_GATEKEEPER");
	
	if( rrq->IsIncludeOptionField(e_ASNH225RegistrationRequestOptionMap_endpointIdentifier) )
		rcf->m_endpointIdentifier.SetValue(rrq->m_endpointIdentifier.value, rrq->m_endpointIdentifier.length);
	else
		rcf->m_endpointIdentifier.SetValueInVisible( "EP0-HS_GATEKEEPER" );

	rcf->IncludeOptionField(e_ASNH225RegistrationConfirmOptionMap_terminalAlias);
	CopyAliasAddresses( &(rcf->m_terminalAlias), &(rrq->m_terminalAlias) );

	rcf->IncludeOptionField(e_ASNH225RegistrationConfirmOptionMap_timeToLive);
	rcf->m_timeToLive.value = rrq->m_timeToLive.value;

	rcf->IncludeOptionField(e_ASNH225RegistrationConfirmOptionMap_willRespondToIRR);
	rcf->m_willRespondToIRR.value = TRUE;

	rcf->IncludeOptionField(e_ASNH225RegistrationConfirmOptionMap_preGrantedARQ);
	rcf->m_preGrantedARQ.m_makeCall.value = FALSE;
	rcf->m_preGrantedARQ.m_useGKCallSignalAddressToMakeCall.value = FALSE;
	rcf->m_preGrantedARQ.m_answerCall.value = FALSE;
	rcf->m_preGrantedARQ.m_useGKCallSignalAddressToAnswer.value = FALSE;

	rcf->IncludeOptionField(e_ASNH225RegistrationConfirmOptionMap_maintainConnection);
	rcf->m_maintainConnection.value = FALSE;


	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeRCF(NULL) -> RCF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeRRJ(ASNH225RegistrationRequest *rrq)
{
	if(rrq==HS_NULL)
	{
		printf( "\n Err:MakeRRJ(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225RegistrationReject *rrj = (ASNH225RegistrationReject *)ras.SetChoice(e_ASNH225RasMessageChoice_registrationReject);
	if(rrj==HS_NULL)
	{
		printf( "\n Err:MakeRRJ(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	rrj->m_requestSeqNum.value = rrq->m_requestSeqNum.value;
	rrj->m_protocolIdentifier.SetValue( (HS_UCHAR*)OID_0_0_8_2250_4, 6 );
	rrj->m_rejectReason.SetChoice(e_ASNH225RegistrationRejectReasonChoice_undefinedReason);
	rrj->IncludeOptionField(e_ASNH225RegistrationRejectOptionMap_gatekeeperIdentifier);
	rrj->m_gatekeeperIdentifier.SetValueInVisible("HS_GATEKEEPER");

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeRCF(NULL) -> RCF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeUCF(ASNH225UnregistrationRequest *urq)
{
	if(urq==HS_NULL)
	{
		printf( "\n Err:MakeURQ(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225UnregistrationConfirm *ucf = (ASNH225UnregistrationConfirm *)ras.SetChoice(e_ASNH225RasMessageChoice_unregistrationConfirm);
	if(ucf==HS_NULL)
	{
		printf( "\n Err:MakeUCF(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	ucf->m_requestSeqNum.value = urq->m_requestSeqNum.value;

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeUCF(NULL) -> UCF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeACF(ASNH225AdmissionRequest *arq, unsigned char *destIpHex)
{
	if(arq==HS_NULL)
	{
		printf( "\n Err:MakeACF(NULL) -> null parameter" );
		return HS_NULL;
	}

	if(destIpHex==HS_NULL) destIpHex = gDestIpHex;

	ASNH225RasMessage		ras;
	ASNH225AdmissionConfirm *acf = (ASNH225AdmissionConfirm *)ras.SetChoice(e_ASNH225RasMessageChoice_admissionConfirm);
	if(acf==HS_NULL)
	{
		printf( "\n Err:MakeACF(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	acf->m_requestSeqNum.value = arq->m_requestSeqNum.value;
	acf->m_bandWidth.value = 100;
	acf->m_callModel.SetChoice(e_ASNH225CallModelChoice_direct);
	ASNH225TransportAddress_ipAddress *ipAddr =
		(ASNH225TransportAddress_ipAddress *)acf->m_destCallSignalAddress.SetChoice(e_ASNH225TransportAddressChoice_ipAddress);
	ipAddr->m_ip.SetValue( 4, (HS_UCHAR*)destIpHex );
	ipAddr->m_port.value = 1720;

	memcpy(gDestIpHex,destIpHex,4);

	if( ! arq->m_answerCall.value )
	{
		if( arq->m_destinationInfo.size )
		{
			ASNH225AliasAddress *alias1 = arq->m_destinationInfo.GetUnit(0);
			if(alias1)
			{
				if(alias1->choice==e_ASNH225AliasAddressChoice_dialedDigits)
				{
					AsnSingleString *dial1 = (AsnSingleString *)alias1->alter;
					if(dial1)
					{
						acf->IncludeOptionField(e_ASNH225AdmissionConfirmOptionMap_destinationInfo);
						acf->m_destinationInfo.SetSize(1);
						ASNH225AliasAddress *alias = acf->m_destinationInfo.GetUnit(0);
						AsnSingleString *dial = (AsnSingleString *)alias->SetChoice(e_ASNH225AliasAddressChoice_dialedDigits);
						dial->SetValue(dial1->value,dial1->length);
					}
				}
			}
		}
	}

	acf->IncludeOptionField(e_ASNH225AdmissionConfirmOptionMap_willRespondToIRR);
	acf->m_willRespondToIRR.value = TRUE;

	acf->IncludeOptionField(e_ASNH225AdmissionConfirmOptionMap_uuiesRequested);
	acf->m_uuiesRequested.IncludeOptionField(e_ASNH225UUIEsRequestedOptionMap_status);
	acf->m_uuiesRequested.IncludeOptionField(e_ASNH225UUIEsRequestedOptionMap_statusInquiry);
	acf->m_uuiesRequested.IncludeOptionField(e_ASNH225UUIEsRequestedOptionMap_setupAcknowledge);
	acf->m_uuiesRequested.IncludeOptionField(e_ASNH225UUIEsRequestedOptionMap_notify);
	acf->m_uuiesRequested.m_setup.value = TRUE;
	acf->m_uuiesRequested.m_callProceeding.value = TRUE;
	acf->m_uuiesRequested.m_connect.value = TRUE;
	acf->m_uuiesRequested.m_alerting.value = TRUE;
	acf->m_uuiesRequested.m_information.value = TRUE;
	acf->m_uuiesRequested.m_releaseComplete.value = TRUE;
	acf->m_uuiesRequested.m_facility.value = TRUE;
	acf->m_uuiesRequested.m_progress.value = TRUE;
	acf->m_uuiesRequested.m_empty.value = TRUE;
	acf->m_uuiesRequested.m_status.value = TRUE;
	acf->m_uuiesRequested.m_statusInquiry.value = TRUE;
	acf->m_uuiesRequested.m_setupAcknowledge.value = TRUE;
	acf->m_uuiesRequested.m_notify.value = TRUE;

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeACF(NULL) -> ACF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeARJ(ASNH225AdmissionRequest *arq)
{
	if(arq==HS_NULL)
	{
		printf( "\n Err:MakeARJ(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225AdmissionReject *arj = (ASNH225AdmissionReject *)ras.SetChoice(e_ASNH225RasMessageChoice_admissionReject);
	if(arj==HS_NULL)
	{
		printf( "\n Err:MakeARJ(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	arj->m_requestSeqNum.value = arq->m_requestSeqNum.value;
	arj->m_rejectReason.SetChoice(e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered);

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeARJ(NULL) -> ACF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeBCF(ASNH225BandwidthRequest *brq)
{
	if(brq==HS_NULL)
	{
		printf( "\n Err:MakeBCF(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225BandwidthConfirm *bcf = (ASNH225BandwidthConfirm *)ras.SetChoice(e_ASNH225RasMessageChoice_bandwidthConfirm);
	if(bcf==HS_NULL)
	{
		printf( "\n Err:MakeBCF(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	bcf->m_requestSeqNum.value = brq->m_requestSeqNum.value;
	bcf->m_bandWidth.value = brq->m_bandWidth.value;

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeBCF(NULL) -> ACF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}



AsnStream *MakeDCF(ASNH225DisengageRequest *drq)
{
	if(drq==HS_NULL)
	{
		printf( "\n Err:MakeDCF(NULL) -> null parameter" );
		return HS_NULL;
	}

	ASNH225RasMessage		ras;
	ASNH225DisengageConfirm *dcf = (ASNH225DisengageConfirm *)ras.SetChoice(e_ASNH225RasMessageChoice_disengageConfirm);
	if(dcf==HS_NULL)
	{
		printf( "\n Err:MakeDCF(NULL) -> SetChoice Fail" );
		return HS_NULL;
	}
	AsnStream *reply = new AsnStream(256);

	dcf->m_requestSeqNum.value = drq->m_requestSeqNum.value;

	if( ras.Encode(reply) != HS_OK )
	{
		printf( "\n Err:MakeDCF(NULL) -> ACF Encode Fail" );
		delete reply;
		return HS_NULL;
	}

	ras.Print(0,"[ SEND ]");
	return reply;
}