/*

	<messageHandler.cpp>	2005-02-18,16:32

*/

#include "messageHandler.h"



typedef struct
{
	char			h323id[10][256];
	unsigned		h323Size;
	char			e164id[10][256];
	unsigned		e164Size;

	unsigned char	ip[4];
	bool			used;
} User;

User	user[10];
void InitUser( unsigned i )
{
	unsigned j;

	if(i>9) return;

	user[i].h323Size = 0;
	user[i].e164Size = 0;
	user[i].used = false;

	for( j=0; j<10; j++ )
	{
		memset(user[i].h323id[j],0,256);
		memset(user[i].e164id[j],0,256);
	}
}
void InitUsers()
{
	unsigned i;
	for( i=0; i<10; i++ )
		InitUser(i);
}

#define NO_USER		HS_UINT_MAX
void BMPString2String( char *str, unsigned short *bmpstr, unsigned bmpsize )
{
	unsigned i=0;
	for( i=0; i<bmpsize; i++ )
		str[i] = (unsigned char)bmpstr[i];
	str[bmpsize]=0;
}
bool AddUser( AsnSequenceOf<ASNH225AliasAddress> *aa, ASNH225TransportAddress *ta )
{
	unsigned i, j, uSize;

	if(aa==0||ta==0) return false;

	uSize = aa->size;
	if(uSize==0) return false;

	for(i=0; i<10; i++)
	{
		if( ! user[i].used ) break;
	}

	if( i<10 )
	{
		for( j=0; j<uSize; j++ )
		{
			ASNH225AliasAddress *aaa = aa->GetUnit(j);
			if(aaa==0) return false;

			if( aaa->choice==e_ASNH225AliasAddressChoice_dialedDigits )
			{
				AsnSingleString *dial = (AsnSingleString *)aaa->alter;
				if(dial==0) return false;
				memcpy(user[i].e164id[user[i].e164Size++],dial->value,dial->length);
				user[i].e164id[user[i].e164Size++][dial->length] = 0;
			}
			else if( aaa->choice==e_ASNH225AliasAddressChoice_h323_ID )
			{
				AsnDoubleString *id = (AsnDoubleString *)aaa->alter;
				if(id==0) return false;
				BMPString2String(user[i].h323id[user[i].h323Size++],id->value,id->length);
				user[i].e164id[user[i].h323Size++][id->length] = 0;
			}
		}

		if(ta->choice!=e_ASNH225TransportAddressChoice_ipAddress){
			InitUser(i);
			return false;
		}
		ASNH225TransportAddress_ipAddress *ipAddr = (ASNH225TransportAddress_ipAddress *)ta->alter;
		if(ipAddr==0){
			InitUser(i);
			return false;
		}
		if(ipAddr->m_ip.length != 4 ){
			InitUser(i);
			return false;
		}

		memcpy(user[i].ip,ipAddr->m_ip.value,4);
		user[i].used = true;
	}

	return true;
}
unsigned FindUser( ASNH225AliasAddress *aa )
{
	unsigned i, j;
	char user323id[256];

	if(aa==0) return NO_USER;

	if( aa->choice==e_ASNH225AliasAddressChoice_dialedDigits )
	{
		AsnSingleString *dial = (AsnSingleString *)aa->alter;
		if(dial==0) return false;
		for( i=0; i<10; i++ )
		{
			for( j=0; j<user[i].e164Size; j++ )
			{
				if( strlen(user[i].e164id[j])==dial->length )
				{
					if( !memcmp(user[i].e164id[j],dial->value,dial->length) )
						return i;
				}
			}
		}
	}
	else if( aa->choice==e_ASNH225AliasAddressChoice_h323_ID )
	{
		AsnDoubleString *id = (AsnDoubleString *)aa->alter;
		if(id==0) return false;
		BMPString2String(user323id,id->value,id->length);
		for( i=0; i<10; i++ )
		{
			for( j=0; j<user[i].h323Size; j++ )
			{
				if( !strcmp(user[i].h323id[j],user323id) )
					return i;
			}
		}
	}

	return NO_USER;
}
unsigned FindUsers( AsnSequenceOf<ASNH225AliasAddress> *aa )
{
	unsigned i, uSize, ret;

	if(aa==0)	return NO_USER;

	uSize = aa->size;
	if(uSize==0) return NO_USER;

	for(i=0; i<uSize; i++)
	{
		ret = FindUser( aa->GetUnit(i) );
		if(ret<10) return ret;
	}

	return NO_USER;
}







AsnStream *HandleGRQ(ASNH225GatekeeperRequest *grq)
{
	if(grq==HS_NULL)
	{
		printf( "\n Err:HandleGRQ(NULL) -> null parameter" );
		return HS_NULL;
	}

	return MakeGCF(grq);
}

AsnStream *HandleRRQ(ASNH225RegistrationRequest *rrq)
{
	unsigned index;
	ASNH225AliasAddress *alias = HS_NULL;

	if(rrq==HS_NULL)
	{
		printf( "\n Err:HandleRRQ(NULL) -> null parameter" );
		return HS_NULL;
	}

	if( rrq->IsIncludeOptionField(e_ASNH225RegistrationRequestOptionMap_terminalAlias) )
	{
		if( rrq->m_terminalAlias.size )
		{
			if( rrq->m_callSignalAddress.size )
			{
				index = FindUsers( &(rrq->m_terminalAlias) );
				if( index < 10 )
				{
					printf( "\n Inf:User Exist" );
					InitUser(index);
				}

				if( AddUser( &(rrq->m_terminalAlias), rrq->m_callSignalAddress.GetUnit(0) ) )
				{
					printf( "\n Inf:User Added" );
					return MakeRCF(rrq);
				}
				else
				{
					printf( "\n Inf:Fail to Add User" );
					return MakeRRJ(rrq);
				}
			}
			else
			{
				printf( "\n Inf:Light RRQ type 2" );
				return MakeRCF(rrq);
			}
		}
		else
		{
			printf( "\n Inf:Light RRQ type 1" );
			return MakeRCF(rrq);
		}
	}
	
	printf( "\n Inf:Light RRQ type 0" );
	return MakeRCF(rrq);	
}

AsnStream *HandleURQ(ASNH225UnregistrationRequest *urq)
{
	return MakeUCF(urq);
}

AsnStream *HandleARQ(ASNH225AdmissionRequest *arq)
{
	unsigned index;

	if( arq->m_answerCall.value )
	{
		printf( "\n Inf:Simple ACF For Called" );
		return MakeACF(arq,HS_NULL);
	}

	if( ! arq->IsIncludeOptionField(e_ASNH225AdmissionRequestOptionMap_destinationInfo) )
	{
		printf( "\n Inf:No Destination:ARJ" );
		return MakeARJ(arq);
	}

	index = FindUsers(&(arq->m_destinationInfo));
	if(index<10)
	{
		printf( "\n Inf:Found User(%u):ACF", index );
		return MakeACF(arq, user[index].ip);
	}

	printf( "\n Inf:Cant Found User(%x):ARJ", index );
	return MakeARJ(arq);
}

AsnStream *HandleBRQ(ASNH225BandwidthRequest *brq)
{
	return MakeBCF(brq);
}

AsnStream *HandleDRQ(ASNH225DisengageRequest *drq)
{
	return MakeDCF(drq);
}

AsnStream *HandleLRQ(ASNH225LocationRequest *lrq)
{
	return HS_NULL;
}

AsnStream *HandleLCF(ASNH225LocationConfirm *lcf)
{
	return HS_NULL;
}

AsnStream *HandleLRJ(ASNH225LocationReject *lrj)
{
	return HS_NULL;
}

AsnStream *HandleIRQ(ASNH225InfoRequest *irq)
{
	return HS_NULL;
}

AsnStream *HandleIRR(ASNH225InfoRequestResponse *irr)
{
	return HS_NULL;
}






AsnStream *HandleRawPDU( unsigned char *rdata, int rlen )
{
	HS_RESULT	ret;
	AsnStream strm(rlen);
	memcpy(strm.datas, rdata, rlen);

	ASNH225RasMessage	rMsg;
	if( (ret=rMsg.Decode(&strm)) == HS_OK )
	{
		rMsg.Print(0,"[ RECEIVE ]");
		switch( rMsg.choice )
		{
			case e_ASNH225RasMessageChoice_gatekeeperRequest:
				return HandleGRQ((ASNH225GatekeeperRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_registrationRequest:
				return HandleRRQ((ASNH225RegistrationRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_unregistrationRequest:
				return HandleURQ((ASNH225UnregistrationRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_admissionRequest:
				return HandleARQ((ASNH225AdmissionRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_bandwidthRequest:
				return HandleBRQ((ASNH225BandwidthRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_disengageRequest:
				return HandleDRQ((ASNH225DisengageRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_locationRequest:
				return HandleLRQ((ASNH225LocationRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_locationConfirm:
				return HandleLCF((ASNH225LocationConfirm *)rMsg.alter);
			case e_ASNH225RasMessageChoice_locationReject:
				return HandleLRJ((ASNH225LocationReject *)rMsg.alter);
			case e_ASNH225RasMessageChoice_infoRequest:
				return HandleIRQ((ASNH225InfoRequest *)rMsg.alter);
			case e_ASNH225RasMessageChoice_infoRequestResponse:
				return HandleIRR((ASNH225InfoRequestResponse *)rMsg.alter);

			case e_ASNH225RasMessageChoice_gatekeeperConfirm:
			case e_ASNH225RasMessageChoice_gatekeeperReject:
			case e_ASNH225RasMessageChoice_registrationConfirm:
			case e_ASNH225RasMessageChoice_registrationReject:
			case e_ASNH225RasMessageChoice_unregistrationConfirm:
			case e_ASNH225RasMessageChoice_unregistrationReject:
			case e_ASNH225RasMessageChoice_admissionConfirm:
			case e_ASNH225RasMessageChoice_admissionReject:
			case e_ASNH225RasMessageChoice_bandwidthConfirm:
			case e_ASNH225RasMessageChoice_bandwidthReject:
			case e_ASNH225RasMessageChoice_disengageConfirm:
			case e_ASNH225RasMessageChoice_disengageReject:
			case e_ASNH225RasMessageChoice_nonStandardMessage:
			case e_ASNH225RasMessageChoice_unknownMessageResponse:
			case e_ASNH225RasMessageChoice_requestInProgress:
			case e_ASNH225RasMessageChoice_resourcesAvailableIndicate:
			case e_ASNH225RasMessageChoice_resourcesAvailableConfirm:
			case e_ASNH225RasMessageChoice_infoRequestAck:
			case e_ASNH225RasMessageChoice_infoRequestNak:
			case e_ASNH225RasMessageChoice_serviceControlIndication:
			case e_ASNH225RasMessageChoice_serviceControlResponse:
			default:
				printf( "\n Err:HandleRawPDU() -> invalid messages" );
				return HS_NULL;
		}
	}
	else
	{
		printf( "\n Infor:Decode  :ret(%d)", ret );
	}

	return HS_NULL;
}
